var $ = jQuery;

function ismatch(str) {
    var ret = null;
    var tab = ['data-aos_', 'data-aos-delay_', 'data-aos-duration_', 'data-aos-easing_'];
    Object.values(tab).forEach(function (value) {
        if (String(str).match(value)) {
            ret = str.split('_');
            return false;
        }
    });
    return ret;
}
jQuery(document).ready(function ($) {

    var firstItem = $('#block-views-block-frontpage-product-block-1 div.product-item .product-item-data').first();
    $(firstItem).addClass('active');
    $('#block-views-block-frontpage-product-block-1').css('background-image', "url(" + $(firstItem).attr('data-image') + ")");
    $('#block-views-block-frontpage-product-block-1 div.product-item .product-item-data').on('mouseover', function (e) {
        $('#block-views-block-frontpage-product-block-1 div.product-item div.active').removeClass('active');
        $(this).addClass('active');
        $('#block-views-block-frontpage-product-block-1').css('background-image', "url(" + $(this).attr('data-image') + ")");
    })

    $('.aos').each(function () {
        var $this = $(this);
        var tab = $this.attr('class').split(' ');
        var keep;
        Object.values(tab).forEach(function (item) {
            var ello = ismatch(item)
            if (ello !== null) 
                $this.attr(ello[0], ello[1]);
            


        });

    });
    AOS.init({once: true, disable: 'mobile'});

    adjustScreenSize();

    $(window).resize(function () {
        adjustScreenSize();
    });
});

var everythingLoaded = setInterval(function () {
    if (/loaded|complete/.test(document.readyState)) {
        clearInterval(everythingLoaded);
        lazyLoad();
        /* $('div#loading-div').fadeOut(500, function () {
            $(this).remove();
            lazyLoad();
        }); */
        if (productSwiper) {
            productSwiper.update();
        }
    }
}, 10);

function lazyLoad() { /* $('#frontpage-video source').attr('src', 'video.mp4');
    $('#frontpage-video').trigger('play'); */
}

function adjustScreenSize() {
    var width = $(window).width();
    if (width > 1100) {
        console.log('viewing desktop');
        if ($('html').hasClass('fp-enabled')) {
            $.fn.fullpage.destroy('all');
        }
        if (awardSwiper) {
            awardSwiper.slidesPerView = 3;
            awardSwiper.spaceBetween = 50;
            awardSwiper.update();
        }
    } else if (width < 1100 && width > 768) {
        console.log('viewing tablet');
        if (! $('html').hasClass('fp-enabled')) {
            $('#block-twenty-content, #block-views-block-award-and-certification-block-1, #block-views-block-product-display-block-1').addClass('section'); // .attr('data-centered', 'true');
            $('#block-views-block-frontpage-product-block-1').wrap($('<div />').addClass('section'));
            // $('#block-views-block-award-and-certification-block-1').addClass('fp-noscroll');

            $('body').css('padding-top', '');
            $('.layout-content').fullpage({
                licenseKey: null,
                // v2compatible: true,
                fixedElements: '.full-width > header, #toolbar-administration, #block-twenty-page-title, footer',
                scrollOverflow: true,
                paddingTop: '87px',
                paddingBottom: '62px',
                afterRender: function () {
                    $.fn.fullpage.reBuild();
                }
            });
        }
        if (awardSwiper) {
            awardSwiper.slidesPerView = 3;
            awardSwiper.spaceBetween = 50;
            awardSwiper.update();
        }
    } else if (width < 768) {
        $('img').each(function () {
            if ($(this).attr('width')) {
                $(this).css('width', $(this).attr('width'));
                $(this).removeAttr('width');
            }
            if ($(this).attr('height')) {
                $(this).css('height', $(this).attr('height'));
                $(this).removeAttr('height');
            }
        });
        if (awardSwiper) {
            awardSwiper.slidesPerView = 2;
            awardSwiper.spaceBetween = 0;
            awardSwiper.update();
        }
    } else {
        console.log('no change');
    }
}

/* Award Swiper JS */
if ($('#awardSwiper.swiper-container').length > 0) {
    var currentYear = 0;
    var awardSwiper = new Swiper('#awardSwiper.swiper-container', {
        slidesPerView: 3,
        centeredSlides: true,
        spaceBetween: 50,
        followFinger: false,
        pagination: {
            el: '.swiper-pagination',
            clickable: true,
            renderBullet: function (index, className) {
                var awardYear = jQuery('.award-row.row_' + index).attr('data-award-year');
                var bulletImg = jQuery('.award-row.row_' + index).attr('data-bullet-image');
                var returnStr = '<div class="' + className + ' swiper-pagination-bullet year-' + awardYear + '" data-bullet-year="' + awardYear + '" style="background-image: url(' + bulletImg + ')"></div>';
                return returnStr;
            }
        },
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev'
        },
        on: {
            paginationRender: function (swiper) {
                var currentYear = 0;
                var yearDiv = jQuery('<span />').addClass('yearDiv');
                jQuery('.swiper-pagination-bullet').each(function () {
                    var bulletYear = jQuery(this).attr('data-bullet-year');
                    if (bulletYear != currentYear) {
                        jQuery(yearDiv).append(jQuery('<span />').addClass('yearBullet year-' + bulletYear).text(bulletYear))
                        currentYear = bulletYear;
                    } else {
                        jQuery(yearDiv).append(jQuery('<span />').addClass('yearBullet'))
                    }
                });
                jQuery('div.swiper-pagination').after(yearDiv);
                highlightYear(jQuery(swiper.slides[swiper.activeIndex]).find('.award-row').attr('data-award-year'));
            },
            slideChange: function (swiper) {
                highlightYear(jQuery(swiper.slides[swiper.activeIndex]).find('.award-row').attr('data-award-year'));
            }
        }
    });


    function highlightYear(year) {
        var currentSelection = jQuery('.yearBullet.year-' + year);
        if (! currentSelection.hasClass('active')) {
            jQuery('.yearBullet').removeClass('active');
            jQuery(currentSelection).addClass('active');
        }
    }
}

if($('#frontpage-slideshow').length > 0){
    var slideshowSwiper = new Swiper('#frontpage-slideshow .front-swiper-container', {
        slidesPerView: 1,
        spaceBetween: 0,
        loop: true,
        autoplay: {
            delay: 5000,
            disableOnInteraction: true,
          },
        /* wrapperClass: 'front-swiper-wrapper',
        slideClass: 'front-swiper-slide', */
        mousewheel: {
            invert: true
        },
        pagination: {
            el: '#frontpage-slideshow .swiper-pagination',
            clickable: true
        },
        /* 
        navigation: {
            nextEl: '.front-swiper-button-next',
            prevEl: '.front-swiper-button-prev'
        }, */
        on: {
            init: function () {
                // console.log('swiper initialized');
            },
            progress: function(){
                //move();
            }
        }
    });

    var autoplay = 5000;
    function move() {
        var elem = document.getElementById("progress"); 
        var width = 1;
        var autoplayTime = autoplay / 100;
        var id = setInterval(frame, autoplayTime);
        function frame() {
            if (width >= 100) {
                clearInterval(id);
            } else {
                width++; 
                elem.style.width = width + '%'; 
            }
        }
    }

    $("#frontpage-slideshow  .front-swiper-container").mouseenter(function() {
        slideshowSwiper.autoplay.stop();
        console.log('slider stopped');
      });
    
      $("#frontpage-slideshow  .front-swiper-container").mouseleave(function() {
        slideshowSwiper.autoplay.start();
        console.log('slider started again');
      });
}

/* Product Swiper JS */
if ($('.product-variation.swiper-container').length > 0) {
    var productSwiper = new Swiper('.product-variation.swiper-container', {
        direction: 'vertical',
        slidesPerView: 5,
        spaceBetween: 10,
        mousewheel: {
            invert: true
        },
        pagination: {
            el: '.swiper-pagination',
            clickable: true
        },
        navigation: {
            nextEl: '.swiper-button-next',
            prevEl: '.swiper-button-prev'
        },
        on: {
            init: function () { // console.log('swiper initialized');
            }
        }
    });

    jQuery('.product-selection').find('.product-selection-item').each(function () {
        var nid = jQuery(this).attr('data-nid');
        var variationImage = jQuery(this).attr('data-variation-image');
        jQuery(this).on('click', function () {
            var coverDiv = jQuery(this).find('.cover-div');
            jQuery('.cover-div.active').not(coverDiv).removeClass('active');
            coverDiv.addClass('active');
            // jQuery('.content-div').not('content-div.nid-'+nid).hide();
            // jQuery('.content-div.nid-'+nid).fadeIn();
            jQuery('.swiper-slide').not('.swiper-slide.nid-' + nid).hide();
            jQuery('.swiper-slide.nid-' + nid).fadeIn();
            jQuery('.product-content').css('background-image', 'url(' + variationImage + ')');
            productSwiper.update();
        });
    });

    function setProductVariationImg(imgUrl) {
        jQuery('.product-content').css('background-image', 'url(' + imgUrl + ')');
    }
}

$('div#loading-div').fadeOut();
