-- Backup and Migrate MySQL Dump
-- http://github.com/backupmigrate
--
-- Generator: Backup and Migrate Core
-- Host: 127.0.0.1
-- Database: siamsenater8
-- Generation Time: Mon, 09 Nov 2020 09:13:38 +0000
-- MySQL Version: 50728

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE=NO_AUTO_VALUE_ON_ZERO */;

/* @TODO expose these options in config with the ability to turn on and off */

SET AUTOCOMMIT = 0;
SET FOREIGN_KEY_CHECKS=0;
SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET NAMES utf8;
DROP TABLE IF EXISTS `batch`;
CREATE TABLE `batch` (   `bid` int(10) unsigned NOT NULL COMMENT 'Primary Key: Unique batch ID.',   `token` varchar(64) CHARACTER SET ascii NOT NULL COMMENT 'A string token generated against the current user''s session id and the batch id, used to ensure that only the user who submitted the batch can effectively access it.',   `timestamp` int(11) NOT NULL COMMENT 'A Unix timestamp indicating when this batch was submitted for processing. Stale batches are purged at cron time.',   `batch` longblob COMMENT 'A serialized array containing the processing data for the batch.',   PRIMARY KEY (`bid`),   KEY `token` (`token`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Stores details about batches (processes that run in…';
DROP TABLE IF EXISTS `block_content`;
CREATE TABLE `block_content` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `revision_id` int(10) unsigned DEFAULT NULL,   `type` varchar(32) CHARACTER SET ascii NOT NULL COMMENT 'The ID of the target entity.',   `uuid` varchar(128) CHARACTER SET ascii NOT NULL,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   PRIMARY KEY (`id`),   UNIQUE KEY `block_content_field__uuid__value` (`uuid`),   UNIQUE KEY `block_content__revision_id` (`revision_id`),   KEY `block_content_field__type__target_id` (`type`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for block_content entities.' AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `block_content__body`;
CREATE TABLE `block_content__body` (   `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',   `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',   `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',   `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',   `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',   `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',   `body_value` longtext NOT NULL,   `body_summary` longtext,   `body_format` varchar(255) CHARACTER SET ascii DEFAULT NULL,   PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),   KEY `bundle` (`bundle`),   KEY `revision_id` (`revision_id`),   KEY `body_format` (`body_format`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for block_content field body.';
DROP TABLE IF EXISTS `block_content_field_data`;
CREATE TABLE `block_content_field_data` (   `id` int(10) unsigned NOT NULL,   `revision_id` int(10) unsigned NOT NULL,   `type` varchar(32) CHARACTER SET ascii NOT NULL COMMENT 'The ID of the target entity.',   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `status` tinyint(4) NOT NULL,   `info` varchar(255) DEFAULT NULL,   `changed` int(11) DEFAULT NULL,   `reusable` tinyint(4) DEFAULT NULL,   `default_langcode` tinyint(4) NOT NULL,   `revision_translation_affected` tinyint(4) DEFAULT NULL,   PRIMARY KEY (`id`,`langcode`),   KEY `block_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`),   KEY `block_content__revision_id` (`revision_id`),   KEY `block_content_field__type__target_id` (`type`),   KEY `block_content__status_type` (`status`,`type`,`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for block_content entities.';
DROP TABLE IF EXISTS `block_content_field_revision`;
CREATE TABLE `block_content_field_revision` (   `id` int(10) unsigned NOT NULL,   `revision_id` int(10) unsigned NOT NULL,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `status` tinyint(4) NOT NULL,   `info` varchar(255) DEFAULT NULL,   `changed` int(11) DEFAULT NULL,   `default_langcode` tinyint(4) NOT NULL,   `revision_translation_affected` tinyint(4) DEFAULT NULL,   PRIMARY KEY (`revision_id`,`langcode`),   KEY `block_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision data table for block_content entities.';
DROP TABLE IF EXISTS `block_content_revision`;
CREATE TABLE `block_content_revision` (   `id` int(10) unsigned NOT NULL,   `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `revision_user` int(10) unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',   `revision_created` int(11) DEFAULT NULL,   `revision_log` longtext,   `revision_default` tinyint(4) DEFAULT NULL,   PRIMARY KEY (`revision_id`),   KEY `block_content__id` (`id`),   KEY `block_content_field__revision_user__target_id` (`revision_user`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for block_content entities.' AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `block_content_revision__body`;
CREATE TABLE `block_content_revision__body` (   `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',   `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',   `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',   `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',   `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',   `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',   `body_value` longtext NOT NULL,   `body_summary` longtext,   `body_format` varchar(255) CHARACTER SET ascii DEFAULT NULL,   PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),   KEY `bundle` (`bundle`),   KEY `revision_id` (`revision_id`),   KEY `body_format` (`body_format`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for block_content field body.';
DROP TABLE IF EXISTS `cache_bootstrap`;
CREATE TABLE `cache_bootstrap` (   `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',   `data` longblob COMMENT 'A collection of data to cache.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',   `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',   `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',   `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',   `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',   PRIMARY KEY (`cid`),   KEY `expire` (`expire`),   KEY `created` (`created`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
DROP TABLE IF EXISTS `cache_config`;
CREATE TABLE `cache_config` (   `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',   `data` longblob COMMENT 'A collection of data to cache.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',   `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',   `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',   `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',   `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',   PRIMARY KEY (`cid`),   KEY `expire` (`expire`),   KEY `created` (`created`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
DROP TABLE IF EXISTS `cache_container`;
CREATE TABLE `cache_container` (   `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',   `data` longblob COMMENT 'A collection of data to cache.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',   `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',   `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',   `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',   `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',   PRIMARY KEY (`cid`),   KEY `expire` (`expire`),   KEY `created` (`created`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
DROP TABLE IF EXISTS `cache_data`;
CREATE TABLE `cache_data` (   `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',   `data` longblob COMMENT 'A collection of data to cache.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',   `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',   `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',   `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',   `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',   PRIMARY KEY (`cid`),   KEY `expire` (`expire`),   KEY `created` (`created`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
DROP TABLE IF EXISTS `cache_default`;
CREATE TABLE `cache_default` (   `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',   `data` longblob COMMENT 'A collection of data to cache.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',   `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',   `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',   `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',   `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',   PRIMARY KEY (`cid`),   KEY `expire` (`expire`),   KEY `created` (`created`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
DROP TABLE IF EXISTS `cache_discovery`;
CREATE TABLE `cache_discovery` (   `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',   `data` longblob COMMENT 'A collection of data to cache.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',   `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',   `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',   `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',   `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',   PRIMARY KEY (`cid`),   KEY `expire` (`expire`),   KEY `created` (`created`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
DROP TABLE IF EXISTS `cache_dynamic_page_cache`;
CREATE TABLE `cache_dynamic_page_cache` (   `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',   `data` longblob COMMENT 'A collection of data to cache.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',   `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',   `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',   `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',   `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',   PRIMARY KEY (`cid`),   KEY `expire` (`expire`),   KEY `created` (`created`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
DROP TABLE IF EXISTS `cache_entity`;
CREATE TABLE `cache_entity` (   `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',   `data` longblob COMMENT 'A collection of data to cache.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',   `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',   `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',   `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',   `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',   PRIMARY KEY (`cid`),   KEY `expire` (`expire`),   KEY `created` (`created`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
DROP TABLE IF EXISTS `cache_menu`;
CREATE TABLE `cache_menu` (   `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',   `data` longblob COMMENT 'A collection of data to cache.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',   `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',   `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',   `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',   `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',   PRIMARY KEY (`cid`),   KEY `expire` (`expire`),   KEY `created` (`created`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
DROP TABLE IF EXISTS `cache_page`;
CREATE TABLE `cache_page` (   `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',   `data` longblob COMMENT 'A collection of data to cache.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',   `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',   `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',   `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',   `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',   PRIMARY KEY (`cid`),   KEY `expire` (`expire`),   KEY `created` (`created`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
DROP TABLE IF EXISTS `cache_render`;
CREATE TABLE `cache_render` (   `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',   `data` longblob COMMENT 'A collection of data to cache.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',   `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',   `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',   `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',   `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',   PRIMARY KEY (`cid`),   KEY `expire` (`expire`),   KEY `created` (`created`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
DROP TABLE IF EXISTS `cache_toolbar`;
CREATE TABLE `cache_toolbar` (   `cid` varchar(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL DEFAULT '' COMMENT 'Primary Key: Unique cache ID.',   `data` longblob COMMENT 'A collection of data to cache.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'A Unix timestamp indicating when the cache entry should expire, or -1 for never.',   `created` decimal(14,3) NOT NULL DEFAULT '0.000' COMMENT 'A timestamp with millisecond precision indicating when the cache entry was created.',   `serialized` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag to indicate whether content is serialized (1) or not (0).',   `tags` longtext COMMENT 'Space-separated list of cache tags for this entry.',   `checksum` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'The tag invalidation checksum when this entry was saved.',   PRIMARY KEY (`cid`),   KEY `expire` (`expire`),   KEY `created` (`created`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Storage for the cache API.';
DROP TABLE IF EXISTS `cachetags`;
CREATE TABLE `cachetags` (   `tag` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'Namespace-prefixed tag string.',   `invalidations` int(11) NOT NULL DEFAULT '0' COMMENT 'Number incremented when the tag is invalidated.',   PRIMARY KEY (`tag`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Cache table for tracking cache tag invalidations.';
INSERT INTO `cachetags` VALUES ('4xx-response','54'),('block_content_view','1'),('breakpoints','29'),('comment_view','1'),('config:action_list','5'),('config:backup_migrate_destination_list','1'),('config:backup_migrate_schedule_list','1'),('config:backup_migrate_source_list','1'),('config:block.block.bartik_account_menu','1'),('config:block.block.bartik_branding','1'),('config:block.block.bartik_breadcrumbs','1'),('config:block.block.bartik_content','1'),('config:block.block.bartik_footer','1'),('config:block.block.bartik_help','1'),('config:block.block.bartik_local_actions','1'),('config:block.block.bartik_local_tasks','1'),('config:block.block.bartik_main_menu','1'),('config:block.block.bartik_messages','1'),('config:block.block.bartik_page_title','1'),('config:block.block.bartik_powered','1'),('config:block.block.bartik_search','1'),('config:block.block.bartik_tools','1'),('config:block.block.seven_breadcrumbs','1'),('config:block.block.seven_content','1'),('config:block.block.seven_help','1'),('config:block.block.seven_local_actions','1'),('config:block.block.seven_messages','1'),('config:block.block.seven_page_title','1'),('config:block.block.seven_primary_local_tasks','1'),('config:block.block.seven_secondary_local_tasks','1');
INSERT INTO `cachetags` VALUES ('config:block.block.twenty_account_menu','1'),('config:block.block.twenty_branding','1'),('config:block.block.twenty_breadcrumbs','1'),('config:block.block.twenty_content','1'),('config:block.block.twenty_footer','1'),('config:block.block.twenty_help','1'),('config:block.block.twenty_local_actions','1'),('config:block.block.twenty_local_tasks','1'),('config:block.block.twenty_main_menu','1'),('config:block.block.twenty_messages','1'),('config:block.block.twenty_page_title','1'),('config:block.block.twenty_powered','1'),('config:block.block.twenty_search','1'),('config:block.block.twenty_tools','1'),('config:block_content_type_list','1'),('config:block_list','2'),('config:comment_type_list','1'),('config:contact.form.feedback','1'),('config:contact_form_list','3'),('config:core.extension','47'),('config:editor_list','1'),('config:entity_form_display_list','1'),('config:entity_form_mode_list','1'),('config:entity_view_display_list','1'),('config:entity_view_mode_list','5'),('config:filter_format_list','2'),('config:image_style_list','1'),('config:menu_list','1'),('config:node.settings','3'),('config:node_type_list','1');
INSERT INTO `cachetags` VALUES ('config:rdf_mapping_list','1'),('config:search_page_list','1'),('config:shortcut.set.default','1'),('config:shortcut_set_list','2'),('config:system.date','1'),('config:system.menu.account','53'),('config:system.menu.admin','54'),('config:system.menu.footer','42'),('config:system.menu.main','52'),('config:system.menu.tools','47'),('config:system.site','2'),('config:system.theme','4'),('config:taxonomy_vocabulary_list','1'),('config:tour_list','1'),('config:user.role.administrator','1'),('config:user.role.anonymous','2'),('config:user.role.authenticated','2'),('config:user_role_list','3'),('config:views.view.archive','1'),('config:views.view.block_content','1'),('config:views.view.comment','1'),('config:views.view.comments_recent','1'),('config:views.view.content','1'),('config:views.view.content_recent','1'),('config:views.view.files','1'),('config:views.view.frontpage','1'),('config:views.view.glossary','1'),('config:views.view.taxonomy_term','1'),('config:views.view.user_admin_people','1'),('config:views.view.watchdog','1');
INSERT INTO `cachetags` VALUES ('config:views.view.who_s_new','1'),('config:views.view.who_s_online','1'),('config:view_list','1'),('contact_message_view','1'),('contextual_links_plugins','50'),('element_info_build','50'),('entity_bundles','8'),('entity_field_info','60'),('entity_types','112'),('http_response','54'),('link_relation_type','50'),('local_action','50'),('local_task','55'),('node_view','1'),('rendered','8'),('routes','54'),('route_match','54'),('shortcut_list:default','1'),('taxonomy_term_view','1'),('theme_registry','46'),('user:1','2'),('user_list','3'),('user_view','1'),('views_data','1');
DROP TABLE IF EXISTS `comment`;
CREATE TABLE `comment` (   `cid` int(10) unsigned NOT NULL AUTO_INCREMENT,   `comment_type` varchar(32) CHARACTER SET ascii NOT NULL COMMENT 'The ID of the target entity.',   `uuid` varchar(128) CHARACTER SET ascii NOT NULL,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   PRIMARY KEY (`cid`),   UNIQUE KEY `comment_field__uuid__value` (`uuid`),   KEY `comment_field__comment_type__target_id` (`comment_type`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for comment entities.' AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `comment__comment_body`;
CREATE TABLE `comment__comment_body` (   `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',   `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',   `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',   `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id',   `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',   `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',   `comment_body_value` longtext NOT NULL,   `comment_body_format` varchar(255) CHARACTER SET ascii DEFAULT NULL,   PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),   KEY `bundle` (`bundle`),   KEY `revision_id` (`revision_id`),   KEY `comment_body_format` (`comment_body_format`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for comment field comment_body.';
DROP TABLE IF EXISTS `comment_entity_statistics`;
CREATE TABLE `comment_entity_statistics` (   `entity_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The entity_id of the entity for which the statistics are compiled.',   `entity_type` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT 'node' COMMENT 'The entity_type of the entity to which this comment is a reply.',   `field_name` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field_name of the field that was used to add this comment.',   `cid` int(11) NOT NULL DEFAULT '0' COMMENT 'The comment.cid of the last comment.',   `last_comment_timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp of the last comment that was posted within this node, from comment.changed.',   `last_comment_name` varchar(60) DEFAULT NULL COMMENT 'The name of the latest author to post a comment on this node, from comment.name.',   `last_comment_uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The user ID of the latest author to post a comment on this node, from comment.uid.',   `comment_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The total number of comments on this entity.',   PRIMARY KEY (`entity_id`,`entity_type`,`field_name`),   KEY `last_comment_timestamp` (`last_comment_timestamp`),   KEY `comment_count` (`comment_count`),   KEY `last_comment_uid` (`last_comment_uid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Maintains statistics of entity and comments posts to show …';
DROP TABLE IF EXISTS `comment_field_data`;
CREATE TABLE `comment_field_data` (   `cid` int(10) unsigned NOT NULL,   `comment_type` varchar(32) CHARACTER SET ascii NOT NULL COMMENT 'The ID of the target entity.',   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `status` tinyint(4) NOT NULL,   `uid` int(10) unsigned NOT NULL COMMENT 'The ID of the target entity.',   `pid` int(10) unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',   `entity_id` int(10) unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',   `subject` varchar(64) DEFAULT NULL,   `name` varchar(60) DEFAULT NULL,   `mail` varchar(254) DEFAULT NULL,   `homepage` varchar(255) DEFAULT NULL,   `hostname` varchar(128) DEFAULT NULL,   `created` int(11) NOT NULL,   `changed` int(11) DEFAULT NULL,   `thread` varchar(255) NOT NULL,   `entity_type` varchar(32) CHARACTER SET ascii NOT NULL,   `field_name` varchar(32) CHARACTER SET ascii NOT NULL,   `default_langcode` tinyint(4) NOT NULL,   PRIMARY KEY (`cid`,`langcode`),   KEY `comment__id__default_langcode__langcode` (`cid`,`default_langcode`,`langcode`),   KEY `comment_field__comment_type__target_id` (`comment_type`),   KEY `comment_field__uid__target_id` (`uid`),   KEY `comment_field__created` (`created`),   KEY `comment__status_comment_type` (`status`,`comment_type`,`cid`),   KEY `comment__status_pid` (`pid`,`status`),   KEY `comment__num_new` (`entity_id`,`entity_type`,`comment_type`,`status`,`created`,`cid`,`thread`(191)),   KEY `comment__entity_langcode` (`entity_id`,`entity_type`,`comment_type`,`default_langcode`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for comment entities.';
DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (   `collection` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'Primary Key: Config object collection.',   `name` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'Primary Key: Config object name.',   `data` longblob COMMENT 'A serialized configuration object data.',   PRIMARY KEY (`collection`,`name`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for configuration data.';
INSERT INTO `config` VALUES ('','automated_cron.settings','a:2:{s:8:"interval";i:10800;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fUksROt4FfkAU9BV4hV2XvhTBSS2nTNrZS4U7S-tKrs";}}'),('','backup_migrate.backup_migrate_destination.private_files','a:9:{s:4:"uuid";s:36:"44c990a9-5b5a-4505-b17b-351a6be2d919";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4iy5jeoTP0Y4BqSaV1C6cz4GKLFea1tWzk3ez1_CMVU";}s:2:"id";s:13:"private_files";s:5:"label";s:23:"Private Files Directory";s:4:"type";s:9:"Directory";s:6:"config";a:2:{s:4:"name";s:23:"Private Files Directory";s:9:"directory";s:25:"private://backup_migrate/";}}'),('','backup_migrate.backup_migrate_schedule.daily_schedule','a:14:{s:4:"uuid";s:36:"a6a4e6f8-b170-4a7c-8a87-c8ca201d1b74";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"j-rE9LRcHAh5WPmOIg9glR7GKLw1CkvVnJvKNe376vM";}s:2:"id";s:14:"daily_schedule";s:5:"label";s:14:"Daily Schedule";s:7:"enabled";N;s:4:"keep";N;s:6:"period";N;s:4:"cron";N;s:9:"source_id";N;s:14:"destination_id";N;s:19:"settings_profile_id";N;}'),('','backup_migrate.backup_migrate_source.default_db','a:9:{s:4:"uuid";s:36:"b2a4d18f-3ad3-4276-a144-68f2f3d768f7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I0ambmTIGFVABBaGMLbQcw-a5eWKxnsz7k2COEPKga4";}s:2:"id";s:10:"default_db";s:5:"label";s:23:"Default Drupal Database";s:4:"type";s:9:"DefaultDB";s:6:"config";a:1:{s:4:"name";s:23:"Default Drupal Database";}}'),('','backup_migrate.backup_migrate_source.entire_site','a:9:{s:4:"uuid";s:36:"6a2ef746-5be0-4919-9f6f-dbf0821f8dfc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0ziF0ShQzLTglyja9_chf5qouy7Ce3i-254JN-PWmk4";}s:2:"id";s:11:"entire_site";s:5:"label";s:11:"Entire Site";s:4:"type";s:10:"EntireSite";s:6:"config";a:1:{s:4:"name";s:11:"Entire Site";}}'),('','backup_migrate.backup_migrate_source.private_files','a:9:{s:4:"uuid";s:36:"611e0a30-7fdf-49b8-bf4f-f5d42afe2bdd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"skfrgCS5JC2HXCG6QfQfiuuFWy_-OQ5Qs0FvaPwc6Vc";}s:2:"id";s:13:"private_files";s:5:"label";s:23:"Private Files Directory";s:4:"type";s:11:"DrupalFiles";s:6:"config";a:2:{s:4:"name";s:23:"Private Files Directory";s:9:"directory";s:10:"private://";}}');
INSERT INTO `config` VALUES ('','backup_migrate.backup_migrate_source.public_files','a:9:{s:4:"uuid";s:36:"ec85668d-eb40-45a6-b292-b4bc31fa3e97";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"PY9HA-hogF4_qq5gZ-TqZDTixx170-APxTcq4rpa014";}s:2:"id";s:12:"public_files";s:5:"label";s:22:"Public Files Directory";s:4:"type";s:11:"DrupalFiles";s:6:"config";a:2:{s:4:"name";s:22:"Public Files Directory";s:9:"directory";s:9:"public://";}}'),('','block.block.bartik_account_menu','a:13:{s:4:"uuid";s:36:"4bc7eba1-0bd9-444a-a9f8-ae1cb228cde4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:19:"system.menu.account";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8a31Ywc1t2zlddGd3bmDrFMefWqgSK2E02ceFdr-bfc";}s:2:"id";s:19:"bartik_account_menu";s:5:"theme";s:6:"bartik";s:6:"region";s:14:"secondary_menu";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:25:"system_menu_block:account";s:8:"settings";a:7:{s:2:"id";s:25:"system_menu_block:account";s:5:"label";s:17:"User account menu";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}'),('','block.block.bartik_branding','a:13:{s:4:"uuid";s:36:"71ce3406-aa1c-4971-991f-42b5f76487de";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NDwadleLD3YVSbDUaakxyYZyINYtkFtOVGShfq4kWy8";}s:2:"id";s:15:"bartik_branding";s:5:"theme";s:6:"bartik";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_branding_block";s:8:"settings";a:7:{s:2:"id";s:21:"system_branding_block";s:5:"label";s:13:"Site branding";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";s:13:"use_site_logo";b:1;s:13:"use_site_name";b:1;s:15:"use_site_slogan";b:1;}s:10:"visibility";a:0:{}}');
INSERT INTO `config` VALUES ('','block.block.bartik_breadcrumbs','a:13:{s:4:"uuid";s:36:"8105725f-4346-4771-911a-40017aac784b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"oXUb3JZR2WW5VOdw4HrhRicCsq51mCgLfRyvheG68ck";}s:2:"id";s:18:"bartik_breadcrumbs";s:5:"theme";s:6:"bartik";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.bartik_content','a:13:{s:4:"uuid";s:36:"1dc2c0ac-79b1-47de-a998-b35ac99874d7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"9EoWV2Lot6FVSr50t4hoKgiz1LIXYWNG-IIPYsWxBqo";}s:2:"id";s:14:"bartik_content";s:5:"theme";s:6:"bartik";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.bartik_footer','a:13:{s:4:"uuid";s:36:"75b100a6-bca5-4807-a45f-98c5db8e6e34";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:18:"system.menu.footer";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8zRjTNbfNAJ94lQpZDu6MkyD87GYJ2zpH9VQPVmRbcM";}s:2:"id";s:13:"bartik_footer";s:5:"theme";s:6:"bartik";s:6:"region";s:12:"footer_fifth";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:24:"system_menu_block:footer";s:8:"settings";a:7:{s:2:"id";s:24:"system_menu_block:footer";s:5:"label";s:11:"Footer menu";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";s:5:"level";i:1;s:5:"depth";i:0;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}');
INSERT INTO `config` VALUES ('','block.block.bartik_help','a:13:{s:4:"uuid";s:36:"71967f4e-059e-42aa-86c9-2d8a99b4f16e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8I8iACSa0sKO3k3jlvUG1ge52rfcKX7USJAQYnzuBgg";}s:2:"id";s:11:"bartik_help";s:5:"theme";s:6:"bartik";s:6:"region";s:7:"content";s:6:"weight";i:-30;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:8:"provider";s:4:"help";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.bartik_local_actions','a:13:{s:4:"uuid";s:36:"3896f939-0518-4036-9dee-7b4bf8374924";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"13GQpeITIJsp1kyPniXtWZfyFH87vb1xxJCHifL4UeE";}s:2:"id";s:20:"bartik_local_actions";s:5:"theme";s:6:"bartik";s:6:"region";s:7:"content";s:6:"weight";i:-20;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:8:"provider";s:4:"core";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.bartik_local_tasks','a:13:{s:4:"uuid";s:36:"8d7d8976-765c-4b28-8e42-58745ca08155";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"X9I1OB0W3WlWtrK-CNcg6hNWwa8wficanpH8pYnDZDE";}s:2:"id";s:18:"bartik_local_tasks";s:5:"theme";s:6:"bartik";s:6:"region";s:7:"content";s:6:"weight";i:-40;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:4:"Tabs";s:8:"provider";s:4:"core";s:13:"label_display";s:1:"0";s:7:"primary";b:1;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}'),('','block.block.bartik_main_menu','a:13:{s:4:"uuid";s:36:"0b8842a5-c83f-4ae6-ac20-02814714e69d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ChCx7DYNUrPTt5uiRdQAPDKJQMc-_SyAQTrZh8H0o-c";}s:2:"id";s:16:"bartik_main_menu";s:5:"theme";s:6:"bartik";s:6:"region";s:12:"primary_menu";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:22:"system_menu_block:main";s:8:"settings";a:7:{s:2:"id";s:22:"system_menu_block:main";s:5:"label";s:15:"Main navigation";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}');
INSERT INTO `config` VALUES ('','block.block.bartik_messages','a:13:{s:4:"uuid";s:36:"a56fed7d-39b6-42be-a47b-35f9bb223548";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KHQIJ7Vfl25lTjzIc7qIvnuistt-Mw2O0kG4jCofmkI";}s:2:"id";s:15:"bartik_messages";s:5:"theme";s:6:"bartik";s:6:"region";s:11:"highlighted";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.bartik_page_title','a:13:{s:4:"uuid";s:36:"aec0563f-beeb-4997-8f8f-3c42392bc0a8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7rR9chwXvdM2H8OYMAYx9Zj3GGlPMrZp_M3ZA4thYTk";}s:2:"id";s:17:"bartik_page_title";s:5:"theme";s:6:"bartik";s:6:"region";s:7:"content";s:6:"weight";i:-50;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:8:"provider";s:4:"core";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.bartik_powered','a:13:{s:4:"uuid";s:36:"52f6c2d8-080f-46b5-a8e0-1adff0f1e694";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jQQUUWN2Uxr5qZtc9zcJKBCxpKY8orN1u2HPqYYRQDI";}s:2:"id";s:14:"bartik_powered";s:5:"theme";s:6:"bartik";s:6:"region";s:12:"footer_fifth";s:6:"weight";i:10;s:8:"provider";N;s:6:"plugin";s:23:"system_powered_by_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_powered_by_block";s:5:"label";s:17:"Powered by Drupal";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.bartik_search','a:13:{s:4:"uuid";s:36:"39721e4d-0bd6-4b90-acd4-708b6dbc2cf5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q-4EcGAsu26ICu4ejEz0uE1zv4akpiaOsizxgZfAmEw";}s:2:"id";s:13:"bartik_search";s:5:"theme";s:6:"bartik";s:6:"region";s:13:"sidebar_first";s:6:"weight";i:-1;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:6:"Search";s:8:"provider";s:6:"search";s:13:"label_display";s:7:"visible";s:7:"page_id";s:11:"node_search";}s:10:"visibility";a:0:{}}');
INSERT INTO `config` VALUES ('','block.block.bartik_tools','a:13:{s:4:"uuid";s:36:"ca4e317e-177e-4647-a13a-5de3ccf03d36";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:17:"system.menu.tools";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"bartik";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rH6PpAn7-RScha1rGkohGAYSSh_1OVeZzioJPzPw6O4";}s:2:"id";s:12:"bartik_tools";s:5:"theme";s:6:"bartik";s:6:"region";s:13:"sidebar_first";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_menu_block:tools";s:8:"settings";a:7:{s:2:"id";s:23:"system_menu_block:tools";s:5:"label";s:5:"Tools";s:8:"provider";s:6:"system";s:13:"label_display";s:7:"visible";s:5:"level";i:1;s:5:"depth";i:0;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}'),('','block.block.seven_breadcrumbs','a:13:{s:4:"uuid";s:36:"c0e19bbd-42e9-497d-82b9-abcb9710f5a9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"seven";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WWu2OQswgCztl9OeXjD1stexIEMZsSgPMYIdC-JHx9c";}s:2:"id";s:17:"seven_breadcrumbs";s:5:"theme";s:5:"seven";s:6:"region";s:10:"breadcrumb";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.seven_content','a:13:{s:4:"uuid";s:36:"7bf6cf9f-1e14-4ee7-a9aa-88438ce28100";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"seven";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YRY68JWkaUiGeZlWMv1nzeIgDm0ZZwXYgpqUpLFzwAY";}s:2:"id";s:13:"seven_content";s:5:"theme";s:5:"seven";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}');
INSERT INTO `config` VALUES ('','block.block.seven_help','a:13:{s:4:"uuid";s:36:"e2bf1521-fec0-467d-abd4-d3f905bfbf1d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:5:"seven";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NU5A_49mwLHfs5xFzMFrZ850w9pgUolxMS9NNF3vv4c";}s:2:"id";s:10:"seven_help";s:5:"theme";s:5:"seven";s:6:"region";s:4:"help";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:8:"provider";s:4:"help";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.seven_local_actions','a:13:{s:4:"uuid";s:36:"b9d46fe4-231c-4d5f-ab35-327314da103d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"seven";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"HHryZVJbeKi9WnuBGC8FOhBZmBnk2G1H6KxFuy-rC9A";}s:2:"id";s:19:"seven_local_actions";s:5:"theme";s:5:"seven";s:6:"region";s:7:"content";s:6:"weight";i:-10;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:8:"provider";s:4:"core";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.seven_messages','a:13:{s:4:"uuid";s:36:"8ed91182-241d-4c00-8a9e-b5dd3c64d1f8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:5:"seven";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"XJqWwLt1LDCnazcEN6QkJmCLjk4R0__-8s0OO9xeNjg";}s:2:"id";s:14:"seven_messages";s:5:"theme";s:5:"seven";s:6:"region";s:11:"highlighted";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.seven_page_title','a:13:{s:4:"uuid";s:36:"e4252b10-ed84-43d3-9d5f-ce3109cf3b3b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"seven";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ZSpc3IoSaLd0PkB02nxjVPBMztIdsTdHek9SiGaqZ_c";}s:2:"id";s:16:"seven_page_title";s:5:"theme";s:5:"seven";s:6:"region";s:6:"header";s:6:"weight";i:-30;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:8:"provider";s:4:"core";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}');
INSERT INTO `config` VALUES ('','block.block.seven_primary_local_tasks','a:13:{s:4:"uuid";s:36:"e174dff6-8c8f-45f2-a5c6-7ced36b6322a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"seven";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ddy1OsBbWxjwEI8VL1viD4I69qcLHOkul4BxbTqLBTs";}s:2:"id";s:25:"seven_primary_local_tasks";s:5:"theme";s:5:"seven";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:12:"Primary tabs";s:8:"provider";s:4:"core";s:13:"label_display";s:1:"0";s:7:"primary";b:1;s:9:"secondary";b:0;}s:10:"visibility";a:0:{}}'),('','block.block.seven_secondary_local_tasks','a:13:{s:4:"uuid";s:36:"656e80fb-4618-4c14-bd5e-1b75a41542bb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:5:"seven";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QeZBeCilQfeET3GeW6ZtJkEiwROADTZktFgKWwPieD4";}s:2:"id";s:27:"seven_secondary_local_tasks";s:5:"theme";s:5:"seven";s:6:"region";s:11:"pre_content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:14:"Secondary tabs";s:8:"provider";s:4:"core";s:13:"label_display";s:1:"0";s:7:"primary";b:0;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}'),('','block.block.twenty_account_menu','a:13:{s:4:"uuid";s:36:"79066ed0-13ae-4de3-a7c7-372005e8e882";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:19:"system.menu.account";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8a31Ywc1t2zlddGd3bmDrFMefWqgSK2E02ceFdr-bfc";}s:2:"id";s:19:"twenty_account_menu";s:5:"theme";s:6:"twenty";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:25:"system_menu_block:account";s:8:"settings";a:7:{s:2:"id";s:25:"system_menu_block:account";s:5:"label";s:17:"User account menu";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}');
INSERT INTO `config` VALUES ('','block.block.twenty_branding','a:13:{s:4:"uuid";s:36:"a47e0b1c-60d6-4562-a38c-d9765a73cefb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NDwadleLD3YVSbDUaakxyYZyINYtkFtOVGShfq4kWy8";}s:2:"id";s:15:"twenty_branding";s:5:"theme";s:6:"twenty";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_branding_block";s:8:"settings";a:7:{s:2:"id";s:21:"system_branding_block";s:5:"label";s:13:"Site branding";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";s:13:"use_site_logo";b:1;s:13:"use_site_name";b:1;s:15:"use_site_slogan";b:1;}s:10:"visibility";a:0:{}}'),('','block.block.twenty_breadcrumbs','a:13:{s:4:"uuid";s:36:"dcb4c7f7-c7e1-473f-8c68-104a3e019ca3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"oXUb3JZR2WW5VOdw4HrhRicCsq51mCgLfRyvheG68ck";}s:2:"id";s:18:"twenty_breadcrumbs";s:5:"theme";s:6:"twenty";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_breadcrumb_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_breadcrumb_block";s:5:"label";s:11:"Breadcrumbs";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.twenty_content','a:13:{s:4:"uuid";s:36:"6c74582f-f795-4345-be54-3955d1e6370b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"9EoWV2Lot6FVSr50t4hoKgiz1LIXYWNG-IIPYsWxBqo";}s:2:"id";s:14:"twenty_content";s:5:"theme";s:6:"twenty";s:6:"region";s:7:"content";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:17:"system_main_block";s:8:"settings";a:4:{s:2:"id";s:17:"system_main_block";s:5:"label";s:17:"Main page content";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}');
INSERT INTO `config` VALUES ('','block.block.twenty_footer','a:13:{s:4:"uuid";s:36:"9d12b9b5-477b-495c-99c2-df8ea3b467cc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:18:"system.menu.footer";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8zRjTNbfNAJ94lQpZDu6MkyD87GYJ2zpH9VQPVmRbcM";}s:2:"id";s:13:"twenty_footer";s:5:"theme";s:6:"twenty";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:24:"system_menu_block:footer";s:8:"settings";a:7:{s:2:"id";s:24:"system_menu_block:footer";s:5:"label";s:11:"Footer menu";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";s:5:"level";i:1;s:5:"depth";i:0;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}'),('','block.block.twenty_help','a:13:{s:4:"uuid";s:36:"4bb851a5-e9a7-4fec-a7fc-8fbd093f63f6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:4:"help";}s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"8I8iACSa0sKO3k3jlvUG1ge52rfcKX7USJAQYnzuBgg";}s:2:"id";s:11:"twenty_help";s:5:"theme";s:6:"twenty";s:6:"region";s:7:"content";s:6:"weight";i:-30;s:8:"provider";N;s:6:"plugin";s:10:"help_block";s:8:"settings";a:4:{s:2:"id";s:10:"help_block";s:5:"label";s:4:"Help";s:8:"provider";s:4:"help";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.twenty_local_actions','a:13:{s:4:"uuid";s:36:"8dce281c-c365-445f-a378-e9756bfbf8f9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"13GQpeITIJsp1kyPniXtWZfyFH87vb1xxJCHifL4UeE";}s:2:"id";s:20:"twenty_local_actions";s:5:"theme";s:6:"twenty";s:6:"region";s:7:"content";s:6:"weight";i:-20;s:8:"provider";N;s:6:"plugin";s:19:"local_actions_block";s:8:"settings";a:4:{s:2:"id";s:19:"local_actions_block";s:5:"label";s:21:"Primary admin actions";s:8:"provider";s:4:"core";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}');
INSERT INTO `config` VALUES ('','block.block.twenty_local_tasks','a:13:{s:4:"uuid";s:36:"3314fee2-daac-4aa2-bde4-ca1dd761bb8d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"X9I1OB0W3WlWtrK-CNcg6hNWwa8wficanpH8pYnDZDE";}s:2:"id";s:18:"twenty_local_tasks";s:5:"theme";s:6:"twenty";s:6:"region";s:7:"content";s:6:"weight";i:-40;s:8:"provider";N;s:6:"plugin";s:17:"local_tasks_block";s:8:"settings";a:6:{s:2:"id";s:17:"local_tasks_block";s:5:"label";s:4:"Tabs";s:8:"provider";s:4:"core";s:13:"label_display";s:1:"0";s:7:"primary";b:1;s:9:"secondary";b:1;}s:10:"visibility";a:0:{}}'),('','block.block.twenty_main_menu','a:13:{s:4:"uuid";s:36:"6a7d038f-06c8-42ad-8a84-1a6bb8ebfc9e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ChCx7DYNUrPTt5uiRdQAPDKJQMc-_SyAQTrZh8H0o-c";}s:2:"id";s:16:"twenty_main_menu";s:5:"theme";s:6:"twenty";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:22:"system_menu_block:main";s:8:"settings";a:7:{s:2:"id";s:22:"system_menu_block:main";s:5:"label";s:15:"Main navigation";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";s:5:"level";i:1;s:5:"depth";i:1;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}'),('','block.block.twenty_messages','a:13:{s:4:"uuid";s:36:"6e4db537-0688-4b44-a26e-98bb10ff85a9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KHQIJ7Vfl25lTjzIc7qIvnuistt-Mw2O0kG4jCofmkI";}s:2:"id";s:15:"twenty_messages";s:5:"theme";s:6:"twenty";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:21:"system_messages_block";s:8:"settings";a:4:{s:2:"id";s:21:"system_messages_block";s:5:"label";s:15:"Status messages";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}');
INSERT INTO `config` VALUES ('','block.block.twenty_page_title','a:13:{s:4:"uuid";s:36:"90772fdd-b87e-4498-bdc8-c3aade9cfb3e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7rR9chwXvdM2H8OYMAYx9Zj3GGlPMrZp_M3ZA4thYTk";}s:2:"id";s:17:"twenty_page_title";s:5:"theme";s:6:"twenty";s:6:"region";s:7:"content";s:6:"weight";i:-50;s:8:"provider";N;s:6:"plugin";s:16:"page_title_block";s:8:"settings";a:4:{s:2:"id";s:16:"page_title_block";s:5:"label";s:10:"Page title";s:8:"provider";s:4:"core";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.twenty_powered','a:13:{s:4:"uuid";s:36:"3bee9890-c8fd-46b2-b2e6-f8390d255d3b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jQQUUWN2Uxr5qZtc9zcJKBCxpKY8orN1u2HPqYYRQDI";}s:2:"id";s:14:"twenty_powered";s:5:"theme";s:6:"twenty";s:6:"region";s:6:"header";s:6:"weight";i:10;s:8:"provider";N;s:6:"plugin";s:23:"system_powered_by_block";s:8:"settings";a:4:{s:2:"id";s:23:"system_powered_by_block";s:5:"label";s:17:"Powered by Drupal";s:8:"provider";s:6:"system";s:13:"label_display";s:1:"0";}s:10:"visibility";a:0:{}}'),('','block.block.twenty_search','a:13:{s:4:"uuid";s:36:"2784e027-b9aa-4968-9741-0732233d53b7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"module";a:1:{i:0;s:6:"search";}s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q-4EcGAsu26ICu4ejEz0uE1zv4akpiaOsizxgZfAmEw";}s:2:"id";s:13:"twenty_search";s:5:"theme";s:6:"twenty";s:6:"region";s:6:"header";s:6:"weight";i:-1;s:8:"provider";N;s:6:"plugin";s:17:"search_form_block";s:8:"settings";a:5:{s:2:"id";s:17:"search_form_block";s:5:"label";s:6:"Search";s:8:"provider";s:6:"search";s:13:"label_display";s:7:"visible";s:7:"page_id";s:11:"node_search";}s:10:"visibility";a:0:{}}'),('','block.block.twenty_tools','a:13:{s:4:"uuid";s:36:"ffa8919f-f60c-4152-95b4-d4e97ad85700";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:3:{s:6:"config";a:1:{i:0;s:17:"system.menu.tools";}s:6:"module";a:1:{i:0;s:6:"system";}s:5:"theme";a:1:{i:0;s:6:"twenty";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rH6PpAn7-RScha1rGkohGAYSSh_1OVeZzioJPzPw6O4";}s:2:"id";s:12:"twenty_tools";s:5:"theme";s:6:"twenty";s:6:"region";s:6:"header";s:6:"weight";i:0;s:8:"provider";N;s:6:"plugin";s:23:"system_menu_block:tools";s:8:"settings";a:7:{s:2:"id";s:23:"system_menu_block:tools";s:5:"label";s:5:"Tools";s:8:"provider";s:6:"system";s:13:"label_display";s:7:"visible";s:5:"level";i:1;s:5:"depth";i:0;s:16:"expand_all_items";b:0;}s:10:"visibility";a:0:{}}');
INSERT INTO `config` VALUES ('','block_content.type.basic','a:9:{s:4:"uuid";s:36:"c7ed7b0c-aa18-449a-b63d-be760c65fdd8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zglzjmYxi0G0ag9MZ02y0LSJOdpWRwJxyP_OvFojFyo";}s:2:"id";s:5:"basic";s:5:"label";s:11:"Basic block";s:8:"revision";i:0;s:11:"description";s:42:"A basic block contains a title and a body.";}'),('','comment.settings','a:2:{s:16:"log_ip_addresses";b:0;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"YNUW2Ij5uE7a4oaXp3i_2lvaFdYM1zNKPPfnEjB0jEc";}}'),('','comment.type.comment','a:9:{s:4:"uuid";s:36:"b020c824-1042-4bc7-b550-caf633d13174";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"bqZsN31T2n0UjcbyCpOPi9D2iO0sAOHR7FnEs9qMvaA";}s:2:"id";s:7:"comment";s:5:"label";s:16:"Default comments";s:21:"target_entity_type_id";s:4:"node";s:11:"description";s:28:"Allows commenting on content";}'),('','contact.form.feedback','a:12:{s:4:"uuid";s:36:"45832c3e-9d57-43ca-adfa-09e83771ef4f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vymHlgJy26BuI5GGj9-IXjwR3dRC5C0tij4BpWJnoqw";}s:2:"id";s:8:"feedback";s:5:"label";s:16:"Website feedback";s:10:"recipients";a:1:{i:0;s:16:"rik72c@gmail.com";}s:5:"reply";s:0:"";s:6:"weight";i:0;s:7:"message";s:27:"Your message has been sent.";s:8:"redirect";s:0:"";}'),('','contact.form.personal','a:12:{s:4:"uuid";s:36:"023da222-5a7d-4c2d-ad49-763f612cf514";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jonvgt3CkUM2eMLTFwWfHileWWDC4YtXCuIlCahTk_I";}s:2:"id";s:8:"personal";s:5:"label";s:21:"Personal contact form";s:10:"recipients";a:0:{}s:5:"reply";s:0:"";s:6:"weight";i:0;s:7:"message";s:27:"Your message has been sent.";s:8:"redirect";s:0:"";}'),('','contact.settings','a:4:{s:12:"default_form";s:8:"feedback";s:5:"flood";a:2:{s:5:"limit";i:5;s:8:"interval";i:3600;}s:20:"user_default_enabled";b:1;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U69DBeuvXuNVOC15rVNaBjDPK2fWFbo9v4takdYSSO8";}}');
INSERT INTO `config` VALUES ('','core.base_field_override.node.page.promote','a:17:{s:4:"uuid";s:36:"22b4f570-777a-4a45-9c25-0e9f6d94567c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:1:{i:0;s:14:"node.type.page";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fPUEnm4T5zfZRr3ttDUqq7yCDd2uW3clWD-pvos4tlQ";}s:2:"id";s:17:"node.page.promote";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:22:"Promoted to front page";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:8:"on_label";s:2:"On";s:9:"off_label";s:3:"Off";}s:10:"field_type";s:7:"boolean";}'),('','core.date_format.fallback','a:9:{s:4:"uuid";s:36:"4cf28f10-975c-4e50-bff5-9c022ea30017";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7klS5IWXrwzVaPpYZFAs6wcx8U2FF1X73OfrtTsvuvE";}s:2:"id";s:8:"fallback";s:5:"label";s:20:"Fallback date format";s:6:"locked";b:1;s:7:"pattern";s:14:"D, m/d/Y - H:i";}'),('','core.date_format.html_date','a:9:{s:4:"uuid";s:36:"91359425-158f-406a-bcfe-a2e118c245c4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EOQltUQPmgc6UQ2rcJ4Xi_leCEJj5ui0TR-12duS-Tk";}s:2:"id";s:9:"html_date";s:5:"label";s:9:"HTML Date";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-m-d";}'),('','core.date_format.html_datetime','a:9:{s:4:"uuid";s:36:"02fe9c19-3845-46a0-be03-2e47798b618a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jxfClwZIRXIdcvMrE--WkcZxDGUVoOIE3Sm2NRZlFuE";}s:2:"id";s:13:"html_datetime";s:5:"label";s:13:"HTML Datetime";s:6:"locked";b:1;s:7:"pattern";s:13:"Y-m-d\\TH:i:sO";}'),('','core.date_format.html_month','a:9:{s:4:"uuid";s:36:"e600a07a-9725-4330-a417-c79a2ecc95a9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Z7KuCUwM_WdTNvLcoltuX3_8d-s-8FZkTN6KgNwF0eM";}s:2:"id";s:10:"html_month";s:5:"label";s:10:"HTML Month";s:6:"locked";b:1;s:7:"pattern";s:3:"Y-m";}');
INSERT INTO `config` VALUES ('','core.date_format.html_time','a:9:{s:4:"uuid";s:36:"cca18316-60e4-405d-b095-abd8890576cd";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M7yqicYkU36hRy5p9drAaGBBihhUD1OyujFrAaQ93ZE";}s:2:"id";s:9:"html_time";s:5:"label";s:9:"HTML Time";s:6:"locked";b:1;s:7:"pattern";s:5:"H:i:s";}'),('','core.date_format.html_week','a:9:{s:4:"uuid";s:36:"3fe6691e-a4fa-4005-a986-d6bb683aeebb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"wKD4WsoV_wFgv2vgI4mcAAFSIzrye17ykzdwrnApkfY";}s:2:"id";s:9:"html_week";s:5:"label";s:9:"HTML Week";s:6:"locked";b:1;s:7:"pattern";s:5:"Y-\\WW";}'),('','core.date_format.html_year','a:9:{s:4:"uuid";s:36:"6465cb57-5bf6-489b-9a6b-4c8124f1f6ba";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"OjekiQuX9RbVQ2_8jOHBL94RgYLePqX7wpfNGgcQzrk";}s:2:"id";s:9:"html_year";s:5:"label";s:9:"HTML Year";s:6:"locked";b:1;s:7:"pattern";s:1:"Y";}'),('','core.date_format.html_yearless_date','a:9:{s:4:"uuid";s:36:"335c3ad1-aec7-487d-8b15-73894ce4f778";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5VpawMrKPEPCkoO4YpPa0TDFO2dgiIHfTziJtwlmUxc";}s:2:"id";s:18:"html_yearless_date";s:5:"label";s:18:"HTML Yearless date";s:6:"locked";b:1;s:7:"pattern";s:3:"m-d";}'),('','core.date_format.long','a:9:{s:4:"uuid";s:36:"22b61f6a-f76e-450a-b682-622dd1aadfa1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"og8sWXhBuHbLMw3CoiBEZjgqSyhFBFmcbUW_wLcfNbo";}s:2:"id";s:4:"long";s:5:"label";s:17:"Default long date";s:6:"locked";b:0;s:7:"pattern";s:15:"l, F j, Y - H:i";}'),('','core.date_format.medium','a:9:{s:4:"uuid";s:36:"6a5537be-6682-48da-9751-bdff593d93e9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nzL5d024NjXIX_8TlT6uFAu973lmfkmHklJC-2i9rAE";}s:2:"id";s:6:"medium";s:5:"label";s:19:"Default medium date";s:6:"locked";b:0;s:7:"pattern";s:14:"D, m/d/Y - H:i";}');
INSERT INTO `config` VALUES ('','core.date_format.short','a:9:{s:4:"uuid";s:36:"a7b2126a-ab50-4b39-bc0b-eb2063ea9a01";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AlzeyytA8InBgxIG9H2UDJYs3CG98Zj6yRsDKmlbZwA";}s:2:"id";s:5:"short";s:5:"label";s:18:"Default short date";s:6:"locked";b:0;s:7:"pattern";s:11:"m/d/Y - H:i";}'),('','core.entity_form_display.block_content.basic.default','a:11:{s:4:"uuid";s:36:"ce7ae483-7bd6-4bdc-8461-7c439246317f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"jAps3FCxvKecABS_tgExbhCZrBLQB3bNPWw18WjE3ss";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:-4;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:4:"info";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}'),('','core.entity_form_display.comment.comment.default','a:11:{s:4:"uuid";s:36:"0b1dec00-8adf-467a-b987-28b5312bb838";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"I0Pa0aQvT_jawlPo9oz4FE3h_ickc55dYKTPl6gILes";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:3:{s:6:"author";a:2:{s:6:"weight";i:-2;s:6:"region";s:7:"content";}s:12:"comment_body";a:5:{s:4:"type";s:13:"text_textarea";s:6:"weight";i:11;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"rows";i:5;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:7:"subject";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}');
INSERT INTO `config` VALUES ('','core.entity_form_display.node.article.default','a:11:{s:4:"uuid";s:36:"8f30e4fc-1c91-43ac-8890-a607fa440c03";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:29:"field.field.node.article.body";i:1;s:32:"field.field.node.article.comment";i:2;s:36:"field.field.node.article.field_image";i:3;s:35:"field.field.node.article.field_tags";i:4;s:21:"image.style.thumbnail";i:5;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"path";i:3;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6VUXB1jTUjK5zjkfMa2Kd2WW4sFUlgfBlfJSx01qLpU";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:11:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:1;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"comment";a:5:{s:4:"type";s:15:"comment_default";s:6:"weight";i:20;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:11:"field_image";a:5:{s:4:"type";s:11:"image_image";s:6:"weight";i:4;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}}s:10:"field_tags";a:5:{s:4:"type";s:34:"entity_reference_autocomplete_tags";s:6:"weight";i:3;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:15;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:120;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:16;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}');
INSERT INTO `config` VALUES ('','core.entity_form_display.node.page.default','a:11:{s:4:"uuid";s:36:"d4b08316-c3b5-4b33-bb78-ddc208140212";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"path";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AD_lefuYmjsKeH3OQApsyP_nLj6ZnGaALznLQSQ0Z_o";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:8:{s:4:"body";a:5:{s:4:"type";s:26:"text_textarea_with_summary";s:6:"weight";i:31;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:4:"rows";i:9;s:12:"summary_rows";i:3;s:11:"placeholder";s:0:"";s:12:"show_summary";b:0;}s:20:"third_party_settings";a:0:{}}s:7:"created";a:5:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:4:"path";a:5:{s:4:"type";s:4:"path";s:6:"weight";i:30;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:7:"promote";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:15;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:6:"status";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:120;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:6:"sticky";a:5:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:16;s:6:"region";s:7:"content";s:20:"third_party_settings";a:0:{}}s:5:"title";a:5:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}s:3:"uid";a:5:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:6:"region";s:7:"content";s:8:"settings";a:4:{s:14:"match_operator";s:8:"CONTAINS";s:11:"match_limit";i:10;s:4:"size";i:60;s:11:"placeholder";s:0:"";}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}');
INSERT INTO `config` VALUES ('','core.entity_form_display.user.user.default','a:11:{s:4:"uuid";s:36:"a6194f6c-bdef-4583-bf3e-9f33c940a8ab";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"K-1rBM8mTIkFp9RqOC2tMRUukOQ1xbRCfSKK8dEddnA";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:7:"account";a:2:{s:6:"weight";i:-10;s:6:"region";s:7:"content";}s:7:"contact";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:8:"language";a:2:{s:6:"weight";i:0;s:6:"region";s:7:"content";}s:8:"timezone";a:2:{s:6:"weight";i:6;s:6:"region";s:7:"content";}s:12:"user_picture";a:5:{s:4:"type";s:11:"image_image";s:8:"settings";a:2:{s:18:"progress_indicator";s:8:"throbber";s:19:"preview_image_style";s:9:"thumbnail";}s:20:"third_party_settings";a:0:{}s:6:"weight";i:-1;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),('','core.entity_form_mode.user.register','a:9:{s:4:"uuid";s:36:"e9552f4c-87df-4527-b3a6-4d3fe230984f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"flXhTcp55yLcyy7ZLOhPGKGZobZQJdkAFVWV3LseiuI";}s:2:"id";s:13:"user.register";s:5:"label";s:8:"Register";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}'),('','core.entity_view_display.block_content.basic.default','a:11:{s:4:"uuid";s:36:"56164653-44e8-418e-97fb-a883f6f8b15f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:36:"field.field.block_content.basic.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"orJpHUlAc_wiQLMUjIgEJXGeiqylGHMPcmNRjGtct-M";}s:2:"id";s:27:"block_content.basic.default";s:16:"targetEntityType";s:13:"block_content";s:6:"bundle";s:5:"basic";s:4:"mode";s:7:"default";s:7:"content";a:1:{s:4:"body";a:6:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}');
INSERT INTO `config` VALUES ('','core.entity_view_display.comment.comment.default','a:11:{s:4:"uuid";s:36:"21756941-3d48-4fc7-a019-13d50933b967";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:40:"field.field.comment.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"77Ye1kR-P6AaiGfEO8mnXNSr7nqtnP3PiiVBwJeGGMI";}s:2:"id";s:23:"comment.comment.default";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:12:"comment_body";a:6:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),('','core.entity_view_display.node.article.default','a:11:{s:4:"uuid";s:36:"09936100-ab99-42ce-94d1-90106f1fbde6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:48:"core.entity_view_display.comment.comment.default";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:17:"image.style.large";i:6;s:17:"node.type.article";}s:6:"module";a:4:{i:0;s:7:"comment";i:1;s:5:"image";i:2;s:4:"text";i:3;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ChmU3AVqDKU32A_fyChG0W9dTRKmVBR58B6OClCLvZI";}s:2:"id";s:20:"node.article.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:7:"default";s:7:"content";a:5:{s:4:"body";a:6:{s:4:"type";s:12:"text_default";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}s:5:"label";s:6:"hidden";}s:7:"comment";a:6:{s:4:"type";s:15:"comment_default";s:6:"weight";i:110;s:6:"region";s:7:"content";s:5:"label";s:5:"above";s:8:"settings";a:2:{s:9:"view_mode";s:7:"default";s:8:"pager_id";i:0;}s:20:"third_party_settings";a:0:{}}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:11:"image_style";s:5:"large";s:10:"image_link";s:0:"";}s:20:"third_party_settings";a:0:{}s:5:"label";s:6:"hidden";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:6:"weight";i:10;s:6:"region";s:7:"content";s:5:"label";s:5:"above";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}}s:5:"links";a:4:{s:6:"weight";i:100;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}}s:6:"hidden";a:0:{}}');
INSERT INTO `config` VALUES ('','core.entity_view_display.node.article.rss','a:11:{s:4:"uuid";s:36:"266be899-a1c2-48af-8bbe-f16f22d34d16";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:6:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2rIr6K5Q0UQ9khg0zE_CK-PtJH76UL-BDDZcZnZzwCc";}s:2:"id";s:16:"node.article.rss";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:3:"rss";s:7:"content";a:1:{s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:4:{s:4:"body";b:1;s:7:"comment";b:1;s:11:"field_image";b:1;s:10:"field_tags";b:1;}}'),('','core.entity_view_display.node.article.teaser','a:11:{s:4:"uuid";s:36:"5c563d22-26c6-431c-8ddc-3de6a2e972cb";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:7:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:29:"field.field.node.article.body";i:2;s:32:"field.field.node.article.comment";i:3;s:36:"field.field.node.article.field_image";i:4;s:35:"field.field.node.article.field_tags";i:5;s:18:"image.style.medium";i:6;s:17:"node.type.article";}s:6:"module";a:3:{i:0;s:5:"image";i:1;s:4:"text";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4NcL2hSQZBpJbYtNuh5jC6kyQTcAc1m5bQpTegEWEso";}s:2:"id";s:19:"node.article.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:4:"mode";s:6:"teaser";s:7:"content";a:4:{s:4:"body";a:6:{s:4:"type";s:23:"text_summary_or_trimmed";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}s:5:"label";s:6:"hidden";}s:11:"field_image";a:6:{s:4:"type";s:5:"image";s:6:"weight";i:-1;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:11:"image_style";s:6:"medium";s:10:"image_link";s:7:"content";}s:20:"third_party_settings";a:0:{}s:5:"label";s:6:"hidden";}s:10:"field_tags";a:6:{s:4:"type";s:22:"entity_reference_label";s:6:"weight";i:10;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:4:"link";b:1;}s:20:"third_party_settings";a:0:{}s:5:"label";s:5:"above";}s:5:"links";a:2:{s:6:"weight";i:100;s:6:"region";s:7:"content";}}s:6:"hidden";a:3:{s:7:"comment";b:1;s:11:"field_image";b:1;s:10:"field_tags";b:1;}}');
INSERT INTO `config` VALUES ('','core.entity_view_display.node.page.default','a:11:{s:4:"uuid";s:36:"aa50f0bf-4c24-4974-9720-c74105fcece9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.field.node.page.body";i:1;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"g1S3_GLaxq4l3I9RIca5Mlz02MxI2KmOquZpHw59akM";}s:2:"id";s:17:"node.page.default";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:4:"body";a:6:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:100;s:6:"region";s:7:"content";s:8:"settings";a:0:{}s:20:"third_party_settings";a:0:{}}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),('','core.entity_view_display.node.page.teaser','a:11:{s:4:"uuid";s:36:"316460e9-692b-44c0-8269-07616166f7b5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:33:"core.entity_view_mode.node.teaser";i:1;s:26:"field.field.node.page.body";i:2;s:14:"node.type.page";}s:6:"module";a:2:{i:0;s:4:"text";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cSv5lDnbIgDug475Hdz3woED2XMqYv3awI-J9u1JLbY";}s:2:"id";s:16:"node.page.teaser";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:4:"mode";s:6:"teaser";s:7:"content";a:2:{s:4:"body";a:6:{s:5:"label";s:6:"hidden";s:4:"type";s:23:"text_summary_or_trimmed";s:6:"weight";i:100;s:6:"region";s:7:"content";s:8:"settings";a:1:{s:11:"trim_length";i:600;}s:20:"third_party_settings";a:0:{}}s:5:"links";a:2:{s:6:"weight";i:101;s:6:"region";s:7:"content";}}s:6:"hidden";a:0:{}}'),('','core.entity_view_display.user.user.compact','a:11:{s:4:"uuid";s:36:"04ed2c81-8a07-4c4c-af48-efa84388348e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:3:{i:0;s:34:"core.entity_view_mode.user.compact";i:1;s:34:"field.field.user.user.user_picture";i:2;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-cLsS3M3JycipXQt9rEb81_HxKneReoGuRh8ijcOPXs";}s:2:"id";s:17:"user.user.compact";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"compact";s:7:"content";a:1:{s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:7:"content";}s:20:"third_party_settings";a:0:{}s:5:"label";s:6:"hidden";}}s:6:"hidden";a:1:{s:10:"member_for";b:1;}}');
INSERT INTO `config` VALUES ('','core.entity_view_display.user.user.default','a:11:{s:4:"uuid";s:36:"8f63e5a1-66dc-4964-948c-a4ffe82433d4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:34:"field.field.user.user.user_picture";i:1;s:21:"image.style.thumbnail";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"V51QPCKkgNREKtSmB9Iu2wmAMEpktVpnzklWaZV8UYo";}s:2:"id";s:17:"user.user.default";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:4:"mode";s:7:"default";s:7:"content";a:2:{s:10:"member_for";a:2:{s:6:"weight";i:5;s:6:"region";s:7:"content";}s:12:"user_picture";a:6:{s:4:"type";s:5:"image";s:6:"weight";i:0;s:6:"region";s:7:"content";s:8:"settings";a:2:{s:11:"image_style";s:9:"thumbnail";s:10:"image_link";s:7:"content";}s:20:"third_party_settings";a:0:{}s:5:"label";s:6:"hidden";}}s:6:"hidden";a:0:{}}'),('','core.entity_view_mode.block_content.full','a:9:{s:4:"uuid";s:36:"161a3b7e-6100-4be2-af77-c97c2c573122";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:13:"block_content";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"4tedlMuvQjDOdvHdw86_e-2Rt78aR7TGFMfOK8Ejppg";}s:2:"id";s:18:"block_content.full";s:5:"label";s:4:"Full";s:16:"targetEntityType";s:13:"block_content";s:5:"cache";b:1;}'),('','core.entity_view_mode.comment.full','a:9:{s:4:"uuid";s:36:"c591e26c-3ebb-44f7-b644-5c46b15b5770";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"K7eNlfU7NEUajz01wItywZklr2oaPgL6s1_97fmDXLA";}s:2:"id";s:12:"comment.full";s:5:"label";s:12:"Full comment";s:16:"targetEntityType";s:7:"comment";s:5:"cache";b:1;}'),('','core.entity_view_mode.node.full','a:9:{s:4:"uuid";s:36:"85a78151-bf74-47b4-9a7f-5782049b7f23";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ElrtInxGjZd7GaapJ5O9n-ugi2hG2IxFivtgn0tHOsk";}s:2:"id";s:9:"node.full";s:5:"label";s:12:"Full content";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}');
INSERT INTO `config` VALUES ('','core.entity_view_mode.node.rss','a:9:{s:4:"uuid";s:36:"602af499-716f-49a2-bd2b-566a725a62fa";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vlYzr-rp2f9NMp-Qlr4sFjlqRq-90mco5-afLNGwCrU";}s:2:"id";s:8:"node.rss";s:5:"label";s:3:"RSS";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),('','core.entity_view_mode.node.search_index','a:9:{s:4:"uuid";s:36:"10cdca43-9784-4c0d-a964-e9ceb9ee3bb0";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fVFfJv_GzBRE-wpRHbfD5a3VjnhbEOXG6lvRd3uaccY";}s:2:"id";s:17:"node.search_index";s:5:"label";s:12:"Search index";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),('','core.entity_view_mode.node.search_result','a:9:{s:4:"uuid";s:36:"9275da4d-0037-4d10-8b19-3f911310cb3e";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6GCOQ-jP2RbdbHA5YWQ6bT8CfGbqrBYKOSC_XY4E3ZM";}s:2:"id";s:18:"node.search_result";s:5:"label";s:32:"Search result highlighting input";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),('','core.entity_view_mode.node.teaser','a:9:{s:4:"uuid";s:36:"04e19688-a980-49d5-a01f-a7a142aeab80";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Mz9qWr1kUYK0mjRAGDsr5XS6PvtZ24en_7ndt-pyWe4";}s:2:"id";s:11:"node.teaser";s:5:"label";s:6:"Teaser";s:16:"targetEntityType";s:4:"node";s:5:"cache";b:1;}'),('','core.entity_view_mode.taxonomy_term.full','a:9:{s:4:"uuid";s:36:"545494df-9caa-4584-9964-698d6d292ae9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"-PPKjsNQPvoIDjOuUAvlLocYD976MNjb9Zpgyz5_BWE";}s:2:"id";s:18:"taxonomy_term.full";s:5:"label";s:18:"Taxonomy term page";s:16:"targetEntityType";s:13:"taxonomy_term";s:5:"cache";b:1;}');
INSERT INTO `config` VALUES ('','core.entity_view_mode.user.compact','a:9:{s:4:"uuid";s:36:"3319117d-76b5-4d3b-b0e2-fe6b514d7110";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"71CSAr_LNPcgu6D6jI4INl1KATkahmeyUFBETAWya8g";}s:2:"id";s:12:"user.compact";s:5:"label";s:7:"Compact";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}'),('','core.entity_view_mode.user.full','a:9:{s:4:"uuid";s:36:"61c3abd7-873f-481a-83f1-d5c9b237e9de";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mQIF_foYjmnVSr9MpcD4CTaJE_FpO1AyDd_DskztGhM";}s:2:"id";s:9:"user.full";s:5:"label";s:12:"User account";s:16:"targetEntityType";s:4:"user";s:5:"cache";b:1;}'),('','core.extension','a:4:{s:6:"module";a:44:{s:14:"automated_cron";i:0;s:14:"backup_migrate";i:0;s:8:"big_pipe";i:0;s:5:"block";i:0;s:13:"block_content";i:0;s:10:"breakpoint";i:0;s:8:"ckeditor";i:0;s:5:"color";i:0;s:7:"comment";i:0;s:6:"config";i:0;s:7:"contact";i:0;s:10:"contextual";i:0;s:8:"datetime";i:0;s:5:"dblog";i:0;s:18:"dynamic_page_cache";i:0;s:6:"editor";i:0;s:5:"field";i:0;s:8:"field_ui";i:0;s:4:"file";i:0;s:6:"filter";i:0;s:4:"help";i:0;s:7:"history";i:0;s:5:"image";i:0;s:4:"link";i:0;s:17:"menu_link_content";i:0;s:7:"menu_ui";i:0;s:4:"node";i:0;s:7:"options";i:0;s:10:"page_cache";i:0;s:4:"path";i:0;s:10:"path_alias";i:0;s:9:"quickedit";i:0;s:3:"rdf";i:0;s:6:"search";i:0;s:8:"shortcut";i:0;s:6:"system";i:0;s:8:"taxonomy";i:0;s:4:"text";i:0;s:7:"toolbar";i:0;s:4:"tour";i:0;s:4:"user";i:0;s:8:"views_ui";i:0;s:5:"views";i:10;s:8:"standard";i:1000;}s:5:"theme";a:5:{s:6:"stable";i:0;s:6:"classy";i:0;s:6:"bartik";i:0;s:5:"seven";i:0;s:6:"twenty";i:0;}s:7:"profile";s:8:"standard";s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"R4IF-ClDHXxblLcG0L7MgsLvfBIMAvi_skumNFQwkDc";}}'),('','core.menu.static_menu_link_overrides','a:2:{s:11:"definitions";a:1:{s:18:"contact__site_page";a:5:{s:7:"enabled";b:1;s:9:"menu_name";s:6:"footer";s:6:"parent";s:0:"";s:6:"weight";i:0;s:8:"expanded";b:0;}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"o4bYR9ZupWb3AsOIizTUG4g-nu1mdJqA59UB7QT-ifQ";}}');
INSERT INTO `config` VALUES ('','dblog.settings','a:2:{s:9:"row_limit";i:1000;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"e883aGsrt1wFrsydlYU584PZONCSfRy0DtkZ9KzHb58";}}'),('','editor.editor.basic_html','a:9:{s:4:"uuid";s:36:"233dbb2c-759e-4942-ab34-b095b712e742";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"filter.format.basic_html";}s:6:"module";a:1:{i:0;s:8:"ckeditor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AqlPmO16LvJI4D0Ih6u4GFQIzqr5OnLgAUSjcUGWk2g";}s:6:"format";s:10:"basic_html";s:6:"editor";s:8:"ckeditor";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:4:"rows";a:1:{i:0;a:6:{i:0;a:2:{s:4:"name";s:10:"Formatting";s:5:"items";a:2:{i:0;s:4:"Bold";i:1;s:6:"Italic";}}i:1;a:2:{s:4:"name";s:7:"Linking";s:5:"items";a:2:{i:0;s:10:"DrupalLink";i:1;s:12:"DrupalUnlink";}}i:2;a:2:{s:4:"name";s:5:"Lists";s:5:"items";a:2:{i:0;s:12:"BulletedList";i:1;s:12:"NumberedList";}}i:3;a:2:{s:4:"name";s:5:"Media";s:5:"items";a:2:{i:0;s:10:"Blockquote";i:1;s:11:"DrupalImage";}}i:4;a:2:{s:4:"name";s:16:"Block Formatting";s:5:"items";a:1:{i:0;s:6:"Format";}}i:5;a:2:{s:4:"name";s:5:"Tools";s:5:"items";a:1:{i:0;s:6:"Source";}}}}}s:7:"plugins";a:1:{s:11:"stylescombo";a:1:{s:6:"styles";s:0:"";}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";s:0:"";s:14:"max_dimensions";a:2:{s:5:"width";i:0;s:6:"height";i:0;}}}'),('','editor.editor.full_html','a:9:{s:4:"uuid";s:36:"77909f6a-3732-4465-8e51-f7ea81a3bc78";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"filter.format.full_html";}s:6:"module";a:1:{i:0;s:8:"ckeditor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"967ijj7p6i7rwrYl7r08WQFeCY_c23YAh0h8u-w_CXM";}s:6:"format";s:9:"full_html";s:6:"editor";s:8:"ckeditor";s:8:"settings";a:2:{s:7:"toolbar";a:1:{s:4:"rows";a:1:{i:0;a:6:{i:0;a:2:{s:4:"name";s:10:"Formatting";s:5:"items";a:7:{i:0;s:4:"Bold";i:1;s:6:"Italic";i:2;s:6:"Strike";i:3;s:11:"Superscript";i:4;s:9:"Subscript";i:5;s:1:"-";i:6;s:12:"RemoveFormat";}}i:1;a:2:{s:4:"name";s:7:"Linking";s:5:"items";a:2:{i:0;s:10:"DrupalLink";i:1;s:12:"DrupalUnlink";}}i:2;a:2:{s:4:"name";s:5:"Lists";s:5:"items";a:2:{i:0;s:12:"BulletedList";i:1;s:12:"NumberedList";}}i:3;a:2:{s:4:"name";s:5:"Media";s:5:"items";a:4:{i:0;s:10:"Blockquote";i:1;s:11:"DrupalImage";i:2;s:5:"Table";i:3;s:14:"HorizontalRule";}}i:4;a:2:{s:4:"name";s:16:"Block Formatting";s:5:"items";a:1:{i:0;s:6:"Format";}}i:5;a:2:{s:4:"name";s:5:"Tools";s:5:"items";a:2:{i:0;s:10:"ShowBlocks";i:1;s:6:"Source";}}}}}s:7:"plugins";a:1:{s:11:"stylescombo";a:1:{s:6:"styles";s:0:"";}}}s:12:"image_upload";a:5:{s:6:"status";b:1;s:6:"scheme";s:6:"public";s:9:"directory";s:13:"inline-images";s:8:"max_size";s:0:"";s:14:"max_dimensions";a:2:{s:5:"width";i:0;s:6:"height";i:0;}}}');
INSERT INTO `config` VALUES ('','field.field.block_content.basic.body','a:17:{s:4:"uuid";s:36:"92808a43-7fc3-4d0a-8988-47add6c803e9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:24:"block_content.type.basic";i:1;s:32:"field.storage.block_content.body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"foetbaMhlB6uLc2bn-PESvaPkbuDWj0MEjpQVwQiP-o";}s:2:"id";s:24:"block_content.basic.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:6:"bundle";s:5:"basic";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:0;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}'),('','field.field.comment.comment.comment_body','a:17:{s:4:"uuid";s:36:"79574c9f-af3c-49a7-9eee-dd32c79a9015";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:20:"comment.type.comment";i:1;s:34:"field.storage.comment.comment_body";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TmAKjNrJ7RR60YpqvJq_QqEewYe_S8Kd23n8VRCqiWs";}s:2:"id";s:28:"comment.comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"label";s:7:"Comment";s:11:"description";s:0:"";s:8:"required";b:1;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:0:{}s:10:"field_type";s:9:"text_long";}'),('','field.field.node.article.body','a:17:{s:4:"uuid";s:36:"101c3cca-0fe1-4dd5-8939-a2f20b100c88";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"IjZnOLWk1Pjq3WRg2pLSA1ERh7Po7izCq_p6UztZr2c";}s:2:"id";s:17:"node.article.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}');
INSERT INTO `config` VALUES ('','field.field.node.article.comment','a:17:{s:4:"uuid";s:36:"5f5645bc-1aec-495c-a653-ede1db601075";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:26:"field.storage.node.comment";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"r-hrxwbKKXBKQnBefGjXNSdU00u2fPvMWEykGRHqd10";}s:2:"id";s:20:"node.article.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:8:"Comments";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:6:{s:6:"status";i:2;s:3:"cid";i:0;s:17:"last_comment_name";N;s:22:"last_comment_timestamp";i:0;s:16:"last_comment_uid";i:0;s:13:"comment_count";i:0;}}s:22:"default_value_callback";s:0:"";s:8:"settings";a:5:{s:12:"default_mode";i:1;s:8:"per_page";i:50;s:13:"form_location";b:1;s:9:"anonymous";i:0;s:7:"preview";i:1;}s:10:"field_type";s:7:"comment";}'),('','field.field.node.article.field_image','a:17:{s:4:"uuid";s:36:"3cb9d578-7c1e-4b3b-bbad-9f364e7f50ae";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"field.storage.node.field_image";i:1;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:5:"image";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tgJzhA7Swh4M_gWU5FwFe5lPxPj5rebpMbvhpdNrERs";}s:2:"id";s:24:"node.article.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:5:"Image";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:14:"file_directory";s:31:"[date:custom:Y]-[date:custom:m]";s:15:"file_extensions";s:16:"png gif jpg jpeg";s:12:"max_filesize";s:0:"";s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:9:"alt_field";b:1;s:11:"title_field";b:0;s:18:"alt_field_required";b:1;s:20:"title_field_required";b:0;s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}}s:10:"field_type";s:5:"image";}');
INSERT INTO `config` VALUES ('','field.field.node.article.field_tags','a:17:{s:4:"uuid";s:36:"f1957d20-5c69-4b69-bc17-1132d838aa9f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"config";a:3:{i:0;s:29:"field.storage.node.field_tags";i:1;s:17:"node.type.article";i:2;s:24:"taxonomy.vocabulary.tags";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"QdUgf_beeoaPiyKorFv0q1fcJpWH_uZTqe_xoVJacrw";}s:2:"id";s:23:"node.article.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:6:"bundle";s:7:"article";s:5:"label";s:4:"Tags";s:11:"description";s:84:"Enter a comma-separated list. For example: Amsterdam, Mexico City, "Cleveland, Ohio"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:7:"handler";s:21:"default:taxonomy_term";s:16:"handler_settings";a:3:{s:14:"target_bundles";a:1:{s:4:"tags";s:4:"tags";}s:4:"sort";a:1:{s:5:"field";s:5:"_none";}s:11:"auto_create";b:1;}}s:10:"field_type";s:16:"entity_reference";}'),('','field.field.node.page.body','a:17:{s:4:"uuid";s:36:"5e0a0055-173b-4c3e-b03d-fd66720c97be";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:23:"field.storage.node.body";i:1;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KgVkxLl_K3E3lvN6CEoWQIDT0V8J4Mv-fVYrAIc7-FE";}s:2:"id";s:14:"node.page.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:6:"bundle";s:4:"page";s:5:"label";s:4:"Body";s:11:"description";s:0:"";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:2:{s:15:"display_summary";b:1;s:16:"required_summary";b:0;}s:10:"field_type";s:17:"text_with_summary";}'),('','field.field.user.user.user_picture','a:17:{s:4:"uuid";s:36:"42230958-0e1c-4dee-927e-f784437fcf31";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:31:"field.storage.user.user_picture";}s:6:"module";a:2:{i:0;s:5:"image";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Iiq0AttdhgbebJwabSFwQQ1ORn64GoGz0xSZ_eyCJ8A";}s:2:"id";s:22:"user.user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:6:"bundle";s:4:"user";s:5:"label";s:7:"Picture";s:11:"description";s:29:"Your virtual face or picture.";s:8:"required";b:0;s:12:"translatable";b:1;s:13:"default_value";a:0:{}s:22:"default_value_callback";s:0:"";s:8:"settings";a:12:{s:15:"file_extensions";s:16:"png gif jpg jpeg";s:14:"file_directory";s:40:"pictures/[date:custom:Y]-[date:custom:m]";s:12:"max_filesize";s:0:"";s:9:"alt_field";b:0;s:11:"title_field";b:0;s:14:"max_resolution";s:0:"";s:14:"min_resolution";s:0:"";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}s:18:"alt_field_required";b:0;s:20:"title_field_required";b:0;s:7:"handler";s:12:"default:file";s:16:"handler_settings";a:0:{}}s:10:"field_type";s:5:"image";}');
INSERT INTO `config` VALUES ('','field.settings','a:2:{s:16:"purge_batch_size";i:50;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nJk0TAQBzlNo52ehiHI7bIEPLGi0BYqZvPdEn7Chfu0";}}'),('','field.storage.block_content.body','a:17:{s:4:"uuid";s:36:"28c1c20b-1e50-4276-a61c-7c8df4790f94";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc";}s:2:"id";s:18:"block_content.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:13:"block_content";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}'),('','field.storage.comment.comment_body','a:17:{s:4:"uuid";s:36:"e4c97621-a86e-4ef2-9011-bb58634bdbd8";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw";}s:2:"id";s:20:"comment.comment_body";s:10:"field_name";s:12:"comment_body";s:11:"entity_type";s:7:"comment";s:4:"type";s:9:"text_long";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}'),('','field.storage.node.body','a:17:{s:4:"uuid";s:36:"f56076c2-3d15-4179-b1a3-7c27c846e13b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:2:"id";s:9:"node.body";s:10:"field_name";s:4:"body";s:11:"entity_type";s:4:"node";s:4:"type";s:17:"text_with_summary";s:8:"settings";a:0:{}s:6:"module";s:4:"text";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:1;s:14:"custom_storage";b:0;}');
INSERT INTO `config` VALUES ('','field.storage.node.comment','a:17:{s:4:"uuid";s:36:"9a407d32-1165-407d-8b46-0d08ae733fd0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ktCna9xmWvYZIUfOCUyDQvedn5RtnS4CRmEIwNmvYjc";}s:2:"id";s:12:"node.comment";s:10:"field_name";s:7:"comment";s:11:"entity_type";s:4:"node";s:4:"type";s:7:"comment";s:8:"settings";a:1:{s:12:"comment_type";s:7:"comment";}s:6:"module";s:7:"comment";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),('','field.storage.node.field_image','a:17:{s:4:"uuid";s:36:"270d89b6-2253-4ee7-a129-e3f30ac9e2a7";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SkXIPKZYiIMMtnBmfnxk58RYfbZ8cHSw5NZPY_JByME";}s:2:"id";s:16:"node.field_image";s:10:"field_name";s:11:"field_image";s:11:"entity_type";s:4:"node";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),('','field.storage.node.field_tags','a:17:{s:4:"uuid";s:36:"c5f588eb-0952-4250-af4d-8f5501a1d24d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs";}s:2:"id";s:15:"node.field_tags";s:10:"field_name";s:10:"field_tags";s:11:"entity_type";s:4:"node";s:4:"type";s:16:"entity_reference";s:8:"settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:6:"module";s:4:"core";s:6:"locked";b:0;s:11:"cardinality";i:-1;s:12:"translatable";b:1;s:7:"indexes";a:0:{}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}');
INSERT INTO `config` VALUES ('','field.storage.user.user_picture','a:17:{s:4:"uuid";s:36:"0a803be1-f0bb-44e2-b180-69f64fa6600d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"6k-VBFilDLuzgSOT-77CFgHFlcd5D-kqRixtH89EShU";}s:2:"id";s:17:"user.user_picture";s:10:"field_name";s:12:"user_picture";s:11:"entity_type";s:4:"user";s:4:"type";s:5:"image";s:8:"settings";a:5:{s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;}s:6:"module";s:5:"image";s:6:"locked";b:0;s:11:"cardinality";i:1;s:12:"translatable";b:1;s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:22:"persist_with_no_fields";b:0;s:14:"custom_storage";b:0;}'),('','field_ui.settings','a:2:{s:12:"field_prefix";s:6:"field_";s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q1nMi90W6YQxKzZAgJQw7Ag9U4JrsEUwkomF0lhvbIM";}}'),('','file.settings','a:4:{s:11:"description";a:2:{s:4:"type";s:9:"textfield";s:6:"length";i:128;}s:4:"icon";a:1:{s:9:"directory";s:23:"core/modules/file/icons";}s:35:"make_unused_managed_files_temporary";b:0;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"0aMkoXYnax5_tHI9C9zHs-K48KJ6K75PHtD9x-0nbgM";}}'),('','filter.format.basic_html','a:9:{s:4:"uuid";s:36:"61159952-ebf2-488e-b215-84d018846c51";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"P8ddpAIKtawJDi5SzOwCzVnnNYqONewSTJ6Xn0dW_aQ";}s:4:"name";s:10:"Basic HTML";s:6:"format";s:10:"basic_html";s:6:"weight";i:0;s:7:"filters";a:5:{s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:250:"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id> <p> <br> <span> <img src alt height width data-entity-type data-entity-uuid data-align data-caption>";s:16:"filter_html_help";b:0;s:20:"filter_html_nofollow";b:0;}}s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:7;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:24:"filter_html_image_secure";a:5:{s:2:"id";s:24:"filter_html_image_secure";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}}}');
INSERT INTO `config` VALUES ('','filter.format.full_html','a:9:{s:4:"uuid";s:36:"3d06ca20-2259-489b-9d48-ca4373de7a7e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:6:"editor";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"WNeK5FbcY8pXgEpbD_KgRzlF1-5PL3BJXwqaBctPTqw";}s:4:"name";s:9:"Full HTML";s:6:"format";s:9:"full_html";s:6:"weight";i:2;s:7:"filters";a:4:{s:12:"filter_align";a:5:{s:2:"id";s:12:"filter_align";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:8;s:8:"settings";a:0:{}}s:14:"filter_caption";a:5:{s:2:"id";s:14:"filter_caption";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:9;s:8:"settings";a:0:{}}s:20:"filter_htmlcorrector";a:5:{s:2:"id";s:20:"filter_htmlcorrector";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:10;s:8:"settings";a:0:{}}s:21:"editor_file_reference";a:5:{s:2:"id";s:21:"editor_file_reference";s:8:"provider";s:6:"editor";s:6:"status";b:1;s:6:"weight";i:11;s:8:"settings";a:0:{}}}}'),('','filter.format.plain_text','a:9:{s:4:"uuid";s:36:"5edb20f4-71e6-4c6d-bb49-3f0a2bcb4186";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"NIKBt6kw_uPhNI0qtR2DnRf7mSOgAQdx7Q94SKMjXbQ";}s:4:"name";s:10:"Plain text";s:6:"format";s:10:"plain_text";s:6:"weight";i:10;s:7:"filters";a:3:{s:18:"filter_html_escape";a:5:{s:2:"id";s:18:"filter_html_escape";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}}}'),('','filter.format.restricted_html','a:9:{s:4:"uuid";s:36:"8b491e42-e0cd-4883-9d63-9d891ed23e6a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"oz6NyPDAB4HB6N9hgH2LwNVtCd-sXbMG1fbn5KsRIDI";}s:4:"name";s:15:"Restricted HTML";s:6:"format";s:15:"restricted_html";s:6:"weight";i:1;s:7:"filters";a:3:{s:11:"filter_html";a:5:{s:2:"id";s:11:"filter_html";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:-10;s:8:"settings";a:3:{s:12:"allowed_html";s:149:"<a href hreflang> <em> <strong> <cite> <blockquote cite> <code> <ul type> <ol start type> <li> <dl> <dt> <dd> <h2 id> <h3 id> <h4 id> <h5 id> <h6 id>";s:16:"filter_html_help";b:1;s:20:"filter_html_nofollow";b:0;}}s:12:"filter_autop";a:5:{s:2:"id";s:12:"filter_autop";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:0:{}}s:10:"filter_url";a:5:{s:2:"id";s:10:"filter_url";s:8:"provider";s:6:"filter";s:6:"status";b:1;s:6:"weight";i:0;s:8:"settings";a:1:{s:17:"filter_url_length";i:72;}}}}');
INSERT INTO `config` VALUES ('','filter.settings','a:3:{s:15:"fallback_format";s:10:"plain_text";s:27:"always_show_fallback_choice";b:0;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"FiPjM3WdB__ruFA7B6TLwni_UcZbmek5G4b2dxQItxA";}}'),('','image.settings','a:4:{s:13:"preview_image";s:29:"core/modules/image/sample.png";s:26:"allow_insecure_derivatives";b:0;s:20:"suppress_itok_output";b:0;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k-yDFHbqNfpe-Srg4sdCSqaosCl2D8uwyEY5esF8gEw";}}'),('','image.style.large','a:8:{s:4:"uuid";s:36:"d6239d57-dffa-4c8c-a1e8-8ef5519482db";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"J2n0RpFzS0-bgSyxjs6rSdgxB1rb-bTAgqywNx_964M";}s:4:"name";s:5:"large";s:5:"label";s:16:"Large (480×480)";s:7:"effects";a:1:{s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";a:4:{s:4:"uuid";s:36:"ddd73aa7-4bd6-4c85-b600-bdf2b1628d1d";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:480;s:6:"height";i:480;s:7:"upscale";b:0;}}}}'),('','image.style.medium','a:8:{s:4:"uuid";s:36:"1415e093-2e38-4fd5-ae80-6ecf70702ddf";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Y9NmnZHQq20ASSyTNA6JnwtWrJJiSajOehGDtmUFdM0";}s:4:"name";s:6:"medium";s:5:"label";s:17:"Medium (220×220)";s:7:"effects";a:1:{s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";a:4:{s:4:"uuid";s:36:"bddf0d06-42f9-4c75-a700-a33cafa25ea0";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:220;s:6:"height";i:220;s:7:"upscale";b:0;}}}}'),('','image.style.thumbnail','a:8:{s:4:"uuid";s:36:"8d73ce16-6ef7-4ab5-9b48-037c65eb9864";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"cCiWdBHgLwj5omG35lsKc4LkW4MBdmcctkVop4ol5x0";}s:4:"name";s:9:"thumbnail";s:5:"label";s:20:"Thumbnail (100×100)";s:7:"effects";a:1:{s:36:"1cfec298-8620-4749-b100-ccb6c4500779";a:4:{s:4:"uuid";s:36:"1cfec298-8620-4749-b100-ccb6c4500779";s:2:"id";s:11:"image_scale";s:6:"weight";i:0;s:4:"data";a:3:{s:5:"width";i:100;s:6:"height";i:100;s:7:"upscale";b:0;}}}}');
INSERT INTO `config` VALUES ('','menu_ui.settings','a:2:{s:24:"override_parent_selector";b:0;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SqMarzIjxC3F8dZo9FEOxfqDKD_sdW1tbcFTV1BA2zU";}}'),('','node.settings','a:2:{s:15:"use_admin_theme";b:1;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"W0cgFPhPJ3gAdqm06-az48BLf5MVcoZVS0HdByoofi0";}}'),('','node.type.article','a:12:{s:4:"uuid";s:36:"3b36644d-0842-42a0-9ca7-cf64d79c967d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"AeW1SEDgb1OTQACAWGhzvMknMYAJlcZu0jljfeU3oso";}s:4:"name";s:7:"Article";s:4:"type";s:7:"article";s:11:"description";s:89:"Use <em>articles</em> for time-sensitive content like news, press releases or blog posts.";s:4:"help";s:0:"";s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:1;}'),('','node.type.page','a:12:{s:4:"uuid";s:36:"b7948230-069d-4546-b275-3875ee5ad828";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"KuyA4NHPXcmKAjRtwa0vQc2ZcyrUJy6IlS2TAyMNRbc";}s:4:"name";s:10:"Basic page";s:4:"type";s:4:"page";s:11:"description";s:77:"Use <em>basic pages</em> for your static content, such as an ''About us'' page.";s:4:"help";s:0:"";s:12:"new_revision";b:1;s:12:"preview_mode";i:1;s:17:"display_submitted";b:0;}'),('','rdf.mapping.comment.comment','a:10:{s:4:"uuid";s:36:"fd151377-09e9-4976-b054-e2aabc7e16e4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:20:"comment.type.comment";}s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uETe6XupRGKDForx2MpY0pMOEu6CzGgdCAZZOKkbgmk";}s:2:"id";s:15:"comment.comment";s:16:"targetEntityType";s:7:"comment";s:6:"bundle";s:7:"comment";s:5:"types";a:1:{i:0;s:14:"schema:Comment";}s:13:"fieldMappings";a:5:{s:7:"subject";a:1:{s:10:"properties";a:1:{i:0;s:11:"schema:name";}}s:7:"created";a:2:{s:10:"properties";a:1:{i:0;s:18:"schema:dateCreated";}s:17:"datatype_callback";a:1:{s:8:"callable";s:48:"Drupal\\rdf\\CommonDataConverter::dateIso8601Value";}}s:7:"changed";a:2:{s:10:"properties";a:1:{i:0;s:19:"schema:dateModified";}s:17:"datatype_callback";a:1:{s:8:"callable";s:48:"Drupal\\rdf\\CommonDataConverter::dateIso8601Value";}}s:12:"comment_body";a:1:{s:10:"properties";a:1:{i:0;s:11:"schema:text";}}s:3:"uid";a:2:{s:10:"properties";a:1:{i:0;s:13:"schema:author";}s:12:"mapping_type";s:3:"rel";}}}');
INSERT INTO `config` VALUES ('','rdf.mapping.node.article','a:10:{s:4:"uuid";s:36:"75856c99-6560-414a-9df9-a9bb4be8c3c1";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:17:"node.type.article";}s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"IdobJe379eDudt7-bXFfJjF7pDqFl-kYxVFtpWrgkro";}s:2:"id";s:12:"node.article";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:7:"article";s:5:"types";a:1:{i:0;s:14:"schema:Article";}s:13:"fieldMappings";a:9:{s:5:"title";a:1:{s:10:"properties";a:1:{i:0;s:11:"schema:name";}}s:7:"created";a:2:{s:10:"properties";a:1:{i:0;s:18:"schema:dateCreated";}s:17:"datatype_callback";a:1:{s:8:"callable";s:48:"Drupal\\rdf\\CommonDataConverter::dateIso8601Value";}}s:7:"changed";a:2:{s:10:"properties";a:1:{i:0;s:19:"schema:dateModified";}s:17:"datatype_callback";a:1:{s:8:"callable";s:48:"Drupal\\rdf\\CommonDataConverter::dateIso8601Value";}}s:4:"body";a:1:{s:10:"properties";a:1:{i:0;s:11:"schema:text";}}s:3:"uid";a:1:{s:10:"properties";a:1:{i:0;s:13:"schema:author";}}s:7:"comment";a:2:{s:10:"properties";a:1:{i:0;s:14:"schema:comment";}s:12:"mapping_type";s:3:"rel";}s:13:"comment_count";a:2:{s:10:"properties";a:1:{i:0;s:23:"schema:interactionCount";}s:17:"datatype_callback";a:2:{s:8:"callable";s:51:"Drupal\\rdf\\SchemaOrgDataConverter::interactionCount";s:9:"arguments";a:1:{s:16:"interaction_type";s:12:"UserComments";}}}s:11:"field_image";a:1:{s:10:"properties";a:1:{i:0;s:12:"schema:image";}}s:10:"field_tags";a:1:{s:10:"properties";a:1:{i:0;s:12:"schema:about";}}}}'),('','rdf.mapping.node.page','a:10:{s:4:"uuid";s:36:"b7a94fb0-56e6-41ca-8bac-747597ec2493";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:14:"node.type.page";}s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"32LxRnl4Wesvzqyfp7HnD0-U9-wxrLBn76pqY5XGNAE";}s:2:"id";s:9:"node.page";s:16:"targetEntityType";s:4:"node";s:6:"bundle";s:4:"page";s:5:"types";a:1:{i:0;s:14:"schema:WebPage";}s:13:"fieldMappings";a:6:{s:5:"title";a:1:{s:10:"properties";a:1:{i:0;s:11:"schema:name";}}s:7:"created";a:2:{s:10:"properties";a:1:{i:0;s:18:"schema:dateCreated";}s:17:"datatype_callback";a:1:{s:8:"callable";s:48:"Drupal\\rdf\\CommonDataConverter::dateIso8601Value";}}s:7:"changed";a:2:{s:10:"properties";a:1:{i:0;s:19:"schema:dateModified";}s:17:"datatype_callback";a:1:{s:8:"callable";s:48:"Drupal\\rdf\\CommonDataConverter::dateIso8601Value";}}s:4:"body";a:1:{s:10:"properties";a:1:{i:0;s:11:"schema:text";}}s:3:"uid";a:2:{s:10:"properties";a:1:{i:0;s:13:"schema:author";}s:12:"mapping_type";s:3:"rel";}s:13:"comment_count";a:2:{s:10:"properties";a:1:{i:0;s:23:"schema:interactionCount";}s:17:"datatype_callback";a:2:{s:8:"callable";s:51:"Drupal\\rdf\\SchemaOrgDataConverter::interactionCount";s:9:"arguments";a:1:{s:16:"interaction_type";s:12:"UserComments";}}}}}');
INSERT INTO `config` VALUES ('','rdf.mapping.taxonomy_term.tags','a:10:{s:4:"uuid";s:36:"04733885-c41b-4e13-afb1-d047d3514038";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"o5duwyS1CTHx3tYOZhuu91kspe8VQjQsnwZjAJv9njk";}s:2:"id";s:18:"taxonomy_term.tags";s:16:"targetEntityType";s:13:"taxonomy_term";s:6:"bundle";s:4:"tags";s:5:"types";a:1:{i:0;s:12:"schema:Thing";}s:13:"fieldMappings";a:2:{s:4:"name";a:1:{s:10:"properties";a:1:{i:0;s:11:"schema:name";}}s:11:"description";a:1:{s:10:"properties";a:1:{i:0;s:18:"schema:description";}}}}'),('','rdf.mapping.user.user','a:10:{s:4:"uuid";s:36:"2e97774f-5752-4b9a-98f9-9738837384f0";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TGTlmpYAtXxjtYMFA_A0vosE2c4R5MCQwLviIA5HUM0";}s:2:"id";s:9:"user.user";s:16:"targetEntityType";s:4:"user";s:6:"bundle";s:4:"user";s:5:"types";a:1:{i:0;s:13:"schema:Person";}s:13:"fieldMappings";a:1:{s:4:"name";a:1:{s:10:"properties";a:1:{i:0;s:11:"schema:name";}}}}'),('','search.page.node_search','a:11:{s:4:"uuid";s:36:"47fb7b52-8b53-43ed-be33-567e213e4690";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"97tvtzGOa8_flb22CzSjgtm_YkiGMHvEBO-6q2K9V_U";}s:2:"id";s:11:"node_search";s:5:"label";s:7:"Content";s:4:"path";s:4:"node";s:6:"weight";i:-10;s:6:"plugin";s:11:"node_search";s:13:"configuration";a:1:{s:8:"rankings";a:0:{}}}'),('','search.page.user_search','a:11:{s:4:"uuid";s:36:"af8678c5-12dd-4eb3-8495-d4555dd3b480";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"k3aUaZXGDuhkek2TZIee0PApOPTvYZLadziekdyHA5A";}s:2:"id";s:11:"user_search";s:5:"label";s:5:"Users";s:4:"path";s:4:"user";s:6:"weight";i:0;s:6:"plugin";s:11:"user_search";s:13:"configuration";a:0:{}}');
INSERT INTO `config` VALUES ('','search.settings','a:5:{s:12:"and_or_limit";i:7;s:12:"default_page";s:11:"node_search";s:5:"index";a:4:{s:10:"cron_limit";i:100;s:11:"overlap_cjk";b:1;s:17:"minimum_word_size";i:3;s:11:"tag_weights";a:12:{s:2:"h1";i:25;s:2:"h2";i:18;s:2:"h3";i:15;s:2:"h4";i:14;s:2:"h5";i:9;s:2:"h6";i:6;s:1:"u";i:3;s:1:"b";i:3;s:1:"i";i:3;s:6:"strong";i:3;s:2:"em";i:3;s:1:"a";i:10;}}s:7:"logging";b:0;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"hvVxL1G-ZCxaq32IZws0YsfuhvaDiQE_np-0g35KjUk";}}'),('','seven.settings','a:1:{s:20:"third_party_settings";a:1:{s:8:"shortcut";a:1:{s:11:"module_link";b:1;}}}'),('','shortcut.set.default','a:7:{s:4:"uuid";s:36:"6b11b537-3e0d-48be-9057-a104a01f433e";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"U5VlGjd_SfV0Qm_EfnaynOfc549cNscFAx48JfYoMRI";}s:2:"id";s:7:"default";s:5:"label";s:7:"Default";}'),('','system.action.comment_delete_action','a:10:{s:4:"uuid";s:36:"3d6650a5-641a-4533-b581-bbf805eda209";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"vpBH8OmL4sdesCdeZLsW8KOutB5gkbreWJbfjhfFKaQ";}s:2:"id";s:21:"comment_delete_action";s:5:"label";s:14:"Delete comment";s:4:"type";s:7:"comment";s:6:"plugin";s:28:"entity:delete_action:comment";s:13:"configuration";a:0:{}}'),('','system.action.comment_publish_action','a:10:{s:4:"uuid";s:36:"cdd13e94-8a85-4745-a6e3-9bbceac091ba";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C00dyL_W_5M0nFlgUB3lWUTUs96jn51Jw1MLHVEHZD0";}s:2:"id";s:22:"comment_publish_action";s:5:"label";s:15:"Publish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:29:"entity:publish_action:comment";s:13:"configuration";a:0:{}}'),('','system.action.comment_save_action','a:10:{s:4:"uuid";s:36:"fc92eafb-056b-45a7-b046-8865285935b3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lfyE_snmvfg_EQ3VDyhUtGAXgmqtEiqa46I3bTMg8DU";}s:2:"id";s:19:"comment_save_action";s:5:"label";s:12:"Save comment";s:4:"type";s:7:"comment";s:6:"plugin";s:26:"entity:save_action:comment";s:13:"configuration";a:0:{}}');
INSERT INTO `config` VALUES ('','system.action.comment_unpublish_action','a:10:{s:4:"uuid";s:36:"f3b8b497-ec18-4c44-be85-3160c2160c4f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:7:"comment";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"tWOIjSMobEWOFZddMkNqb9JySbOVwE1diC6NRqcfLTk";}s:2:"id";s:24:"comment_unpublish_action";s:5:"label";s:17:"Unpublish comment";s:4:"type";s:7:"comment";s:6:"plugin";s:31:"entity:unpublish_action:comment";s:13:"configuration";a:0:{}}'),('','system.action.node_delete_action','a:10:{s:4:"uuid";s:36:"f9275dc8-7ab5-4529-9755-02d20e5ecd2a";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t43OqwzP3CTbcAagSsWKNy6KwMm_zShXo3c4-So6rQg";}s:2:"id";s:18:"node_delete_action";s:5:"label";s:14:"Delete content";s:4:"type";s:4:"node";s:6:"plugin";s:25:"entity:delete_action:node";s:13:"configuration";a:0:{}}'),('','system.action.node_make_sticky_action','a:10:{s:4:"uuid";s:36:"247f2f23-53d0-4bd2-8d03-6cbd0a28a440";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sOb26JSy3fGpWkvR0WYN6_hMqj_6d1rvbvrkzp1yya0";}s:2:"id";s:23:"node_make_sticky_action";s:5:"label";s:19:"Make content sticky";s:4:"type";s:4:"node";s:6:"plugin";s:23:"node_make_sticky_action";s:13:"configuration";a:0:{}}'),('','system.action.node_make_unsticky_action','a:10:{s:4:"uuid";s:36:"0dd26eee-651f-4310-8f96-25b4dde80733";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"lDM9mvIGAu8Sw8rt-uCO4Sr7yX5VPrDPxYcawkbKd6k";}s:2:"id";s:25:"node_make_unsticky_action";s:5:"label";s:21:"Make content unsticky";s:4:"type";s:4:"node";s:6:"plugin";s:25:"node_make_unsticky_action";s:13:"configuration";a:0:{}}'),('','system.action.node_promote_action','a:10:{s:4:"uuid";s:36:"be104e29-b905-49c6-b044-7fb47526b28b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"N0RDBTqiK4dKoN4p4oW2j0SGWycdHyALUe9M-Ofp89U";}s:2:"id";s:19:"node_promote_action";s:5:"label";s:29:"Promote content to front page";s:4:"type";s:4:"node";s:6:"plugin";s:19:"node_promote_action";s:13:"configuration";a:0:{}}');
INSERT INTO `config` VALUES ('','system.action.node_publish_action','a:10:{s:4:"uuid";s:36:"c987b1a7-63f3-4997-ad50-becfd8c1b718";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2B9uF8NL5gutNKSdPRAhhAsDWFZZG1PJOBmx0aBGd_0";}s:2:"id";s:19:"node_publish_action";s:5:"label";s:15:"Publish content";s:4:"type";s:4:"node";s:6:"plugin";s:26:"entity:publish_action:node";s:13:"configuration";a:0:{}}'),('','system.action.node_save_action','a:10:{s:4:"uuid";s:36:"6329b690-9439-4d96-8f28-f4d7e51f4bde";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"LhdsoZPL_pFas2fjaAWue4zvrQ_tEVofLYtcNec-JGM";}s:2:"id";s:16:"node_save_action";s:5:"label";s:12:"Save content";s:4:"type";s:4:"node";s:6:"plugin";s:23:"entity:save_action:node";s:13:"configuration";a:0:{}}'),('','system.action.node_unpromote_action','a:10:{s:4:"uuid";s:36:"979b557c-89f1-4218-b697-1497bd1ac383";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"JBptjnfuOMtsdKygklXxoOgeOCTMtQxlkymjnnj-cC0";}s:2:"id";s:21:"node_unpromote_action";s:5:"label";s:30:"Remove content from front page";s:4:"type";s:4:"node";s:6:"plugin";s:21:"node_unpromote_action";s:13:"configuration";a:0:{}}'),('','system.action.node_unpublish_action','a:10:{s:4:"uuid";s:36:"4f864afd-edac-433d-b740-373f4e51e93b";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"node";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"C7X8h9FWlwkQ9y5mnU2JzgaZICAdc6HFbPVbhvjlAYE";}s:2:"id";s:21:"node_unpublish_action";s:5:"label";s:17:"Unpublish content";s:4:"type";s:4:"node";s:6:"plugin";s:28:"entity:unpublish_action:node";s:13:"configuration";a:0:{}}'),('','system.action.taxonomy_term_publish_action','a:10:{s:4:"uuid";s:36:"2d3a3def-9d62-4fa3-8cae-f839f0586099";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DoVt_VGgVLcDD4XmVbSFzr0K17SJy9imFiYusKkJBgY";}s:2:"id";s:28:"taxonomy_term_publish_action";s:5:"label";s:21:"Publish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:35:"entity:publish_action:taxonomy_term";s:13:"configuration";a:0:{}}');
INSERT INTO `config` VALUES ('','system.action.taxonomy_term_unpublish_action','a:10:{s:4:"uuid";s:36:"4ecf994a-b914-49b8-94f7-1da608fd7657";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"taxonomy";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z2sNRM3ECa7FPCGnSNje_9SmZJQgwhD_6fG_L4Mr8zI";}s:2:"id";s:30:"taxonomy_term_unpublish_action";s:5:"label";s:23:"Unpublish taxonomy term";s:4:"type";s:13:"taxonomy_term";s:6:"plugin";s:37:"entity:unpublish_action:taxonomy_term";s:13:"configuration";a:0:{}}'),('','system.action.user_add_role_action.administrator','a:9:{s:4:"uuid";s:36:"eebcdee0-c08b-418e-8d5c-2a095f4de490";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:34:"user_add_role_action.administrator";s:5:"label";s:50:"Add the Administrator role to the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:20:"user_add_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}'),('','system.action.user_block_user_action','a:10:{s:4:"uuid";s:36:"794e330d-e16c-4fa6-9f0a-2c3ca8ad7892";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"DyypzTfThX10FFQw-399qPfEbLLyrhXgQrKPVsmAoJ4";}s:2:"id";s:22:"user_block_user_action";s:5:"label";s:26:"Block the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:22:"user_block_user_action";s:13:"configuration";a:0:{}}'),('','system.action.user_cancel_user_action','a:10:{s:4:"uuid";s:36:"e85b3d9e-542f-474f-bb60-f3bd6dbc84d4";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nvrL9bFilzBvm2bjO9rQnFDpBA7dBBUjShSSt6NS-DU";}s:2:"id";s:23:"user_cancel_user_action";s:5:"label";s:35:"Cancel the selected user account(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_cancel_user_action";s:13:"configuration";a:0:{}}');
INSERT INTO `config` VALUES ('','system.action.user_remove_role_action.administrator','a:9:{s:4:"uuid";s:36:"afd5df12-5ba0-4beb-be15-e19cd2a1cafc";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:23:"user.role.administrator";}s:6:"module";a:1:{i:0;s:4:"user";}}s:2:"id";s:37:"user_remove_role_action.administrator";s:5:"label";s:55:"Remove the Administrator role from the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:23:"user_remove_role_action";s:13:"configuration";a:1:{s:3:"rid";s:13:"administrator";}}'),('','system.action.user_unblock_user_action','a:10:{s:4:"uuid";s:36:"90e44b28-9b3e-4273-ba8a-310606e00567";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"SPsUXsR3Rc8d1y3gewzaAKWa1ncea_ywXX3f7LTn7k0";}s:2:"id";s:24:"user_unblock_user_action";s:5:"label";s:28:"Unblock the selected user(s)";s:4:"type";s:4:"user";s:6:"plugin";s:24:"user_unblock_user_action";s:13:"configuration";a:0:{}}'),('','system.authorize','a:2:{s:20:"filetransfer_default";N;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"z63ds8M4zPrylEgFRkRcOlfcsXWwfITzjD4cj1kRdfg";}}'),('','system.cron','a:3:{s:9:"threshold";a:2:{s:20:"requirements_warning";i:172800;s:18:"requirements_error";i:1209600;}s:7:"logging";i:1;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"5Pw921y1EPfFN98wykliBBLArm51pC-SmrXeYCe7d0Y";}}'),('','system.date','a:4:{s:7:"country";a:1:{s:7:"default";s:2:"TH";}s:9:"first_day";i:0;s:8:"timezone";a:2:{s:7:"default";s:12:"Asia/Bangkok";s:4:"user";a:3:{s:12:"configurable";b:1;s:4:"warn";b:0;s:7:"default";i:0;}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"V9UurX2GPT05NWKG9f2GWQqFG2TRG8vczidwjpy7Woo";}}'),('','system.diff','a:2:{s:7:"context";a:2:{s:13:"lines_leading";i:2;s:14:"lines_trailing";i:2;}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"1WanmaEhxW_vM8_5Ktsdntj8MaO9UBHXg0lN603PsWM";}}'),('','system.file','a:4:{s:22:"allow_insecure_uploads";b:0;s:14:"default_scheme";s:6:"public";s:21:"temporary_maximum_age";i:21600;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"mguGHCYb9Dw5EcpfjwoShGV1Vjkbz3QuPRCLfxiye-g";}}');
INSERT INTO `config` VALUES ('','system.image','a:2:{s:7:"toolkit";s:2:"gd";s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"durWHaKeBaq4d9Wpi4RqwADj1OufDepcnJuhVLmKN24";}}'),('','system.image.gd','a:2:{s:12:"jpeg_quality";i:75;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"eNXaHfkJJUThHeF0nvkoXyPLRrKYGxgHRjORvT4F5rQ";}}'),('','system.logging','a:2:{s:11:"error_level";s:4:"hide";s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"u3-njszl92FaxjrCMiq0yDcjAfcdx72w1zT1O9dx6aA";}}'),('','system.mail','a:2:{s:9:"interface";a:1:{s:7:"default";s:8:"php_mail";}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rYgt7uhPafP2ngaN_ZUPFuyI4KdE0zU868zLNSlzKoE";}}'),('','system.maintenance','a:3:{s:7:"message";s:93:"@site is currently under maintenance. We should be back shortly. Thank you for your patience.";s:8:"langcode";s:2:"en";s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Z5MXifrF77GEAgx0GQ6iWT8wStjFuY8BD9OruofWTJ8";}}'),('','system.menu.account','a:9:{s:4:"uuid";s:36:"231aa860-69eb-4635-9509-9cfeb112d58c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"M_Bh81osDyUQ4wV0GgU_NdBNqkzM87sLxjaCdFj9mnw";}s:2:"id";s:7:"account";s:5:"label";s:17:"User account menu";s:11:"description";s:40:"Links related to the active user account";s:6:"locked";b:1;}'),('','system.menu.admin','a:9:{s:4:"uuid";s:36:"b11b3a43-c3c6-4dfe-9b5c-87f29137fc3c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"sapEi2YDGoI9yQIT_WgIV2vUdQ6DScH0V3fAyTadAL0";}s:2:"id";s:5:"admin";s:5:"label";s:14:"Administration";s:11:"description";s:25:"Administrative task links";s:6:"locked";b:1;}'),('','system.menu.footer','a:9:{s:4:"uuid";s:36:"a8e77f50-eada-4342-ace6-8d2954b09fc9";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"7yrlW5z9zdg2eBucB2GPqXKSMQfH9lSRSO4DbWF7AFc";}s:2:"id";s:6:"footer";s:5:"label";s:6:"Footer";s:11:"description";s:22:"Site information links";s:6:"locked";b:1;}');
INSERT INTO `config` VALUES ('','system.menu.main','a:9:{s:4:"uuid";s:36:"4accf9a2-eec5-4f59-9462-f13691bfc82f";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Q2Ra3jfoIVk0f3SjxJX61byRQFVBAbpzYDQOiY-kno8";}s:2:"id";s:4:"main";s:5:"label";s:15:"Main navigation";s:11:"description";s:18:"Site section links";s:6:"locked";b:1;}'),('','system.menu.tools','a:9:{s:4:"uuid";s:36:"849d3b62-9334-4165-8fe8-fba448b93993";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"BCM-vV1zzRaLHN18dqAR_CuGOj8AFJvTx7BKl_8Gcxc";}s:2:"id";s:5:"tools";s:5:"label";s:5:"Tools";s:11:"description";s:39:"User tool links, often added by modules";s:6:"locked";b:1;}'),('','system.performance','a:6:{s:5:"cache";a:1:{s:4:"page";a:1:{s:7:"max_age";i:0;}}s:3:"css";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:8:"fast_404";a:4:{s:7:"enabled";b:1;s:5:"paths";s:69:"/\\.(?:txt|png|gif|jpe?g|css|js|ico|swf|flv|cgi|bat|pl|dll|exe|asp)$/i";s:13:"exclude_paths";s:27:"/\\/(?:styles|imagecache)\\//";s:4:"html";s:162:"<!DOCTYPE html><html><head><title>404 Not Found</title></head><body><h1>Not Found</h1><p>The requested URL "@path" was not found on this server.</p></body></html>";}s:2:"js";a:2:{s:10:"preprocess";b:1;s:4:"gzip";b:1;}s:20:"stale_file_threshold";i:2592000;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"b2cssrj-lOmATIbdehfCqfCFgVR0qCdxxWhwqa2KBVQ";}}'),('','system.rss','a:4:{s:7:"channel";a:1:{s:11:"description";s:0:"";}s:5:"items";a:2:{s:5:"limit";i:10;s:9:"view_mode";s:3:"rss";}s:8:"langcode";s:2:"en";s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"TlH7NNk46phfxu1mSUfwg1C0YqaGsUCeD4l9JQnQlDU";}}'),('','system.site','a:10:{s:4:"uuid";s:36:"268fadaa-83de-4f6e-ae3d-1c24161b79b6";s:4:"name";s:22:"Siam Senater Co., Ltd.";s:4:"mail";s:16:"rik72c@gmail.com";s:6:"slogan";s:0:"";s:4:"page";a:3:{i:403;s:0:"";i:404;s:0:"";s:5:"front";s:5:"/node";}s:18:"admin_compact_mode";b:0;s:17:"weight_select_max";i:100;s:8:"langcode";s:2:"en";s:16:"default_langcode";s:2:"en";s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yTxtFqBHnEWxQswuWvkjE8mKw2t8oKuCL1q8KnfHuGE";}}');
INSERT INTO `config` VALUES ('','system.theme','a:3:{s:5:"admin";s:5:"seven";s:7:"default";s:6:"twenty";s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fOjer9hADYYnbCJVZMFZIIM1azTFWyg84ZkFDHfAbUg";}}'),('','system.theme.global','a:4:{s:7:"favicon";a:4:{s:8:"mimetype";s:24:"image/vnd.microsoft.icon";s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}s:8:"features";a:4:{s:20:"comment_user_picture";b:1;s:25:"comment_user_verification";b:1;s:7:"favicon";b:1;s:17:"node_user_picture";b:1;}s:4:"logo";a:3:{s:4:"path";s:0:"";s:3:"url";s:0:"";s:11:"use_default";b:1;}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"9rAU4Pku7eMBQxauQqAgjzlcicFZ2As6zEa6zvTlCB8";}}'),('','taxonomy.settings','a:4:{s:20:"maintain_index_table";b:1;s:17:"override_selector";b:0;s:20:"terms_per_page_admin";i:100;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"zKpaWT6cJc1tVQQaTqatGELaCqU_oyRym6zTl27Yias";}}'),('','taxonomy.vocabulary.tags','a:9:{s:4:"uuid";s:36:"5f2e0557-4bc0-44e7-85bc-062e3574ef0c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"yoNVreoTdTZTY7GuE8fI9Jmxqdz8vlo4ZJKixMNSosw";}s:4:"name";s:4:"Tags";s:3:"vid";s:4:"tags";s:11:"description";s:61:"Use tags to group articles on similar topics into categories.";s:6:"weight";i:0;}'),('','text.settings','a:2:{s:22:"default_summary_length";i:600;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Bkewb77RBOK3_aXMPsp8p87gbc03NvmC5gBLzPl7hVA";}}'),('','tour.tour.views-ui','a:10:{s:4:"uuid";s:36:"d69551f4-9081-44c4-9c19-9e857df01f95";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:8:"views_ui";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"c-HMyZwgeP8H6AITDcq4hznePkd7azpe8xl_WTnx2O0";}s:2:"id";s:8:"views-ui";s:5:"label";s:14:"View edit page";s:6:"module";s:8:"views_ui";s:6:"routes";a:2:{i:0;a:1:{s:10:"route_name";s:21:"entity.view.edit_form";}i:1;a:1:{s:10:"route_name";s:29:"entity.view.edit_display_form";}}s:4:"tips";a:10:{s:10:"views-main";a:5:{s:2:"id";s:10:"views-main";s:6:"plugin";s:4:"text";s:5:"label";s:20:"Manage view settings";s:4:"body";s:31:"View or edit the configuration.";s:6:"weight";i:1;}s:17:"views-ui-displays";a:6:{s:2:"id";s:17:"views-ui-displays";s:6:"plugin";s:4:"text";s:5:"label";s:21:"Displays in this view";s:4:"body";s:169:"A display is a way of outputting the results, e.g., as a page or a block. A view can contain multiple displays, which are listed here. The active display is highlighted.";s:6:"weight";i:2;s:10:"attributes";a:1:{s:7:"data-id";s:17:"views-display-top";}}s:19:"views-ui-view-admin";a:7:{s:2:"id";s:19:"views-ui-view-admin";s:6:"plugin";s:4:"text";s:5:"label";s:19:"View administration";s:4:"body";s:140:"Perform administrative tasks, including adding a description and creating a clone. Click the drop-down button to view the available options.";s:6:"weight";i:3;s:8:"location";s:4:"left";s:10:"attributes";a:1:{s:7:"data-id";s:27:"views-display-extra-actions";}}s:15:"views-ui-format";a:6:{s:2:"id";s:15:"views-ui-format";s:6:"plugin";s:4:"text";s:5:"label";s:13:"Output format";s:4:"body";s:325:"Choose how to output results. E.g., choose <em>Content</em> to output each item completely, using your configured display settings. Or choose <em>Fields</em>, which allows you to output only specific fields for each result. Additional formats can be added by installing modules to <em>extend</em> Drupal''s base functionality.";s:6:"weight";i:4;s:10:"attributes";a:1:{s:10:"data-class";s:34:"views-ui-display-tab-bucket.format";}}s:15:"views-ui-fields";a:6:{s:2:"id";s:15:"views-ui-fields";s:6:"plugin";s:4:"text";s:5:"label";s:6:"Fields";s:4:"body";s:89:"If this view uses fields, they are listed here. You can click on a field to configure it.";s:6:"weight";i:5;s:10:"attributes";a:1:{s:10:"data-class";s:33:"views-ui-display-tab-bucket.field";}}s:15:"views-ui-filter";a:6:{s:2:"id";s:15:"views-ui-filter";s:6:"plugin";s:4:"text";s:5:"label";s:16:"Filter your view";s:4:"body";s:173:"Add filters to limit the results in the output. E.g., to only show content that is <em>published</em>, you would add a filter for <em>Published</em> and select <em>Yes</em>.";s:6:"weight";i:6;s:10:"attributes";a:1:{s:10:"data-class";s:34:"views-ui-display-tab-bucket.filter";}}s:26:"views-ui-filter-operations";a:6:{s:2:"id";s:26:"views-ui-filter-operations";s:6:"plugin";s:4:"text";s:5:"label";s:14:"Filter actions";s:4:"body";s:33:"Add, rearrange or remove filters.";s:6:"weight";i:7;s:10:"attributes";a:1:{s:10:"data-class";s:53:"views-ui-display-tab-bucket.filter .dropbutton-widget";}}s:14:"views-ui-sorts";a:6:{s:2:"id";s:14:"views-ui-sorts";s:6:"plugin";s:4:"text";s:5:"label";s:13:"Sort Criteria";s:4:"body";s:96:"Control the order in which the results are output. Click on an active sort rule to configure it.";s:6:"weight";i:8;s:10:"attributes";a:1:{s:10:"data-class";s:32:"views-ui-display-tab-bucket.sort";}}s:25:"views-ui-sorts-operations";a:6:{s:2:"id";s:25:"views-ui-sorts-operations";s:6:"plugin";s:4:"text";s:5:"label";s:12:"Sort actions";s:4:"body";s:39:"Add, rearrange or remove sorting rules.";s:6:"weight";i:9;s:10:"attributes";a:1:{s:10:"data-class";s:51:"views-ui-display-tab-bucket.sort .dropbutton-widget";}}s:16:"views-ui-preview";a:7:{s:2:"id";s:16:"views-ui-preview";s:6:"plugin";s:4:"text";s:5:"label";s:7:"Preview";s:4:"body";s:34:"Show a preview of the view output.";s:6:"weight";i:10;s:8:"location";s:4:"left";s:10:"attributes";a:1:{s:7:"data-id";s:14:"preview-submit";}}}}');
INSERT INTO `config` VALUES ('','twenty.settings','a:3:{s:4:"logo";a:2:{s:11:"use_default";b:0;s:4:"path";s:29:"themes/twenty/images/logo.png";}s:7:"favicon";a:2:{s:11:"use_default";b:0;s:4:"path";s:32:"themes/twenty/images/favicon.png";}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"ekugTN8cgV6Ku3_-HkgXExt27x7X8OnBvtn-OQIaKEA";}}'),('','user.flood','a:6:{s:8:"uid_only";b:0;s:8:"ip_limit";i:50;s:9:"ip_window";i:3600;s:10:"user_limit";i:5;s:11:"user_window";i:21600;s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"UYfMzeP1S8jKm9PSvxf7nQNe8DsNS-3bc2WSNNXBQWs";}}'),('','user.mail','a:11:{s:14:"cancel_confirm";a:2:{s:4:"body";s:377:"[user:display-name],\n\nA request to cancel your account has been made at [site:name].\n\nYou may now cancel your account on [site:url-brief] by clicking this link or copying and pasting it into your browser:\n\n[user:cancel-url]\n\nNOTE: The cancellation of your account is not reversible.\n\nThis link expires in one day and nothing will happen if it is not used.\n\n--  [site:name] team";s:7:"subject";s:67:"Account cancellation request for [user:display-name] at [site:name]";}s:14:"password_reset";a:2:{s:4:"body";s:407:"[user:display-name],\n\nA request to reset the password for your account has been made at [site:name].\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password. It expires after one day and nothing will happen if it''s not used.\n\n--  [site:name] team";s:7:"subject";s:68:"Replacement login information for [user:display-name] at [site:name]";}s:22:"register_admin_created";a:2:{s:4:"body";s:473:"[user:display-name],\n\nA site administrator at [site:name] has created an account for you. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team";s:7:"subject";s:58:"An administrator created an account for you at [site:name]";}s:29:"register_no_approval_required";a:2:{s:4:"body";s:447:"[user:display-name],\n\nThank you for registering at [site:name]. You may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:name]\npassword: Your password\n\n--  [site:name] team";s:7:"subject";s:54:"Account details for [user:display-name] at [site:name]";}s:25:"register_pending_approval";a:2:{s:4:"body";s:288:"[user:display-name],\n\nThank you for registering at [site:name]. Your application for an account is currently pending approval. Once it has been approved, you will receive another email containing information about how to log in, set your password, and other details.\n\n--  [site:name] team";s:7:"subject";s:79:"Account details for [user:display-name] at [site:name] (pending admin approval)";}s:31:"register_pending_approval_admin";a:2:{s:4:"body";s:64:"[user:display-name] has applied for an account.\n\n[user:edit-url]";s:7:"subject";s:79:"Account details for [user:display-name] at [site:name] (pending admin approval)";}s:16:"status_activated";a:2:{s:4:"body";s:462:"[user:display-name],\n\nYour account at [site:name] has been activated.\n\nYou may now log in by clicking this link or copying and pasting it into your browser:\n\n[user:one-time-login-url]\n\nThis link can only be used once to log in and will lead you to a page where you can set your password.\n\nAfter setting your password, you will be able to log in at [site:login-url] in the future using:\n\nusername: [user:account-name]\npassword: Your password\n\n--  [site:name] team";s:7:"subject";s:65:"Account details for [user:display-name] at [site:name] (approved)";}s:14:"status_blocked";a:2:{s:4:"body";s:89:"[user:display-name],\n\nYour account on [site:name] has been blocked.\n\n--  [site:name] team";s:7:"subject";s:64:"Account details for [user:display-name] at [site:name] (blocked)";}s:15:"status_canceled";a:2:{s:4:"body";s:90:"[user:display-name],\n\nYour account on [site:name] has been canceled.\n\n--  [site:name] team";s:7:"subject";s:65:"Account details for [user:display-name] at [site:name] (canceled)";}s:8:"langcode";s:2:"en";s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"IWzNdUVX2YSiflxrGSTLIiqTrhgIzbV2C-hRL5DniJM";}}');
INSERT INTO `config` VALUES ('','user.role.administrator','a:10:{s:4:"uuid";s:36:"a26da142-326e-4818-a353-590596ad17db";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Om6FEO7vZZMkPIbVvfxtdkWerQ2PvQM4sWUd6Q3ZnfI";}s:2:"id";s:13:"administrator";s:5:"label";s:13:"Administrator";s:6:"weight";i:2;s:8:"is_admin";b:1;s:11:"permissions";a:0:{}}'),('','user.role.anonymous','a:10:{s:4:"uuid";s:36:"42a852b7-1e3d-4f13-b428-c43a2a3b7d40";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"pq_mEIu_B4widZN7Ap81iCJSjShFFdcL0jEiCi8VrDk";}s:2:"id";s:9:"anonymous";s:5:"label";s:14:"Anonymous user";s:6:"weight";i:0;s:8:"is_admin";b:0;s:11:"permissions";a:5:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:29:"access site-wide contact form";i:3;s:14:"search content";i:4;s:31:"use text format restricted_html";}}'),('','user.role.authenticated','a:10:{s:4:"uuid";s:36:"b8705504-d0e2-4131-aae2-3cd76c4278da";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:0:{}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"btW6TFHajhy7Eo6YUvdFiPh4TcPggo8GBXYctjV6zag";}s:2:"id";s:13:"authenticated";s:5:"label";s:18:"Authenticated user";s:6:"weight";i:1;s:8:"is_admin";b:0;s:11:"permissions";a:8:{i:0;s:15:"access comments";i:1;s:14:"access content";i:2;s:16:"access shortcuts";i:3;s:29:"access site-wide contact form";i:4;s:13:"post comments";i:5;s:14:"search content";i:6;s:21:"skip comment approval";i:7;s:26:"use text format basic_html";}}'),('','user.settings','a:9:{s:9:"anonymous";s:9:"Anonymous";s:11:"verify_mail";b:1;s:6:"notify";a:8:{s:14:"cancel_confirm";b:1;s:14:"password_reset";b:1;s:16:"status_activated";b:1;s:14:"status_blocked";b:0;s:15:"status_canceled";b:0;s:22:"register_admin_created";b:1;s:29:"register_no_approval_required";b:1;s:25:"register_pending_approval";b:1;}s:8:"register";s:23:"visitors_admin_approval";s:13:"cancel_method";s:17:"user_cancel_block";s:22:"password_reset_timeout";i:86400;s:17:"password_strength";b:1;s:8:"langcode";s:2:"en";s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"w314Zp7B4NbrlV4KeeZLNSmTTpdJiv-KwZO2E1fSSK0";}}');
INSERT INTO `config` VALUES ('','views.settings','a:6:{s:17:"display_extenders";a:0:{}s:10:"skip_cache";b:0;s:13:"sql_signature";b:0;s:2:"ui";a:3:{s:4:"show";a:7:{s:18:"additional_queries";b:0;s:15:"advanced_column";b:0;s:14:"master_display";b:0;s:22:"performance_statistics";b:0;s:19:"preview_information";b:1;s:9:"sql_query";a:2:{s:7:"enabled";b:0;s:5:"where";s:5:"above";}s:13:"display_embed";b:0;}s:19:"always_live_preview";b:1;s:24:"exposed_filter_any_label";s:7:"old_any";}s:22:"field_rewrite_elements";a:29:{s:3:"div";s:3:"DIV";s:4:"span";s:4:"SPAN";s:2:"h1";s:2:"H1";s:2:"h2";s:2:"H2";s:2:"h3";s:2:"H3";s:2:"h4";s:2:"H4";s:2:"h5";s:2:"H5";s:2:"h6";s:2:"H6";s:1:"p";s:1:"P";s:6:"header";s:6:"HEADER";s:6:"footer";s:6:"FOOTER";s:7:"article";s:7:"ARTICLE";s:7:"section";s:7:"SECTION";s:5:"aside";s:5:"ASIDE";s:7:"details";s:7:"DETAILS";s:10:"blockquote";s:10:"BLOCKQUOTE";s:6:"figure";s:6:"FIGURE";s:7:"address";s:7:"ADDRESS";s:4:"code";s:4:"CODE";s:3:"pre";s:3:"PRE";s:3:"var";s:3:"VAR";s:4:"samp";s:4:"SAMP";s:3:"kbd";s:3:"KBD";s:6:"strong";s:6:"STRONG";s:2:"em";s:2:"EM";s:3:"del";s:3:"DEL";s:3:"ins";s:3:"INS";s:1:"q";s:1:"Q";s:1:"s";s:1:"S";}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"RaRd9EIcwA4u3qCSRLL8EnCicbda1kV__ASmVbyehvQ";}}'),('','views.view.archive','a:13:{s:4:"uuid";s:36:"c560a236-5d79-46c1-89eb-c53b03bc29b6";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gA3tLETtsrObWW1Uvb6Mh-fg0Qu_6uCEzgL9jKQgPgo";}s:2:"id";s:7:"archive";s:5:"label";s:7:"Archive";s:6:"module";s:4:"node";s:11:"description";s:22:"All content, by month.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:5:"title";s:15:"Monthly archive";s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:14:"items_per_page";i:10;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";i:0;s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:4:"tags";a:2:{s:8:"previous";s:6:"‹‹";s:4:"next";s:6:"››";}}}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"created";s:5:"order";s:4:"DESC";s:9:"plugin_id";s:4:"date";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:7:"exposed";b:0;s:6:"expose";a:1:{s:5:"label";s:0:"";}s:11:"granularity";s:6:"second";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";}}s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:7:"summary";a:2:{s:10:"sort_order";s:4:"desc";s:6:"format";s:15:"default_summary";}s:15:"summary_options";a:2:{s:8:"override";b:1;s:14:"items_per_page";i:30;}s:18:"specify_validation";b:1;s:9:"plugin_id";s:15:"date_year_month";s:11:"entity_type";s:4:"node";}}s:7:"filters";a:2:{s:6:"status";a:9:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:5:"value";s:1:"1";s:5:"group";i:0;s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:9:"plugin_id";s:7:"boolean";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:8:"language";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:0:{}s:13:"relationships";a:0:{}s:6:"fields";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:14:"display_plugin";s:5:"block";s:8:"position";i:1;s:15:"display_options";a:4:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:9:"arguments";a:1:{s:18:"created_year_month";a:13:{s:2:"id";s:18:"created_year_month";s:5:"table";s:15:"node_field_data";s:5:"field";s:18:"created_year_month";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:12:"title_enable";b:1;s:5:"title";s:34:"{{ arguments.created_year_month }}";s:21:"default_argument_type";s:5:"fixed";s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:15:"summary_options";a:1:{s:14:"items_per_page";i:30;}s:18:"specify_validation";b:1;s:9:"plugin_id";s:15:"date_year_month";s:11:"entity_type";s:4:"node";}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:2;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:4:"path";s:7:"archive";s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.block_content','a:13:{s:4:"uuid";s:36:"e5bffd05-d1e6-450b-9cb4-b8b395a0442c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"2J0rd5cWfFsdSX-kAb0f9EzvC0_vn4NxGlUpOQAXeOU";}s:2:"id";s:13:"block_content";s:5:"label";s:20:"Custom block library";s:6:"module";s:5:"views";s:11:"description";s:30:"Find and manage custom blocks.";s:3:"tag";s:7:"default";s:10:"base_table";s:24:"block_content_field_data";s:10:"base_field";s:2:"id";s:7:"display";a:2:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:17:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:17:"administer blocks";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:14:"items_per_page";i:50;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";N;s:4:"tags";a:2:{s:8:"previous";s:12:"‹ Previous";s:4:"next";s:8:"Next ›";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:8:"override";b:1;s:6:"sticky";b:0;s:7:"caption";s:0:"";s:7:"summary";s:0:"";s:11:"description";s:0:"";s:7:"columns";a:4:{s:4:"info";s:4:"info";s:4:"type";s:4:"type";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:4:"info";a:4:{s:4:"info";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:7:"default";s:7:"changed";s:11:"empty_table";b:1;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:6:"fields";a:4:{s:4:"info";a:37:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:17:"Block description";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";N;s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:5:"field";}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:10:"Block type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:7:"changed";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:9:"plugin_id";s:5:"field";}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:13:"block_content";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;s:11:"entity_type";s:13:"block_content";s:9:"plugin_id";s:17:"entity_operations";}}s:7:"filters";a:3:{s:4:"info";a:16:{s:2:"id";s:4:"info";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"info";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:7:"info_op";s:5:"label";s:17:"Block description";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"info_op";s:10:"identifier";s:4:"info";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"info";s:9:"plugin_id";s:6:"string";}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:10:"Block type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:6:"bundle";}s:8:"reusable";a:16:{s:2:"id";s:8:"reusable";s:5:"table";s:24:"block_content_field_data";s:5:"field";s:8:"reusable";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:13:"block_content";s:12:"entity_field";s:8:"reusable";s:9:"plugin_id";s:7:"boolean";}}s:5:"sorts";a:0:{}s:5:"title";s:20:"Custom block library";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:2:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:8:"tokenize";b:0;s:7:"content";s:37:"There are no custom blocks available.";s:9:"plugin_id";s:11:"text_custom";}s:27:"block_content_listing_empty";a:10:{s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:5:"field";s:27:"block_content_listing_empty";s:10:"group_type";s:5:"group";s:2:"id";s:27:"block_content_listing_empty";s:5:"label";s:0:"";s:12:"relationship";s:4:"none";s:5:"table";s:13:"block_content";s:9:"plugin_id";s:27:"block_content_listing_empty";s:11:"entity_type";s:13:"block_content";}}s:13:"relationships";a:0:{}s:9:"arguments";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:14:"display_plugin";s:4:"page";s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"display_extenders";a:0:{}s:4:"path";s:35:"admin/structure/block/block-content";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:20:"Custom block library";s:11:"description";s:0:"";s:6:"parent";s:19:"block.admin_display";s:6:"weight";i:0;s:7:"context";s:1:"0";s:9:"menu_name";s:5:"admin";}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.comment','a:13:{s:4:"uuid";s:36:"a25984c2-733d-4be8-b218-5463fbaae6e6";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"fsBo_zgUeLyYZdghaw4PkOHA-HqFxu7wmQLilF35XYg";}s:2:"id";s:7:"comment";s:5:"label";s:8:"Comments";s:6:"module";s:7:"comment";s:11:"description";s:25:"Find and manage comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:3:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:26:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:19:"administer comments";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:14:"items_per_page";i:50;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";N;s:4:"tags";a:4:{s:8:"previous";s:12:"‹ previous";s:4:"next";s:8:"next ›";s:5:"first";s:8:"« first";s:4:"last";s:7:"last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:8:"override";b:1;s:6:"sticky";b:1;s:7:"caption";s:0:"";s:7:"summary";s:0:"";s:11:"description";s:0:"";s:7:"columns";a:6:{s:17:"comment_bulk_form";s:17:"comment_bulk_form";s:7:"subject";s:7:"subject";s:3:"uid";s:3:"uid";s:9:"entity_id";s:9:"entity_id";s:7:"changed";s:7:"changed";s:10:"operations";s:10:"operations";}s:4:"info";a:6:{s:17:"comment_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"subject";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:3:"uid";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"entity_id";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"operations";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:7:"default";s:7:"changed";s:11:"empty_table";b:1;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:24:"comment_unpublish_action";}s:9:"plugin_id";s:17:"comment_bulk_form";s:11:"entity_type";s:7:"comment";}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";}}s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}s:9:"plugin_id";s:7:"combine";}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"order";s:4:"DESC";s:7:"exposed";b:0;s:6:"expose";a:1:{s:5:"label";s:0:"";}s:11:"granularity";s:6:"second";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";}}s:5:"title";s:8:"Comments";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:8:"tokenize";b:0;s:7:"content";s:22:"No comments available.";s:9:"plugin_id";s:11:"text_custom";}}s:9:"arguments";a:0:{}s:17:"display_extenders";a:0:{}s:8:"use_more";b:0;s:15:"use_more_always";b:1;s:13:"use_more_text";s:4:"more";s:8:"use_ajax";b:0;s:23:"hide_attachment_summary";b:0;s:16:"show_admin_links";b:1;s:8:"group_by";b:0;s:9:"css_class";s:0:"";s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:8:"required";b:0;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}}s:14:"cache_metadata";a:4:{s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:9:"cacheable";b:0;s:7:"max-age";i:0;s:4:"tags";a:0:{}}}s:14:"page_published";a:6:{s:14:"display_plugin";s:4:"page";s:2:"id";s:14:"page_published";s:13:"display_title";s:18:"Published comments";s:8:"position";i:1;s:15:"display_options";a:6:{s:4:"path";s:21:"admin/content/comment";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:8:"Comments";s:11:"description";s:18:"Comments published";s:6:"parent";s:0:"";s:6:"weight";i:0;s:7:"context";s:1:"0";s:9:"menu_name";s:5:"admin";}s:19:"display_description";s:30:"The approved comments listing.";s:17:"display_extenders";a:0:{}s:13:"exposed_block";b:0;s:15:"display_comment";s:0:"";}s:14:"cache_metadata";a:4:{s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:9:"cacheable";b:0;s:7:"max-age";i:0;s:4:"tags";a:0:{}}}s:15:"page_unapproved";a:6:{s:14:"display_plugin";s:4:"page";s:2:"id";s:15:"page_unapproved";s:13:"display_title";s:19:"Unapproved comments";s:8:"position";i:2;s:15:"display_options";a:8:{s:4:"path";s:30:"admin/content/comment/approval";s:4:"menu";a:7:{s:4:"type";s:3:"tab";s:5:"title";s:19:"Unapproved comments";s:11:"description";s:19:"Comments unapproved";s:6:"parent";s:0:"";s:6:"weight";i:1;s:7:"context";s:1:"0";s:9:"menu_name";s:5:"admin";}s:19:"display_description";s:32:"The unapproved comments listing.";s:7:"filters";a:4:{s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";s:9:"plugin_id";s:7:"boolean";}s:7:"subject";a:16:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"subject_op";s:5:"label";s:7:"Subject";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"subject_op";s:10:"identifier";s:7:"subject";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:6:"string";}s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:11:"Author Name";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:10:"identifier";s:11:"author_name";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:6:"name_1";s:6:"name_1";}s:9:"plugin_id";s:7:"combine";}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:18:"comment_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";}}s:8:"defaults";a:3:{s:7:"filters";b:0;s:13:"filter_groups";b:0;s:6:"fields";b:0;}s:17:"display_extenders";a:0:{}s:6:"fields";a:8:{s:17:"comment_bulk_form";a:26:{s:2:"id";s:17:"comment_bulk_form";s:5:"table";s:7:"comment";s:5:"field";s:17:"comment_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"action_title";s:6:"Action";s:15:"include_exclude";s:7:"include";s:16:"selected_actions";a:2:{i:0;s:21:"comment_delete_action";i:1;s:22:"comment_publish_action";}s:9:"plugin_id";s:17:"comment_bulk_form";s:11:"entity_type";s:7:"comment";}s:7:"subject";a:37:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:7:"Subject";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:17:"comment_permalink";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";s:9:"plugin_id";s:5:"field";}s:3:"uid";a:37:{s:2:"id";s:3:"uid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:5:"field";}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:18:"comment_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:9:"{{ uid }}";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:16:"comment_username";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";}s:9:"entity_id";a:37:{s:2:"id";s:9:"entity_id";s:5:"table";s:18:"comment_field_data";s:5:"field";s:9:"entity_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:9:"Posted in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:1;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:9:"entity_id";s:9:"plugin_id";s:16:"commented_entity";}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:7:"comment";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;s:11:"entity_type";s:7:"comment";s:9:"plugin_id";s:17:"entity_operations";}s:6:"name_1";a:37:{s:2:"id";s:6:"name_1";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:0;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";}}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}}s:14:"cache_metadata";a:4:{s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:9:"cacheable";b:0;s:7:"max-age";i:0;s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.comments_recent','a:13:{s:4:"uuid";s:36:"73269755-9a33-4461-80c9-3e4bc505180d";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:3:{i:0;s:7:"comment";i:1;s:4:"node";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"rX48v_U7vIh1FltSyJnTdpebtM-lj991qL_jO8BmZ2w";}s:2:"id";s:15:"comments_recent";s:5:"label";s:15:"Recent comments";s:6:"module";s:5:"views";s:11:"description";s:16:"Recent comments.";s:3:"tag";s:7:"default";s:10:"base_table";s:18:"comment_field_data";s:10:"base_field";s:3:"cid";s:7:"display";a:2:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:14:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:15:"access comments";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:12:"exposed_form";a:1:{s:4:"type";s:5:"basic";}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:14:"items_per_page";i:10;s:6:"offset";i:0;}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:2:{s:22:"default_field_elements";b:1;s:10:"hide_empty";b:0;}}s:13:"relationships";a:1:{s:4:"node";a:5:{s:5:"field";s:4:"node";s:2:"id";s:4:"node";s:5:"table";s:18:"comment_field_data";s:8:"required";b:1;s:9:"plugin_id";s:8:"standard";}}s:6:"fields";a:2:{s:7:"subject";a:26:{s:2:"id";s:7:"subject";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"subject";s:12:"relationship";s:4:"none";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:9:"plugin_id";s:5:"field";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"subject";}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:9:"plugin_id";s:5:"field";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"changed";}}s:7:"filters";a:2:{s:6:"status";a:9:{s:5:"value";s:1:"1";s:5:"table";s:18:"comment_field_data";s:5:"field";s:6:"status";s:2:"id";s:6:"status";s:9:"plugin_id";s:7:"boolean";s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:5:"group";i:1;s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:6:"status";}s:11:"status_node";a:10:{s:5:"value";s:1:"1";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"node";s:2:"id";s:11:"status_node";s:9:"plugin_id";s:7:"boolean";s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:5:"group";i:1;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";}}s:5:"sorts";a:2:{s:7:"created";a:12:{s:2:"id";s:7:"created";s:5:"table";s:18:"comment_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"order";s:4:"DESC";s:7:"exposed";b:0;s:6:"expose";a:1:{s:5:"label";s:0:"";}s:9:"plugin_id";s:4:"date";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:7:"created";}s:3:"cid";a:11:{s:2:"id";s:3:"cid";s:5:"table";s:18:"comment_field_data";s:5:"field";s:3:"cid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"order";s:4:"DESC";s:7:"exposed";b:0;s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:7:"comment";s:12:"entity_field";s:3:"cid";}}s:5:"title";s:15:"Recent comments";s:5:"empty";a:1:{s:16:"area_text_custom";a:11:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:5:"empty";b:1;s:7:"content";s:22:"No comments available.";s:8:"tokenize";b:0;s:9:"plugin_id";s:11:"text_custom";}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:14:"display_plugin";s:5:"block";s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:8:"position";i:1;s:15:"display_options";a:4:{s:17:"block_description";s:15:"Recent comments";s:14:"block_category";s:13:"Lists (Views)";s:5:"allow";a:1:{s:14:"items_per_page";b:1;}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.content','a:13:{s:4:"uuid";s:36:"89563342-294f-4ba6-a1da-8af2873b0850";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"P7F4DFe8BL31DRVqsvS-ix9KZZqvvaPjZ7zEvGo9yNM";}s:2:"id";s:7:"content";s:5:"label";s:7:"Content";s:6:"module";s:4:"node";s:11:"description";s:24:"Find and manage content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:15:"display_options";a:17:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:23:"access content overview";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"query";a:1:{s:4:"type";s:11:"views_query";}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:2:{s:14:"items_per_page";i:50;s:4:"tags";a:4:{s:8:"previous";s:12:"‹ Previous";s:4:"next";s:8:"Next ›";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:8:"override";b:1;s:6:"sticky";b:1;s:7:"caption";s:0:"";s:7:"summary";s:0:"";s:11:"description";s:0:"";s:7:"columns";a:10:{s:14:"node_bulk_form";s:14:"node_bulk_form";s:5:"title";s:5:"title";s:4:"type";s:4:"type";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:7:"changed";s:7:"changed";s:9:"edit_node";s:9:"edit_node";s:11:"delete_node";s:11:"delete_node";s:10:"dropbutton";s:10:"dropbutton";s:9:"timestamp";s:5:"title";}s:4:"info";a:10:{s:14:"node_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"title";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:11:"delete_node";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:9:"timestamp";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:7:"default";s:7:"changed";s:11:"empty_table";b:1;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:6:"fields";a:7:{s:14:"node_bulk_form";a:14:{s:2:"id";s:14:"node_bulk_form";s:5:"table";s:4:"node";s:5:"field";s:14:"node_bulk_form";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:14:"node_bulk_form";s:11:"entity_type";s:4:"node";}s:5:"title";a:17:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:9:"plugin_id";s:5:"field";}s:4:"type";a:37:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:12:"Content type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:9:"target_id";s:4:"type";s:22:"entity_reference_label";s:8:"settings";a:1:{s:4:"link";b:0;}s:12:"group_column";s:9:"target_id";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";s:9:"plugin_id";s:5:"field";}s:4:"name";a:17:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:5:"label";s:6:"Author";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:5:"field";s:4:"type";s:9:"user_name";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";}s:6:"status";a:17:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:18:"format_custom_true";s:9:"Published";s:19:"format_custom_false";s:11:"Unpublished";}s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";}s:7:"changed";a:17:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:5:"label";s:7:"Updated";s:7:"exclude";b:0;s:5:"alter";a:1:{s:10:"alter_text";b:0;}s:13:"element_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";}s:10:"operations";a:23:{s:2:"id";s:10:"operations";s:5:"table";s:4:"node";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;s:9:"plugin_id";s:17:"entity_operations";}}s:7:"filters";a:5:{s:5:"title";a:16:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:8:"title_op";s:5:"label";s:5:"Title";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:8:"title_op";s:10:"identifier";s:5:"title";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:6:"string";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";}s:4:"type";a:16:{s:2:"id";s:4:"type";s:5:"table";s:15:"node_field_data";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:12:"Content type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:6:"bundle";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:4:"type";}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:16:"Published status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:9:"Published";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:11:"Unpublished";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}s:9:"plugin_id";s:7:"boolean";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"langcode_op";s:5:"label";s:8:"Language";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"langcode_op";s:10:"identifier";s:8:"langcode";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:8:"language";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";}s:12:"status_extra";a:9:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:8:"operator";s:1:"=";s:5:"value";b:0;s:9:"plugin_id";s:11:"node_status";s:5:"group";i:1;s:11:"entity_type";s:4:"node";s:6:"expose";a:2:{s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}}}s:5:"sorts";a:0:{}s:5:"title";s:7:"Content";s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:5:"empty";b:1;s:7:"content";s:21:"No content available.";s:9:"plugin_id";s:11:"text_custom";}}s:9:"arguments";a:0:{}s:13:"relationships";a:1:{s:3:"uid";a:6:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:11:"admin_label";s:6:"author";s:8:"required";b:1;s:9:"plugin_id";s:8:"standard";}}s:16:"show_admin_links";b:0;s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:17:"display_extenders";a:0:{}}s:14:"display_plugin";s:7:"default";s:13:"display_title";s:6:"Master";s:2:"id";s:7:"default";s:8:"position";i:0;s:14:"cache_metadata";a:3:{s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:7:"max-age";i:0;s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:15:"display_options";a:4:{s:4:"path";s:18:"admin/content/node";s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:7:"Content";s:11:"description";s:0:"";s:9:"menu_name";s:5:"admin";s:6:"weight";i:-10;s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:7:"Content";s:11:"description";s:23:"Find and manage content";s:9:"menu_name";s:5:"admin";s:6:"weight";i:-10;}s:17:"display_extenders";a:0:{}}s:14:"display_plugin";s:4:"page";s:13:"display_title";s:4:"Page";s:2:"id";s:6:"page_1";s:8:"position";i:1;s:14:"cache_metadata";a:3:{s:8:"contexts";a:7:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:4:"user";i:5;s:21:"user.node_grants:view";i:6;s:16:"user.permissions";}s:7:"max-age";i:0;s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.content_recent','a:13:{s:4:"uuid";s:36:"76b46003-73cd-45e5-8588-d1ca01a760a3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"MxwbHUmXqKQgTGCTWcMxsfUH9NZJ8ZVqZp6801AOa40";}s:2:"id";s:14:"content_recent";s:5:"label";s:14:"Recent content";s:6:"module";s:4:"node";s:11:"description";s:15:"Recent content.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:2:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:22:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:14:"items_per_page";i:10;s:6:"offset";i:0;}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:6:"fields";a:2:{s:5:"title";a:26:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:4:"trim";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"html";b:0;}s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:16:"hide_alter_empty";b:1;s:4:"type";s:6:"string";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:9:"plugin_id";s:5:"field";}s:7:"changed";a:37:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:5:"field";}}s:7:"filters";a:2:{s:12:"status_extra";a:15:{s:2:"id";s:12:"status_extra";s:5:"table";s:15:"node_field_data";s:5:"field";s:12:"status_extra";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"=";s:5:"value";b:0;s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:4:"node";s:9:"plugin_id";s:11:"node_status";}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";s:9:"plugin_id";s:8:"language";}}s:5:"sorts";a:1:{s:7:"changed";a:13:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"order";s:4:"DESC";s:7:"exposed";b:0;s:6:"expose";a:1:{s:5:"label";s:0:"";}s:11:"granularity";s:6:"second";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";s:9:"plugin_id";s:4:"date";}}s:5:"title";s:14:"Recent content";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:8:"tokenize";b:0;s:7:"content";s:21:"No content available.";s:9:"plugin_id";s:11:"text_custom";}}s:13:"relationships";a:1:{s:3:"uid";a:10:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:8:"required";b:1;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:3:"uid";s:9:"plugin_id";s:8:"standard";}}s:9:"arguments";a:0:{}s:17:"display_extenders";a:0:{}s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"More";s:8:"link_url";s:0:"";s:12:"link_display";s:1:"0";}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:14:"display_plugin";s:5:"block";s:2:"id";s:7:"block_1";s:13:"display_title";s:5:"Block";s:8:"position";i:1;s:15:"display_options";a:1:{s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:4:"user";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.files','a:13:{s:4:"uuid";s:36:"b729a102-890f-4052-8649-501c9279f9a3";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"file";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"gLmoA0yjvlXfMRp9ihOhRKSSQQlbdLdvpDkbVwkYPrg";}s:2:"id";s:5:"files";s:5:"label";s:5:"Files";s:6:"module";s:4:"file";s:11:"description";s:22:"Find and manage files.";s:3:"tag";s:7:"default";s:10:"base_table";s:12:"file_managed";s:10:"base_field";s:3:"fid";s:7:"display";a:3:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:19:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:21:"access files overview";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:14:"items_per_page";i:50;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";i:0;s:4:"tags";a:2:{s:8:"previous";s:12:"‹ Previous";s:4:"next";s:8:"Next ›";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:8:"override";b:1;s:6:"sticky";b:0;s:7:"caption";s:0:"";s:7:"summary";s:0:"";s:11:"description";s:0:"";s:7:"columns";a:8:{s:3:"fid";s:3:"fid";s:8:"filename";s:8:"filename";s:8:"filemime";s:8:"filemime";s:8:"filesize";s:8:"filesize";s:6:"status";s:6:"status";s:7:"created";s:7:"created";s:7:"changed";s:7:"changed";s:5:"count";s:5:"count";}s:4:"info";a:8:{s:3:"fid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filename";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:8:"filemime";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:8:"filesize";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"status";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:7:"changed";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}}s:7:"default";s:7:"changed";s:11:"empty_table";b:1;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:6:"fields";a:8:{s:3:"fid";a:24:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:4:"trim";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"html";b:0;}s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:3:"Fid";s:7:"exclude";b:1;s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";}s:8:"filename";a:36:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:4:"Name";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"file_link";s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";}s:8:"filemime";a:25:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:9:"MIME type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"file_filemime";s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";}s:8:"filesize";a:25:{s:2:"id";s:8:"filesize";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filesize";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:4:"Size";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"file_size";s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filesize";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:19:"format_custom_false";s:9:"Temporary";s:18:"format_custom_true";s:9:"Permanent";}s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:11:"Upload date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"created";}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:12:"file_managed";s:5:"field";s:7:"changed";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:12:"Changed date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:6:"medium";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:7:"changed";}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:3:"fid";s:10:"group_type";s:3:"sum";s:11:"admin_label";s:0:"";s:5:"label";s:7:"Used in";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/content/files/usage/{{ fid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:1;s:20:"format_plural_string";s:21:"1 place@count places";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:9:"plugin_id";s:7:"numeric";}}s:7:"filters";a:3:{s:8:"filename";a:16:{s:2:"id";s:8:"filename";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filename";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:8:"Filename";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filename_op";s:10:"identifier";s:8:"filename";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:6:"string";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filename";}s:8:"filemime";a:16:{s:2:"id";s:8:"filemime";s:5:"table";s:12:"file_managed";s:5:"field";s:8:"filemime";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:4:"word";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:11:"filemime_op";s:5:"label";s:9:"MIME type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"filemime_op";s:10:"identifier";s:8:"filemime";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:6:"string";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:8:"filemime";}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:12:"file_managed";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:9:"status_op";s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:11:"file_status";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:6:"status";}}s:5:"sorts";a:0:{}s:5:"title";s:5:"Files";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:1:{s:16:"area_text_custom";a:6:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:5:"empty";b:1;s:7:"content";s:19:"No files available.";s:9:"plugin_id";s:11:"text_custom";}}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:9:"arguments";a:0:{}s:8:"group_by";b:1;s:16:"show_admin_links";b:1;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:14:"display_plugin";s:4:"page";s:2:"id";s:6:"page_1";s:13:"display_title";s:14:"Files overview";s:8:"position";i:1;s:15:"display_options";a:6:{s:4:"path";s:19:"admin/content/files";s:4:"menu";a:6:{s:4:"type";s:3:"tab";s:5:"title";s:5:"Files";s:11:"description";s:0:"";s:9:"menu_name";s:5:"admin";s:6:"weight";i:0;s:7:"context";s:0:"";}s:19:"display_description";s:0:"";s:8:"defaults";a:2:{s:5:"pager";b:1;s:13:"relationships";b:0;}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:0;}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:6:"page_2";a:6:{s:14:"display_plugin";s:4:"page";s:2:"id";s:6:"page_2";s:13:"display_title";s:10:"File usage";s:8:"position";i:2;s:15:"display_options";a:15:{s:19:"display_description";s:0:"";s:4:"path";s:27:"admin/content/files/usage/%";s:5:"empty";a:0:{}s:8:"defaults";a:11:{s:5:"empty";b:0;s:5:"pager";b:0;s:7:"filters";b:0;s:13:"filter_groups";b:0;s:6:"fields";b:0;s:8:"group_by";b:0;s:5:"title";b:0;s:9:"arguments";b:0;s:5:"style";b:0;s:3:"row";b:0;s:13:"relationships";b:0;}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:14:"items_per_page";i:10;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";i:0;s:4:"tags";a:2:{s:8:"previous";s:12:"‹ Previous";s:4:"next";s:8:"Next ›";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}}}s:7:"filters";a:0:{}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:0:{}}s:6:"fields";a:4:{s:12:"entity_label";a:23:{s:2:"id";s:12:"entity_label";s:5:"table";s:10:"file_usage";s:5:"field";s:12:"entity_label";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:6:"Entity";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:14:"link_to_entity";b:1;s:9:"plugin_id";s:12:"entity_label";}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:10:"file_usage";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:11:"Entity type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:8:"standard";}s:6:"module";a:22:{s:2:"id";s:6:"module";s:5:"table";s:10:"file_usage";s:5:"field";s:6:"module";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:18:"Registering module";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:8:"standard";}s:5:"count";a:30:{s:2:"id";s:5:"count";s:5:"table";s:10:"file_usage";s:5:"field";s:5:"count";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:9:"Use count";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:13:"set_precision";b:0;s:9:"precision";i:0;s:7:"decimal";s:1:".";s:9:"separator";s:1:",";s:13:"format_plural";b:0;s:20:"format_plural_string";s:8:"1@count";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:9:"plugin_id";s:7:"numeric";}}s:8:"group_by";b:0;s:5:"title";s:10:"File usage";s:9:"arguments";a:1:{s:3:"fid";a:23:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:3:"all";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:46:"File usage information for {{ arguments.fid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:14:"items_per_page";i:25;s:8:"override";b:0;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:12:"break_phrase";b:0;s:3:"not";b:0;s:9:"plugin_id";s:8:"file_fid";s:11:"entity_type";s:4:"file";s:12:"entity_field";s:3:"fid";}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:8:"override";b:1;s:6:"sticky";b:0;s:7:"caption";s:0:"";s:7:"summary";s:0:"";s:11:"description";s:0:"";s:7:"columns";a:4:{s:12:"entity_label";s:12:"entity_label";s:4:"type";s:4:"type";s:6:"module";s:6:"module";s:5:"count";s:5:"count";}s:4:"info";a:4:{s:12:"entity_label";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:6:"module";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:5:"count";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:7:"default";s:12:"entity_label";s:11:"empty_table";b:1;}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:0:{}}s:13:"relationships";a:1:{s:3:"fid";a:7:{s:2:"id";s:3:"fid";s:5:"table";s:12:"file_managed";s:5:"field";s:3:"fid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:10:"File usage";s:8:"required";b:1;}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.frontpage','a:13:{s:4:"uuid";s:36:"acbd425c-b6aa-484c-81ae-b81337949610";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:2:{i:0;s:30:"core.entity_view_mode.node.rss";i:1;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Xk6puCoRlHSJG8mU9Zg2iN4fbnzaw2dFolwMfpWxDSE";}s:2:"id";s:9:"frontpage";s:5:"label";s:9:"Frontpage";s:6:"module";s:4:"node";s:11:"description";s:39:"All content promoted to the front page.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:15:"display_options";a:17:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"empty";a:3:{s:16:"area_text_custom";a:11:{s:11:"admin_label";s:0:"";s:7:"content";s:181:"No front page content has been created yet.<br/>Follow the <a target="_blank" href="https://www.drupal.org/docs/user_guide/en/index.html">User Guide</a> to start building your site.";s:5:"empty";b:1;s:5:"field";s:16:"area_text_custom";s:10:"group_type";s:5:"group";s:2:"id";s:16:"area_text_custom";s:5:"label";s:0:"";s:12:"relationship";s:4:"none";s:5:"table";s:5:"views";s:8:"tokenize";b:0;s:9:"plugin_id";s:11:"text_custom";}s:18:"node_listing_empty";a:10:{s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:5:"field";s:18:"node_listing_empty";s:10:"group_type";s:5:"group";s:2:"id";s:18:"node_listing_empty";s:5:"label";s:0:"";s:12:"relationship";s:4:"none";s:5:"table";s:4:"node";s:9:"plugin_id";s:18:"node_listing_empty";s:11:"entity_type";s:4:"node";}s:5:"title";a:10:{s:2:"id";s:5:"title";s:5:"table";s:5:"views";s:5:"field";s:5:"title";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:5:"empty";b:1;s:5:"title";s:22:"Welcome to [site:name]";s:9:"plugin_id";s:5:"title";}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:7:"filters";a:3:{s:7:"promote";a:16:{s:11:"admin_label";s:0:"";s:6:"expose";a:12:{s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:5:"label";s:0:"";s:8:"multiple";b:0;s:8:"operator";s:0:"";s:11:"operator_id";s:0:"";s:8:"remember";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:8:"required";b:0;s:12:"use_operator";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:7:"exposed";b:0;s:5:"field";s:7:"promote";s:5:"group";i:1;s:10:"group_info";a:10:{s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"description";s:0:"";s:11:"group_items";a:0:{}s:10:"identifier";s:0:"";s:5:"label";s:0:"";s:8:"multiple";b:0;s:8:"optional";b:1;s:8:"remember";b:0;s:6:"widget";s:6:"select";}s:10:"group_type";s:5:"group";s:2:"id";s:7:"promote";s:10:"is_grouped";b:0;s:8:"operator";s:1:"=";s:12:"relationship";s:4:"none";s:5:"table";s:15:"node_field_data";s:5:"value";s:1:"1";s:9:"plugin_id";s:7:"boolean";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"promote";}s:6:"status";a:9:{s:6:"expose";a:3:{s:8:"operator";s:0:"";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:5:"field";s:6:"status";s:5:"group";i:1;s:2:"id";s:6:"status";s:5:"table";s:15:"node_field_data";s:5:"value";s:1:"1";s:9:"plugin_id";s:7:"boolean";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"status";}s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:8:"language";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:14:"items_per_page";i:10;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";i:0;s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:4:"tags";a:4:{s:8:"previous";s:12:"‹ Previous";s:4:"next";s:8:"Next ›";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:8:"quantity";i:9;}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:5:"sorts";a:2:{s:6:"sticky";a:12:{s:11:"admin_label";s:0:"";s:6:"expose";a:1:{s:5:"label";s:0:"";}s:7:"exposed";b:0;s:5:"field";s:6:"sticky";s:10:"group_type";s:5:"group";s:2:"id";s:6:"sticky";s:5:"order";s:4:"DESC";s:12:"relationship";s:4:"none";s:5:"table";s:15:"node_field_data";s:9:"plugin_id";s:7:"boolean";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:6:"sticky";}s:7:"created";a:13:{s:5:"field";s:7:"created";s:2:"id";s:7:"created";s:5:"order";s:4:"DESC";s:5:"table";s:15:"node_field_data";s:9:"plugin_id";s:4:"date";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:7:"exposed";b:0;s:6:"expose";a:1:{s:5:"label";s:0:"";}s:11:"granularity";s:6:"second";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"created";}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:5:"title";s:0:"";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:13:"relationships";a:0:{}s:6:"fields";a:0:{}s:9:"arguments";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"display_plugin";s:7:"default";s:13:"display_title";s:6:"Master";s:2:"id";s:7:"default";s:8:"position";i:0;s:14:"cache_metadata";a:3:{s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:14:"display_plugin";s:4:"feed";s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:14:"sitename_title";b:1;s:4:"path";s:7:"rss.xml";s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:0:"";}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:14:"items_per_page";i:10;s:6:"offset";i:0;}}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:11:"description";s:0:"";s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:3:"rss";}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:3:{i:0;s:28:"languages:language_interface";i:1;s:21:"user.node_grants:view";i:2;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:15:"display_options";a:2:{s:4:"path";s:4:"node";s:17:"display_extenders";a:0:{}}s:14:"display_plugin";s:4:"page";s:13:"display_title";s:4:"Page";s:2:"id";s:6:"page_1";s:8:"position";i:1;s:14:"cache_metadata";a:3:{s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:14:"url.query_args";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.glossary','a:13:{s:4:"uuid";s:36:"e61ece44-03f1-4651-be4e-2d2348cd74b4";s:8:"langcode";s:2:"en";s:6:"status";b:0;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:16:"system.menu.main";}s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"Z1Lg95xnf11BTHIugkzple_pdxZdECiqLRcrLVo3bcw";}s:2:"id";s:8:"glossary";s:5:"label";s:8:"Glossary";s:6:"module";s:4:"node";s:11:"description";s:23:"All content, by letter.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:17:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:8:"use_ajax";b:1;s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:14:"items_per_page";i:36;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";i:0;s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:4:"tags";a:2:{s:8:"previous";s:6:"‹‹";s:4:"next";s:6:"››";}}}s:6:"fields";a:3:{s:5:"title";a:24:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:9:"plugin_id";s:5:"field";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:5:"Title";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:5:"label";s:6:"Author";s:12:"relationship";s:3:"uid";s:9:"plugin_id";s:5:"field";s:4:"type";s:9:"user_name";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";}s:7:"changed";a:26:{s:2:"id";s:7:"changed";s:5:"table";s:15:"node_field_data";s:5:"field";s:7:"changed";s:5:"label";s:11:"Last update";s:4:"type";s:9:"timestamp";s:8:"settings";a:3:{s:11:"date_format";s:4:"long";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";}s:9:"plugin_id";s:5:"field";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:7:"changed";}}s:9:"arguments";a:1:{s:5:"title";a:27:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:14:"default_action";s:7:"default";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:7:"summary";a:1:{s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:9:"plugin_id";s:6:"string";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:12:"title_enable";b:0;s:5:"title";s:0:"";s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:0:{}s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:12:"break_phrase";b:0;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";}}s:13:"relationships";a:1:{s:3:"uid";a:8:{s:2:"id";s:3:"uid";s:5:"table";s:15:"node_field_data";s:5:"field";s:3:"uid";s:9:"plugin_id";s:8:"standard";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:6:"author";s:8:"required";b:0;}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:7:"columns";a:3:{s:5:"title";s:5:"title";s:4:"name";s:4:"name";s:7:"changed";s:7:"changed";}s:7:"default";s:5:"title";s:4:"info";a:3:{s:5:"title";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:4:"name";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}s:7:"changed";a:2:{s:8:"sortable";b:1;s:9:"separator";s:0:"";}}s:8:"override";b:1;s:6:"sticky";b:0;s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;s:5:"order";s:3:"asc";s:7:"summary";s:0:"";s:11:"empty_table";b:0;}}s:3:"row";a:2:{s:4:"type";s:6:"fields";s:7:"options";a:4:{s:6:"inline";a:0:{}s:9:"separator";s:0:"";s:10:"hide_empty";b:0;s:22:"default_field_elements";b:1;}}s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:0:{}s:5:"sorts";a:0:{}s:7:"filters";a:1:{s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:8:"language";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:12:"attachment_1";a:6:{s:2:"id";s:12:"attachment_1";s:13:"display_title";s:10:"Attachment";s:14:"display_plugin";s:10:"attachment";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:5:"pager";a:2:{s:4:"type";s:4:"none";s:7:"options";a:2:{s:6:"offset";i:0;s:14:"items_per_page";i:0;}}s:8:"defaults";a:1:{s:9:"arguments";b:0;}s:9:"arguments";a:1:{s:5:"title";a:27:{s:2:"id";s:5:"title";s:5:"table";s:15:"node_field_data";s:5:"field";s:5:"title";s:14:"default_action";s:7:"summary";s:9:"exception";a:1:{s:12:"title_enable";b:1;}s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:1:"a";}s:7:"summary";a:1:{s:6:"format";s:19:"unformatted_summary";}s:15:"summary_options";a:3:{s:14:"items_per_page";i:25;s:6:"inline";b:1;s:9:"separator";s:3:" | ";}s:18:"specify_validation";b:1;s:8:"glossary";b:1;s:5:"limit";i:1;s:4:"case";s:5:"upper";s:9:"path_case";s:5:"lower";s:14:"transform_dash";b:0;s:9:"plugin_id";s:6:"string";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:12:"title_enable";b:0;s:5:"title";s:0:"";s:25:"default_argument_skip_url";b:0;s:8:"validate";a:2:{s:4:"type";s:4:"none";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:0:{}s:12:"break_phrase";b:0;s:11:"entity_type";s:4:"node";s:12:"entity_field";s:5:"title";}}s:8:"displays";a:2:{s:7:"default";s:7:"default";s:6:"page_1";s:6:"page_1";}s:17:"inherit_arguments";b:0;s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:4:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:4:"path";s:8:"glossary";s:4:"menu";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:8:"Glossary";s:6:"weight";i:0;s:9:"menu_name";s:4:"main";s:6:"parent";s:0:"";}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:6:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:21:"user.node_grants:view";i:5;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.taxonomy_term','a:13:{s:4:"uuid";s:36:"215f3bc7-c5a1-456c-8bf9-d102d2cbf416";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:2:{s:6:"config";a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}s:6:"module";a:3:{i:0;s:4:"node";i:1;s:8:"taxonomy";i:2;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"uvMAn5Qf8Uni989mhr5KY4hx66xkSpP8nFYZMHgj7kY";}s:2:"id";s:13:"taxonomy_term";s:5:"label";s:13:"Taxonomy term";s:6:"module";s:8:"taxonomy";s:11:"description";s:45:"Content belonging to a certain taxonomy term.";s:3:"tag";s:7:"default";s:10:"base_table";s:15:"node_field_data";s:10:"base_field";s:3:"nid";s:7:"display";a:3:{s:7:"default";a:6:{s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:14:"display_plugin";s:7:"default";s:8:"position";i:0;s:15:"display_options";a:18:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:13:"query_comment";s:0:"";s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:10:"query_tags";a:0:{}}}s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:14:"items_per_page";i:10;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";i:0;s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:4:"tags";a:2:{s:8:"previous";s:6:"‹‹";s:4:"next";s:6:"››";}}}s:5:"sorts";a:2:{s:6:"sticky";a:10:{s:2:"id";s:6:"sticky";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"sticky";s:5:"order";s:4:"DESC";s:9:"plugin_id";s:8:"standard";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:7:"exposed";b:0;s:6:"expose";a:1:{s:5:"label";s:0:"";}}s:7:"created";a:11:{s:2:"id";s:7:"created";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:7:"created";s:5:"order";s:4:"DESC";s:9:"plugin_id";s:4:"date";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:7:"exposed";b:0;s:6:"expose";a:1:{s:5:"label";s:0:"";}s:11:"granularity";s:6:"second";}}s:9:"arguments";a:1:{s:3:"tid";a:23:{s:2:"id";s:3:"tid";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:3:"tid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:14:"default_action";s:9:"not found";s:9:"exception";a:3:{s:5:"value";s:0:"";s:12:"title_enable";b:0;s:5:"title";s:3:"All";}s:12:"title_enable";b:1;s:5:"title";s:19:"{{ arguments.tid }}";s:21:"default_argument_type";s:5:"fixed";s:24:"default_argument_options";a:1:{s:8:"argument";s:0:"";}s:25:"default_argument_skip_url";b:0;s:15:"summary_options";a:4:{s:9:"base_path";s:0:"";s:5:"count";b:1;s:14:"items_per_page";i:25;s:8:"override";b:0;}s:7:"summary";a:3:{s:10:"sort_order";s:3:"asc";s:17:"number_of_records";i:0;s:6:"format";s:15:"default_summary";}s:18:"specify_validation";b:1;s:8:"validate";a:2:{s:4:"type";s:20:"entity:taxonomy_term";s:4:"fail";s:9:"not found";}s:16:"validate_options";a:4:{s:6:"access";b:1;s:9:"operation";s:4:"view";s:8:"multiple";i:0;s:7:"bundles";a:0:{}}s:12:"break_phrase";b:0;s:9:"add_table";b:0;s:13:"require_value";b:0;s:17:"reduce_duplicates";b:0;s:9:"plugin_id";s:18:"taxonomy_index_tid";}}s:7:"filters";a:2:{s:8:"langcode";a:16:{s:2:"id";s:8:"langcode";s:5:"table";s:15:"node_field_data";s:5:"field";s:8:"langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:1:{s:31:"***LANGUAGE_language_content***";s:31:"***LANGUAGE_language_content***";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:13:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:8:"language";s:11:"entity_type";s:4:"node";s:12:"entity_field";s:8:"langcode";}s:6:"status";a:14:{s:2:"id";s:6:"status";s:5:"table";s:14:"taxonomy_index";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:7:"boolean";}}s:5:"style";a:2:{s:4:"type";s:7:"default";s:7:"options";a:4:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:11:"entity:node";s:7:"options";a:1:{s:9:"view_mode";s:6:"teaser";}}s:6:"header";a:1:{s:20:"entity_taxonomy_term";a:12:{s:2:"id";s:20:"entity_taxonomy_term";s:5:"table";s:5:"views";s:5:"field";s:20:"entity_taxonomy_term";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:8:"tokenize";b:1;s:6:"target";s:23:"{{ raw_arguments.tid }}";s:9:"view_mode";s:4:"full";s:13:"bypass_access";b:0;s:9:"plugin_id";s:6:"entity";}}s:6:"footer";a:0:{}s:5:"empty";a:0:{}s:13:"relationships";a:0:{}s:6:"fields";a:0:{}s:17:"display_extenders";a:0:{}s:8:"link_url";s:0:"";s:12:"link_display";s:6:"page_1";}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:6:"feed_1";a:6:{s:2:"id";s:6:"feed_1";s:13:"display_title";s:4:"Feed";s:14:"display_plugin";s:4:"feed";s:8:"position";i:2;s:15:"display_options";a:7:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:14:"items_per_page";i:10;s:6:"offset";i:0;}}s:4:"path";s:20:"taxonomy/term/%/feed";s:8:"displays";a:2:{s:6:"page_1";s:6:"page_1";s:7:"default";s:1:"0";}s:5:"style";a:2:{s:4:"type";s:3:"rss";s:7:"options";a:3:{s:11:"description";s:0:"";s:8:"grouping";a:0:{}s:11:"uses_fields";b:0;}}s:3:"row";a:2:{s:4:"type";s:8:"node_rss";s:7:"options";a:2:{s:12:"relationship";s:4:"none";s:9:"view_mode";s:7:"default";}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:4:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:21:"user.node_grants:view";i:3;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:14:"display_plugin";s:4:"page";s:8:"position";i:1;s:15:"display_options";a:3:{s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:0:{}}s:4:"path";s:15:"taxonomy/term/%";s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:28:"languages:language_interface";i:1;s:3:"url";i:2;s:14:"url.query_args";i:3;s:21:"user.node_grants:view";i:4;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.user_admin_people','a:13:{s:4:"uuid";s:36:"8da79b94-a69c-4c77-ac6e-bec9687f900c";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"J5EbGNdz0YUaSIYKwomyFSOtZjsV9TrBA3qdb3ZwBS0";}s:2:"id";s:17:"user_admin_people";s:5:"label";s:6:"People";s:6:"module";s:4:"user";s:11:"description";s:50:"Find and manage people interacting with your site.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:25:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:16:"administer users";}}s:5:"cache";a:1:{s:4:"type";s:3:"tag";}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"full";s:7:"options";a:7:{s:14:"items_per_page";i:50;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";i:0;s:4:"tags";a:4:{s:8:"previous";s:12:"‹ Previous";s:4:"next";s:8:"Next ›";s:5:"first";s:8:"« First";s:4:"last";s:7:"Last »";}s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:8:"quantity";i:9;}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:10:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:8:"override";b:1;s:6:"sticky";b:0;s:7:"summary";s:0:"";s:7:"columns";a:8:{s:14:"user_bulk_form";s:14:"user_bulk_form";s:4:"name";s:4:"name";s:6:"status";s:6:"status";s:3:"rid";s:3:"rid";s:7:"created";s:7:"created";s:6:"access";s:6:"access";s:9:"edit_node";s:9:"edit_node";s:10:"dropbutton";s:10:"dropbutton";}s:4:"info";a:8:{s:14:"user_bulk_form";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:6:"status";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:3:"rid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"created";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:6:"access";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:9:"edit_node";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:10:"dropbutton";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}}s:7:"default";s:7:"created";s:11:"empty_table";b:1;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:6:"fields";a:8:{s:14:"user_bulk_form";a:23:{s:2:"id";s:14:"user_bulk_form";s:5:"table";s:5:"users";s:5:"field";s:14:"user_bulk_form";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:11:"Bulk update";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:14:"user_bulk_form";s:11:"entity_type";s:4:"user";}s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:8:"Username";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:5:"field";s:4:"type";s:9:"user_name";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";}s:6:"status";a:26:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:6:"Status";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:5:"field";s:4:"type";s:7:"boolean";s:8:"settings";a:3:{s:6:"format";s:6:"custom";s:18:"format_custom_true";s:6:"Active";s:19:"format_custom_false";s:7:"Blocked";}s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";}s:15:"roles_target_id";a:24:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:5:"Roles";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:2:"ul";s:9:"separator";s:2:", ";s:9:"plugin_id";s:10:"user_roles";}s:7:"created";a:26:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:10:"Member for";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:9:"@interval";s:11:"past_format";s:9:"@interval";s:11:"granularity";i:2;}s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";}s:6:"access";a:26:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:11:"Last access";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:4:"type";s:13:"timestamp_ago";s:8:"settings";a:3:{s:13:"future_format";s:15:"@interval hence";s:11:"past_format";s:13:"@interval ago";s:11:"granularity";i:2;}s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";}s:10:"operations";a:24:{s:2:"id";s:10:"operations";s:5:"table";s:5:"users";s:5:"field";s:10:"operations";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"destination";b:1;s:11:"entity_type";s:4:"user";s:9:"plugin_id";s:17:"entity_operations";}s:4:"mail";a:37:{s:2:"id";s:4:"mail";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"mail";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:0:"";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:12:"basic_string";s:8:"settings";a:0:{}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:9:"plugin_id";s:5:"field";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"mail";}}s:7:"filters";a:6:{s:7:"combine";a:15:{s:2:"id";s:7:"combine";s:5:"table";s:5:"views";s:5:"field";s:7:"combine";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:8:"contains";s:5:"value";s:0:"";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:10:"combine_op";s:5:"label";s:22:"Name or email contains";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:10:"combine_op";s:10:"identifier";s:4:"user";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:6:"fields";a:2:{s:4:"name";s:4:"name";s:4:"mail";s:4:"mail";}s:9:"plugin_id";s:7:"combine";}s:6:"status";a:16:{s:2:"id";s:6:"status";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:9:"status_op";s:10:"identifier";s:6:"status";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:1;s:10:"group_info";a:10:{s:5:"label";s:6:"Status";s:11:"description";s:0:"";s:10:"identifier";s:6:"status";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:2:{i:1;a:3:{s:5:"title";s:6:"Active";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";}i:2;a:3:{s:5:"title";s:7:"Blocked";s:8:"operator";s:1:"=";s:5:"value";s:1:"0";}}}s:9:"plugin_id";s:7:"boolean";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";}s:15:"roles_target_id";a:15:{s:2:"id";s:15:"roles_target_id";s:5:"table";s:11:"user__roles";s:5:"field";s:15:"roles_target_id";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:18:"roles_target_id_op";s:5:"label";s:4:"Role";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:18:"roles_target_id_op";s:10:"identifier";s:4:"role";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;s:9:"plugin_id";s:10:"user_roles";}s:10:"permission";a:15:{s:2:"id";s:10:"permission";s:5:"table";s:11:"user__roles";s:5:"field";s:10:"permission";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"or";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:13:"permission_op";s:5:"label";s:10:"Permission";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:13:"permission_op";s:10:"identifier";s:10:"permission";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:17:"reduce_duplicates";b:0;s:9:"plugin_id";s:16:"user_permissions";}s:16:"default_langcode";a:16:{s:2:"id";s:16:"default_langcode";s:5:"table";s:16:"users_field_data";s:5:"field";s:16:"default_langcode";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:"=";s:5:"value";s:1:"1";s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:0:"";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:11:"entity_type";s:4:"user";s:12:"entity_field";s:16:"default_langcode";s:9:"plugin_id";s:7:"boolean";}s:7:"uid_raw";a:15:{s:2:"id";s:7:"uid_raw";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"uid_raw";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"!=";s:5:"value";a:3:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:1:"0";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:1:"0";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:7:"numeric";s:11:"entity_type";s:4:"user";}}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"order";s:4:"DESC";s:7:"exposed";b:0;s:6:"expose";a:1:{s:5:"label";s:0:"";}s:11:"granularity";s:6:"second";s:9:"plugin_id";s:4:"date";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";}}s:5:"title";s:6:"People";s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:8:"tokenize";b:0;s:7:"content";s:20:"No people available.";s:9:"plugin_id";s:11:"text_custom";}}s:8:"use_more";b:0;s:15:"use_more_always";b:0;s:13:"use_more_text";s:4:"more";s:15:"display_comment";s:0:"";s:8:"use_ajax";b:0;s:23:"hide_attachment_summary";b:0;s:16:"show_admin_links";b:1;s:8:"group_by";b:0;s:8:"link_url";s:0:"";s:12:"link_display";s:6:"page_1";s:9:"css_class";s:0:"";s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:7:"max-age";i:0;s:4:"tags";a:0:{}}}s:6:"page_1";a:6:{s:14:"display_plugin";s:4:"page";s:2:"id";s:6:"page_1";s:13:"display_title";s:4:"Page";s:8:"position";i:1;s:15:"display_options";a:6:{s:4:"path";s:17:"admin/people/list";s:16:"show_admin_links";b:0;s:4:"menu";a:6:{s:4:"type";s:11:"default tab";s:5:"title";s:4:"List";s:11:"description";s:50:"Find and manage people interacting with your site.";s:9:"menu_name";s:5:"admin";s:6:"weight";i:-10;s:7:"context";s:0:"";}s:11:"tab_options";a:5:{s:4:"type";s:6:"normal";s:5:"title";s:6:"People";s:11:"description";s:45:"Manage user accounts, roles, and permissions.";s:9:"menu_name";s:5:"admin";s:6:"weight";i:0;}s:8:"defaults";a:1:{s:16:"show_admin_links";b:0;}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:7:"max-age";i:0;s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.watchdog','a:13:{s:4:"uuid";s:36:"2f7db337-f30d-4daa-a2b5-5801767e9ae5";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:2:{i:0;s:5:"dblog";i:1;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"oG4FVrpj6HxivwdvkAyY23ApbR-iWTnKvM4JHdJ6XmA";}s:2:"id";s:8:"watchdog";s:5:"label";s:8:"Watchdog";s:6:"module";s:5:"views";s:11:"description";s:19:"Recent log messages";s:3:"tag";s:0:"";s:10:"base_table";s:8:"watchdog";s:10:"base_field";s:3:"wid";s:7:"display";a:2:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:19:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:19:"access site reports";}}s:5:"cache";a:2:{s:4:"type";s:4:"none";s:7:"options";a:0:{}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:6:"Filter";s:12:"reset_button";b:1;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:0;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"mini";s:7:"options";a:6:{s:14:"items_per_page";i:50;s:6:"offset";i:0;s:2:"id";i:0;s:11:"total_pages";N;s:6:"expose";a:7:{s:14:"items_per_page";b:0;s:20:"items_per_page_label";s:14:"Items per page";s:22:"items_per_page_options";s:13:"5, 10, 25, 50";s:26:"items_per_page_options_all";b:0;s:32:"items_per_page_options_all_label";s:7:"- All -";s:6:"offset";b:0;s:12:"offset_label";s:6:"Offset";}s:4:"tags";a:2:{s:8:"previous";s:6:"‹‹";s:4:"next";s:6:"››";}}}s:5:"style";a:2:{s:4:"type";s:5:"table";s:7:"options";a:12:{s:8:"grouping";a:0:{}s:9:"row_class";s:25:"{{ type }} {{ severity }}";s:17:"default_row_class";b:1;s:8:"override";b:1;s:6:"sticky";b:0;s:7:"caption";s:0:"";s:7:"summary";s:0:"";s:11:"description";s:0:"";s:7:"columns";a:8:{s:7:"nothing";s:7:"nothing";s:3:"wid";s:3:"wid";s:8:"severity";s:8:"severity";s:4:"type";s:4:"type";s:9:"timestamp";s:9:"timestamp";s:7:"message";s:7:"message";s:4:"name";s:4:"name";s:4:"link";s:4:"link";}s:4:"info";a:8:{s:7:"nothing";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:3:"wid";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:8:"severity";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:4:"type";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:9:"timestamp";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:4:"desc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}s:7:"message";a:6:{s:8:"sortable";b:0;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:0:"";}s:4:"name";a:6:{s:8:"sortable";b:1;s:18:"default_sort_order";s:3:"asc";s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:15:"priority-medium";}s:4:"link";a:4:{s:5:"align";s:0:"";s:9:"separator";s:0:"";s:12:"empty_column";b:0;s:10:"responsive";s:12:"priority-low";}}s:7:"default";s:3:"wid";s:11:"empty_table";b:0;}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:6:"fields";a:8:{s:7:"nothing";a:22:{s:2:"id";s:7:"nothing";s:5:"table";s:5:"views";s:5:"field";s:7:"nothing";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:4:"Icon";s:5:"label";s:0:"";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:1;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:4:"icon";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:0;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:0;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:0;s:9:"plugin_id";s:6:"custom";}s:3:"wid";a:22:{s:2:"id";s:3:"wid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"wid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:3:"WID";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:8:"standard";}s:8:"severity";a:23:{s:2:"id";s:8:"severity";s:5:"table";s:8:"watchdog";s:5:"field";s:8:"severity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:8:"Severity";s:7:"exclude";b:1;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:12:"machine_name";b:0;s:9:"plugin_id";s:12:"machine_name";}s:4:"type";a:22:{s:2:"id";s:4:"type";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:4:"Type";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:8:"standard";}s:9:"timestamp";a:25:{s:2:"id";s:9:"timestamp";s:5:"table";s:8:"watchdog";s:5:"field";s:9:"timestamp";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:4:"Date";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:11:"date_format";s:5:"short";s:18:"custom_date_format";s:0:"";s:8:"timezone";s:0:"";s:9:"plugin_id";s:4:"date";}s:7:"message";a:23:{s:2:"id";s:7:"message";s:5:"table";s:8:"watchdog";s:5:"field";s:7:"message";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:7:"Message";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:1;s:4:"path";s:35:"admin/reports/dblog/event/{{ wid }}";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:13:"{{ message }}";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:56;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:1;s:4:"trim";b:1;s:13:"preserve_tags";s:0:"";s:4:"html";b:1;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"replace_variables";b:1;s:9:"plugin_id";s:13:"dblog_message";}s:4:"name";a:37:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:12:"relationship";s:3:"uid";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:4:"User";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:17:"click_sort_column";s:5:"value";s:4:"type";s:9:"user_name";s:8:"settings";a:1:{s:14:"link_to_entity";b:1;}s:12:"group_column";s:5:"value";s:13:"group_columns";a:0:{}s:10:"group_rows";b:1;s:11:"delta_limit";i:0;s:12:"delta_offset";i:0;s:14:"delta_reversed";b:0;s:16:"delta_first_last";b:0;s:10:"multi_type";s:9:"separator";s:9:"separator";s:2:", ";s:17:"field_api_classes";b:0;s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";s:9:"plugin_id";s:5:"field";}s:4:"link";a:22:{s:2:"id";s:4:"link";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"link";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"label";s:10:"Operations";s:7:"exclude";b:0;s:5:"alter";a:26:{s:10:"alter_text";b:0;s:4:"text";s:0:"";s:9:"make_link";b:0;s:4:"path";s:0:"";s:8:"absolute";b:0;s:8:"external";b:0;s:14:"replace_spaces";b:0;s:9:"path_case";s:4:"none";s:15:"trim_whitespace";b:0;s:3:"alt";s:0:"";s:3:"rel";s:0:"";s:10:"link_class";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";s:6:"target";s:0:"";s:5:"nl2br";b:0;s:10:"max_length";i:0;s:13:"word_boundary";b:1;s:8:"ellipsis";b:1;s:9:"more_link";b:0;s:14:"more_link_text";s:0:"";s:14:"more_link_path";s:0:"";s:10:"strip_tags";b:0;s:4:"trim";b:0;s:13:"preserve_tags";s:0:"";s:4:"html";b:0;}s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:16:"hide_alter_empty";b:1;s:9:"plugin_id";s:16:"dblog_operations";}}s:7:"filters";a:2:{s:4:"type";a:14:{s:2:"id";s:4:"type";s:5:"table";s:8:"watchdog";s:5:"field";s:4:"type";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:7:"type_op";s:5:"label";s:4:"Type";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:7:"type_op";s:10:"identifier";s:4:"type";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:1;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:11:"dblog_types";}s:8:"severity";a:14:{s:2:"id";s:8:"severity";s:5:"table";s:8:"watchdog";s:5:"field";s:8:"severity";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:"in";s:5:"value";a:0:{}s:5:"group";i:1;s:7:"exposed";b:1;s:6:"expose";a:13:{s:11:"operator_id";s:11:"severity_op";s:5:"label";s:8:"Severity";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:11:"severity_op";s:10:"identifier";s:8:"severity";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:1;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:6:"reduce";b:0;s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:11:"in_operator";}}s:5:"sorts";a:1:{s:3:"wid";a:10:{s:2:"id";s:3:"wid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"wid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"order";s:4:"DESC";s:7:"exposed";b:0;s:6:"expose";a:1:{s:5:"label";s:0:"";}s:9:"plugin_id";s:8:"standard";}}s:5:"title";s:19:"Recent log messages";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:1:{s:4:"area";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:26:"No log messages available.";s:5:"empty";b:1;s:8:"tokenize";b:0;s:7:"content";s:26:"No log messages available.";s:9:"plugin_id";s:11:"text_custom";}}s:13:"relationships";a:1:{s:3:"uid";a:8:{s:2:"id";s:3:"uid";s:5:"table";s:8:"watchdog";s:5:"field";s:3:"uid";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:4:"User";s:8:"required";b:0;s:9:"plugin_id";s:8:"standard";}}s:9:"arguments";a:0:{}s:17:"display_extenders";a:0:{}s:13:"filter_groups";a:2:{s:8:"operator";s:3:"AND";s:6:"groups";a:1:{i:1;s:3:"AND";}}s:9:"css_class";s:11:"admin-dblog";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}s:4:"page";a:6:{s:14:"display_plugin";s:4:"page";s:2:"id";s:4:"page";s:13:"display_title";s:4:"Page";s:8:"position";i:1;s:15:"display_options";a:2:{s:17:"display_extenders";a:0:{}s:4:"path";s:19:"admin/reports/dblog";}s:14:"cache_metadata";a:3:{s:7:"max-age";i:-1;s:8:"contexts";a:5:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:3:"url";i:3;s:14:"url.query_args";i:4;s:16:"user.permissions";}s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.who_s_new','a:13:{s:4:"uuid";s:36:"033e30da-c9ff-4c83-b056-84b3484284db";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"nCa1oy25w2fh-nk_iQ7IJFQwQIcKxrV_5EQW2y8dzPc";}s:2:"id";s:9:"who_s_new";s:5:"label";s:9:"Who''s new";s:6:"module";s:4:"user";s:11:"description";s:53:"Shows a list of the newest user accounts on the site.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:17:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:14:"access content";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:14:"items_per_page";i:5;s:6:"offset";i:0;}}s:5:"style";a:1:{s:4:"type";s:9:"html_list";}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:6:"fields";a:1:{s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:5:"label";s:0:"";s:9:"plugin_id";s:5:"field";s:4:"type";s:9:"user_name";s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:4:"trim";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"html";b:0;}s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:7:"exclude";b:0;s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:16:"hide_alter_empty";b:1;s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";}}s:7:"filters";a:2:{s:6:"status";a:9:{s:5:"value";s:1:"1";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:2:"id";s:6:"status";s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:5:"group";i:1;s:9:"plugin_id";s:7:"boolean";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";}s:6:"access";a:16:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:1:">";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:10:"1970-01-01";s:4:"type";s:4:"date";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:1:"0";s:5:"label";s:0:"";s:11:"description";s:0:"";s:12:"use_operator";b:0;s:8:"operator";s:0:"";s:10:"identifier";s:0:"";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:1:{s:13:"authenticated";s:13:"authenticated";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:4:"date";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";}}s:5:"sorts";a:1:{s:7:"created";a:13:{s:2:"id";s:7:"created";s:5:"table";s:16:"users_field_data";s:5:"field";s:7:"created";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"order";s:4:"DESC";s:7:"exposed";b:0;s:6:"expose";a:1:{s:5:"label";s:0:"";}s:11:"granularity";s:6:"second";s:9:"plugin_id";s:4:"date";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:7:"created";}}s:5:"title";s:9:"Who''s new";s:6:"header";a:0:{}s:6:"footer";a:0:{}s:5:"empty";a:0:{}s:13:"relationships";a:0:{}s:9:"arguments";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:7:"block_1";a:6:{s:14:"display_plugin";s:5:"block";s:2:"id";s:7:"block_1";s:13:"display_title";s:9:"Who''s new";s:8:"position";i:1;s:15:"display_options";a:4:{s:19:"display_description";s:19:"A list of new users";s:17:"block_description";s:9:"Who''s new";s:14:"block_category";s:4:"User";s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}}}');
INSERT INTO `config` VALUES ('','views.view.who_s_online','a:13:{s:4:"uuid";s:36:"209a36cd-2a33-426a-b07c-c17469c7fa62";s:8:"langcode";s:2:"en";s:6:"status";b:1;s:12:"dependencies";a:1:{s:6:"module";a:1:{i:0;s:4:"user";}}s:5:"_core";a:1:{s:19:"default_config_hash";s:43:"t9qu6R6PnnbZNOft0SpIMxwCg6VCfaX3aW2W-NjeFyc";}s:2:"id";s:12:"who_s_online";s:5:"label";s:18:"Who''s online block";s:6:"module";s:4:"user";s:11:"description";s:93:"Shows the user names of the most recently active users, and the total number of active users.";s:3:"tag";s:7:"default";s:10:"base_table";s:16:"users_field_data";s:10:"base_field";s:3:"uid";s:7:"display";a:2:{s:7:"default";a:6:{s:14:"display_plugin";s:7:"default";s:2:"id";s:7:"default";s:13:"display_title";s:6:"Master";s:8:"position";i:0;s:15:"display_options";a:17:{s:6:"access";a:2:{s:4:"type";s:4:"perm";s:7:"options";a:1:{s:4:"perm";s:20:"access user profiles";}}s:5:"cache";a:2:{s:4:"type";s:3:"tag";s:7:"options";a:0:{}}s:5:"query";a:2:{s:4:"type";s:11:"views_query";s:7:"options";a:5:{s:19:"disable_sql_rewrite";b:0;s:8:"distinct";b:0;s:7:"replica";b:0;s:13:"query_comment";s:0:"";s:10:"query_tags";a:0:{}}}s:12:"exposed_form";a:2:{s:4:"type";s:5:"basic";s:7:"options";a:7:{s:13:"submit_button";s:5:"Apply";s:12:"reset_button";b:0;s:18:"reset_button_label";s:5:"Reset";s:19:"exposed_sorts_label";s:7:"Sort by";s:17:"expose_sort_order";b:1;s:14:"sort_asc_label";s:3:"Asc";s:15:"sort_desc_label";s:4:"Desc";}}s:5:"pager";a:2:{s:4:"type";s:4:"some";s:7:"options";a:2:{s:14:"items_per_page";i:10;s:6:"offset";i:0;}}s:5:"style";a:2:{s:4:"type";s:9:"html_list";s:7:"options";a:6:{s:8:"grouping";a:0:{}s:9:"row_class";s:0:"";s:17:"default_row_class";b:1;s:4:"type";s:2:"ul";s:13:"wrapper_class";s:9:"item-list";s:5:"class";s:0:"";}}s:3:"row";a:1:{s:4:"type";s:6:"fields";}s:6:"fields";a:1:{s:4:"name";a:25:{s:2:"id";s:4:"name";s:5:"table";s:16:"users_field_data";s:5:"field";s:4:"name";s:5:"label";s:0:"";s:9:"plugin_id";s:5:"field";s:4:"type";s:9:"user_name";s:5:"alter";a:8:{s:10:"alter_text";b:0;s:9:"make_link";b:0;s:8:"absolute";b:0;s:4:"trim";b:0;s:13:"word_boundary";b:0;s:8:"ellipsis";b:0;s:10:"strip_tags";b:0;s:4:"html";b:0;}s:10:"hide_empty";b:0;s:10:"empty_zero";b:0;s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:7:"exclude";b:0;s:12:"element_type";s:0:"";s:13:"element_class";s:0:"";s:18:"element_label_type";s:0:"";s:19:"element_label_class";s:0:"";s:19:"element_label_colon";b:1;s:20:"element_wrapper_type";s:0:"";s:21:"element_wrapper_class";s:0:"";s:23:"element_default_classes";b:1;s:5:"empty";s:0:"";s:16:"hide_alter_empty";b:1;s:11:"entity_type";s:4:"user";s:12:"entity_field";s:4:"name";}}s:7:"filters";a:2:{s:6:"status";a:9:{s:5:"value";s:1:"1";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"status";s:2:"id";s:6:"status";s:6:"expose";a:3:{s:8:"operator";s:1:"0";s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:5:"group";i:1;s:9:"plugin_id";s:7:"boolean";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"status";}s:6:"access";a:16:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:8:"operator";s:2:">=";s:5:"value";a:4:{s:3:"min";s:0:"";s:3:"max";s:0:"";s:5:"value";s:11:"-15 minutes";s:4:"type";s:6:"offset";}s:5:"group";i:1;s:7:"exposed";b:0;s:6:"expose";a:12:{s:11:"operator_id";s:9:"access_op";s:5:"label";s:11:"Last access";s:11:"description";s:77:"A user is considered online for this long after they have last viewed a page.";s:12:"use_operator";b:0;s:8:"operator";s:9:"access_op";s:10:"identifier";s:6:"access";s:8:"required";b:0;s:8:"remember";b:0;s:8:"multiple";b:0;s:14:"remember_roles";a:3:{s:13:"authenticated";s:13:"authenticated";s:9:"anonymous";s:1:"0";s:13:"administrator";s:1:"0";}s:24:"operator_limit_selection";b:0;s:13:"operator_list";a:0:{}}s:10:"is_grouped";b:0;s:10:"group_info";a:10:{s:5:"label";s:0:"";s:11:"description";s:0:"";s:10:"identifier";s:0:"";s:8:"optional";b:1;s:6:"widget";s:6:"select";s:8:"multiple";b:0;s:8:"remember";b:0;s:13:"default_group";s:3:"All";s:22:"default_group_multiple";a:0:{}s:11:"group_items";a:0:{}}s:9:"plugin_id";s:4:"date";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";}}s:5:"sorts";a:1:{s:6:"access";a:13:{s:2:"id";s:6:"access";s:5:"table";s:16:"users_field_data";s:5:"field";s:6:"access";s:5:"order";s:4:"DESC";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:7:"exposed";b:0;s:6:"expose";a:1:{s:5:"label";s:0:"";}s:11:"granularity";s:6:"second";s:9:"plugin_id";s:4:"date";s:11:"entity_type";s:4:"user";s:12:"entity_field";s:6:"access";}}s:5:"title";s:12:"Who''s online";s:6:"header";a:1:{s:6:"result";a:9:{s:2:"id";s:6:"result";s:5:"table";s:5:"views";s:5:"field";s:6:"result";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"empty";b:0;s:7:"content";s:40:"There are currently @total users online.";s:9:"plugin_id";s:6:"result";}}s:6:"footer";a:0:{}s:5:"empty";a:1:{s:16:"area_text_custom";a:10:{s:2:"id";s:16:"area_text_custom";s:5:"table";s:5:"views";s:5:"field";s:16:"area_text_custom";s:12:"relationship";s:4:"none";s:10:"group_type";s:5:"group";s:11:"admin_label";s:0:"";s:5:"empty";b:1;s:8:"tokenize";b:0;s:7:"content";s:35:"There are currently 0 users online.";s:9:"plugin_id";s:11:"text_custom";}}s:13:"relationships";a:0:{}s:9:"arguments";a:0:{}s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}s:18:"who_s_online_block";a:6:{s:14:"display_plugin";s:5:"block";s:2:"id";s:18:"who_s_online_block";s:13:"display_title";s:12:"Who''s online";s:8:"position";i:1;s:15:"display_options";a:3:{s:17:"block_description";s:12:"Who''s online";s:19:"display_description";s:45:"A list of users that are currently logged in.";s:17:"display_extenders";a:0:{}}s:14:"cache_metadata";a:3:{s:8:"contexts";a:3:{i:0;s:26:"languages:language_content";i:1;s:28:"languages:language_interface";i:2;s:16:"user.permissions";}s:7:"max-age";i:-1;s:4:"tags";a:0:{}}}}}');
DROP TABLE IF EXISTS `file_managed`;
CREATE TABLE `file_managed` (   `fid` int(10) unsigned NOT NULL AUTO_INCREMENT,   `uuid` varchar(128) CHARACTER SET ascii NOT NULL,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `uid` int(10) unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',   `filename` varchar(255) DEFAULT NULL,   `uri` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,   `filemime` varchar(255) CHARACTER SET ascii DEFAULT NULL,   `filesize` bigint(20) unsigned DEFAULT NULL,   `status` tinyint(4) NOT NULL,   `created` int(11) DEFAULT NULL,   `changed` int(11) NOT NULL,   PRIMARY KEY (`fid`),   UNIQUE KEY `file_field__uuid__value` (`uuid`),   KEY `file_field__uid__target_id` (`uid`),   KEY `file_field__uri` (`uri`(191)),   KEY `file_field__status` (`status`),   KEY `file_field__changed` (`changed`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for file entities.' AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `file_usage`;
CREATE TABLE `file_usage` (   `fid` int(10) unsigned NOT NULL COMMENT 'File ID.',   `module` varchar(50) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The name of the module that is using the file.',   `type` varchar(64) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The name of the object type in which the file is used.',   `id` varchar(64) CHARACTER SET ascii NOT NULL DEFAULT '0' COMMENT 'The primary key of the object using the file.',   `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The number of times this file is used by this object.',   PRIMARY KEY (`fid`,`type`,`id`,`module`),   KEY `type_id` (`type`,`id`),   KEY `fid_count` (`fid`,`count`),   KEY `fid_module` (`fid`,`module`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Track where a file is used.';
DROP TABLE IF EXISTS `history`;
CREATE TABLE `history` (   `uid` int(11) NOT NULL DEFAULT '0' COMMENT 'The users.uid that read the node nid.',   `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The node.nid that was read.',   `timestamp` int(11) NOT NULL DEFAULT '0' COMMENT 'The Unix timestamp at which the read occurred.',   PRIMARY KEY (`uid`,`nid`),   KEY `nid` (`nid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='A record of which users have read which nodes.';
DROP TABLE IF EXISTS `key_value`;
CREATE TABLE `key_value` (   `collection` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'A named collection of key and value pairs.',   `name` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The key of the key-value pair. As KEY is a SQL reserved keyword, name was chosen instead.',   `value` longblob NOT NULL COMMENT 'The value.',   PRIMARY KEY (`collection`,`name`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Generic key-value storage table. See the state system for…';
INSERT INTO `key_value` VALUES ('config.entity.key_store.action','uuid:0dd26eee-651f-4310-8f96-25b4dde80733','a:1:{i:0;s:39:"system.action.node_make_unsticky_action";}'),('config.entity.key_store.action','uuid:247f2f23-53d0-4bd2-8d03-6cbd0a28a440','a:1:{i:0;s:37:"system.action.node_make_sticky_action";}'),('config.entity.key_store.action','uuid:2d3a3def-9d62-4fa3-8cae-f839f0586099','a:1:{i:0;s:42:"system.action.taxonomy_term_publish_action";}'),('config.entity.key_store.action','uuid:3d6650a5-641a-4533-b581-bbf805eda209','a:1:{i:0;s:35:"system.action.comment_delete_action";}'),('config.entity.key_store.action','uuid:4ecf994a-b914-49b8-94f7-1da608fd7657','a:1:{i:0;s:44:"system.action.taxonomy_term_unpublish_action";}'),('config.entity.key_store.action','uuid:4f864afd-edac-433d-b740-373f4e51e93b','a:1:{i:0;s:35:"system.action.node_unpublish_action";}'),('config.entity.key_store.action','uuid:6329b690-9439-4d96-8f28-f4d7e51f4bde','a:1:{i:0;s:30:"system.action.node_save_action";}'),('config.entity.key_store.action','uuid:794e330d-e16c-4fa6-9f0a-2c3ca8ad7892','a:1:{i:0;s:36:"system.action.user_block_user_action";}'),('config.entity.key_store.action','uuid:90e44b28-9b3e-4273-ba8a-310606e00567','a:1:{i:0;s:38:"system.action.user_unblock_user_action";}'),('config.entity.key_store.action','uuid:979b557c-89f1-4218-b697-1497bd1ac383','a:1:{i:0;s:35:"system.action.node_unpromote_action";}'),('config.entity.key_store.action','uuid:afd5df12-5ba0-4beb-be15-e19cd2a1cafc','a:1:{i:0;s:51:"system.action.user_remove_role_action.administrator";}'),('config.entity.key_store.action','uuid:be104e29-b905-49c6-b044-7fb47526b28b','a:1:{i:0;s:33:"system.action.node_promote_action";}'),('config.entity.key_store.action','uuid:c987b1a7-63f3-4997-ad50-becfd8c1b718','a:1:{i:0;s:33:"system.action.node_publish_action";}'),('config.entity.key_store.action','uuid:cdd13e94-8a85-4745-a6e3-9bbceac091ba','a:1:{i:0;s:36:"system.action.comment_publish_action";}'),('config.entity.key_store.action','uuid:e85b3d9e-542f-474f-bb60-f3bd6dbc84d4','a:1:{i:0;s:37:"system.action.user_cancel_user_action";}');
INSERT INTO `key_value` VALUES ('config.entity.key_store.action','uuid:eebcdee0-c08b-418e-8d5c-2a095f4de490','a:1:{i:0;s:48:"system.action.user_add_role_action.administrator";}'),('config.entity.key_store.action','uuid:f3b8b497-ec18-4c44-be85-3160c2160c4f','a:1:{i:0;s:38:"system.action.comment_unpublish_action";}'),('config.entity.key_store.action','uuid:f9275dc8-7ab5-4529-9755-02d20e5ecd2a','a:1:{i:0;s:32:"system.action.node_delete_action";}'),('config.entity.key_store.action','uuid:fc92eafb-056b-45a7-b046-8865285935b3','a:1:{i:0;s:33:"system.action.comment_save_action";}'),('config.entity.key_store.backup_migrate_destination','uuid:44c990a9-5b5a-4505-b17b-351a6be2d919','a:1:{i:0;s:55:"backup_migrate.backup_migrate_destination.private_files";}'),('config.entity.key_store.backup_migrate_schedule','uuid:a6a4e6f8-b170-4a7c-8a87-c8ca201d1b74','a:1:{i:0;s:53:"backup_migrate.backup_migrate_schedule.daily_schedule";}'),('config.entity.key_store.backup_migrate_source','uuid:611e0a30-7fdf-49b8-bf4f-f5d42afe2bdd','a:1:{i:0;s:50:"backup_migrate.backup_migrate_source.private_files";}'),('config.entity.key_store.backup_migrate_source','uuid:6a2ef746-5be0-4919-9f6f-dbf0821f8dfc','a:1:{i:0;s:48:"backup_migrate.backup_migrate_source.entire_site";}'),('config.entity.key_store.backup_migrate_source','uuid:b2a4d18f-3ad3-4276-a144-68f2f3d768f7','a:1:{i:0;s:47:"backup_migrate.backup_migrate_source.default_db";}'),('config.entity.key_store.backup_migrate_source','uuid:ec85668d-eb40-45a6-b292-b4bc31fa3e97','a:1:{i:0;s:49:"backup_migrate.backup_migrate_source.public_files";}'),('config.entity.key_store.base_field_override','uuid:22b4f570-777a-4a45-9c25-0e9f6d94567c','a:1:{i:0;s:42:"core.base_field_override.node.page.promote";}'),('config.entity.key_store.block','theme:bartik','a:14:{i:0;s:32:"block.block.bartik_local_actions";i:1;s:30:"block.block.bartik_local_tasks";i:2;s:29:"block.block.bartik_page_title";i:3;s:23:"block.block.bartik_help";i:4;s:25:"block.block.bartik_search";i:5;s:26:"block.block.bartik_powered";i:6;s:27:"block.block.bartik_messages";i:7;s:26:"block.block.bartik_content";i:8;s:30:"block.block.bartik_breadcrumbs";i:9;s:27:"block.block.bartik_branding";i:10;s:31:"block.block.bartik_account_menu";i:11;s:25:"block.block.bartik_footer";i:12;s:28:"block.block.bartik_main_menu";i:13;s:24:"block.block.bartik_tools";}');
INSERT INTO `key_value` VALUES ('config.entity.key_store.block','theme:seven','a:8:{i:0;s:39:"block.block.seven_secondary_local_tasks";i:1;s:37:"block.block.seven_primary_local_tasks";i:2;s:28:"block.block.seven_page_title";i:3;s:31:"block.block.seven_local_actions";i:4;s:22:"block.block.seven_help";i:5;s:26:"block.block.seven_messages";i:6;s:25:"block.block.seven_content";i:7;s:29:"block.block.seven_breadcrumbs";}'),('config.entity.key_store.block','theme:twenty','a:14:{i:0;s:31:"block.block.twenty_account_menu";i:1;s:27:"block.block.twenty_branding";i:2;s:30:"block.block.twenty_breadcrumbs";i:3;s:26:"block.block.twenty_content";i:4;s:25:"block.block.twenty_footer";i:5;s:23:"block.block.twenty_help";i:6;s:32:"block.block.twenty_local_actions";i:7;s:30:"block.block.twenty_local_tasks";i:8;s:28:"block.block.twenty_main_menu";i:9;s:27:"block.block.twenty_messages";i:10;s:29:"block.block.twenty_page_title";i:11;s:26:"block.block.twenty_powered";i:12;s:25:"block.block.twenty_search";i:13;s:24:"block.block.twenty_tools";}'),('config.entity.key_store.block','uuid:0b8842a5-c83f-4ae6-ac20-02814714e69d','a:1:{i:0;s:28:"block.block.bartik_main_menu";}'),('config.entity.key_store.block','uuid:1dc2c0ac-79b1-47de-a998-b35ac99874d7','a:1:{i:0;s:26:"block.block.bartik_content";}'),('config.entity.key_store.block','uuid:2784e027-b9aa-4968-9741-0732233d53b7','a:1:{i:0;s:25:"block.block.twenty_search";}'),('config.entity.key_store.block','uuid:3314fee2-daac-4aa2-bde4-ca1dd761bb8d','a:1:{i:0;s:30:"block.block.twenty_local_tasks";}'),('config.entity.key_store.block','uuid:3896f939-0518-4036-9dee-7b4bf8374924','a:1:{i:0;s:32:"block.block.bartik_local_actions";}'),('config.entity.key_store.block','uuid:39721e4d-0bd6-4b90-acd4-708b6dbc2cf5','a:1:{i:0;s:25:"block.block.bartik_search";}'),('config.entity.key_store.block','uuid:3bee9890-c8fd-46b2-b2e6-f8390d255d3b','a:1:{i:0;s:26:"block.block.twenty_powered";}'),('config.entity.key_store.block','uuid:4bb851a5-e9a7-4fec-a7fc-8fbd093f63f6','a:1:{i:0;s:23:"block.block.twenty_help";}'),('config.entity.key_store.block','uuid:4bc7eba1-0bd9-444a-a9f8-ae1cb228cde4','a:1:{i:0;s:31:"block.block.bartik_account_menu";}');
INSERT INTO `key_value` VALUES ('config.entity.key_store.block','uuid:52f6c2d8-080f-46b5-a8e0-1adff0f1e694','a:1:{i:0;s:26:"block.block.bartik_powered";}'),('config.entity.key_store.block','uuid:656e80fb-4618-4c14-bd5e-1b75a41542bb','a:1:{i:0;s:39:"block.block.seven_secondary_local_tasks";}'),('config.entity.key_store.block','uuid:6a7d038f-06c8-42ad-8a84-1a6bb8ebfc9e','a:1:{i:0;s:28:"block.block.twenty_main_menu";}'),('config.entity.key_store.block','uuid:6c74582f-f795-4345-be54-3955d1e6370b','a:1:{i:0;s:26:"block.block.twenty_content";}'),('config.entity.key_store.block','uuid:6e4db537-0688-4b44-a26e-98bb10ff85a9','a:1:{i:0;s:27:"block.block.twenty_messages";}'),('config.entity.key_store.block','uuid:71967f4e-059e-42aa-86c9-2d8a99b4f16e','a:1:{i:0;s:23:"block.block.bartik_help";}'),('config.entity.key_store.block','uuid:71ce3406-aa1c-4971-991f-42b5f76487de','a:1:{i:0;s:27:"block.block.bartik_branding";}'),('config.entity.key_store.block','uuid:75b100a6-bca5-4807-a45f-98c5db8e6e34','a:1:{i:0;s:25:"block.block.bartik_footer";}'),('config.entity.key_store.block','uuid:79066ed0-13ae-4de3-a7c7-372005e8e882','a:1:{i:0;s:31:"block.block.twenty_account_menu";}'),('config.entity.key_store.block','uuid:7bf6cf9f-1e14-4ee7-a9aa-88438ce28100','a:1:{i:0;s:25:"block.block.seven_content";}'),('config.entity.key_store.block','uuid:8105725f-4346-4771-911a-40017aac784b','a:1:{i:0;s:30:"block.block.bartik_breadcrumbs";}'),('config.entity.key_store.block','uuid:8d7d8976-765c-4b28-8e42-58745ca08155','a:1:{i:0;s:30:"block.block.bartik_local_tasks";}'),('config.entity.key_store.block','uuid:8dce281c-c365-445f-a378-e9756bfbf8f9','a:1:{i:0;s:32:"block.block.twenty_local_actions";}'),('config.entity.key_store.block','uuid:8ed91182-241d-4c00-8a9e-b5dd3c64d1f8','a:1:{i:0;s:26:"block.block.seven_messages";}'),('config.entity.key_store.block','uuid:90772fdd-b87e-4498-bdc8-c3aade9cfb3e','a:1:{i:0;s:29:"block.block.twenty_page_title";}'),('config.entity.key_store.block','uuid:9d12b9b5-477b-495c-99c2-df8ea3b467cc','a:1:{i:0;s:25:"block.block.twenty_footer";}'),('config.entity.key_store.block','uuid:a47e0b1c-60d6-4562-a38c-d9765a73cefb','a:1:{i:0;s:27:"block.block.twenty_branding";}');
INSERT INTO `key_value` VALUES ('config.entity.key_store.block','uuid:a56fed7d-39b6-42be-a47b-35f9bb223548','a:1:{i:0;s:27:"block.block.bartik_messages";}'),('config.entity.key_store.block','uuid:aec0563f-beeb-4997-8f8f-3c42392bc0a8','a:1:{i:0;s:29:"block.block.bartik_page_title";}'),('config.entity.key_store.block','uuid:b9d46fe4-231c-4d5f-ab35-327314da103d','a:1:{i:0;s:31:"block.block.seven_local_actions";}'),('config.entity.key_store.block','uuid:c0e19bbd-42e9-497d-82b9-abcb9710f5a9','a:1:{i:0;s:29:"block.block.seven_breadcrumbs";}'),('config.entity.key_store.block','uuid:ca4e317e-177e-4647-a13a-5de3ccf03d36','a:1:{i:0;s:24:"block.block.bartik_tools";}'),('config.entity.key_store.block','uuid:dcb4c7f7-c7e1-473f-8c68-104a3e019ca3','a:1:{i:0;s:30:"block.block.twenty_breadcrumbs";}'),('config.entity.key_store.block','uuid:e174dff6-8c8f-45f2-a5c6-7ced36b6322a','a:1:{i:0;s:37:"block.block.seven_primary_local_tasks";}'),('config.entity.key_store.block','uuid:e2bf1521-fec0-467d-abd4-d3f905bfbf1d','a:1:{i:0;s:22:"block.block.seven_help";}'),('config.entity.key_store.block','uuid:e4252b10-ed84-43d3-9d5f-ce3109cf3b3b','a:1:{i:0;s:28:"block.block.seven_page_title";}'),('config.entity.key_store.block','uuid:ffa8919f-f60c-4152-95b4-d4e97ad85700','a:1:{i:0;s:24:"block.block.twenty_tools";}'),('config.entity.key_store.block_content_type','uuid:c7ed7b0c-aa18-449a-b63d-be760c65fdd8','a:1:{i:0;s:24:"block_content.type.basic";}'),('config.entity.key_store.comment_type','uuid:b020c824-1042-4bc7-b550-caf633d13174','a:1:{i:0;s:20:"comment.type.comment";}'),('config.entity.key_store.contact_form','uuid:023da222-5a7d-4c2d-ad49-763f612cf514','a:1:{i:0;s:21:"contact.form.personal";}'),('config.entity.key_store.contact_form','uuid:45832c3e-9d57-43ca-adfa-09e83771ef4f','a:1:{i:0;s:21:"contact.form.feedback";}'),('config.entity.key_store.date_format','uuid:02fe9c19-3845-46a0-be03-2e47798b618a','a:1:{i:0;s:30:"core.date_format.html_datetime";}'),('config.entity.key_store.date_format','uuid:22b61f6a-f76e-450a-b682-622dd1aadfa1','a:1:{i:0;s:21:"core.date_format.long";}');
INSERT INTO `key_value` VALUES ('config.entity.key_store.date_format','uuid:335c3ad1-aec7-487d-8b15-73894ce4f778','a:1:{i:0;s:35:"core.date_format.html_yearless_date";}'),('config.entity.key_store.date_format','uuid:3fe6691e-a4fa-4005-a986-d6bb683aeebb','a:1:{i:0;s:26:"core.date_format.html_week";}'),('config.entity.key_store.date_format','uuid:4cf28f10-975c-4e50-bff5-9c022ea30017','a:1:{i:0;s:25:"core.date_format.fallback";}'),('config.entity.key_store.date_format','uuid:6465cb57-5bf6-489b-9a6b-4c8124f1f6ba','a:1:{i:0;s:26:"core.date_format.html_year";}'),('config.entity.key_store.date_format','uuid:6a5537be-6682-48da-9751-bdff593d93e9','a:1:{i:0;s:23:"core.date_format.medium";}'),('config.entity.key_store.date_format','uuid:91359425-158f-406a-bcfe-a2e118c245c4','a:1:{i:0;s:26:"core.date_format.html_date";}'),('config.entity.key_store.date_format','uuid:a7b2126a-ab50-4b39-bc0b-eb2063ea9a01','a:1:{i:0;s:22:"core.date_format.short";}'),('config.entity.key_store.date_format','uuid:cca18316-60e4-405d-b095-abd8890576cd','a:1:{i:0;s:26:"core.date_format.html_time";}'),('config.entity.key_store.date_format','uuid:e600a07a-9725-4330-a417-c79a2ecc95a9','a:1:{i:0;s:27:"core.date_format.html_month";}'),('config.entity.key_store.editor','uuid:233dbb2c-759e-4942-ab34-b095b712e742','a:1:{i:0;s:24:"editor.editor.basic_html";}'),('config.entity.key_store.editor','uuid:77909f6a-3732-4465-8e51-f7ea81a3bc78','a:1:{i:0;s:23:"editor.editor.full_html";}'),('config.entity.key_store.entity_form_display','uuid:0b1dec00-8adf-467a-b987-28b5312bb838','a:1:{i:0;s:48:"core.entity_form_display.comment.comment.default";}'),('config.entity.key_store.entity_form_display','uuid:8f30e4fc-1c91-43ac-8890-a607fa440c03','a:1:{i:0;s:45:"core.entity_form_display.node.article.default";}'),('config.entity.key_store.entity_form_display','uuid:a6194f6c-bdef-4583-bf3e-9f33c940a8ab','a:1:{i:0;s:42:"core.entity_form_display.user.user.default";}'),('config.entity.key_store.entity_form_display','uuid:ce7ae483-7bd6-4bdc-8461-7c439246317f','a:1:{i:0;s:52:"core.entity_form_display.block_content.basic.default";}');
INSERT INTO `key_value` VALUES ('config.entity.key_store.entity_form_display','uuid:d4b08316-c3b5-4b33-bb78-ddc208140212','a:1:{i:0;s:42:"core.entity_form_display.node.page.default";}'),('config.entity.key_store.entity_form_mode','uuid:e9552f4c-87df-4527-b3a6-4d3fe230984f','a:1:{i:0;s:35:"core.entity_form_mode.user.register";}'),('config.entity.key_store.entity_view_display','uuid:04ed2c81-8a07-4c4c-af48-efa84388348e','a:1:{i:0;s:42:"core.entity_view_display.user.user.compact";}'),('config.entity.key_store.entity_view_display','uuid:09936100-ab99-42ce-94d1-90106f1fbde6','a:1:{i:0;s:45:"core.entity_view_display.node.article.default";}'),('config.entity.key_store.entity_view_display','uuid:21756941-3d48-4fc7-a019-13d50933b967','a:1:{i:0;s:48:"core.entity_view_display.comment.comment.default";}'),('config.entity.key_store.entity_view_display','uuid:266be899-a1c2-48af-8bbe-f16f22d34d16','a:1:{i:0;s:41:"core.entity_view_display.node.article.rss";}'),('config.entity.key_store.entity_view_display','uuid:316460e9-692b-44c0-8269-07616166f7b5','a:1:{i:0;s:41:"core.entity_view_display.node.page.teaser";}'),('config.entity.key_store.entity_view_display','uuid:56164653-44e8-418e-97fb-a883f6f8b15f','a:1:{i:0;s:52:"core.entity_view_display.block_content.basic.default";}'),('config.entity.key_store.entity_view_display','uuid:5c563d22-26c6-431c-8ddc-3de6a2e972cb','a:1:{i:0;s:44:"core.entity_view_display.node.article.teaser";}'),('config.entity.key_store.entity_view_display','uuid:8f63e5a1-66dc-4964-948c-a4ffe82433d4','a:1:{i:0;s:42:"core.entity_view_display.user.user.default";}'),('config.entity.key_store.entity_view_display','uuid:aa50f0bf-4c24-4974-9720-c74105fcece9','a:1:{i:0;s:42:"core.entity_view_display.node.page.default";}'),('config.entity.key_store.entity_view_mode','uuid:04e19688-a980-49d5-a01f-a7a142aeab80','a:1:{i:0;s:33:"core.entity_view_mode.node.teaser";}'),('config.entity.key_store.entity_view_mode','uuid:10cdca43-9784-4c0d-a964-e9ceb9ee3bb0','a:1:{i:0;s:39:"core.entity_view_mode.node.search_index";}'),('config.entity.key_store.entity_view_mode','uuid:161a3b7e-6100-4be2-af77-c97c2c573122','a:1:{i:0;s:40:"core.entity_view_mode.block_content.full";}');
INSERT INTO `key_value` VALUES ('config.entity.key_store.entity_view_mode','uuid:3319117d-76b5-4d3b-b0e2-fe6b514d7110','a:1:{i:0;s:34:"core.entity_view_mode.user.compact";}'),('config.entity.key_store.entity_view_mode','uuid:545494df-9caa-4584-9964-698d6d292ae9','a:1:{i:0;s:40:"core.entity_view_mode.taxonomy_term.full";}'),('config.entity.key_store.entity_view_mode','uuid:602af499-716f-49a2-bd2b-566a725a62fa','a:1:{i:0;s:30:"core.entity_view_mode.node.rss";}'),('config.entity.key_store.entity_view_mode','uuid:61c3abd7-873f-481a-83f1-d5c9b237e9de','a:1:{i:0;s:31:"core.entity_view_mode.user.full";}'),('config.entity.key_store.entity_view_mode','uuid:85a78151-bf74-47b4-9a7f-5782049b7f23','a:1:{i:0;s:31:"core.entity_view_mode.node.full";}'),('config.entity.key_store.entity_view_mode','uuid:9275da4d-0037-4d10-8b19-3f911310cb3e','a:1:{i:0;s:40:"core.entity_view_mode.node.search_result";}'),('config.entity.key_store.entity_view_mode','uuid:c591e26c-3ebb-44f7-b644-5c46b15b5770','a:1:{i:0;s:34:"core.entity_view_mode.comment.full";}'),('config.entity.key_store.field_config','uuid:101c3cca-0fe1-4dd5-8939-a2f20b100c88','a:1:{i:0;s:29:"field.field.node.article.body";}'),('config.entity.key_store.field_config','uuid:3cb9d578-7c1e-4b3b-bbad-9f364e7f50ae','a:1:{i:0;s:36:"field.field.node.article.field_image";}'),('config.entity.key_store.field_config','uuid:42230958-0e1c-4dee-927e-f784437fcf31','a:1:{i:0;s:34:"field.field.user.user.user_picture";}'),('config.entity.key_store.field_config','uuid:5e0a0055-173b-4c3e-b03d-fd66720c97be','a:1:{i:0;s:26:"field.field.node.page.body";}'),('config.entity.key_store.field_config','uuid:5f5645bc-1aec-495c-a653-ede1db601075','a:1:{i:0;s:32:"field.field.node.article.comment";}'),('config.entity.key_store.field_config','uuid:79574c9f-af3c-49a7-9eee-dd32c79a9015','a:1:{i:0;s:40:"field.field.comment.comment.comment_body";}'),('config.entity.key_store.field_config','uuid:92808a43-7fc3-4d0a-8988-47add6c803e9','a:1:{i:0;s:36:"field.field.block_content.basic.body";}'),('config.entity.key_store.field_config','uuid:f1957d20-5c69-4b69-bc17-1132d838aa9f','a:1:{i:0;s:35:"field.field.node.article.field_tags";}');
INSERT INTO `key_value` VALUES ('config.entity.key_store.field_storage_config','uuid:0a803be1-f0bb-44e2-b180-69f64fa6600d','a:1:{i:0;s:31:"field.storage.user.user_picture";}'),('config.entity.key_store.field_storage_config','uuid:270d89b6-2253-4ee7-a129-e3f30ac9e2a7','a:1:{i:0;s:30:"field.storage.node.field_image";}'),('config.entity.key_store.field_storage_config','uuid:28c1c20b-1e50-4276-a61c-7c8df4790f94','a:1:{i:0;s:32:"field.storage.block_content.body";}'),('config.entity.key_store.field_storage_config','uuid:9a407d32-1165-407d-8b46-0d08ae733fd0','a:1:{i:0;s:26:"field.storage.node.comment";}'),('config.entity.key_store.field_storage_config','uuid:c5f588eb-0952-4250-af4d-8f5501a1d24d','a:1:{i:0;s:29:"field.storage.node.field_tags";}'),('config.entity.key_store.field_storage_config','uuid:e4c97621-a86e-4ef2-9011-bb58634bdbd8','a:1:{i:0;s:34:"field.storage.comment.comment_body";}'),('config.entity.key_store.field_storage_config','uuid:f56076c2-3d15-4179-b1a3-7c27c846e13b','a:1:{i:0;s:23:"field.storage.node.body";}'),('config.entity.key_store.filter_format','uuid:3d06ca20-2259-489b-9d48-ca4373de7a7e','a:1:{i:0;s:23:"filter.format.full_html";}'),('config.entity.key_store.filter_format','uuid:5edb20f4-71e6-4c6d-bb49-3f0a2bcb4186','a:1:{i:0;s:24:"filter.format.plain_text";}'),('config.entity.key_store.filter_format','uuid:61159952-ebf2-488e-b215-84d018846c51','a:1:{i:0;s:24:"filter.format.basic_html";}'),('config.entity.key_store.filter_format','uuid:8b491e42-e0cd-4883-9d63-9d891ed23e6a','a:1:{i:0;s:29:"filter.format.restricted_html";}'),('config.entity.key_store.image_style','uuid:1415e093-2e38-4fd5-ae80-6ecf70702ddf','a:1:{i:0;s:18:"image.style.medium";}'),('config.entity.key_store.image_style','uuid:8d73ce16-6ef7-4ab5-9b48-037c65eb9864','a:1:{i:0;s:21:"image.style.thumbnail";}'),('config.entity.key_store.image_style','uuid:d6239d57-dffa-4c8c-a1e8-8ef5519482db','a:1:{i:0;s:17:"image.style.large";}'),('config.entity.key_store.menu','uuid:231aa860-69eb-4635-9509-9cfeb112d58c','a:1:{i:0;s:19:"system.menu.account";}'),('config.entity.key_store.menu','uuid:4accf9a2-eec5-4f59-9462-f13691bfc82f','a:1:{i:0;s:16:"system.menu.main";}');
INSERT INTO `key_value` VALUES ('config.entity.key_store.menu','uuid:849d3b62-9334-4165-8fe8-fba448b93993','a:1:{i:0;s:17:"system.menu.tools";}'),('config.entity.key_store.menu','uuid:a8e77f50-eada-4342-ace6-8d2954b09fc9','a:1:{i:0;s:18:"system.menu.footer";}'),('config.entity.key_store.menu','uuid:b11b3a43-c3c6-4dfe-9b5c-87f29137fc3c','a:1:{i:0;s:17:"system.menu.admin";}'),('config.entity.key_store.node_type','uuid:3b36644d-0842-42a0-9ca7-cf64d79c967d','a:1:{i:0;s:17:"node.type.article";}'),('config.entity.key_store.node_type','uuid:b7948230-069d-4546-b275-3875ee5ad828','a:1:{i:0;s:14:"node.type.page";}'),('config.entity.key_store.rdf_mapping','uuid:04733885-c41b-4e13-afb1-d047d3514038','a:1:{i:0;s:30:"rdf.mapping.taxonomy_term.tags";}'),('config.entity.key_store.rdf_mapping','uuid:2e97774f-5752-4b9a-98f9-9738837384f0','a:1:{i:0;s:21:"rdf.mapping.user.user";}'),('config.entity.key_store.rdf_mapping','uuid:75856c99-6560-414a-9df9-a9bb4be8c3c1','a:1:{i:0;s:24:"rdf.mapping.node.article";}'),('config.entity.key_store.rdf_mapping','uuid:b7a94fb0-56e6-41ca-8bac-747597ec2493','a:1:{i:0;s:21:"rdf.mapping.node.page";}'),('config.entity.key_store.rdf_mapping','uuid:fd151377-09e9-4976-b054-e2aabc7e16e4','a:1:{i:0;s:27:"rdf.mapping.comment.comment";}'),('config.entity.key_store.search_page','uuid:47fb7b52-8b53-43ed-be33-567e213e4690','a:1:{i:0;s:23:"search.page.node_search";}'),('config.entity.key_store.search_page','uuid:af8678c5-12dd-4eb3-8495-d4555dd3b480','a:1:{i:0;s:23:"search.page.user_search";}'),('config.entity.key_store.shortcut_set','uuid:6b11b537-3e0d-48be-9057-a104a01f433e','a:1:{i:0;s:20:"shortcut.set.default";}'),('config.entity.key_store.taxonomy_vocabulary','uuid:5f2e0557-4bc0-44e7-85bc-062e3574ef0c','a:1:{i:0;s:24:"taxonomy.vocabulary.tags";}'),('config.entity.key_store.tour','routes.*.route_name:entity.view.edit_display_form','a:1:{i:0;s:18:"tour.tour.views-ui";}'),('config.entity.key_store.tour','routes.*.route_name:entity.view.edit_form','a:1:{i:0;s:18:"tour.tour.views-ui";}'),('config.entity.key_store.tour','uuid:d69551f4-9081-44c4-9c19-9e857df01f95','a:1:{i:0;s:18:"tour.tour.views-ui";}');
INSERT INTO `key_value` VALUES ('config.entity.key_store.user_role','uuid:42a852b7-1e3d-4f13-b428-c43a2a3b7d40','a:1:{i:0;s:19:"user.role.anonymous";}'),('config.entity.key_store.user_role','uuid:a26da142-326e-4818-a353-590596ad17db','a:1:{i:0;s:23:"user.role.administrator";}'),('config.entity.key_store.user_role','uuid:b8705504-d0e2-4131-aae2-3cd76c4278da','a:1:{i:0;s:23:"user.role.authenticated";}'),('config.entity.key_store.view','uuid:033e30da-c9ff-4c83-b056-84b3484284db','a:1:{i:0;s:20:"views.view.who_s_new";}'),('config.entity.key_store.view','uuid:209a36cd-2a33-426a-b07c-c17469c7fa62','a:1:{i:0;s:23:"views.view.who_s_online";}'),('config.entity.key_store.view','uuid:215f3bc7-c5a1-456c-8bf9-d102d2cbf416','a:1:{i:0;s:24:"views.view.taxonomy_term";}'),('config.entity.key_store.view','uuid:2f7db337-f30d-4daa-a2b5-5801767e9ae5','a:1:{i:0;s:19:"views.view.watchdog";}'),('config.entity.key_store.view','uuid:73269755-9a33-4461-80c9-3e4bc505180d','a:1:{i:0;s:26:"views.view.comments_recent";}'),('config.entity.key_store.view','uuid:76b46003-73cd-45e5-8588-d1ca01a760a3','a:1:{i:0;s:25:"views.view.content_recent";}'),('config.entity.key_store.view','uuid:89563342-294f-4ba6-a1da-8af2873b0850','a:1:{i:0;s:18:"views.view.content";}'),('config.entity.key_store.view','uuid:8da79b94-a69c-4c77-ac6e-bec9687f900c','a:1:{i:0;s:28:"views.view.user_admin_people";}'),('config.entity.key_store.view','uuid:a25984c2-733d-4be8-b218-5463fbaae6e6','a:1:{i:0;s:18:"views.view.comment";}'),('config.entity.key_store.view','uuid:acbd425c-b6aa-484c-81ae-b81337949610','a:1:{i:0;s:20:"views.view.frontpage";}'),('config.entity.key_store.view','uuid:b729a102-890f-4052-8649-501c9279f9a3','a:1:{i:0;s:16:"views.view.files";}'),('config.entity.key_store.view','uuid:c560a236-5d79-46c1-89eb-c53b03bc29b6','a:1:{i:0;s:18:"views.view.archive";}'),('config.entity.key_store.view','uuid:e5bffd05-d1e6-450b-9cb4-b8b395a0442c','a:1:{i:0;s:24:"views.view.block_content";}'),('config.entity.key_store.view','uuid:e61ece44-03f1-4651-be4e-2d2348cd74b4','a:1:{i:0;s:19:"views.view.glossary";}'),('entity.definitions.bundle_field_map','block_content','a:1:{s:4:"body";a:2:{s:4:"type";s:17:"text_with_summary";s:7:"bundles";a:1:{s:5:"basic";s:5:"basic";}}}');
INSERT INTO `key_value` VALUES ('entity.definitions.bundle_field_map','comment','a:1:{s:12:"comment_body";a:2:{s:4:"type";s:9:"text_long";s:7:"bundles";a:1:{s:7:"comment";s:7:"comment";}}}'),('entity.definitions.bundle_field_map','node','a:4:{s:11:"field_image";a:2:{s:4:"type";s:5:"image";s:7:"bundles";a:1:{s:7:"article";s:7:"article";}}s:7:"comment";a:2:{s:4:"type";s:7:"comment";s:7:"bundles";a:1:{s:7:"article";s:7:"article";}}s:10:"field_tags";a:2:{s:4:"type";s:16:"entity_reference";s:7:"bundles";a:1:{s:7:"article";s:7:"article";}}s:4:"body";a:2:{s:4:"type";s:17:"text_with_summary";s:7:"bundles";a:2:{s:4:"page";s:4:"page";s:7:"article";s:7:"article";}}}'),('entity.definitions.bundle_field_map','user','a:1:{s:12:"user_picture";a:2:{s:4:"type";s:5:"image";s:7:"bundles";a:1:{s:4:"user";s:4:"user";}}}'),('entity.definitions.installed','action.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:4:"type";i:3;s:6:"plugin";i:4;s:13:"configuration";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:6:"action";s:16:"\0*\0originalClass";s:27:"Drupal\\system\\Entity\\Action";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:18:"administer actions";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Action";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Actions";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"action";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"actions";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:13:"@count action";s:6:"plural";s:14:"@count actions";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"config:action_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:27:"Drupal\\system\\Entity\\Action";s:11:"\0*\0provider";s:6:"system";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','backup_migrate_destination.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:0:{}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:4:"uuid";s:4:"uuid";s:4:"type";s:4:"type";s:6:"config";s:6:"config";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:26:"backup_migrate_destination";s:16:"\0*\0originalClass";s:40:"Drupal\\backup_migrate\\Entity\\Destination";s:11:"\0*\0handlers";a:4:{s:12:"list_builder";s:55:"Drupal\\backup_migrate\\Controller\\DestinationListBuilder";s:4:"form";a:2:{s:7:"default";s:42:"Drupal\\backup_migrate\\Form\\DestinationForm";s:6:"delete";s:43:"Drupal\\backup_migrate\\Form\\EntityDeleteForm";}s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:29:"administer backup and migrate";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:9:"edit-form";s:95:"/admin/config/development/backup_migrate/settings/destination/edit/{backup_migrate_destination}";s:11:"delete-form";s:97:"/admin/config/development/backup_migrate/settings/destination/delete/{backup_migrate_destination}";s:10:"collection";s:61:"/admin/config/development/backup_migrate/settings/destination";s:7:"backups";s:98:"/admin/config/development/backup_migrate/settings/destination/backups/{backup_migrate_destination}";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"Backup Destination";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:38:"config:backup_migrate_destination_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:1:{s:6:"module";s:14:"backup_migrate";}s:8:"\0*\0class";s:40:"Drupal\\backup_migrate\\Entity\\Destination";s:11:"\0*\0provider";s:14:"backup_migrate";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','backup_migrate_schedule.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:0:{}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:4:"uuid";s:4:"uuid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:23:"backup_migrate_schedule";s:16:"\0*\0originalClass";s:37:"Drupal\\backup_migrate\\Entity\\Schedule";s:11:"\0*\0handlers";a:4:{s:12:"list_builder";s:52:"Drupal\\backup_migrate\\Controller\\ScheduleListBuilder";s:4:"form";a:2:{s:7:"default";s:39:"Drupal\\backup_migrate\\Form\\ScheduleForm";s:6:"delete";s:43:"Drupal\\backup_migrate\\Form\\EntityDeleteForm";}s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:29:"administer backup and migrate";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"edit-form";s:80:"/admin/config/development/backup_migrate/schedule/edit/{backup_migrate_schedule}";s:11:"delete-form";s:82:"/admin/config/development/backup_migrate/schedule/delete/{backup_migrate_schedule}";s:10:"collection";s:49:"/admin/config/development/backup_migrate/schedule";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Schedule";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:35:"config:backup_migrate_schedule_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:1:{s:6:"module";s:14:"backup_migrate";}s:8:"\0*\0class";s:37:"Drupal\\backup_migrate\\Entity\\Schedule";s:11:"\0*\0provider";s:14:"backup_migrate";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','backup_migrate_settings.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:0:{}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:4:"uuid";s:4:"uuid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:23:"backup_migrate_settings";s:16:"\0*\0originalClass";s:44:"Drupal\\backup_migrate\\Entity\\SettingsProfile";s:11:"\0*\0handlers";a:4:{s:12:"list_builder";s:59:"Drupal\\backup_migrate\\Controller\\SettingsProfileListBuilder";s:4:"form";a:2:{s:7:"default";s:46:"Drupal\\backup_migrate\\Form\\SettingsProfileForm";s:6:"delete";s:43:"Drupal\\backup_migrate\\Form\\EntityDeleteForm";}s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:29:"administer backup and migrate";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:5:{s:9:"canonical";s:75:"/admin/config/development/backup_migrate/settings/{backup_migrate_settings}";s:8:"add-form";s:53:"/admin/config/development/backup_migrate/settings/add";s:9:"edit-form";s:80:"/admin/config/development/backup_migrate/settings/{backup_migrate_settings}/edit";s:11:"delete-form";s:82:"/admin/config/development/backup_migrate/settings/{backup_migrate_settings}/delete";s:10:"collection";s:49:"/admin/config/development/backup_migrate/settings";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Settings Profile";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:35:"config:backup_migrate_settings_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:1:{s:6:"module";s:14:"backup_migrate";}s:8:"\0*\0class";s:44:"Drupal\\backup_migrate\\Entity\\SettingsProfile";s:11:"\0*\0provider";s:14:"backup_migrate";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','backup_migrate_source.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:0:{}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:4:"uuid";s:4:"uuid";s:4:"type";s:4:"type";s:6:"config";s:6:"config";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:21:"backup_migrate_source";s:16:"\0*\0originalClass";s:35:"Drupal\\backup_migrate\\Entity\\Source";s:11:"\0*\0handlers";a:4:{s:12:"list_builder";s:50:"Drupal\\backup_migrate\\Controller\\SourceListBuilder";s:4:"form";a:2:{s:7:"default";s:37:"Drupal\\backup_migrate\\Form\\SourceForm";s:6:"delete";s:43:"Drupal\\backup_migrate\\Form\\EntityDeleteForm";}s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:29:"administer backup and migrate";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:5:{s:9:"canonical";s:80:"/admin/config/development/backup_migrate/settings/source/{backup_migrate_source}";s:8:"add-form";s:60:"/admin/config/development/backup_migrate/settings/source/add";s:9:"edit-form";s:85:"/admin/config/development/backup_migrate/settings/source/{backup_migrate_source}/edit";s:11:"delete-form";s:87:"/admin/config/development/backup_migrate/settings/source/{backup_migrate_source}/delete";s:10:"collection";s:56:"/admin/config/development/backup_migrate/settings/source";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Backup Source";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:33:"config:backup_migrate_source_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:35:"Drupal\\backup_migrate\\Entity\\Source";s:11:"\0*\0provider";s:14:"backup_migrate";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','base_field_override.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:19:"base_field_override";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:6:"bundle";i:4;s:5:"label";i:5;s:11:"description";i:6;s:8:"required";i:7;s:12:"translatable";i:8;s:13:"default_value";i:9;s:22:"default_value_callback";i:10;s:8:"settings";i:11;s:10:"field_type";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:19:"base_field_override";s:16:"\0*\0originalClass";s:42:"Drupal\\Core\\Field\\Entity\\BaseFieldOverride";s:11:"\0*\0handlers";a:2:{s:7:"storage";s:42:"Drupal\\Core\\Field\\BaseFieldOverrideStorage";s:6:"access";s:55:"Drupal\\Core\\Field\\BaseFieldOverrideAccessControlHandler";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Base field override";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:base_field_override_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:42:"Drupal\\Core\\Field\\Entity\\BaseFieldOverride";s:11:"\0*\0provider";s:4:"core";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','block.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:2:{i:0;s:5:"theme";i:1;s:4:"uuid";}s:16:"\0*\0config_export";a:8:{i:0;s:2:"id";i:1;s:5:"theme";i:2;s:6:"region";i:3;s:6:"weight";i:4;s:8:"provider";i:5;s:6:"plugin";i:6;s:8:"settings";i:7;s:10:"visibility";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:5:"block";s:16:"\0*\0originalClass";s:25:"Drupal\\block\\Entity\\Block";s:11:"\0*\0handlers";a:5:{s:6:"access";s:38:"Drupal\\block\\BlockAccessControlHandler";s:12:"view_builder";s:29:"Drupal\\block\\BlockViewBuilder";s:12:"list_builder";s:29:"Drupal\\block\\BlockListBuilder";s:4:"form";a:2:{s:7:"default";s:22:"Drupal\\block\\BlockForm";s:6:"delete";s:33:"Drupal\\block\\Form\\BlockDeleteForm";}s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:17:"administer blocks";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:11:"delete-form";s:44:"/admin/structure/block/manage/{block}/delete";s:9:"edit-form";s:37:"/admin/structure/block/manage/{block}";s:6:"enable";s:44:"/admin/structure/block/manage/{block}/enable";s:7:"disable";s:45:"/admin/structure/block/manage/{block}/disable";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:12:"@count block";s:6:"plural";s:13:"@count blocks";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:17:"config:block_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:25:"Drupal\\block\\Entity\\Block";s:11:"\0*\0provider";s:5:"block";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','block_content.entity_type','O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:13:"revision_user";s:16:"revision_created";s:16:"revision_created";s:20:"revision_log_message";s:12:"revision_log";s:16:"revision_default";s:16:"revision_default";}s:31:"\0*\0requiredRevisionMetadataKeys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:0;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:8:"revision";s:11:"revision_id";s:6:"bundle";s:4:"type";s:5:"label";s:4:"info";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:13:"block_content";s:16:"\0*\0originalClass";s:40:"Drupal\\block_content\\Entity\\BlockContent";s:11:"\0*\0handlers";a:7:{s:7:"storage";s:46:"Drupal\\Core\\Entity\\Sql\\SqlContentEntityStorage";s:6:"access";s:53:"Drupal\\block_content\\BlockContentAccessControlHandler";s:12:"list_builder";s:44:"Drupal\\block_content\\BlockContentListBuilder";s:12:"view_builder";s:44:"Drupal\\block_content\\BlockContentViewBuilder";s:10:"views_data";s:42:"Drupal\\block_content\\BlockContentViewsData";s:4:"form";a:4:{s:3:"add";s:37:"Drupal\\block_content\\BlockContentForm";s:4:"edit";s:37:"Drupal\\block_content\\BlockContentForm";s:6:"delete";s:48:"Drupal\\block_content\\Form\\BlockContentDeleteForm";s:7:"default";s:37:"Drupal\\block_content\\BlockContentForm";}s:11:"translation";s:51:"Drupal\\block_content\\BlockContentTranslationHandler";}s:19:"\0*\0admin_permission";s:17:"administer blocks";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:5:{s:9:"canonical";s:22:"/block/{block_content}";s:11:"delete-form";s:29:"/block/{block_content}/delete";s:9:"edit-form";s:22:"/block/{block_content}";s:10:"collection";s:36:"/admin/structure/block/block-content";s:6:"create";s:6:"/block";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";s:18:"block_content_type";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Custom block type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:13:"block_content";s:22:"\0*\0revision_data_table";s:28:"block_content_field_revision";s:17:"\0*\0revision_table";s:22:"block_content_revision";s:13:"\0*\0data_table";s:24:"block_content_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:1;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Custom block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Custom blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"custom block";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"custom blocks";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:19:"@count custom block";s:6:"plural";s:20:"@count custom blocks";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:35:"entity.block_content_type.edit_form";s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"block_content_list";}s:14:"\0*\0constraints";a:2:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:40:"Drupal\\block_content\\Entity\\BlockContent";s:11:"\0*\0provider";s:13:"block_content";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','block_content.field_storage_definitions','a:16:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:2;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"Custom block ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"The custom block ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:2:"id";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:40;s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:22:"The custom block UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:77;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"The revision ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:115;s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:31:"The custom block language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:155;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:18:"block_content_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Block type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"The block type.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:4:"type";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"revision_created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:193;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:16:"revision_created";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:13:"revision_user";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:223;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:13:"revision_user";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:12:"revision_log";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:260;s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"The log entry explaining the changes in this revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:25;s:8:"settings";a:1:{s:4:"rows";i:4;}}}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:12:"revision_log";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:302;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:6:"status";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"info";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:341;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:12:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Block description";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"A brief description of your block.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"required";b:1;s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:11:"constraints";a:1:{s:11:"UniqueField";a:0:{}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:4:"info";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:386;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the custom block was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"reusable";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:417;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Reusable";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"A boolean indicating whether this block is reusable.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:0;s:12:"revisionable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:8:"reusable";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:460;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:13:"block_content";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:503;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:545;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:13:"block_content";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:13:"block_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"body";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:5:"\0*\0id";s:18:"block_content.body";s:13:"\0*\0field_name";s:4:"body";s:14:"\0*\0entity_type";s:13:"block_content";s:7:"\0*\0type";s:17:"text_with_summary";s:9:"\0*\0module";s:4:"text";s:11:"\0*\0settings";a:0:{}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;s:13:"\0*\0originalId";s:18:"block_content.body";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"28c1c20b-1e50-4276-a61c-7c8df4790f94";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"eS0snV_L3dx9shtWRTzm5eblwOJ7qKWC9IE-4GMTDFc";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:13:"block_content";i:1;s:4:"text";}}s:12:"\0*\0isSyncing";b:0;}}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','block_content_type.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:4:"type";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:8:"revision";i:3;s:11:"description";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:18:"block_content_type";s:16:"\0*\0originalClass";s:44:"Drupal\\block_content\\Entity\\BlockContentType";s:11:"\0*\0handlers";a:5:{s:4:"form";a:4:{s:7:"default";s:41:"Drupal\\block_content\\BlockContentTypeForm";s:3:"add";s:41:"Drupal\\block_content\\BlockContentTypeForm";s:4:"edit";s:41:"Drupal\\block_content\\BlockContentTypeForm";s:6:"delete";s:52:"Drupal\\block_content\\Form\\BlockContentTypeDeleteForm";}s:14:"route_provider";a:1:{s:4:"html";s:49:"Drupal\\Core\\Entity\\Routing\\AdminHtmlRouteProvider";}s:12:"list_builder";s:48:"Drupal\\block_content\\BlockContentTypeListBuilder";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:17:"administer blocks";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:11:"delete-form";s:71:"/admin/structure/block/block-content/manage/{block_content_type}/delete";s:9:"edit-form";s:64:"/admin/structure/block/block-content/manage/{block_content_type}";s:10:"collection";s:42:"/admin/structure/block/block-content/types";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:13:"block_content";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Custom block type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Custom block library";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"custom block type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"custom block types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:24:"@count custom block type";s:6:"plural";s:25:"@count custom block types";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:30:"config:block_content_type_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:44:"Drupal\\block_content\\Entity\\BlockContentType";s:11:"\0*\0provider";s:13:"block_content";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','comment.entity_type','O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:31:"\0*\0requiredRevisionMetadataKeys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:3:"cid";s:6:"bundle";s:12:"comment_type";s:5:"label";s:7:"subject";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:5:"owner";s:3:"uid";s:8:"revision";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:7:"comment";s:16:"\0*\0originalClass";s:29:"Drupal\\comment\\Entity\\Comment";s:11:"\0*\0handlers";a:8:{s:7:"storage";s:29:"Drupal\\comment\\CommentStorage";s:14:"storage_schema";s:35:"Drupal\\comment\\CommentStorageSchema";s:6:"access";s:42:"Drupal\\comment\\CommentAccessControlHandler";s:12:"list_builder";s:36:"Drupal\\Core\\Entity\\EntityListBuilder";s:12:"view_builder";s:33:"Drupal\\comment\\CommentViewBuilder";s:10:"views_data";s:31:"Drupal\\comment\\CommentViewsData";s:4:"form";a:2:{s:7:"default";s:26:"Drupal\\comment\\CommentForm";s:6:"delete";s:30:"Drupal\\comment\\Form\\DeleteForm";}s:11:"translation";s:40:"Drupal\\comment\\CommentTranslationHandler";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:5:{s:9:"canonical";s:18:"/comment/{comment}";s:11:"delete-form";s:25:"/comment/{comment}/delete";s:20:"delete-multiple-form";s:29:"/admin/content/comment/delete";s:9:"edit-form";s:23:"/comment/{comment}/edit";s:6:"create";s:8:"/comment";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";s:12:"comment_type";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Comment type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:7:"comment";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";s:18:"comment_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Comment";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"comment";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"comments";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:14:"@count comment";s:6:"plural";s:15:"@count comments";s:7:"context";N;}s:15:"\0*\0uri_callback";s:11:"comment_uri";s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:29:"entity.comment_type.edit_form";s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:12:"comment_list";}s:14:"\0*\0constraints";a:3:{s:11:"CommentName";a:0:{}s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:29:"Drupal\\comment\\Entity\\Comment";s:11:"\0*\0provider";s:7:"comment";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','comment.field_storage_definitions','a:20:{s:3:"cid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:2;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Comment ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"The comment ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:3:"cid";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:40;s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"The comment UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:77;s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"The comment language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:12:"comment_type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:116;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:12:"comment_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Comment Type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"The comment type.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:12:"comment_type";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:154;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:22:"default_value_callback";s:47:"Drupal\\comment\\Entity\\Comment::getDefaultStatus";s:8:"provider";s:7:"comment";s:10:"field_name";s:6:"status";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:194;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"User ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:22:"default_value_callback";s:52:"Drupal\\comment\\Entity\\Comment::getDefaultEntityOwner";s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"The user ID of the comment author.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:3:"pid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:232;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:7:"comment";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Parent ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"The parent comment ID if this is a reply to a comment.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:3:"pid";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:9:"entity_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:268;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"node";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Entity ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"The ID of the entity of which this comment is a reply.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:9:"entity_id";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"subject";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:305;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:64;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Subject";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:10;}s:12:"configurable";b:1;}}s:8:"provider";s:7:"comment";s:10:"field_name";s:7:"subject";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:342;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:60;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"The comment author''s name.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:8:"provider";s:7:"comment";s:10:"field_name";s:4:"name";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"mail";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:5:"email";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:7:"varchar";s:6:"length";i:254;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:380;s:13:"\0*\0definition";a:2:{s:4:"type";s:16:"field_item:email";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The comment author''s email address.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:4:"mail";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"homepage";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:3:"uri";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:411;s:13:"\0*\0definition";a:2:{s:4:"type";s:14:"field_item:uri";s:8:"settings";a:2:{s:10:"max_length";i:255;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Homepage";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"The comment author''s home page address.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:8:"homepage";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"hostname";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:445;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Hostname";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:30:"The comment author''s hostname.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:22:"default_value_callback";s:49:"Drupal\\comment\\Entity\\Comment::getDefaultHostname";s:8:"provider";s:7:"comment";s:10:"field_name";s:8:"hostname";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:481;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Created";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"The time that the comment was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:7:"created";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:511;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:42:"The time that the comment was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:7:"comment";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"thread";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:541;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Thread place";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:144:"The alphadecimal representation of the comment''s place in a thread, consisting of a base 36 string prefixed by an integer indicating its length.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:6:"thread";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:11:"entity_type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:575;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Entity type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The entity type to which this comment is attached.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:11:"entity_type";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:10:"field_name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:610;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"Comment field name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"The field name through which this comment was added.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"comment";s:10:"field_name";s:10:"field_name";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:645;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:7:"comment";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:7:"comment";s:6:"bundle";N;s:13:"initial_value";N;}}s:12:"comment_body";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:5:"\0*\0id";s:20:"comment.comment_body";s:13:"\0*\0field_name";s:12:"comment_body";s:14:"\0*\0entity_type";s:7:"comment";s:7:"\0*\0type";s:9:"text_long";s:9:"\0*\0module";s:4:"text";s:11:"\0*\0settings";a:0:{}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;s:13:"\0*\0originalId";s:20:"comment.comment_body";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"e4c97621-a86e-4ef2-9011-bb58634bdbd8";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"swYoCch_hY8QO5uwr4FURplfnUCUlpPB4idF8WGVCpw";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"text";}}s:12:"\0*\0isSyncing";b:0;}}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','comment_type.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:4:"type";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:21:"target_entity_type_id";i:3;s:11:"description";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:12:"comment_type";s:16:"\0*\0originalClass";s:33:"Drupal\\comment\\Entity\\CommentType";s:11:"\0*\0handlers";a:4:{s:4:"form";a:4:{s:7:"default";s:30:"Drupal\\comment\\CommentTypeForm";s:3:"add";s:30:"Drupal\\comment\\CommentTypeForm";s:4:"edit";s:30:"Drupal\\comment\\CommentTypeForm";s:6:"delete";s:41:"Drupal\\comment\\Form\\CommentTypeDeleteForm";}s:12:"list_builder";s:37:"Drupal\\comment\\CommentTypeListBuilder";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:24:"administer comment types";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:11:"delete-form";s:53:"/admin/structure/comment/manage/{comment_type}/delete";s:9:"edit-form";s:46:"/admin/structure/comment/manage/{comment_type}";s:8:"add-form";s:34:"/admin/structure/comment/types/add";s:10:"collection";s:24:"/admin/structure/comment";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:7:"comment";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Comment type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"comment type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"comment types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:19:"@count comment type";s:6:"plural";s:20:"@count comment types";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:comment_type_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:33:"Drupal\\comment\\Entity\\CommentType";s:11:"\0*\0provider";s:7:"comment";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','contact_form.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:4:"form";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:7:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:10:"recipients";i:3;s:5:"reply";i:4;s:6:"weight";i:5;s:7:"message";i:6;s:8:"redirect";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:12:"contact_form";s:16:"\0*\0originalClass";s:33:"Drupal\\contact\\Entity\\ContactForm";s:11:"\0*\0handlers";a:4:{s:6:"access";s:46:"Drupal\\contact\\ContactFormAccessControlHandler";s:12:"list_builder";s:37:"Drupal\\contact\\ContactFormListBuilder";s:4:"form";a:3:{s:3:"add";s:34:"Drupal\\contact\\ContactFormEditForm";s:4:"edit";s:34:"Drupal\\contact\\ContactFormEditForm";s:6:"delete";s:35:"Drupal\\Core\\Entity\\EntityDeleteForm";}s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:24:"administer contact forms";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:11:"delete-form";s:53:"/admin/structure/contact/manage/{contact_form}/delete";s:9:"edit-form";s:46:"/admin/structure/contact/manage/{contact_form}";s:10:"collection";s:24:"/admin/structure/contact";s:9:"canonical";s:23:"/contact/{contact_form}";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:15:"contact_message";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Contact form";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Contact forms";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"contact form";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"contact forms";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:19:"@count contact form";s:6:"plural";s:20:"@count contact forms";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:contact_form_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:33:"Drupal\\contact\\Entity\\ContactForm";s:11:"\0*\0provider";s:7:"contact";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','contact_message.entity_type','O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:31:"\0*\0requiredRevisionMetadataKeys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:6:{s:6:"bundle";s:12:"contact_form";s:4:"uuid";s:4:"uuid";s:8:"langcode";s:8:"langcode";s:8:"revision";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:15:"contact_message";s:16:"\0*\0originalClass";s:29:"Drupal\\contact\\Entity\\Message";s:11:"\0*\0handlers";a:4:{s:6:"access";s:49:"Drupal\\contact\\ContactMessageAccessControlHandler";s:7:"storage";s:43:"Drupal\\Core\\Entity\\ContentEntityNullStorage";s:12:"view_builder";s:33:"Drupal\\contact\\MessageViewBuilder";s:4:"form";a:1:{s:7:"default";s:26:"Drupal\\contact\\MessageForm";}}s:19:"\0*\0admin_permission";s:24:"administer contact forms";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";s:12:"contact_form";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Contact form";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"Contact message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Contact messages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"contact message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"contact messages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:22:"@count contact message";s:6:"plural";s:23:"@count contact messages";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:29:"entity.contact_form.edit_form";s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:20:"contact_message_list";}s:14:"\0*\0constraints";a:1:{s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:29:"Drupal\\contact\\Entity\\Message";s:11:"\0*\0provider";s:7:"contact";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','contact_message.field_storage_definitions','a:9:{s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:2;s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"The message UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:28;s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"The message language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}}s:12:"contact_form";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:58;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:12:"contact_form";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Form ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:30:"The ID of the associated form.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:12:"contact_form";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}}s:4:"name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:85;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:6:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"The sender''s name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:59:"The name of the person that is sending the contact message.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:4:"name";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}}s:4:"mail";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:5:"email";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:110;s:13:"\0*\0definition";a:2:{s:4:"type";s:16:"field_item:email";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:6:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"The sender''s email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:60:"The email of the person that is sending the contact message.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:4:"mail";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}}s:7:"subject";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:132;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:100;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Subject";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-10;}s:12:"configurable";b:1;}}s:8:"provider";s:7:"contact";s:10:"field_name";s:7:"subject";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}}s:7:"message";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:160;s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:7:"display";a:2:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:0;s:8:"settings";a:1:{s:4:"rows";i:12;}}s:12:"configurable";b:1;}s:4:"view";a:2:{s:7:"options";a:3:{s:4:"type";s:6:"string";s:6:"weight";i:0;s:5:"label";s:5:"above";}s:12:"configurable";b:1;}}s:8:"provider";s:7:"contact";s:10:"field_name";s:7:"message";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}}s:4:"copy";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:194;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:6:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Copy";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"Whether to send a copy of the message to the sender.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:4:"copy";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}}s:9:"recipient";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";N;s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:224;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:6:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Recipient ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:59:"The ID of the recipient user for personal contact messages.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:7:"contact";s:10:"field_name";s:9:"recipient";s:11:"entity_type";s:15:"contact_message";s:6:"bundle";N;}}}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','date_format.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"locked";i:3;s:7:"pattern";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:11:"date_format";s:16:"\0*\0originalClass";s:38:"Drupal\\Core\\Datetime\\Entity\\DateFormat";s:11:"\0*\0handlers";a:4:{s:6:"access";s:44:"Drupal\\system\\DateFormatAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";s:4:"form";a:3:{s:3:"add";s:36:"Drupal\\system\\Form\\DateFormatAddForm";s:4:"edit";s:37:"Drupal\\system\\Form\\DateFormatEditForm";s:6:"delete";s:39:"Drupal\\system\\Form\\DateFormatDeleteForm";}s:12:"list_builder";s:35:"Drupal\\system\\DateFormatListBuilder";}s:19:"\0*\0admin_permission";s:29:"administer site configuration";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"edit-form";s:61:"/admin/config/regional/date-time/formats/manage/{date_format}";s:11:"delete-form";s:68:"/admin/config/regional/date-time/formats/manage/{date_format}/delete";s:10:"collection";s:40:"/admin/config/regional/date-time/formats";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Date format";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:8:"rendered";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:38:"Drupal\\Core\\Datetime\\Entity\\DateFormat";s:11:"\0*\0provider";s:4:"core";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','editor.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:6:"format";i:1;s:6:"editor";i:2;s:8:"settings";i:3;s:12:"image_upload";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:7:{s:2:"id";s:6:"format";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:6:"editor";s:16:"\0*\0originalClass";s:27:"Drupal\\editor\\Entity\\Editor";s:11:"\0*\0handlers";a:2:{s:6:"access";s:40:"Drupal\\editor\\EditorAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Text Editor";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Text Editors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"text editor";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"text editors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:18:"@count text editor";s:6:"plural";s:19:"@count text editors";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"config:editor_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:27:"Drupal\\editor\\Entity\\Editor";s:11:"\0*\0provider";s:6:"editor";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','entity_form_display.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:6:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";i:4;s:7:"content";i:5;s:6:"hidden";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:19:"entity_form_display";s:16:"\0*\0originalClass";s:43:"Drupal\\Core\\Entity\\Entity\\EntityFormDisplay";s:11:"\0*\0handlers";a:2:{s:6:"access";s:71:"\\Drupal\\Core\\Entity\\Entity\\Access\\EntityFormDisplayAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Entity form display";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:entity_form_display_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:43:"Drupal\\Core\\Entity\\Entity\\EntityFormDisplay";s:11:"\0*\0provider";s:4:"core";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','entity_form_mode.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:16:"targetEntityType";i:3;s:5:"cache";}s:21:"\0*\0mergedConfigExport";a:10:{s:4:"uuid";s:4:"uuid";s:8:"langcode";s:8:"langcode";s:6:"status";s:6:"status";s:12:"dependencies";s:12:"dependencies";s:20:"third_party_settings";s:20:"third_party_settings";s:5:"_core";s:5:"_core";s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:16:"targetEntityType";s:16:"targetEntityType";s:5:"cache";s:5:"cache";}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:16:"entity_form_mode";s:16:"\0*\0originalClass";s:40:"Drupal\\Core\\Entity\\Entity\\EntityFormMode";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Form mode";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:28:"config:entity_form_mode_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:40:"Drupal\\Core\\Entity\\Entity\\EntityFormMode";s:11:"\0*\0provider";s:4:"core";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','entity_view_display.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:6:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:4:"mode";i:4;s:7:"content";i:5;s:6:"hidden";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:19:"entity_view_display";s:16:"\0*\0originalClass";s:43:"Drupal\\Core\\Entity\\Entity\\EntityViewDisplay";s:11:"\0*\0handlers";a:2:{s:6:"access";s:71:"\\Drupal\\Core\\Entity\\Entity\\Access\\EntityViewDisplayAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Entity view display";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:entity_view_display_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:43:"Drupal\\Core\\Entity\\Entity\\EntityViewDisplay";s:11:"\0*\0provider";s:4:"core";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','entity_view_mode.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:16:"targetEntityType";i:3;s:5:"cache";}s:21:"\0*\0mergedConfigExport";a:10:{s:4:"uuid";s:4:"uuid";s:8:"langcode";s:8:"langcode";s:6:"status";s:6:"status";s:12:"dependencies";s:12:"dependencies";s:20:"third_party_settings";s:20:"third_party_settings";s:5:"_core";s:5:"_core";s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:16:"targetEntityType";s:16:"targetEntityType";s:5:"cache";s:5:"cache";}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:16:"entity_view_mode";s:16:"\0*\0originalClass";s:40:"Drupal\\Core\\Entity\\Entity\\EntityViewMode";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"View mode";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";s:0:"";s:15:"\0*\0label_plural";s:0:"";s:14:"\0*\0label_count";a:0:{}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:28:"config:entity_view_mode_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:40:"Drupal\\Core\\Entity\\Entity\\EntityViewMode";s:11:"\0*\0provider";s:4:"core";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','field_config.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:5:"field";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:6:"bundle";i:4;s:5:"label";i:5;s:11:"description";i:6;s:8:"required";i:7;s:12:"translatable";i:8;s:13:"default_value";i:9;s:22:"default_value_callback";i:10;s:8:"settings";i:11;s:10:"field_type";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:12:"field_config";s:16:"\0*\0originalClass";s:31:"Drupal\\field\\Entity\\FieldConfig";s:11:"\0*\0handlers";a:2:{s:6:"access";s:44:"Drupal\\field\\FieldConfigAccessControlHandler";s:7:"storage";s:31:"Drupal\\field\\FieldConfigStorage";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Field";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Fields";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"field";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"fields";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:12:"@count field";s:6:"plural";s:13:"@count fields";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:field_config_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:31:"Drupal\\field\\Entity\\FieldConfig";s:11:"\0*\0provider";s:5:"field";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','field_storage_config.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:7:"storage";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:12:{i:0;s:2:"id";i:1;s:10:"field_name";i:2;s:11:"entity_type";i:3;s:4:"type";i:4;s:8:"settings";i:5;s:6:"module";i:6;s:6:"locked";i:7;s:11:"cardinality";i:8;s:12:"translatable";i:9;s:7:"indexes";i:10;s:22:"persist_with_no_fields";i:11;s:14:"custom_storage";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:2:"id";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:20:"field_storage_config";s:16:"\0*\0originalClass";s:38:"Drupal\\field\\Entity\\FieldStorageConfig";s:11:"\0*\0handlers";a:2:{s:6:"access";s:51:"Drupal\\field\\FieldStorageConfigAccessControlHandler";s:7:"storage";s:38:"Drupal\\field\\FieldStorageConfigStorage";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Field storage";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Field storages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"field storage";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"field storages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:20:"@count field storage";s:6:"plural";s:21:"@count field storages";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:32:"config:field_storage_config_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:38:"Drupal\\field\\Entity\\FieldStorageConfig";s:11:"\0*\0provider";s:5:"field";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','file.entity_type','O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:31:"\0*\0requiredRevisionMetadataKeys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:3:"fid";s:5:"label";s:8:"filename";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:5:"owner";s:3:"uid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:4:"file";s:16:"\0*\0originalClass";s:23:"Drupal\\file\\Entity\\File";s:11:"\0*\0handlers";a:5:{s:7:"storage";s:23:"Drupal\\file\\FileStorage";s:14:"storage_schema";s:29:"Drupal\\file\\FileStorageSchema";s:6:"access";s:36:"Drupal\\file\\FileAccessControlHandler";s:10:"views_data";s:25:"Drupal\\file\\FileViewsData";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:12:"file_managed";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"File";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Files";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"file";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"files";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:11:"@count file";s:6:"plural";s:12:"@count files";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:9:"file_list";}s:14:"\0*\0constraints";a:2:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:23:"Drupal\\file\\Entity\\File";s:11:"\0*\0provider";s:4:"file";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','file.field_storage_definitions','a:11:{s:3:"fid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:2;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"File ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"The file ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:3:"fid";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:40;s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"The file UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:77;s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The file language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}}s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:115;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"User ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:0;s:22:"default_value_callback";s:46:"Drupal\\file\\Entity\\File::getDefaultEntityOwner";s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"The user ID of the file.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"filename";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:153;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Filename";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:41:"Name of the file with no path components.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"filename";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}}s:3:"uri";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"file_uri";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:1;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:187;s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:file_uri";s:8:"settings";a:2:{s:10:"max_length";i:255;s:14:"case_sensitive";b:1;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"URI";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"The URI to access the file (either local or remote).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"constraints";a:1:{s:13:"FileUriUnique";N;}s:8:"provider";s:4:"file";s:10:"field_name";s:3:"uri";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"filemime";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:222;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"File MIME type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:21:"The file''s MIME type.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"filemime";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"filesize";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:256;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:3:"big";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"File size";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:30:"The size of the file in bytes.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:8:"filesize";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:293;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Status";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:63:"The status of the file, temporary (FALSE) and permanent (TRUE).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:8:"provider";s:4:"file";s:10:"field_name";s:6:"status";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:334;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Created";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:40:"The timestamp that the file was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:7:"created";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:363;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"The timestamp that the file was last changed.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"file";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:4:"file";s:6:"bundle";N;s:13:"initial_value";N;}}}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','filter_format.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:6:"format";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:4:"name";i:1;s:6:"format";i:2;s:6:"weight";i:3;s:5:"roles";i:4;s:7:"filters";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:6:"format";s:5:"label";s:4:"name";s:6:"weight";s:6:"weight";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:13:"filter_format";s:16:"\0*\0originalClass";s:33:"Drupal\\filter\\Entity\\FilterFormat";s:11:"\0*\0handlers";a:4:{s:4:"form";a:3:{s:3:"add";s:33:"Drupal\\filter\\FilterFormatAddForm";s:4:"edit";s:34:"Drupal\\filter\\FilterFormatEditForm";s:7:"disable";s:36:"Drupal\\filter\\Form\\FilterDisableForm";}s:12:"list_builder";s:37:"Drupal\\filter\\FilterFormatListBuilder";s:6:"access";s:46:"Drupal\\filter\\FilterFormatAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:18:"administer filters";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:2:{s:9:"edit-form";s:52:"/admin/config/content/formats/manage/{filter_format}";s:7:"disable";s:60:"/admin/config/content/formats/manage/{filter_format}/disable";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Text format";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Text formats";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"text format";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"text formats";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:18:"@count text format";s:6:"plural";s:19:"@count text formats";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:25:"config:filter_format_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:33:"Drupal\\filter\\Entity\\FilterFormat";s:11:"\0*\0provider";s:6:"filter";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','image_style.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:5:"style";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:3:{i:0;s:4:"name";i:1;s:5:"label";i:2;s:7:"effects";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:4:"name";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:11:"image_style";s:16:"\0*\0originalClass";s:30:"Drupal\\image\\Entity\\ImageStyle";s:11:"\0*\0handlers";a:4:{s:4:"form";a:4:{s:3:"add";s:35:"Drupal\\image\\Form\\ImageStyleAddForm";s:4:"edit";s:36:"Drupal\\image\\Form\\ImageStyleEditForm";s:6:"delete";s:38:"Drupal\\image\\Form\\ImageStyleDeleteForm";s:5:"flush";s:37:"Drupal\\image\\Form\\ImageStyleFlushForm";}s:12:"list_builder";s:34:"Drupal\\image\\ImageStyleListBuilder";s:7:"storage";s:30:"Drupal\\image\\ImageStyleStorage";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";}s:19:"\0*\0admin_permission";s:23:"administer image styles";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:10:"flush-form";s:59:"/admin/config/media/image-styles/manage/{image_style}/flush";s:9:"edit-form";s:53:"/admin/config/media/image-styles/manage/{image_style}";s:11:"delete-form";s:60:"/admin/config/media/image-styles/manage/{image_style}/delete";s:10:"collection";s:32:"/admin/config/media/image-styles";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Image style";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Image styles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"image style";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"image styles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:18:"@count image style";s:6:"plural";s:19:"@count image styles";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:23:"config:image_style_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:30:"Drupal\\image\\Entity\\ImageStyle";s:11:"\0*\0provider";s:5:"image";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','menu.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:11:"description";i:3;s:6:"locked";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:4:"menu";s:16:"\0*\0originalClass";s:25:"Drupal\\system\\Entity\\Menu";s:11:"\0*\0handlers";a:2:{s:6:"access";s:38:"Drupal\\system\\MenuAccessControlHandler";s:7:"storage";s:25:"Drupal\\system\\MenuStorage";}s:19:"\0*\0admin_permission";s:15:"administer menu";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Menu";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Menus";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"menu";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"menus";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:11:"@count menu";s:6:"plural";s:12:"@count menus";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:16:"config:menu_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:25:"Drupal\\system\\Entity\\Menu";s:11:"\0*\0provider";s:6:"system";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','menu_link_content.entity_type','O:36:"Drupal\\Core\\Entity\\ContentEntityType":41:{s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:13:"revision_user";s:16:"revision_created";s:16:"revision_created";s:20:"revision_log_message";s:20:"revision_log_message";s:16:"revision_default";s:16:"revision_default";}s:31:"\0*\0requiredRevisionMetadataKeys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:8:"revision";s:11:"revision_id";s:5:"label";s:5:"title";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:6:"bundle";s:6:"bundle";s:9:"published";s:7:"enabled";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:17:"menu_link_content";s:16:"\0*\0originalClass";s:47:"Drupal\\menu_link_content\\Entity\\MenuLinkContent";s:11:"\0*\0handlers";a:6:{s:7:"storage";s:48:"\\Drupal\\menu_link_content\\MenuLinkContentStorage";s:14:"storage_schema";s:53:"Drupal\\menu_link_content\\MenuLinkContentStorageSchema";s:6:"access";s:60:"Drupal\\menu_link_content\\MenuLinkContentAccessControlHandler";s:4:"form";a:2:{s:7:"default";s:49:"Drupal\\menu_link_content\\Form\\MenuLinkContentForm";s:6:"delete";s:55:"Drupal\\menu_link_content\\Form\\MenuLinkContentDeleteForm";}s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";s:10:"moderation";s:0:"";}s:19:"\0*\0admin_permission";s:15:"administer menu";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"canonical";s:51:"/admin/structure/menu/item/{menu_link_content}/edit";s:9:"edit-form";s:51:"/admin/structure/menu/item/{menu_link_content}/edit";s:11:"delete-form";s:53:"/admin/structure/menu/item/{menu_link_content}/delete";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:17:"menu_link_content";s:22:"\0*\0revision_data_table";s:32:"menu_link_content_field_revision";s:17:"\0*\0revision_table";s:26:"menu_link_content_revision";s:13:"\0*\0data_table";s:22:"menu_link_content_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Custom menu link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Custom menu links";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"custom menu link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"custom menu links";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:23:"@count custom menu link";s:6:"plural";s:24:"@count custom menu links";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:22:"menu_link_content_list";}s:14:"\0*\0constraints";a:3:{s:17:"MenuTreeHierarchy";a:0:{}s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:47:"Drupal\\menu_link_content\\Entity\\MenuLinkContent";s:11:"\0*\0provider";s:17:"menu_link_content";s:14:"\0*\0_serviceIds";a:1:{s:17:"stringTranslation";s:18:"string_translation";}s:18:"\0*\0_entityStorages";a:0:{}}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','menu_link_content.field_storage_definitions','a:22:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:2;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Entity ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:48:"The entity ID for this menu link content entity.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:2:"id";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:40;s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:27:"The content menu link UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:77;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:111;s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:28:"The menu link language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"bundle";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:151;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:9:{s:5:"label";s:23:"Custom menu link bundle";s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"The content menu link bundle.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:6:"bundle";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"revision_created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:184;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:16:"revision_created";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:13:"revision_user";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:214;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:13:"revision_user";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:20:"revision_log_message";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:251;s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Briefly describe the changes you have made.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:20:"revision_log_message";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"enabled";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:290;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Enabled";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:65:"A flag for whether the link should be enabled in menus or hidden.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:7:"boolean";s:6:"weight";i:0;}}s:4:"form";a:1:{s:7:"options";a:2:{s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:-1;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:7:"enabled";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:5:"title";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:344;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:15:"Menu link title";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:46:"The text to be used for this link in the menu.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:-5;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:5:"title";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:11:"description";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:392;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Description";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"Shown when hovering over the menu link.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:0;}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:0;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:11:"description";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:9:"menu_name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:438;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Menu name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:93:"The menu name. All links with the same menu name (such as "tools") are part of the same menu.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:5:"tools";}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:9:"menu_name";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"link";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:4:"link";s:9:"\0*\0schema";a:4:{s:7:"columns";a:3:{s:3:"uri";a:3:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;}s:5:"title";a:3:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;}s:7:"options";a:4:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;}}s:7:"indexes";a:1:{s:3:"uri";a:1:{i:0;a:2:{i:0;s:3:"uri";i:1;i:30;}}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:475;s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:link";s:8:"settings";a:2:{s:5:"title";i:0;s:9:"link_type";i:17;}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"The location this menu link points to.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"required";b:1;s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:12:"link_default";s:6:"weight";i:-2;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:4:"link";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"external";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:528;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"External";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:120:"A flag to indicate if the link points to a full URL starting with a protocol, like http:// (1 = external, 0 = internal).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:8:"external";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:10:"rediscover";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:570;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:54:"Indicates whether the menu link should be rediscovered";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:10:"rediscover";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"weight";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:607;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Weight";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:172:"Link weight among links in the same menu at the same depth. In the menu, the links with high weight will sink and links with a low weight will be positioned nearer the top.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:14:"number_integer";s:6:"weight";i:0;}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:6:"number";s:6:"weight";i:20;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:6:"weight";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"expanded";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:657;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Show as expanded";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:164:"If selected and this menu link has children, the menu will always appear expanded. This option may be overridden for the entire menu tree when placing a menu block.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:7:"boolean";s:6:"weight";i:0;}}s:4:"form";a:1:{s:7:"options";a:2:{s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:0;}}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:8:"expanded";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"parent";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:709;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Parent plugin ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:94:"The ID of the parent menu link plugin, or empty string when at the top level of the hierarchy.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:6:"parent";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:743;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:44:"The time that the menu link was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:774;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:817;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:859;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:17:"menu_link_content";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:17:"menu_link_content";s:6:"bundle";N;s:13:"initial_value";N;}}}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','node.entity_type','O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:12:"revision_uid";s:16:"revision_created";s:18:"revision_timestamp";s:20:"revision_log_message";s:12:"revision_log";s:16:"revision_default";s:16:"revision_default";}s:31:"\0*\0requiredRevisionMetadataKeys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:12:{s:2:"id";s:3:"nid";s:8:"revision";s:3:"vid";s:6:"bundle";s:4:"type";s:5:"label";s:5:"title";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:6:"status";s:6:"status";s:9:"published";s:6:"status";s:3:"uid";s:3:"uid";s:5:"owner";s:3:"uid";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:4:"node";s:16:"\0*\0originalClass";s:23:"Drupal\\node\\Entity\\Node";s:11:"\0*\0handlers";a:9:{s:7:"storage";s:23:"Drupal\\node\\NodeStorage";s:14:"storage_schema";s:29:"Drupal\\node\\NodeStorageSchema";s:12:"view_builder";s:27:"Drupal\\node\\NodeViewBuilder";s:6:"access";s:36:"Drupal\\node\\NodeAccessControlHandler";s:10:"views_data";s:25:"Drupal\\node\\NodeViewsData";s:4:"form";a:4:{s:7:"default";s:20:"Drupal\\node\\NodeForm";s:6:"delete";s:31:"Drupal\\node\\Form\\NodeDeleteForm";s:4:"edit";s:20:"Drupal\\node\\NodeForm";s:23:"delete-multiple-confirm";s:31:"Drupal\\node\\Form\\DeleteMultiple";}s:14:"route_provider";a:1:{s:4:"html";s:36:"Drupal\\node\\Entity\\NodeRouteProvider";}s:12:"list_builder";s:27:"Drupal\\node\\NodeListBuilder";s:11:"translation";s:34:"Drupal\\node\\NodeTranslationHandler";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:6:"bundle";s:8:"\0*\0links";a:7:{s:9:"canonical";s:12:"/node/{node}";s:11:"delete-form";s:19:"/node/{node}/delete";s:20:"delete-multiple-form";s:26:"/admin/content/node/delete";s:9:"edit-form";s:17:"/node/{node}/edit";s:15:"version-history";s:22:"/node/{node}/revisions";s:8:"revision";s:43:"/node/{node}/revisions/{node_revision}/view";s:6:"create";s:5:"/node";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";s:9:"node_type";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Content type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:4:"node";s:22:"\0*\0revision_data_table";s:19:"node_field_revision";s:17:"\0*\0revision_table";s:13:"node_revision";s:13:"\0*\0data_table";s:15:"node_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:1;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"content item";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"content items";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:19:"@count content item";s:6:"plural";s:20:"@count content items";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:26:"entity.node_type.edit_form";s:26:"\0*\0common_reference_target";b:1;s:22:"\0*\0list_cache_contexts";a:1:{i:0;s:21:"user.node_grants:view";}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:9:"node_list";}s:14:"\0*\0constraints";a:2:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:23:"Drupal\\node\\Entity\\Node";s:11:"\0*\0provider";s:4:"node";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','node.field_storage_definitions','a:22:{s:3:"nid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:2;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:3:"nid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:36;s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:3:"vid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:69;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:3:"vid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:103;s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"type";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:139;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:9:"node_type";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:8:{s:5:"label";s:12:"Content type";s:8:"required";b:1;s:9:"read-only";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:4:"type";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:18:"revision_timestamp";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:170;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:18:"revision_timestamp";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:12:"revision_uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:200;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:12:"revision_uid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:12:"revision_log";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:237;s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Briefly describe the changes you have made.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:15:"string_textarea";s:6:"weight";i:25;s:8:"settings";a:1:{s:4:"rows";i:4;}}}}s:8:"provider";s:4:"node";s:10:"field_name";s:12:"revision_log";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:279;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:120;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:6:"status";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:326;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Authored by";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:22:"default_value_callback";s:46:"Drupal\\node\\Entity\\Node::getDefaultEntityOwner";s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The username of the content author.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"author";s:6:"weight";i:0;}}s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:29:"entity_reference_autocomplete";s:6:"weight";i:5;s:8:"settings";a:3:{s:14:"match_operator";s:8:"CONTAINS";s:4:"size";s:2:"60";s:11:"placeholder";s:0:"";}}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:5:"title";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:380;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Title";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:-5;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:5:"title";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:424;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Authored on";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The time that the node was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:9:"timestamp";s:6:"weight";i:0;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:18:"datetime_timestamp";s:6:"weight";i:10;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:7:"created";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:466;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"The time that the node was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"promote";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:497;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:22:"Promoted to front page";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:15;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:7:"promote";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"sticky";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:544;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:22:"Sticky at top of lists";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:16;}s:12:"configurable";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:6:"sticky";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:591;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:4:"node";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:634;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:676;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:4:"node";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:4:"node";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"body";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:5:"\0*\0id";s:9:"node.body";s:13:"\0*\0field_name";s:4:"body";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:17:"text_with_summary";s:9:"\0*\0module";s:4:"text";s:11:"\0*\0settings";a:0:{}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:1;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;s:13:"\0*\0originalId";s:9:"node.body";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"f56076c2-3d15-4179-b1a3-7c27c846e13b";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"EBUo7qOWqaiZaQ_RC9sLY5IoDKphS34v77VIHSACmVY";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:4:"text";}}s:12:"\0*\0isSyncing";b:0;}s:11:"field_image";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:5:"\0*\0id";s:16:"node.field_image";s:13:"\0*\0field_name";s:11:"field_image";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:5:"image";s:9:"\0*\0module";s:5:"image";s:11:"\0*\0settings";a:5:{s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:10:"\0*\0deleted";b:0;s:13:"\0*\0originalId";s:16:"node.field_image";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"270d89b6-2253-4ee7-a129-e3f30ac9e2a7";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"SkXIPKZYiIMMtnBmfnxk58RYfbZ8cHSw5NZPY_JByME";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:15:"\0*\0dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"node";}}s:12:"\0*\0isSyncing";b:0;}s:7:"comment";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:5:"\0*\0id";s:12:"node.comment";s:13:"\0*\0field_name";s:7:"comment";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:7:"comment";s:9:"\0*\0module";s:7:"comment";s:11:"\0*\0settings";a:1:{s:12:"comment_type";s:7:"comment";}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;s:13:"\0*\0originalId";s:12:"node.comment";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"9a407d32-1165-407d-8b46-0d08ae733fd0";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"ktCna9xmWvYZIUfOCUyDQvedn5RtnS4CRmEIwNmvYjc";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:7:"comment";i:1;s:4:"node";}}s:12:"\0*\0isSyncing";b:0;}s:10:"field_tags";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:5:"\0*\0id";s:15:"node.field_tags";s:13:"\0*\0field_name";s:10:"field_tags";s:14:"\0*\0entity_type";s:4:"node";s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0module";s:4:"core";s:11:"\0*\0settings";a:1:{s:11:"target_type";s:13:"taxonomy_term";}s:14:"\0*\0cardinality";i:-1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:0:{}s:10:"\0*\0deleted";b:0;s:13:"\0*\0originalId";s:15:"node.field_tags";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"c5f588eb-0952-4250-af4d-8f5501a1d24d";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"WpOE_bs8Bs_HY2ns7n2r__de-xno0-Bxkqep5-MsHAs";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:15:"\0*\0dependencies";a:1:{s:6:"module";a:2:{i:0;s:4:"node";i:1;s:8:"taxonomy";}}s:12:"\0*\0isSyncing";b:0;}}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','node_type.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:4:"type";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:7:{i:0;s:4:"name";i:1;s:4:"type";i:2;s:11:"description";i:3;s:4:"help";i:4;s:12:"new_revision";i:5;s:12:"preview_mode";i:6;s:17:"display_submitted";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:4:"type";s:5:"label";s:4:"name";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:9:"node_type";s:16:"\0*\0originalClass";s:27:"Drupal\\node\\Entity\\NodeType";s:11:"\0*\0handlers";a:4:{s:6:"access";s:40:"Drupal\\node\\NodeTypeAccessControlHandler";s:4:"form";a:3:{s:3:"add";s:24:"Drupal\\node\\NodeTypeForm";s:4:"edit";s:24:"Drupal\\node\\NodeTypeForm";s:6:"delete";s:38:"Drupal\\node\\Form\\NodeTypeDeleteConfirm";}s:12:"list_builder";s:31:"Drupal\\node\\NodeTypeListBuilder";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:24:"administer content types";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"edit-form";s:41:"/admin/structure/types/manage/{node_type}";s:11:"delete-form";s:48:"/admin/structure/types/manage/{node_type}/delete";s:10:"collection";s:22:"/admin/structure/types";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:4:"node";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Content type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Content types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"content type";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"content types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:19:"@count content type";s:6:"plural";s:20:"@count content types";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:21:"config:node_type_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:27:"Drupal\\node\\Entity\\NodeType";s:11:"\0*\0provider";s:4:"node";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','path_alias.entity_type','O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:31:"\0*\0requiredRevisionMetadataKeys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:8:"revision";s:11:"revision_id";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:10:"path_alias";s:16:"\0*\0originalClass";s:34:"Drupal\\path_alias\\Entity\\PathAlias";s:11:"\0*\0handlers";a:4:{s:7:"storage";s:34:"Drupal\\path_alias\\PathAliasStorage";s:14:"storage_schema";s:40:"Drupal\\path_alias\\PathAliasStorageSchema";s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";s:22:"administer url aliases";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:10:"path_alias";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";s:19:"path_alias_revision";s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"URL alias";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"URL aliases";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"URL alias";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"URL aliases";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:16:"@count URL alias";s:6:"plural";s:18:"@count URL aliases";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:11:"route_match";}s:14:"\0*\0constraints";a:2:{s:15:"UniquePathAlias";a:0:{}s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:34:"Drupal\\path_alias\\Entity\\PathAlias";s:11:"\0*\0provider";s:10:"path_alias";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','path_alias.field_storage_definitions','a:8:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:2;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:2:"id";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:36;s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:69;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:103;s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:3:"und";}}s:8:"provider";s:10:"path_alias";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"path";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:141;s:13:"\0*\0definition";a:3:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:2:{s:9:"ValidPath";a:0:{}s:5:"Regex";a:2:{s:7:"pattern";s:6:"/^\\//i";s:7:"message";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:42:"The source path has to start with a slash.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"System path";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:36:"The path that this alias belongs to.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"revisionable";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:4:"path";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}}s:5:"alias";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:187;s:13:"\0*\0definition";a:3:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:1:{s:5:"Regex";a:2:{s:7:"pattern";s:6:"/^\\//i";s:7:"message";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:41:"The alias path has to start with a slash.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"URL alias";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"An alias used with this path.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"revisionable";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:5:"alias";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:232;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:0;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:10:"path_alias";s:10:"field_name";s:6:"status";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:271;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:10:"path_alias";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:10:"path_alias";s:6:"bundle";N;s:13:"initial_value";N;}}}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','rdf_mapping.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:7:"mapping";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:16:"targetEntityType";i:2;s:6:"bundle";i:3;s:5:"types";i:4;s:13:"fieldMappings";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:7:{s:2:"id";s:2:"id";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:11:"rdf_mapping";s:16:"\0*\0originalClass";s:28:"Drupal\\rdf\\Entity\\RdfMapping";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:29:"administer site configuration";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"RDF mapping";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";s:0:"";s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"RDF mapping item";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"RDF mappings items";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:23:"@count RDF mapping item";s:6:"plural";s:24:"@count RDF mapping items";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:23:"config:rdf_mapping_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:28:"Drupal\\rdf\\Entity\\RdfMapping";s:11:"\0*\0provider";s:3:"rdf";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','search_page.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:4:"page";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:6:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:4:"path";i:3;s:6:"weight";i:4;s:6:"plugin";i:5;s:13:"configuration";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:10:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:6:"weight";s:6:"weight";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:11:"search_page";s:16:"\0*\0originalClass";s:31:"Drupal\\search\\Entity\\SearchPage";s:11:"\0*\0handlers";a:4:{s:6:"access";s:44:"Drupal\\search\\SearchPageAccessControlHandler";s:12:"list_builder";s:35:"Drupal\\search\\SearchPageListBuilder";s:4:"form";a:3:{s:3:"add";s:36:"Drupal\\search\\Form\\SearchPageAddForm";s:4:"edit";s:37:"Drupal\\search\\Form\\SearchPageEditForm";s:6:"delete";s:35:"Drupal\\Core\\Entity\\EntityDeleteForm";}s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:17:"administer search";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:6:{s:9:"edit-form";s:47:"/admin/config/search/pages/manage/{search_page}";s:11:"delete-form";s:54:"/admin/config/search/pages/manage/{search_page}/delete";s:6:"enable";s:54:"/admin/config/search/pages/manage/{search_page}/enable";s:7:"disable";s:55:"/admin/config/search/pages/manage/{search_page}/disable";s:11:"set-default";s:59:"/admin/config/search/pages/manage/{search_page}/set-default";s:10:"collection";s:26:"/admin/config/search/pages";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Search page";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Search pages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"search page";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"search pages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:18:"@count search page";s:6:"plural";s:19:"@count search pages";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:23:"config:search_page_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:31:"Drupal\\search\\Entity\\SearchPage";s:11:"\0*\0provider";s:6:"search";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','shortcut.entity_type','O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:31:"\0*\0requiredRevisionMetadataKeys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:4:"uuid";s:4:"uuid";s:6:"bundle";s:12:"shortcut_set";s:5:"label";s:5:"title";s:8:"langcode";s:8:"langcode";s:8:"revision";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:8:"shortcut";s:16:"\0*\0originalClass";s:31:"Drupal\\shortcut\\Entity\\Shortcut";s:11:"\0*\0handlers";a:4:{s:6:"access";s:44:"Drupal\\shortcut\\ShortcutAccessControlHandler";s:4:"form";a:4:{s:7:"default";s:28:"Drupal\\shortcut\\ShortcutForm";s:3:"add";s:28:"Drupal\\shortcut\\ShortcutForm";s:4:"edit";s:28:"Drupal\\shortcut\\ShortcutForm";s:6:"delete";s:39:"Drupal\\shortcut\\Form\\ShortcutDeleteForm";}s:7:"storage";s:46:"Drupal\\Core\\Entity\\Sql\\SqlContentEntityStorage";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:3:{s:9:"canonical";s:53:"/admin/config/user-interface/shortcut/link/{shortcut}";s:11:"delete-form";s:60:"/admin/config/user-interface/shortcut/link/{shortcut}/delete";s:9:"edit-form";s:53:"/admin/config/user-interface/shortcut/link/{shortcut}";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";s:12:"shortcut_set";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Shortcut set";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:8:"shortcut";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";s:19:"shortcut_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Shortcut link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Shortcut links";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"shortcut link";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"shortcut links";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:20:"@count shortcut link";s:6:"plural";s:21:"@count shortcut links";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:shortcut_set_list";}s:14:"\0*\0constraints";a:1:{s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:31:"Drupal\\shortcut\\Entity\\Shortcut";s:11:"\0*\0provider";s:8:"shortcut";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','shortcut.field_storage_definitions','a:8:{s:2:"id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:2;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The ID of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:2:"id";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:40;s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"The UUID of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:77;s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"The language code of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}}s:12:"shortcut_set";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:116;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:12:"shortcut_set";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Shortcut set";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:27:"The bundle of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:12:"shortcut_set";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}}s:5:"title";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:154;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"The name of the shortcut.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:12:"translatable";b:1;s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:3:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-10;s:8:"settings";a:1:{s:4:"size";i:40;}}}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:5:"title";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"weight";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:197;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Weight";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:48:"Weight among shortcuts in the same shortcut set.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:6:"weight";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"link";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:4:"link";s:9:"\0*\0schema";a:4:{s:7:"columns";a:3:{s:3:"uri";a:3:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;}s:5:"title";a:3:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;}s:7:"options";a:4:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;}}s:7:"indexes";a:1:{s:3:"uri";a:1:{i:0;a:2:{i:0;s:3:"uri";i:1;i:30;}}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:234;s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:link";s:8:"settings";a:2:{s:5:"title";i:0;s:9:"link_type";i:1;}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Path";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:37:"The location this shortcut points to.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:12:"link_default";s:6:"weight";i:0;}s:12:"configurable";b:1;}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:4:"link";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:287;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:8:"shortcut";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:8:"shortcut";s:6:"bundle";N;s:13:"initial_value";N;}}}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','shortcut_set.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:3:"set";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:2:{i:0;s:2:"id";i:1;s:5:"label";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:12:"shortcut_set";s:16:"\0*\0originalClass";s:34:"Drupal\\shortcut\\Entity\\ShortcutSet";s:11:"\0*\0handlers";a:4:{s:7:"storage";s:34:"Drupal\\shortcut\\ShortcutSetStorage";s:6:"access";s:47:"Drupal\\shortcut\\ShortcutSetAccessControlHandler";s:12:"list_builder";s:38:"Drupal\\shortcut\\ShortcutSetListBuilder";s:4:"form";a:5:{s:7:"default";s:31:"Drupal\\shortcut\\ShortcutSetForm";s:3:"add";s:31:"Drupal\\shortcut\\ShortcutSetForm";s:4:"edit";s:31:"Drupal\\shortcut\\ShortcutSetForm";s:9:"customize";s:33:"Drupal\\shortcut\\Form\\SetCustomize";s:6:"delete";s:42:"Drupal\\shortcut\\Form\\ShortcutSetDeleteForm";}}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:14:"customize-form";s:69:"/admin/config/user-interface/shortcut/manage/{shortcut_set}/customize";s:11:"delete-form";s:66:"/admin/config/user-interface/shortcut/manage/{shortcut_set}/delete";s:9:"edit-form";s:59:"/admin/config/user-interface/shortcut/manage/{shortcut_set}";s:10:"collection";s:37:"/admin/config/user-interface/shortcut";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:8:"shortcut";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Shortcut set";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Shortcut sets";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"shortcut set";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"shortcut sets";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:19:"@count shortcut set";s:6:"plural";s:20:"@count shortcut sets";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:24:"config:shortcut_set_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:34:"Drupal\\shortcut\\Entity\\ShortcutSet";s:11:"\0*\0provider";s:8:"shortcut";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','taxonomy_term.entity_type','O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:25:"\0*\0revision_metadata_keys";a:4:{s:13:"revision_user";s:13:"revision_user";s:16:"revision_created";s:16:"revision_created";s:20:"revision_log_message";s:20:"revision_log_message";s:16:"revision_default";s:16:"revision_default";}s:31:"\0*\0requiredRevisionMetadataKeys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:3:"tid";s:8:"revision";s:11:"revision_id";s:6:"bundle";s:3:"vid";s:5:"label";s:4:"name";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:9:"published";s:6:"status";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:13:"taxonomy_term";s:16:"\0*\0originalClass";s:27:"Drupal\\taxonomy\\Entity\\Term";s:11:"\0*\0handlers";a:9:{s:7:"storage";s:27:"Drupal\\taxonomy\\TermStorage";s:14:"storage_schema";s:33:"Drupal\\taxonomy\\TermStorageSchema";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";s:12:"list_builder";s:36:"Drupal\\Core\\Entity\\EntityListBuilder";s:6:"access";s:40:"Drupal\\taxonomy\\TermAccessControlHandler";s:10:"views_data";s:29:"Drupal\\taxonomy\\TermViewsData";s:4:"form";a:2:{s:7:"default";s:24:"Drupal\\taxonomy\\TermForm";s:6:"delete";s:35:"Drupal\\taxonomy\\Form\\TermDeleteForm";}s:11:"translation";s:38:"Drupal\\taxonomy\\TermTranslationHandler";s:10:"moderation";s:0:"";}s:19:"\0*\0admin_permission";N;s:25:"\0*\0permission_granularity";s:6:"bundle";s:8:"\0*\0links";a:4:{s:9:"canonical";s:30:"/taxonomy/term/{taxonomy_term}";s:11:"delete-form";s:37:"/taxonomy/term/{taxonomy_term}/delete";s:9:"edit-form";s:35:"/taxonomy/term/{taxonomy_term}/edit";s:6:"create";s:14:"/taxonomy/term";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";s:19:"taxonomy_vocabulary";s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Vocabulary";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"\0*\0base_table";s:18:"taxonomy_term_data";s:22:"\0*\0revision_data_table";s:28:"taxonomy_term_field_revision";s:17:"\0*\0revision_table";s:22:"taxonomy_term_revision";s:13:"\0*\0data_table";s:24:"taxonomy_term_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Taxonomy term";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Taxonomy terms";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"taxonomy term";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"taxonomy terms";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:20:"@count taxonomy term";s:6:"plural";s:21:"@count taxonomy terms";s:7:"context";N;}s:15:"\0*\0uri_callback";s:17:"taxonomy_term_uri";s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:40:"entity.taxonomy_vocabulary.overview_form";s:26:"\0*\0common_reference_target";b:1;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:18:"taxonomy_term_list";}s:14:"\0*\0constraints";a:3:{s:17:"TaxonomyHierarchy";a:0:{}s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:27:"Drupal\\taxonomy\\Entity\\Term";s:11:"\0*\0provider";s:8:"taxonomy";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','taxonomy_term.field_storage_definitions','a:17:{s:3:"tid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:2;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Term ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"The term ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:3:"tid";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:40;s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"The term UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:11:"revision_id";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:77;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Revision ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:11:"revision_id";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:111;s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:2:{s:4:"type";s:15:"language_select";s:6:"weight";i:2;}}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The term language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:3:"vid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:151;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:19:"taxonomy_vocabulary";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Vocabulary";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"The vocabulary to which the term is assigned.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:3:"vid";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"revision_created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:189;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision create time";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:47:"The time that the current revision was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:16:"revision_created";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:13:"revision_user";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:219;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:4:"user";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Revision user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:50:"The user ID of the author of the current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:13:"revision_user";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:20:"revision_log_message";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:11:"string_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:256;s:13:"\0*\0definition";a:2:{s:4:"type";s:22:"field_item:string_long";s:8:"settings";a:1:{s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Revision log message";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Briefly describe the changes you have made.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:7:"display";a:1:{s:4:"form";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:20:"revision_log_message";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:295;s:13:"\0*\0definition";a:3:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}s:5:"class";s:22:"Drupal\\user\\StatusItem";}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Published";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"revisionable";b:1;s:12:"translatable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:7:"display";a:1:{s:4:"form";a:2:{s:7:"options";a:3:{s:4:"type";s:16:"boolean_checkbox";s:8:"settings";a:1:{s:13:"display_label";b:1;}s:6:"weight";i:100;}s:12:"configurable";b:1;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:6:"status";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:343;s:13:"\0*\0definition";a:2:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"required";b:1;s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:6:"string";s:6:"weight";i:-5;}}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:16:"string_textfield";s:6:"weight";i:-5;}s:12:"configurable";b:1;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:4:"name";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:11:"description";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:9:"text_long";s:9:"\0*\0schema";a:4:{s:7:"columns";a:2:{s:5:"value";a:2:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";}s:6:"format";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;}}s:7:"indexes";a:1:{s:6:"format";a:1:{i:0;s:6:"format";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:387;s:13:"\0*\0definition";a:2:{s:4:"type";s:20:"field_item:text_long";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Description";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:7:"display";a:2:{s:4:"view";a:2:{s:7:"options";a:3:{s:5:"label";s:6:"hidden";s:4:"type";s:12:"text_default";s:6:"weight";i:0;}s:12:"configurable";b:1;}s:4:"form";a:2:{s:7:"options";a:2:{s:4:"type";s:14:"text_textfield";s:6:"weight";i:0;}s:12:"configurable";b:1;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:11:"description";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"weight";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:432;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Weight";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:51:"The weight of this term in relation to other terms.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:6:"weight";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"parent";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:472;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:13:"taxonomy_term";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Term Parents";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"The parents of this term.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"cardinality";i:-1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:6:"parent";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:508;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"The time that the term was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:539;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:16:"revision_default";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:582;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:11:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Default revision";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"A flag indicating whether this was a default revision when it was saved.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:16:"storage_required";b:1;s:8:"internal";b:1;s:12:"translatable";b:0;s:12:"revisionable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:16:"revision_default";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}s:29:"revision_translation_affected";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:624;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Revision translation affected";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:72:"Indicates if the last edit of a translation belongs to current revision.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:12:"revisionable";b:1;s:12:"translatable";b:1;s:8:"provider";s:8:"taxonomy";s:10:"field_name";s:29:"revision_translation_affected";s:11:"entity_type";s:13:"taxonomy_term";s:6:"bundle";N;s:13:"initial_value";N;}}}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','taxonomy_vocabulary.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:10:"vocabulary";s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:4:{i:0;s:4:"name";i:1;s:3:"vid";i:2;s:11:"description";i:3;s:6:"weight";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:3:"vid";s:5:"label";s:4:"name";s:6:"weight";s:6:"weight";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:19:"taxonomy_vocabulary";s:16:"\0*\0originalClass";s:33:"Drupal\\taxonomy\\Entity\\Vocabulary";s:11:"\0*\0handlers";a:5:{s:7:"storage";s:33:"Drupal\\taxonomy\\VocabularyStorage";s:12:"list_builder";s:37:"Drupal\\taxonomy\\VocabularyListBuilder";s:6:"access";s:46:"Drupal\\taxonomy\\VocabularyAccessControlHandler";s:4:"form";a:4:{s:7:"default";s:30:"Drupal\\taxonomy\\VocabularyForm";s:5:"reset";s:40:"Drupal\\taxonomy\\Form\\VocabularyResetForm";s:6:"delete";s:41:"Drupal\\taxonomy\\Form\\VocabularyDeleteForm";s:8:"overview";s:34:"Drupal\\taxonomy\\Form\\OverviewTerms";}s:14:"route_provider";a:1:{s:4:"html";s:54:"Drupal\\taxonomy\\Entity\\Routing\\VocabularyRouteProvider";}}s:19:"\0*\0admin_permission";s:19:"administer taxonomy";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:6:{s:8:"add-form";s:29:"/admin/structure/taxonomy/add";s:11:"delete-form";s:61:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}/delete";s:10:"reset-form";s:60:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}/reset";s:13:"overview-form";s:63:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}/overview";s:9:"edit-form";s:54:"/admin/structure/taxonomy/manage/{taxonomy_vocabulary}";s:10:"collection";s:25:"/admin/structure/taxonomy";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";s:13:"taxonomy_term";s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Taxonomy vocabulary";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Taxonomy";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"vocabulary";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"vocabularies";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:17:"@count vocabulary";s:6:"plural";s:19:"@count vocabularies";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:31:"config:taxonomy_vocabulary_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:33:"Drupal\\taxonomy\\Entity\\Vocabulary";s:11:"\0*\0provider";s:8:"taxonomy";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','tour.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:2:{i:0;s:19:"routes.*.route_name";i:1;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"module";i:3;s:6:"routes";i:4;s:4:"tips";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:8:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:4:"tour";s:16:"\0*\0originalClass";s:23:"Drupal\\tour\\Entity\\Tour";s:11:"\0*\0handlers";a:3:{s:12:"view_builder";s:27:"Drupal\\tour\\TourViewBuilder";s:6:"access";s:36:"Drupal\\tour\\TourAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:29:"administer site configuration";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Tour";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Tours";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"tour";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"tours";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:11:"@count tour";s:6:"plural";s:12:"@count tours";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:16:"config:tour_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:23:"Drupal\\tour\\Entity\\Tour";s:11:"\0*\0provider";s:4:"tour";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','user.entity_type','O:36:"Drupal\\Core\\Entity\\ContentEntityType":42:{s:25:"\0*\0revision_metadata_keys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:31:"\0*\0requiredRevisionMetadataKeys";a:1:{s:16:"revision_default";s:16:"revision_default";}s:15:"\0*\0static_cache";b:1;s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:7:{s:2:"id";s:3:"uid";s:8:"langcode";s:8:"langcode";s:4:"uuid";s:4:"uuid";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";}s:5:"\0*\0id";s:4:"user";s:16:"\0*\0originalClass";s:23:"Drupal\\user\\Entity\\User";s:11:"\0*\0handlers";a:9:{s:7:"storage";s:23:"Drupal\\user\\UserStorage";s:14:"storage_schema";s:29:"Drupal\\user\\UserStorageSchema";s:6:"access";s:36:"Drupal\\user\\UserAccessControlHandler";s:12:"list_builder";s:27:"Drupal\\user\\UserListBuilder";s:10:"views_data";s:25:"Drupal\\user\\UserViewsData";s:14:"route_provider";a:1:{s:4:"html";s:36:"Drupal\\user\\Entity\\UserRouteProvider";}s:4:"form";a:3:{s:7:"default";s:23:"Drupal\\user\\ProfileForm";s:6:"cancel";s:31:"Drupal\\user\\Form\\UserCancelForm";s:8:"register";s:24:"Drupal\\user\\RegisterForm";}s:11:"translation";s:37:"Drupal\\user\\ProfileTranslationHandler";s:12:"view_builder";s:36:"Drupal\\Core\\Entity\\EntityViewBuilder";}s:19:"\0*\0admin_permission";s:16:"administer users";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:9:"canonical";s:12:"/user/{user}";s:9:"edit-form";s:17:"/user/{user}/edit";s:11:"cancel-form";s:19:"/user/{user}/cancel";s:10:"collection";s:13:"/admin/people";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";s:5:"users";s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";s:16:"users_field_data";s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:1;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"User";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Users";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"user";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"users";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:11:"@count user";s:6:"plural";s:12:"@count users";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:7:"content";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";s:22:"entity.user.admin_form";s:26:"\0*\0common_reference_target";b:1;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:9:"user_list";}s:14:"\0*\0constraints";a:2:{s:13:"EntityChanged";N;s:26:"EntityUntranslatableFields";N;}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:23:"Drupal\\user\\Entity\\User";s:11:"\0*\0provider";s:4:"user";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','user.field_storage_definitions','a:18:{s:3:"uid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"integer";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:2;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:integer";s:8:"settings";a:6:{s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:3:"min";s:0:"";s:3:"max";s:0:"";s:6:"prefix";s:0:"";s:6:"suffix";s:0:"";}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"User ID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"The user ID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:3:"uid";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"uuid";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:4:"uuid";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;}}s:11:"unique keys";a:1:{s:5:"value";a:1:{i:0;s:5:"value";}}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:40;s:13:"\0*\0definition";a:2:{s:4:"type";s:15:"field_item:uuid";s:8:"settings";a:3:{s:10:"max_length";i:128;s:8:"is_ascii";b:1;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"UUID";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"read-only";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"The user UUID.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"uuid";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:77;s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:7:"display";a:2:{s:4:"view";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}s:4:"form";a:1:{s:7:"options";a:1:{s:6:"region";s:6:"hidden";}}}s:12:"translatable";b:1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The user language code.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:8:"langcode";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:18:"preferred_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:115;s:13:"\0*\0definition";a:3:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:2:{s:13:"AllowedValues";a:1:{s:8:"callback";s:60:"Drupal\\user\\Entity\\User::getAllowedConfigurableLanguageCodes";}s:6:"Length";a:1:{s:3:"max";i:12;}}}}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"Preferred language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:77:"The user''s preferred language code for receiving emails and viewing the site.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:18:"preferred_langcode";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:24:"preferred_admin_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"language";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:152;s:13:"\0*\0definition";a:3:{s:4:"type";s:19:"field_item:language";s:8:"settings";a:0:{}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:2:{s:13:"AllowedValues";a:1:{s:8:"callback";s:60:"Drupal\\user\\Entity\\User::getAllowedConfigurableLanguageCodes";}s:6:"Length";a:1:{s:3:"max";i:12;}}}}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Preferred admin language code";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:68:"The user''s preferred language code for viewing administration pages.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";N;}}s:8:"provider";s:4:"user";s:10:"field_name";s:24:"preferred_admin_langcode";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"name";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:192;s:13:"\0*\0definition";a:3:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:5:"class";s:25:"\\Drupal\\user\\UserNameItem";}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Name";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:22:"The name of this user.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"required";b:1;s:11:"constraints";a:2:{s:8:"UserName";a:0:{}s:14:"UserNameUnique";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"name";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"pass";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:8:"password";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:231;s:13:"\0*\0definition";a:2:{s:4:"type";s:19:"field_item:password";s:8:"settings";a:3:{s:10:"max_length";i:255;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Password";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The password of this user (hashed).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"constraints";a:1:{s:18:"ProtectedUserField";N;}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"pass";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"mail";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:5:"email";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:7:"varchar";s:6:"length";i:254;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:267;s:13:"\0*\0definition";a:2:{s:4:"type";s:16:"field_item:email";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:9:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The email of this user.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:11:"constraints";a:3:{s:14:"UserMailUnique";N;s:16:"UserMailRequired";N;s:18:"ProtectedUserField";N;}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"mail";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:8:"timezone";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:6:"string";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:6:"binary";b:0;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:304;s:13:"\0*\0definition";a:4:{s:4:"type";s:17:"field_item:string";s:8:"settings";a:3:{s:10:"max_length";i:32;s:8:"is_ascii";b:0;s:14:"case_sensitive";b:0;}s:11:"constraints";a:1:{s:11:"ComplexData";a:1:{s:5:"value";a:1:{s:13:"AllowedValues";a:1:{s:8:"callback";s:44:"Drupal\\user\\Entity\\User::getAllowedTimezones";}}}}s:5:"class";s:24:"Drupal\\user\\TimeZoneItem";}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Timezone";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"The timezone of this user.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:8:"timezone";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"status";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:344;s:13:"\0*\0definition";a:3:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}s:5:"class";s:22:"Drupal\\user\\StatusItem";}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"User status";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"Whether the user is active or blocked.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:0;}}s:8:"provider";s:4:"user";s:10:"field_name";s:6:"status";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"created";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"created";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:386;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:created";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Created";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"The time that the user was created.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:7:"created";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:7:"changed";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"changed";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:415;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:changed";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Changed";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"The time that the user was last edited.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:8:"provider";s:4:"user";s:10:"field_name";s:7:"changed";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:6:"access";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:9:"timestamp";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:445;s:13:"\0*\0definition";a:2:{s:4:"type";s:20:"field_item:timestamp";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Last access";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:46:"The time that the user last accessed the site.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:8:"provider";s:4:"user";s:10:"field_name";s:6:"access";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:5:"login";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:9:"timestamp";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:1:{s:4:"type";s:3:"int";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:477;s:13:"\0*\0definition";a:2:{s:4:"type";s:20:"field_item:timestamp";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Last login";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"The time that the user last logged in.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";i:0;}}s:8:"provider";s:4:"user";s:10:"field_name";s:5:"login";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:4:"init";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:5:"email";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:7:"varchar";s:6:"length";i:254;}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:509;s:13:"\0*\0definition";a:2:{s:4:"type";s:16:"field_item:email";s:8:"settings";a:0:{}}}s:13:"\0*\0definition";a:8:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Initial email";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"The email address used for initial account creation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";s:0:"";}}s:8:"provider";s:4:"user";s:10:"field_name";s:4:"init";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:5:"roles";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:16:"entity_reference";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:9:"target_id";a:3:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;}}s:7:"indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:11:"unique keys";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:542;s:13:"\0*\0definition";a:2:{s:4:"type";s:27:"field_item:entity_reference";s:8:"settings";a:3:{s:11:"target_type";s:9:"user_role";s:7:"handler";s:7:"default";s:16:"handler_settings";a:0:{}}}}s:13:"\0*\0definition";a:7:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Roles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"cardinality";i:-1;s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:23:"The roles the user has.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:8:"provider";s:4:"user";s:10:"field_name";s:5:"roles";s:11:"entity_type";s:4:"user";s:6:"bundle";N;}}s:16:"default_langcode";O:37:"Drupal\\Core\\Field\\BaseFieldDefinition":5:{s:7:"\0*\0type";s:7:"boolean";s:9:"\0*\0schema";a:4:{s:7:"columns";a:1:{s:5:"value";a:2:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";}}s:11:"unique keys";a:0:{}s:7:"indexes";a:0:{}s:12:"foreign keys";a:0:{}}s:10:"\0*\0indexes";a:0:{}s:17:"\0*\0itemDefinition";O:51:"Drupal\\Core\\Field\\TypedData\\FieldItemDataDefinition":2:{s:18:"\0*\0fieldDefinition";r:578;s:13:"\0*\0definition";a:2:{s:4:"type";s:18:"field_item:boolean";s:8:"settings";a:2:{s:8:"on_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:2:"On";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:9:"off_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:3:"Off";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}}}}s:13:"\0*\0definition";a:10:{s:5:"label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Default translation";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:11:"description";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"A flag indicating whether this is the default translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:12:"translatable";b:1;s:12:"revisionable";b:1;s:13:"default_value";a:1:{i:0;a:1:{s:5:"value";b:1;}}s:8:"provider";s:4:"user";s:10:"field_name";s:16:"default_langcode";s:11:"entity_type";s:4:"user";s:6:"bundle";N;s:13:"initial_value";N;}}s:12:"user_picture";O:38:"Drupal\\field\\Entity\\FieldStorageConfig":30:{s:5:"\0*\0id";s:17:"user.user_picture";s:13:"\0*\0field_name";s:12:"user_picture";s:14:"\0*\0entity_type";s:4:"user";s:7:"\0*\0type";s:5:"image";s:9:"\0*\0module";s:5:"image";s:11:"\0*\0settings";a:5:{s:10:"uri_scheme";s:6:"public";s:13:"default_image";a:5:{s:4:"uuid";N;s:3:"alt";s:0:"";s:5:"title";s:0:"";s:5:"width";N;s:6:"height";N;}s:11:"target_type";s:4:"file";s:13:"display_field";b:0;s:15:"display_default";b:0;}s:14:"\0*\0cardinality";i:1;s:15:"\0*\0translatable";b:1;s:9:"\0*\0locked";b:0;s:25:"\0*\0persist_with_no_fields";b:0;s:14:"custom_storage";b:0;s:10:"\0*\0indexes";a:1:{s:9:"target_id";a:1:{i:0;s:9:"target_id";}}s:10:"\0*\0deleted";b:0;s:13:"\0*\0originalId";s:17:"user.user_picture";s:9:"\0*\0status";b:1;s:7:"\0*\0uuid";s:36:"0a803be1-f0bb-44e2-b180-69f64fa6600d";s:11:"\0*\0langcode";s:2:"en";s:23:"\0*\0third_party_settings";a:0:{}s:8:"\0*\0_core";a:1:{s:19:"default_config_hash";s:43:"6k-VBFilDLuzgSOT-77CFgHFlcd5D-kqRixtH89EShU";}s:14:"\0*\0trustedData";b:1;s:15:"\0*\0entityTypeId";s:20:"field_storage_config";s:15:"\0*\0enforceIsNew";b:1;s:12:"\0*\0typedData";N;s:16:"\0*\0cacheContexts";a:0:{}s:12:"\0*\0cacheTags";a:0:{}s:14:"\0*\0cacheMaxAge";i:-1;s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:15:"\0*\0dependencies";a:1:{s:6:"module";a:3:{i:0;s:4:"file";i:1;s:5:"image";i:2;s:4:"user";}}s:12:"\0*\0isSyncing";b:0;}}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','user_role.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";s:4:"role";s:15:"\0*\0static_cache";b:1;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:5:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"weight";i:3;s:8:"is_admin";i:4;s:11:"permissions";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:6:"weight";s:6:"weight";s:5:"label";s:5:"label";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:9:"user_role";s:16:"\0*\0originalClass";s:23:"Drupal\\user\\Entity\\Role";s:11:"\0*\0handlers";a:4:{s:7:"storage";s:23:"Drupal\\user\\RoleStorage";s:6:"access";s:36:"Drupal\\user\\RoleAccessControlHandler";s:12:"list_builder";s:27:"Drupal\\user\\RoleListBuilder";s:4:"form";a:2:{s:7:"default";s:20:"Drupal\\user\\RoleForm";s:6:"delete";s:35:"Drupal\\Core\\Entity\\EntityDeleteForm";}}s:19:"\0*\0admin_permission";s:22:"administer permissions";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:4:{s:11:"delete-form";s:45:"/admin/people/roles/manage/{user_role}/delete";s:9:"edit-form";s:38:"/admin/people/roles/manage/{user_role}";s:21:"edit-permissions-form";s:37:"/admin/people/permissions/{user_role}";s:10:"collection";s:19:"/admin/people/roles";}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Role";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Roles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"role";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"roles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:11:"@count role";s:6:"plural";s:12:"@count roles";s:7:"context";N;}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:21:"config:user_role_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:23:"Drupal\\user\\Entity\\Role";s:11:"\0*\0provider";s:4:"user";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.definitions.installed','view.entity_type','O:42:"Drupal\\Core\\Config\\Entity\\ConfigEntityType":44:{s:16:"\0*\0config_prefix";N;s:15:"\0*\0static_cache";b:0;s:14:"\0*\0lookup_keys";a:1:{i:0;s:4:"uuid";}s:16:"\0*\0config_export";a:8:{i:0;s:2:"id";i:1;s:5:"label";i:2;s:6:"module";i:3;s:11:"description";i:4;s:3:"tag";i:5;s:10:"base_table";i:6;s:10:"base_field";i:7;s:7:"display";}s:21:"\0*\0mergedConfigExport";a:0:{}s:15:"\0*\0render_cache";b:1;s:19:"\0*\0persistent_cache";b:1;s:14:"\0*\0entity_keys";a:9:{s:2:"id";s:2:"id";s:5:"label";s:5:"label";s:6:"status";s:6:"status";s:8:"revision";s:0:"";s:6:"bundle";s:0:"";s:8:"langcode";s:8:"langcode";s:16:"default_langcode";s:16:"default_langcode";s:29:"revision_translation_affected";s:29:"revision_translation_affected";s:4:"uuid";s:4:"uuid";}s:5:"\0*\0id";s:4:"view";s:16:"\0*\0originalClass";s:24:"Drupal\\views\\Entity\\View";s:11:"\0*\0handlers";a:2:{s:6:"access";s:45:"Drupal\\Core\\Entity\\EntityAccessControlHandler";s:7:"storage";s:45:"Drupal\\Core\\Config\\Entity\\ConfigEntityStorage";}s:19:"\0*\0admin_permission";s:16:"administer views";s:25:"\0*\0permission_granularity";s:11:"entity_type";s:8:"\0*\0links";a:0:{}s:17:"\0*\0label_callback";N;s:21:"\0*\0bundle_entity_type";N;s:12:"\0*\0bundle_of";N;s:15:"\0*\0bundle_label";N;s:13:"\0*\0base_table";N;s:22:"\0*\0revision_data_table";N;s:17:"\0*\0revision_table";N;s:13:"\0*\0data_table";N;s:11:"\0*\0internal";b:0;s:15:"\0*\0translatable";b:0;s:19:"\0*\0show_revision_ui";b:0;s:8:"\0*\0label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"View";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:16:"View entity type";}}s:19:"\0*\0label_collection";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Views";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:16:"View entity type";}}s:17:"\0*\0label_singular";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"view";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:16:"View entity type";}}s:15:"\0*\0label_plural";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"views";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:16:"View entity type";}}s:14:"\0*\0label_count";a:3:{s:8:"singular";s:11:"@count view";s:6:"plural";s:12:"@count views";s:7:"context";s:16:"View entity type";}s:15:"\0*\0uri_callback";N;s:8:"\0*\0group";s:13:"configuration";s:14:"\0*\0group_label";O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:1:{s:7:"context";s:17:"Entity type group";}}s:22:"\0*\0field_ui_base_route";N;s:26:"\0*\0common_reference_target";b:0;s:22:"\0*\0list_cache_contexts";a:0:{}s:18:"\0*\0list_cache_tags";a:1:{i:0;s:16:"config:view_list";}s:14:"\0*\0constraints";a:0:{}s:13:"\0*\0additional";a:0:{}s:8:"\0*\0class";s:24:"Drupal\\views\\Entity\\View";s:11:"\0*\0provider";s:5:"views";s:14:"\0*\0_serviceIds";a:0:{}s:18:"\0*\0_entityStorages";a:0:{}s:20:"\0*\0stringTranslation";N;}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','block_content.entity_schema_data','a:4:{s:13:"block_content";a:2:{s:11:"primary key";a:1:{i:0;s:2:"id";}s:11:"unique keys";a:1:{s:26:"block_content__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:22:"block_content_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:1:{s:17:"block_content__id";a:1:{i:0;s:2:"id";}}}s:24:"block_content_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:2:"id";i:1;s:8:"langcode";}s:7:"indexes";a:3:{s:45:"block_content__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:26:"block_content__revision_id";a:1:{i:0;s:11:"revision_id";}s:26:"block_content__status_type";a:3:{i:0;s:6:"status";i:1;s:4:"type";i:2;s:2:"id";}}}s:28:"block_content_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:11:"revision_id";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:45:"block_content__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.body','a:2:{s:19:"block_content__body";a:4:{s:11:"description";s:42:"Data storage for block_content field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}s:28:"block_content_revision__body";a:4:{s:11:"description";s:54:"Revision archive storage for block_content field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','block_content.field_schema_data.changed','a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.default_langcode','a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.id','a:4:{s:13:"block_content";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.info','a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:4:"info";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:4:"info";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.langcode','a:4:{s:13:"block_content";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','block_content.field_schema_data.reusable','a:1:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:8:"reusable";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.revision_created','a:1:{s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.revision_default','a:1:{s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.revision_id','a:4:{s:13:"block_content";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.revision_log','a:1:{s:22:"block_content_revision";a:1:{s:6:"fields";a:1:{s:12:"revision_log";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.revision_translation_affected','a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','block_content.field_schema_data.revision_user','a:1:{s:22:"block_content_revision";a:2:{s:6:"fields";a:1:{s:13:"revision_user";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:45:"block_content_field__revision_user__target_id";a:1:{i:0;s:13:"revision_user";}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.status','a:2:{s:24:"block_content_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:28:"block_content_field_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.type','a:2:{s:13:"block_content";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:36:"block_content_field__type__target_id";a:1:{i:0;s:4:"type";}}}s:24:"block_content_field_data";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:36:"block_content_field__type__target_id";a:1:{i:0;s:4:"type";}}}}'),('entity.storage_schema.sql','block_content.field_schema_data.uuid','a:1:{s:13:"block_content";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:32:"block_content_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),('entity.storage_schema.sql','comment.entity_schema_data','a:2:{s:7:"comment";a:1:{s:11:"primary key";a:1:{i:0;s:3:"cid";}}s:18:"comment_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:3:"cid";i:1;s:8:"langcode";}s:7:"indexes";a:5:{s:39:"comment__id__default_langcode__langcode";a:3:{i:0;s:3:"cid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:28:"comment__status_comment_type";a:3:{i:0;s:6:"status";i:1;s:12:"comment_type";i:2;s:3:"cid";}s:19:"comment__status_pid";a:2:{i:0;s:3:"pid";i:1;s:6:"status";}s:16:"comment__num_new";a:7:{i:0;s:9:"entity_id";i:1;s:11:"entity_type";i:2;s:12:"comment_type";i:3;s:6:"status";i:4;s:7:"created";i:5;s:3:"cid";i:6;s:6:"thread";}s:24:"comment__entity_langcode";a:4:{i:0;s:9:"entity_id";i:1;s:11:"entity_type";i:2;s:12:"comment_type";i:3;s:16:"default_langcode";}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','comment.field_schema_data.changed','a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','comment.field_schema_data.cid','a:2:{s:7:"comment";a:1:{s:6:"fields";a:1:{s:3:"cid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:3:"cid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','comment.field_schema_data.comment_body','a:1:{s:21:"comment__comment_body";a:4:{s:11:"description";s:44:"Data storage for comment field comment_body.";s:6:"fields";a:8:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:114:"The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:18:"comment_body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:19:"comment_body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:19:"comment_body_format";a:1:{i:0;s:19:"comment_body_format";}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','comment.field_schema_data.comment_type','a:2:{s:7:"comment";a:2:{s:6:"fields";a:1:{s:12:"comment_type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:38:"comment_field__comment_type__target_id";a:1:{i:0;s:12:"comment_type";}}}s:18:"comment_field_data";a:2:{s:6:"fields";a:1:{s:12:"comment_type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:38:"comment_field__comment_type__target_id";a:1:{i:0;s:12:"comment_type";}}}}'),('entity.storage_schema.sql','comment.field_schema_data.created','a:1:{s:18:"comment_field_data";a:2:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:22:"comment_field__created";a:1:{i:0;s:7:"created";}}}}'),('entity.storage_schema.sql','comment.field_schema_data.default_langcode','a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','comment.field_schema_data.entity_id','a:1:{s:18:"comment_field_data";a:2:{s:6:"fields";a:1:{s:9:"entity_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:0:{}}}'),('entity.storage_schema.sql','comment.field_schema_data.entity_type','a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:11:"entity_type";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','comment.field_schema_data.field_name','a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:10:"field_name";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','comment.field_schema_data.homepage','a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:8:"homepage";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','comment.field_schema_data.hostname','a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:8:"hostname";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','comment.field_schema_data.langcode','a:2:{s:7:"comment";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','comment.field_schema_data.mail','a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:4:"mail";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:254;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','comment.field_schema_data.name','a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','comment.field_schema_data.pid','a:1:{s:18:"comment_field_data";a:2:{s:6:"fields";a:1:{s:3:"pid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:0:{}}}'),('entity.storage_schema.sql','comment.field_schema_data.status','a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','comment.field_schema_data.subject','a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:7:"subject";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:64;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','comment.field_schema_data.thread','a:1:{s:18:"comment_field_data";a:1:{s:6:"fields";a:1:{s:6:"thread";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','comment.field_schema_data.uid','a:1:{s:18:"comment_field_data";a:3:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:29:"comment_field__uid__target_id";a:1:{i:0;s:3:"uid";}}s:12:"foreign keys";a:1:{s:18:"comment_field__uid";a:2:{s:5:"table";s:5:"users";s:7:"columns";a:1:{s:3:"uid";s:3:"uid";}}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','comment.field_schema_data.uuid','a:1:{s:7:"comment";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:26:"comment_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),('entity.storage_schema.sql','file.entity_schema_data','a:1:{s:12:"file_managed";a:1:{s:11:"primary key";a:1:{i:0;s:3:"fid";}}}'),('entity.storage_schema.sql','file.field_schema_data.changed','a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"file_field__changed";a:1:{i:0;s:7:"changed";}}}}'),('entity.storage_schema.sql','file.field_schema_data.created','a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','file.field_schema_data.fid','a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:3:"fid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','file.field_schema_data.filemime','a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:8:"filemime";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','file.field_schema_data.filename','a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:8:"filename";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','file.field_schema_data.filesize','a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:8:"filesize";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','file.field_schema_data.langcode','a:1:{s:12:"file_managed";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','file.field_schema_data.status','a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:18:"file_field__status";a:1:{i:0;s:6:"status";}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','file.field_schema_data.uid','a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:26:"file_field__uid__target_id";a:1:{i:0;s:3:"uid";}}}}'),('entity.storage_schema.sql','file.field_schema_data.uri','a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:3:"uri";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:15:"file_field__uri";a:1:{i:0;s:3:"uri";}}}}'),('entity.storage_schema.sql','file.field_schema_data.uuid','a:1:{s:12:"file_managed";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:23:"file_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),('entity.storage_schema.sql','menu_link_content.entity_schema_data','a:4:{s:17:"menu_link_content";a:2:{s:11:"primary key";a:1:{i:0;s:2:"id";}s:11:"unique keys";a:1:{s:30:"menu_link_content__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:26:"menu_link_content_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:1:{s:21:"menu_link_content__id";a:1:{i:0;s:2:"id";}}}s:22:"menu_link_content_data";a:2:{s:11:"primary key";a:2:{i:0;s:2:"id";i:1;s:8:"langcode";}s:7:"indexes";a:3:{s:49:"menu_link_content__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:30:"menu_link_content__revision_id";a:1:{i:0;s:11:"revision_id";}s:33:"menu_link_content__enabled_bundle";a:3:{i:0;s:7:"enabled";i:1;s:6:"bundle";i:2;s:2:"id";}}}s:32:"menu_link_content_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:11:"revision_id";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:49:"menu_link_content__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.bundle','a:2:{s:17:"menu_link_content";a:1:{s:6:"fields";a:1:{s:6:"bundle";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:1;}}}s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:6:"bundle";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:1;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','menu_link_content.field_schema_data.changed','a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.default_langcode','a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.description','a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:11:"description";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:11:"description";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.enabled','a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:7:"enabled";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:7:"enabled";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.expanded','a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:8:"expanded";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.external','a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:8:"external";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:8:"external";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','menu_link_content.field_schema_data.id','a:4:{s:17:"menu_link_content";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.langcode','a:4:{s:17:"menu_link_content";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.link','a:2:{s:22:"menu_link_content_data";a:2:{s:6:"fields";a:3:{s:9:"link__uri";a:4:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;s:8:"not null";b:0;}s:11:"link__title";a:4:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;}s:13:"link__options";a:5:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:34:"menu_link_content_field__link__uri";a:1:{i:0;a:2:{i:0;s:9:"link__uri";i:1;i:30;}}}}s:32:"menu_link_content_field_revision";a:2:{s:6:"fields";a:3:{s:9:"link__uri";a:4:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;s:8:"not null";b:0;}s:11:"link__title";a:4:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;}s:13:"link__options";a:5:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:34:"menu_link_content_field__link__uri";a:1:{i:0;a:2:{i:0;s:9:"link__uri";i:1;i:30;}}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','menu_link_content.field_schema_data.menu_name','a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:9:"menu_name";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.parent','a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:6:"parent";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.rediscover','a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:10:"rediscover";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.revision_created','a:1:{s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.revision_default','a:1:{s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.revision_id','a:4:{s:17:"menu_link_content";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.revision_log_message','a:1:{s:26:"menu_link_content_revision";a:1:{s:6:"fields";a:1:{s:20:"revision_log_message";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','menu_link_content.field_schema_data.revision_translation_affected','a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.revision_user','a:1:{s:26:"menu_link_content_revision";a:2:{s:6:"fields";a:1:{s:13:"revision_user";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:29:"menu_link_content__ef029a1897";a:1:{i:0;s:13:"revision_user";}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.title','a:2:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:32:"menu_link_content_field_revision";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.uuid','a:1:{s:17:"menu_link_content";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:36:"menu_link_content_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),('entity.storage_schema.sql','menu_link_content.field_schema_data.weight','a:1:{s:22:"menu_link_content_data";a:1:{s:6:"fields";a:1:{s:6:"weight";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','node.entity_schema_data','a:4:{s:4:"node";a:2:{s:11:"primary key";a:1:{i:0;s:3:"nid";}s:11:"unique keys";a:1:{s:9:"node__vid";a:1:{i:0;s:3:"vid";}}}s:13:"node_revision";a:2:{s:11:"primary key";a:1:{i:0;s:3:"vid";}s:7:"indexes";a:1:{s:9:"node__nid";a:1:{i:0;s:3:"nid";}}}s:15:"node_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:3:"nid";i:1;s:8:"langcode";}s:7:"indexes";a:5:{s:36:"node__id__default_langcode__langcode";a:3:{i:0;s:3:"nid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:9:"node__vid";a:1:{i:0;s:3:"vid";}s:17:"node__status_type";a:3:{i:0;s:6:"status";i:1;s:4:"type";i:2;s:3:"nid";}s:15:"node__frontpage";a:4:{i:0;s:7:"promote";i:1;s:6:"status";i:2;s:6:"sticky";i:3;s:7:"created";}s:16:"node__title_type";a:2:{i:0;s:5:"title";i:1;a:2:{i:0;s:4:"type";i:1;i:4;}}}}s:19:"node_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:3:"vid";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:36:"node__id__default_langcode__langcode";a:3:{i:0;s:3:"nid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','node.field_schema_data.body','a:2:{s:10:"node__body";a:4:{s:11:"description";s:33:"Data storage for node field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}s:19:"node_revision__body";a:4:{s:11:"description";s:45:"Revision archive storage for node field body.";s:6:"fields";a:9:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:10:"body_value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:1;}s:12:"body_summary";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:11:"body_format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:11:"body_format";a:1:{i:0;s:11:"body_format";}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','node.field_schema_data.changed','a:2:{s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"node_field__changed";a:1:{i:0;s:7:"changed";}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','node.field_schema_data.comment','a:2:{s:13:"node__comment";a:4:{s:11:"description";s:36:"Data storage for node field comment.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:14:"comment_status";a:4:{s:11:"description";s:99:"Whether comments are allowed on this entity: 0 = no, 1 = closed (read only), 2 = open (read/write).";s:4:"type";s:3:"int";s:7:"default";i:0;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:2:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}}}s:22:"node_revision__comment";a:4:{s:11:"description";s:48:"Revision archive storage for node field comment.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:14:"comment_status";a:4:{s:11:"description";s:99:"Whether comments are allowed on this entity: 0 = no, 1 = closed (read only), 2 = open (read/write).";s:4:"type";s:3:"int";s:7:"default";i:0;s:8:"not null";b:1;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:2:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','node.field_schema_data.created','a:2:{s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"node_field__created";a:1:{i:0;s:7:"created";}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','node.field_schema_data.default_langcode','a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','node.field_schema_data.field_image','a:2:{s:17:"node__field_image";a:5:{s:11:"description";s:40:"Data storage for node field field_image.";s:6:"fields";a:11:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:21:"field_image_target_id";a:4:{s:11:"description";s:26:"The ID of the file entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:15:"field_image_alt";a:4:{s:11:"description";s:56:"Alternative image text, for the image''s ''alt'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:512;s:8:"not null";b:0;}s:17:"field_image_title";a:4:{s:11:"description";s:52:"Image title text, for the image''s ''title'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:1024;s:8:"not null";b:0;}s:17:"field_image_width";a:4:{s:11:"description";s:33:"The width of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}s:18:"field_image_height";a:4:{s:11:"description";s:34:"The height of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:21:"field_image_target_id";a:1:{i:0;s:21:"field_image_target_id";}}s:12:"foreign keys";a:1:{s:21:"field_image_target_id";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:21:"field_image_target_id";s:3:"fid";}}}}s:26:"node_revision__field_image";a:5:{s:11:"description";s:52:"Revision archive storage for node field field_image.";s:6:"fields";a:11:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:21:"field_image_target_id";a:4:{s:11:"description";s:26:"The ID of the file entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:15:"field_image_alt";a:4:{s:11:"description";s:56:"Alternative image text, for the image''s ''alt'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:512;s:8:"not null";b:0;}s:17:"field_image_title";a:4:{s:11:"description";s:52:"Image title text, for the image''s ''title'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:1024;s:8:"not null";b:0;}s:17:"field_image_width";a:4:{s:11:"description";s:33:"The width of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}s:18:"field_image_height";a:4:{s:11:"description";s:34:"The height of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:21:"field_image_target_id";a:1:{i:0;s:21:"field_image_target_id";}}s:12:"foreign keys";a:1:{s:21:"field_image_target_id";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:21:"field_image_target_id";s:3:"fid";}}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','node.field_schema_data.field_tags','a:2:{s:16:"node__field_tags";a:4:{s:11:"description";s:39:"Data storage for node field field_tags.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:20:"field_tags_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:20:"field_tags_target_id";a:1:{i:0;s:20:"field_tags_target_id";}}}s:25:"node_revision__field_tags";a:4:{s:11:"description";s:51:"Revision archive storage for node field field_tags.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:20:"field_tags_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:20:"field_tags_target_id";a:1:{i:0;s:20:"field_tags_target_id";}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','node.field_schema_data.langcode','a:4:{s:4:"node";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:13:"node_revision";a:2:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:20:"node_field__langcode";a:1:{i:0;s:8:"langcode";}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','node.field_schema_data.nid','a:4:{s:4:"node";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:3:"nid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','node.field_schema_data.promote','a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:7:"promote";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:7:"promote";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','node.field_schema_data.revision_default','a:1:{s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','node.field_schema_data.revision_log','a:1:{s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:12:"revision_log";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','node.field_schema_data.revision_timestamp','a:1:{s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:18:"revision_timestamp";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','node.field_schema_data.revision_translation_affected','a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','node.field_schema_data.revision_uid','a:1:{s:13:"node_revision";a:3:{s:6:"fields";a:1:{s:12:"revision_uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:35:"node_field__revision_uid__target_id";a:1:{i:0;s:12:"revision_uid";}}s:12:"foreign keys";a:1:{s:24:"node_field__revision_uid";a:2:{s:5:"table";s:5:"users";s:7:"columns";a:1:{s:12:"revision_uid";s:3:"uid";}}}}}'),('entity.storage_schema.sql','node.field_schema_data.status','a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','node.field_schema_data.sticky','a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:6:"sticky";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:6:"sticky";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','node.field_schema_data.title','a:2:{s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','node.field_schema_data.type','a:2:{s:4:"node";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:27:"node_field__type__target_id";a:1:{i:0;s:4:"type";}}}s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:4:"type";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:27:"node_field__type__target_id";a:1:{i:0;s:4:"type";}}}}'),('entity.storage_schema.sql','node.field_schema_data.uid','a:2:{s:15:"node_field_data";a:2:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:26:"node_field__uid__target_id";a:1:{i:0;s:3:"uid";}}}s:19:"node_field_revision";a:2:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:26:"node_field__uid__target_id";a:1:{i:0;s:3:"uid";}}}}'),('entity.storage_schema.sql','node.field_schema_data.uuid','a:1:{s:4:"node";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:23:"node_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),('entity.storage_schema.sql','node.field_schema_data.vid','a:4:{s:4:"node";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:15:"node_field_data";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:13:"node_revision";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"node_field_revision";a:1:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','path_alias.entity_schema_data','a:2:{s:10:"path_alias";a:3:{s:11:"primary key";a:1:{i:0;s:2:"id";}s:7:"indexes";a:3:{s:18:"path_alias__status";a:2:{i:0;s:6:"status";i:1;s:2:"id";}s:36:"path_alias__alias_langcode_id_status";a:4:{i:0;s:5:"alias";i:1;s:8:"langcode";i:2;s:2:"id";i:3;s:6:"status";}s:35:"path_alias__path_langcode_id_status";a:4:{i:0;s:4:"path";i:1;s:8:"langcode";i:2;s:2:"id";i:3;s:6:"status";}}s:11:"unique keys";a:1:{s:23:"path_alias__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:19:"path_alias_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:1:{s:14:"path_alias__id";a:1:{i:0;s:2:"id";}}}}'),('entity.storage_schema.sql','path_alias.field_schema_data.alias','a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:5:"alias";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:5:"alias";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','path_alias.field_schema_data.id','a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','path_alias.field_schema_data.langcode','a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','path_alias.field_schema_data.path','a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:4:"path";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:4:"path";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','path_alias.field_schema_data.revision_default','a:1:{s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','path_alias.field_schema_data.revision_id','a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','path_alias.field_schema_data.status','a:2:{s:10:"path_alias";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:19:"path_alias_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','path_alias.field_schema_data.uuid','a:1:{s:10:"path_alias";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:29:"path_alias_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),('entity.storage_schema.sql','shortcut.entity_schema_data','a:2:{s:8:"shortcut";a:1:{s:11:"primary key";a:1:{i:0;s:2:"id";}}s:19:"shortcut_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:2:"id";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:40:"shortcut__id__default_langcode__langcode";a:3:{i:0;s:2:"id";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}}'),('entity.storage_schema.sql','shortcut.field_schema_data.default_langcode','a:1:{s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','shortcut.field_schema_data.id','a:2:{s:8:"shortcut";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:2:"id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','shortcut.field_schema_data.langcode','a:2:{s:8:"shortcut";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','shortcut.field_schema_data.link','a:1:{s:19:"shortcut_field_data";a:2:{s:6:"fields";a:3:{s:9:"link__uri";a:4:{s:11:"description";s:20:"The URI of the link.";s:4:"type";s:7:"varchar";s:6:"length";i:2048;s:8:"not null";b:0;}s:11:"link__title";a:4:{s:11:"description";s:14:"The link text.";s:4:"type";s:7:"varchar";s:6:"length";i:255;s:8:"not null";b:0;}s:13:"link__options";a:5:{s:11:"description";s:41:"Serialized array of options for the link.";s:4:"type";s:4:"blob";s:4:"size";s:3:"big";s:9:"serialize";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:25:"shortcut_field__link__uri";a:1:{i:0;a:2:{i:0;s:9:"link__uri";i:1;i:30;}}}}}'),('entity.storage_schema.sql','shortcut.field_schema_data.shortcut_set','a:2:{s:8:"shortcut";a:2:{s:6:"fields";a:1:{s:12:"shortcut_set";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:39:"shortcut_field__shortcut_set__target_id";a:1:{i:0;s:12:"shortcut_set";}}}s:19:"shortcut_field_data";a:2:{s:6:"fields";a:1:{s:12:"shortcut_set";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:39:"shortcut_field__shortcut_set__target_id";a:1:{i:0;s:12:"shortcut_set";}}}}'),('entity.storage_schema.sql','shortcut.field_schema_data.title','a:1:{s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:5:"title";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','shortcut.field_schema_data.uuid','a:1:{s:8:"shortcut";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:27:"shortcut_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','shortcut.field_schema_data.weight','a:1:{s:19:"shortcut_field_data";a:1:{s:6:"fields";a:1:{s:6:"weight";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','taxonomy_term.entity_schema_data','a:5:{s:18:"taxonomy_term_data";a:2:{s:11:"primary key";a:1:{i:0;s:3:"tid";}s:11:"unique keys";a:1:{s:26:"taxonomy_term__revision_id";a:1:{i:0;s:11:"revision_id";}}}s:22:"taxonomy_term_revision";a:2:{s:11:"primary key";a:1:{i:0;s:11:"revision_id";}s:7:"indexes";a:1:{s:18:"taxonomy_term__tid";a:1:{i:0;s:3:"tid";}}}s:24:"taxonomy_term_field_data";a:2:{s:11:"primary key";a:2:{i:0;s:3:"tid";i:1;s:8:"langcode";}s:7:"indexes";a:5:{s:45:"taxonomy_term__id__default_langcode__langcode";a:3:{i:0;s:3:"tid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}s:26:"taxonomy_term__revision_id";a:1:{i:0;s:11:"revision_id";}s:25:"taxonomy_term__status_vid";a:3:{i:0;s:6:"status";i:1;s:3:"vid";i:2;s:3:"tid";}s:19:"taxonomy_term__tree";a:3:{i:0;s:3:"vid";i:1;s:6:"weight";i:2;s:4:"name";}s:23:"taxonomy_term__vid_name";a:2:{i:0;s:3:"vid";i:1;s:4:"name";}}}s:28:"taxonomy_term_field_revision";a:2:{s:11:"primary key";a:2:{i:0;s:11:"revision_id";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:45:"taxonomy_term__id__default_langcode__langcode";a:3:{i:0;s:3:"tid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}}s:14:"taxonomy_index";a:2:{s:11:"primary key";a:2:{i:0;s:3:"nid";i:1;s:3:"tid";}s:7:"indexes";a:1:{s:9:"term_node";a:4:{i:0;s:3:"tid";i:1;s:6:"status";i:2;s:6:"sticky";i:3;s:7:"created";}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.changed','a:2:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.default_langcode','a:2:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','taxonomy_term.field_schema_data.description','a:2:{s:24:"taxonomy_term_field_data";a:2:{s:6:"fields";a:2:{s:18:"description__value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:19:"description__format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:7:"indexes";a:0:{}}s:28:"taxonomy_term_field_revision";a:2:{s:6:"fields";a:2:{s:18:"description__value";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}s:19:"description__format";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:40:"taxonomy_term_field__description__format";a:1:{i:0;s:19:"description__format";}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.langcode','a:4:{s:18:"taxonomy_term_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.name','a:2:{s:24:"taxonomy_term_field_data";a:2:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:25:"taxonomy_term_field__name";a:1:{i:0;s:4:"name";}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.parent','a:2:{s:21:"taxonomy_term__parent";a:4:{s:11:"description";s:44:"Data storage for taxonomy_term field parent.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:16:"parent_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:16:"parent_target_id";a:1:{i:0;s:16:"parent_target_id";}s:22:"bundle_delta_target_id";a:3:{i:0;s:6:"bundle";i:1;s:5:"delta";i:2;s:16:"parent_target_id";}}}s:30:"taxonomy_term_revision__parent";a:4:{s:11:"description";s:56:"Revision archive storage for taxonomy_term field parent.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:47:"The entity revision id this data is attached to";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:16:"parent_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}}s:11:"primary key";a:5:{i:0;s:9:"entity_id";i:1;s:11:"revision_id";i:2;s:7:"deleted";i:3;s:5:"delta";i:4;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:16:"parent_target_id";a:1:{i:0;s:16:"parent_target_id";}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','taxonomy_term.field_schema_data.revision_created','a:1:{s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.revision_default','a:1:{s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:16:"revision_default";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.revision_id','a:4:{s:18:"taxonomy_term_data";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:0;}}}s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.revision_log_message','a:1:{s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:20:"revision_log_message";a:3:{s:4:"type";s:4:"text";s:4:"size";s:3:"big";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.revision_translation_affected','a:2:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:29:"revision_translation_affected";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.revision_user','a:1:{s:22:"taxonomy_term_revision";a:2:{s:6:"fields";a:1:{s:13:"revision_user";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:45:"taxonomy_term_field__revision_user__target_id";a:1:{i:0;s:13:"revision_user";}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','taxonomy_term.field_schema_data.status','a:2:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.tid','a:4:{s:18:"taxonomy_term_data";a:1:{s:6:"fields";a:1:{s:3:"tid";a:4:{s:4:"type";s:6:"serial";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:3:"tid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:22:"taxonomy_term_revision";a:1:{s:6:"fields";a:1:{s:3:"tid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:28:"taxonomy_term_field_revision";a:1:{s:6:"fields";a:1:{s:3:"tid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.uuid','a:1:{s:18:"taxonomy_term_data";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:32:"taxonomy_term_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.vid','a:2:{s:18:"taxonomy_term_data";a:2:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:35:"taxonomy_term_field__vid__target_id";a:1:{i:0;s:3:"vid";}}}s:24:"taxonomy_term_field_data";a:2:{s:6:"fields";a:1:{s:3:"vid";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;}}s:7:"indexes";a:0:{}}}'),('entity.storage_schema.sql','taxonomy_term.field_schema_data.weight','a:1:{s:24:"taxonomy_term_field_data";a:1:{s:6:"fields";a:1:{s:6:"weight";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:0;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','user.entity_schema_data','a:2:{s:5:"users";a:1:{s:11:"primary key";a:1:{i:0;s:3:"uid";}}s:16:"users_field_data";a:3:{s:11:"primary key";a:2:{i:0;s:3:"uid";i:1;s:8:"langcode";}s:7:"indexes";a:1:{s:36:"user__id__default_langcode__langcode";a:3:{i:0;s:3:"uid";i:1;s:16:"default_langcode";i:2;s:8:"langcode";}}s:11:"unique keys";a:1:{s:10:"user__name";a:2:{i:0;s:4:"name";i:1;s:8:"langcode";}}}}'),('entity.storage_schema.sql','user.field_schema_data.access','a:1:{s:16:"users_field_data";a:2:{s:6:"fields";a:1:{s:6:"access";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:18:"user_field__access";a:1:{i:0;s:6:"access";}}}}'),('entity.storage_schema.sql','user.field_schema_data.changed','a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:7:"changed";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','user.field_schema_data.created','a:1:{s:16:"users_field_data";a:2:{s:6:"fields";a:1:{s:7:"created";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:1;}}s:7:"indexes";a:1:{s:19:"user_field__created";a:1:{i:0;s:7:"created";}}}}'),('entity.storage_schema.sql','user.field_schema_data.default_langcode','a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:16:"default_langcode";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','user.field_schema_data.init','a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:4:"init";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:254;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','user.field_schema_data.langcode','a:2:{s:5:"users";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:8:"langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','user.field_schema_data.login','a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:5:"login";a:2:{s:4:"type";s:3:"int";s:8:"not null";b:0;}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','user.field_schema_data.mail','a:1:{s:16:"users_field_data";a:2:{s:6:"fields";a:1:{s:4:"mail";a:3:{s:4:"type";s:7:"varchar";s:6:"length";i:254;s:8:"not null";b:0;}}s:7:"indexes";a:1:{s:16:"user_field__mail";a:1:{i:0;s:4:"mail";}}}}'),('entity.storage_schema.sql','user.field_schema_data.name','a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:4:"name";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:60;s:6:"binary";b:0;s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','user.field_schema_data.pass','a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:4:"pass";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:255;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','user.field_schema_data.preferred_admin_langcode','a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:24:"preferred_admin_langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','user.field_schema_data.preferred_langcode','a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:18:"preferred_langcode";a:3:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:12;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','user.field_schema_data.roles','a:1:{s:11:"user__roles";a:4:{s:11:"description";s:34:"Data storage for user field roles.";s:6:"fields";a:7:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:114:"The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:15:"roles_target_id";a:4:{s:11:"description";s:28:"The ID of the target entity.";s:4:"type";s:13:"varchar_ascii";s:6:"length";i:255;s:8:"not null";b:1;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:15:"roles_target_id";a:1:{i:0;s:15:"roles_target_id";}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','user.field_schema_data.status','a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:6:"status";a:3:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','user.field_schema_data.timezone','a:1:{s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:8:"timezone";a:4:{s:4:"type";s:7:"varchar";s:6:"length";i:32;s:6:"binary";b:0;s:8:"not null";b:0;}}}}'),('entity.storage_schema.sql','user.field_schema_data.uid','a:2:{s:5:"users";a:1:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}s:16:"users_field_data";a:1:{s:6:"fields";a:1:{s:3:"uid";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:4:"size";s:6:"normal";s:8:"not null";b:1;}}}}'),('entity.storage_schema.sql','user.field_schema_data.user_picture','a:1:{s:18:"user__user_picture";a:5:{s:11:"description";s:41:"Data storage for user field user_picture.";s:6:"fields";a:11:{s:6:"bundle";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:88:"The field instance bundle to which this row belongs, used when deleting a field instance";}s:7:"deleted";a:5:{s:4:"type";s:3:"int";s:4:"size";s:4:"tiny";s:8:"not null";b:1;s:7:"default";i:0;s:11:"description";s:60:"A boolean indicating whether this data item has been deleted";}s:9:"entity_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:38:"The entity id this data is attached to";}s:11:"revision_id";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:114:"The entity revision id this data is attached to, which for an unversioned entity type is the same as the entity id";}s:8:"langcode";a:5:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:32;s:8:"not null";b:1;s:7:"default";s:0:"";s:11:"description";s:37:"The language code for this data item.";}s:5:"delta";a:4:{s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;s:11:"description";s:67:"The sequence number for this data item, used for multi-value fields";}s:22:"user_picture_target_id";a:4:{s:11:"description";s:26:"The ID of the file entity.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:1;}s:16:"user_picture_alt";a:4:{s:11:"description";s:56:"Alternative image text, for the image''s ''alt'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:512;s:8:"not null";b:0;}s:18:"user_picture_title";a:4:{s:11:"description";s:52:"Image title text, for the image''s ''title'' attribute.";s:4:"type";s:7:"varchar";s:6:"length";i:1024;s:8:"not null";b:0;}s:18:"user_picture_width";a:4:{s:11:"description";s:33:"The width of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}s:19:"user_picture_height";a:4:{s:11:"description";s:34:"The height of the image in pixels.";s:4:"type";s:3:"int";s:8:"unsigned";b:1;s:8:"not null";b:0;}}s:11:"primary key";a:4:{i:0;s:9:"entity_id";i:1;s:7:"deleted";i:2;s:5:"delta";i:3;s:8:"langcode";}s:7:"indexes";a:3:{s:6:"bundle";a:1:{i:0;s:6:"bundle";}s:11:"revision_id";a:1:{i:0;s:11:"revision_id";}s:22:"user_picture_target_id";a:1:{i:0;s:22:"user_picture_target_id";}}s:12:"foreign keys";a:1:{s:22:"user_picture_target_id";a:2:{s:5:"table";s:12:"file_managed";s:7:"columns";a:1:{s:22:"user_picture_target_id";s:3:"fid";}}}}}');
INSERT INTO `key_value` VALUES ('entity.storage_schema.sql','user.field_schema_data.uuid','a:1:{s:5:"users";a:2:{s:6:"fields";a:1:{s:4:"uuid";a:4:{s:4:"type";s:13:"varchar_ascii";s:6:"length";i:128;s:6:"binary";b:0;s:8:"not null";b:1;}}s:11:"unique keys";a:1:{s:23:"user_field__uuid__value";a:1:{i:0;s:4:"uuid";}}}}'),('post_update','existing_updates','a:67:{i:0;s:64:"system_post_update_add_expand_all_items_key_in_system_menu_block";i:1;s:48:"system_post_update_add_region_to_entity_displays";i:2;s:40:"system_post_update_change_action_plugins";i:3;s:47:"system_post_update_change_delete_action_plugins";i:4;s:41:"system_post_update_classy_message_library";i:5;s:35:"system_post_update_clear_menu_cache";i:6;s:60:"system_post_update_entity_reference_autocomplete_match_limit";i:7;s:31:"system_post_update_extra_fields";i:8;s:44:"system_post_update_extra_fields_form_display";i:9;s:48:"system_post_update_field_formatter_entity_schema";i:10;s:37:"system_post_update_field_type_plugins";i:11;s:36:"system_post_update_fix_jquery_extend";i:12;s:37:"system_post_update_hashes_clear_cache";i:13;s:41:"system_post_update_language_item_callback";i:14;s:46:"system_post_update_layout_plugin_schema_change";i:15;s:64:"system_post_update_recalculate_configuration_entity_dependencies";i:16;s:37:"system_post_update_states_clear_cache";i:17;s:36:"system_post_update_timestamp_plugins";i:18;s:45:"user_post_update_enforce_order_of_permissions";i:19;s:43:"field_post_update_email_widget_size_setting";i:20;s:50:"field_post_update_entity_reference_handler_setting";i:21;s:47:"field_post_update_remove_handler_submit_setting";i:22;s:46:"field_post_update_save_custom_storage_property";i:23;s:29:"search_post_update_block_page";i:24;s:49:"dblog_post_update_convert_recent_messages_to_view";i:25;s:62:"contact_post_update_add_message_redirect_field_to_contact_form";i:26;s:42:"text_post_update_add_required_summary_flag";i:27;s:55:"text_post_update_add_required_summary_flag_form_display";i:28;s:54:"block_post_update_disable_blocks_with_missing_contexts";i:29;s:40:"block_post_update_disabled_region_update";i:30;s:42:"block_post_update_fix_negate_in_conditions";i:31;s:51:"block_content_post_update_add_views_reusable_filter";i:32;s:46:"node_post_update_configure_status_field_widget";i:33;s:41:"node_post_update_node_revision_views_data";i:34;s:56:"editor_post_update_clear_cache_for_file_reference_filter";i:35;s:42:"comment_post_update_add_ip_address_setting";i:36;s:45:"comment_post_update_enable_comment_admin_view";i:37;s:48:"contextual_post_update_fixed_endpoint_and_markup";i:38;s:64:"taxonomy_post_update_clear_entity_bundle_field_definitions_cache";i:39;s:43:"taxonomy_post_update_clear_views_data_cache";i:40;s:50:"taxonomy_post_update_configure_status_field_widget";i:41;s:63:"taxonomy_post_update_handle_publishing_status_addition_in_views";i:42;s:52:"taxonomy_post_update_make_taxonomy_term_revisionable";i:43;s:55:"taxonomy_post_update_remove_hierarchy_from_vocabularies";i:44;s:42:"image_post_update_image_style_dependencies";i:45;s:50:"image_post_update_scale_and_crop_effect_add_anchor";i:46;s:39:"views_post_update_boolean_filter_values";i:47;s:34:"views_post_update_bulk_field_moved";i:48;s:46:"views_post_update_cleanup_duplicate_views_data";i:49;s:33:"views_post_update_entity_link_url";i:50;s:53:"views_post_update_exposed_filter_blocks_label_display";i:51;s:46:"views_post_update_field_formatter_dependencies";i:52;s:51:"views_post_update_field_names_for_multivalue_fields";i:53;s:41:"views_post_update_filter_placeholder_text";i:54;s:33:"views_post_update_grouped_filters";i:55;s:41:"views_post_update_limit_operator_defaults";i:56;s:48:"views_post_update_make_placeholders_translatable";i:57;s:33:"views_post_update_remove_core_key";i:58;s:42:"views_post_update_revision_metadata_fields";i:59;s:41:"views_post_update_serializer_dependencies";i:60;s:45:"views_post_update_table_display_cache_max_age";i:61;s:36:"views_post_update_taxonomy_index_tid";i:62;s:46:"views_post_update_update_cacheability_metadata";i:63;s:47:"views_post_update_views_data_table_dependencies";i:64;s:65:"menu_link_content_post_update_make_menu_link_content_revisionable";i:65;s:49:"path_post_update_create_language_content_settings";i:66;s:55:"search_post_update_reindex_after_diacritics_rule_change";}');
INSERT INTO `key_value` VALUES ('state','comment.maintain_entity_statistics','b:1;'),('state','comment.node_comment_statistics_scale','d:1;'),('state','drupal_css_cache_files','a:9:{s:64:"ef1bbf04adb7cc978bb2b6cc15baff625cdf4a9cab18c1e769bce01ec8cedc87";s:64:"public://css/css_O3ulzE1ALav0rdaNp8nubiMmqZkl8GW_ekSB9P5WosM.css";s:64:"9a4362e0556298f86ccb8090eda2c8951379ba73dd00c9a63b93c7a611ca8884";s:64:"public://css/css_rppRGD_OoHfR_SJsouUbDXbYqdDsbR40sRSsm5MvFnw.css";s:64:"cda5925b5c6261fbd009f9bc80b773305afc8174f988ecae47e7169c53096bd8";s:64:"public://css/css_35fqv7NYNNIsRwp41HyR3pDgvvRqpTvfcl1iBenEKBg.css";s:64:"47ece9b00345e19e8b43abbf02c9ca893929924a37a570854dfb1b7a0cfd8882";s:64:"public://css/css_0gyPWXOWRajIBV2qPPGXQxKaOFH4Cd-7ULcPAXi_6LQ.css";s:64:"03882a1b04e3f21a515fa4ea0fbb6d786b8f5adaaa3516976ae212424dff6467";s:64:"public://css/css_oNA2BWMCOXI9OB2Nd9pMiuF3GM4hZm1jnRcQjdBaspo.css";s:64:"d2c56bdf0a2427408cc81371ec9146c68bb47ea4068adcacc2ab2521420aabe9";s:64:"public://css/css_IPvFjxVAOHPcivu1UQWzuqG0sBtusCTFaW5xCxjr6mY.css";s:64:"2758d63b6d310fa57c5d3147371d42711f008db67cbbccf5f87230611670ed43";s:64:"public://css/css_BocvtRd2AxyMo4MlnhSxw7zfppz_j8Mq0fpTZ7Lqf6U.css";s:64:"89d2f7b4a42c33ef64db3888aa85c12cfbd0a95a1e11647a555b9dcca63d2719";s:64:"public://css/css_myFbaJ2ghp-OTbopkkuAp_ichDBL_teqNvR5miT_mvs.css";s:64:"782e38844576a949e14420594feb965ff2f42e7e18fb3eacc1a2d7b5fdd96d1b";s:64:"public://css/css_oXvy1Vrwwj1OlXT14c-4ckBTXE8MpAuQF69n_YbitzM.css";}'),('state','install_task','s:4:"done";'),('state','install_time','i:1604908227;'),('state','node.min_max_update_time','a:2:{s:11:"min_created";N;s:11:"max_created";N;}'),('state','router.path_roots','a:31:{i:0;s:5:"admin";i:1;s:8:"big_pipe";i:2;s:14:"block-category";i:3;s:5:"block";i:4;s:7:"comment";i:5;s:8:"comments";i:6;s:7:"contact";i:7;s:4:"user";i:8;s:10:"contextual";i:9;s:6:"editor";i:10;s:4:"file";i:11;s:6:"filter";i:12;s:7:"history";i:13;s:5:"sites";i:14;s:6:"system";i:15;s:9:"quickedit";i:16;s:4:"node";i:17;s:6:"search";i:18;s:4:"cron";i:19;s:12:"machine_name";i:20;s:0:"";i:21;s:9:"<current>";i:22;s:5:"batch";i:23;s:10:"update.php";i:24;s:29:"entity_reference_autocomplete";i:25;s:7:"session";i:26;s:8:"taxonomy";i:27;s:7:"toolbar";i:28;s:11:".well-known";i:29;s:7:"rss.xml";i:30;s:5:"views";}');
INSERT INTO `key_value` VALUES ('state','routing.menu_masks.router','a:45:{i:0;i:1018;i:1;i:501;i:2;i:493;i:3;i:464;i:4;i:254;i:5;i:253;i:6;i:252;i:7;i:251;i:8;i:250;i:9;i:247;i:10;i:246;i:11;i:245;i:12;i:232;i:13;i:224;i:14;i:127;i:15;i:126;i:16;i:125;i:17;i:123;i:18;i:122;i:19;i:116;i:20;i:96;i:21;i:63;i:22;i:62;i:23;i:61;i:24;i:60;i:25;i:49;i:26;i:42;i:27;i:32;i:28;i:31;i:29;i:30;i:30;i:28;i:31;i:24;i:32;i:21;i:33;i:15;i:34;i:14;i:35;i:13;i:36;i:12;i:37;i:11;i:38;i:8;i:39;i:7;i:40;i:6;i:41;i:5;i:42;i:3;i:43;i:2;i:44;i:1;}'),('state','routing.non_admin_routes','a:103:{i:0;s:13:"big_pipe.nojs";i:1;s:27:"block.category_autocomplete";i:2;s:22:"block_content.add_page";i:3;s:22:"block_content.add_form";i:4;s:30:"entity.block_content.canonical";i:5;s:30:"entity.block_content.edit_form";i:6;s:32:"entity.block_content.delete_form";i:7;s:24:"entity.comment.edit_form";i:8;s:15:"comment.approve";i:9;s:24:"entity.comment.canonical";i:10;s:26:"entity.comment.delete_form";i:11;s:13:"comment.reply";i:12;s:31:"comment.new_comments_node_links";i:13;s:21:"comment.node_redirect";i:14;s:17:"contact.site_page";i:15;s:29:"entity.contact_form.canonical";i:16;s:24:"entity.user.contact_form";i:17;s:17:"contextual.render";i:18;s:17:"editor.filter_xss";i:19;s:31:"editor.field_untransformed_text";i:20;s:19:"editor.image_dialog";i:21;s:18:"editor.link_dialog";i:22;s:18:"file.ajax_progress";i:23;s:15:"filter.tips_all";i:24;s:11:"filter.tips";i:25;s:26:"history.get_last_node_view";i:26;s:17:"history.read_node";i:27;s:18:"image.style_public";i:28;s:19:"image.style_private";i:29;s:12:"image.upload";i:30;s:10:"image.info";i:31;s:13:"node.add_page";i:32;s:8:"node.add";i:33;s:19:"entity.node.preview";i:34;s:27:"entity.node.version_history";i:35;s:20:"entity.node.revision";i:36;s:28:"node.revision_revert_confirm";i:37;s:40:"node.revision_revert_translation_confirm";i:38;s:28:"node.revision_delete_confirm";i:39;s:18:"quickedit.metadata";i:40;s:21:"quickedit.attachments";i:41;s:20:"quickedit.field_form";i:42;s:21:"quickedit.entity_save";i:43;s:11:"search.view";i:44;s:23:"search.view_node_search";i:45;s:23:"search.help_node_search";i:46;s:23:"search.view_user_search";i:47;s:23:"search.help_user_search";i:48;s:19:"shortcut.set_switch";i:49;s:10:"system.401";i:50;s:10:"system.403";i:51;s:10:"system.404";i:52;s:10:"system.4xx";i:53;s:11:"system.cron";i:54;s:33:"system.machine_name_transliterate";i:55;s:12:"system.files";i:56;s:28:"system.private_file_download";i:57;s:16:"system.temporary";i:58;s:7:"<front>";i:59;s:6:"<none>";i:60;s:8:"<nolink>";i:61;s:8:"<button>";i:62;s:9:"<current>";i:63;s:15:"system.timezone";i:64;s:22:"system.batch_page.html";i:65;s:22:"system.batch_page.json";i:66;s:16:"system.db_update";i:67;s:26:"system.entity_autocomplete";i:68;s:16:"system.csrftoken";i:69;s:30:"entity.taxonomy_term.edit_form";i:70;s:32:"entity.taxonomy_term.delete_form";i:71;s:16:"toolbar.subtrees";i:72;s:13:"user.register";i:73;s:11:"user.logout";i:74;s:9:"user.pass";i:75;s:14:"user.pass.http";i:76;s:9:"user.page";i:77;s:10:"user.login";i:78;s:15:"user.login.http";i:79;s:22:"user.login_status.http";i:80;s:16:"user.logout.http";i:81;s:19:"user.cancel_confirm";i:82;s:16:"user.reset.login";i:83;s:10:"user.reset";i:84;s:15:"user.reset.form";i:85;s:31:"user.well-known.change_password";i:86;s:21:"view.frontpage.feed_1";i:87;s:21:"view.frontpage.page_1";i:88;s:25:"view.taxonomy_term.feed_1";i:89;s:25:"view.taxonomy_term.page_1";i:90;s:10:"views.ajax";i:91;s:21:"entity.node.canonical";i:92;s:23:"entity.node.delete_form";i:93;s:21:"entity.node.edit_form";i:94;s:21:"entity.user.canonical";i:95;s:21:"entity.user.edit_form";i:96;s:23:"entity.user.cancel_form";i:97;s:14:"path.admin_add";i:98;s:15:"path.admin_edit";i:99;s:11:"path.delete";i:100;s:19:"path.admin_overview";i:101;s:26:"path.admin_overview_filter";i:102;s:30:"entity.taxonomy_term.canonical";}');
INSERT INTO `key_value` VALUES ('state','system.cron_key','s:74:"lO-owRcjAEFqTPQr60_nnq0d3aZUohYSQRaLylOfrcSdTvfnUftCu-9oj7-RMKHHdxJhnpJA0A";'),('state','system.cron_last','i:1604908227;'),('state','system.css_js_query_string','s:6:"qjiu7z";'),('state','system.js_cache_files','a:11:{s:64:"ef5219d33ebedcd4b9b0ccc64f741d50bebb463122945dd3b12519b97e268ab4";s:61:"public://js/js_VtafjXmRvoUgAzqzYTA3Wrjkx9wcWhjP0G4ZnnqRamA.js";s:64:"c839df7c4fcaff2cb7890a0c2e9316f456b4c990c363fb4eb87a2a601c594055";s:61:"public://js/js_VhqXmo4azheUjYC30rijnR_Dddo0WjWkF27k5gTL8S4.js";s:64:"2c5b8cf43212f8427e90f2841264c4e2a8b6b7eaad320bac736bb84734ad0b68";s:61:"public://js/js_X_80-G_CR-K-rJ6KHC6wrHagFkDyFnBSTwkyNZbXipo.js";s:64:"969be1d3cfb5d14f7a6870d50249d8e57ed97ef810cf9c20b833dc3cfc22c175";s:61:"public://js/js_-I7XhDX7aFtfnOTB3E2bSN5LEYuwrFR5MtTQ6dfk1jQ.js";s:64:"ed9cf1a8e0b5cbd6862b26cb8f258d052c1fddb1041c39827b681b041bb9a21c";s:61:"public://js/js_q9kF65AC6bY7_vVOawcD3TdebBCzBmBHHRefDbfWFWc.js";s:64:"ebcb96b06e6108dc594955c395d30ee24618cdf81596fff6776a62e829315e2d";s:61:"public://js/js_BYqDO68AvPZths32WwJUcuWL7xWLja-QCBhkvSbFrtc.js";s:64:"957f0bd762299635a1d7cd95ccc64df6c14ab676cebf39a643a7dd3757d4aaef";s:61:"public://js/js_ka9mUD8oA3mbloaHxvHR19aj0GZrxeQYLTGlntbO3e8.js";s:64:"4a05aaf3864dbf930e7450e9faab027f8cfe131fd8f77d50a9a610849f06cc20";s:61:"public://js/js_EY5MGG4Hf-5UywgB9Vwli3CBqXFNjEWK3FCyRRwNM8w.js";s:64:"abcf0452e8dd7b468ecb549c339e31a11ffb8e54ef5cdd1f37fe455ecbf79f68";s:61:"public://js/js_egYNibU0Np0g7tNJFIVZLdyiYI4-avYqPwF1WrVn_DA.js";s:64:"5564f70bc009de5d672f5beeaaa1595f89a3cafc76834fedfc61cd24548ae098";s:61:"public://js/js_Sk6wGWDjHOV4jyKB7n0T0HH9wRjKoFQ9rmHC6wUGZFk.js";s:64:"e1a756b13e0443d11a5795bf2116e413a759764bbae8467dcfdcc56001bf00fa";s:61:"public://js/js_ntnG20IITKb5IVapyKfR3UTNPamRaJVwrmPoPMbanpw.js";}'),('state','system.maintenance_mode','i:0;'),('state','system.private_key','s:74:"cvd_k0J_zY2_oeVn_NSuAlfuiE6dGL6SwQzI_CuGiGrMo1cO-unKBZ5YEQPxHc9NLgmEofEoVQ";'),('state','system.profile.files','a:15:{s:10:"demo_umami";s:44:"core/profiles/demo_umami/demo_umami.info.yml";s:7:"minimal";s:38:"core/profiles/minimal/minimal.info.yml";s:18:"nightwatch_testing";s:60:"core/profiles/nightwatch_testing/nightwatch_testing.info.yml";s:8:"standard";s:40:"core/profiles/standard/standard.info.yml";s:7:"testing";s:38:"core/profiles/testing/testing.info.yml";s:21:"testing_config_import";s:66:"core/profiles/testing_config_import/testing_config_import.info.yml";s:24:"testing_config_overrides";s:72:"core/profiles/testing_config_overrides/testing_config_overrides.info.yml";s:40:"testing_install_profile_all_dependencies";s:104:"core/profiles/testing_install_profile_all_dependencies/testing_install_profile_all_dependencies.info.yml";s:36:"testing_install_profile_dependencies";s:96:"core/profiles/testing_install_profile_dependencies/testing_install_profile_dependencies.info.yml";s:39:"testing_install_profile_dependencies_bc";s:102:"core/profiles/testing_install_profile_dependencies_bc/testing_install_profile_dependencies_bc.info.yml";s:28:"testing_missing_dependencies";s:80:"core/profiles/testing_missing_dependencies/testing_missing_dependencies.info.yml";s:20:"testing_multilingual";s:64:"core/profiles/testing_multilingual/testing_multilingual.info.yml";s:33:"testing_multilingual_with_english";s:90:"core/profiles/testing_multilingual_with_english/testing_multilingual_with_english.info.yml";s:20:"testing_requirements";s:64:"core/profiles/testing_requirements/testing_requirements.info.yml";s:19:"testing_site_config";s:62:"core/profiles/testing_site_config/testing_site_config.info.yml";}');
INSERT INTO `key_value` VALUES ('state','twig_extension_hash_prefix','a:2:{s:19:"twig_extension_hash";s:43:"zwbdYxFPeNk-aJWDAUhf24pGtkfBwRY9PbT4y3Ln11A";s:17:"twig_cache_prefix";s:13:"5fa904844421a";}'),('state','views.view_route_names','a:12:{s:13:"watchdog.page";s:14:"dblog.overview";s:24:"user_admin_people.page_1";s:22:"entity.user.collection";s:20:"taxonomy_term.page_1";s:30:"entity.taxonomy_term.canonical";s:14:"content.page_1";s:20:"system.admin_content";s:23:"comment.page_unapproved";s:22:"comment.admin_approval";s:22:"comment.page_published";s:13:"comment.admin";s:20:"block_content.page_1";s:31:"entity.block_content.collection";s:12:"files.page_1";s:17:"view.files.page_1";s:12:"files.page_2";s:17:"view.files.page_2";s:16:"frontpage.feed_1";s:21:"view.frontpage.feed_1";s:16:"frontpage.page_1";s:21:"view.frontpage.page_1";s:20:"taxonomy_term.feed_1";s:25:"view.taxonomy_term.feed_1";}'),('system.schema','automated_cron','i:8000;'),('system.schema','backup_migrate','i:8000;'),('system.schema','big_pipe','i:8000;'),('system.schema','block','s:4:"8003";'),('system.schema','block_content','s:4:"8600";'),('system.schema','breakpoint','i:8000;'),('system.schema','ckeditor','i:8000;'),('system.schema','color','i:8000;'),('system.schema','comment','s:4:"8701";'),('system.schema','config','i:8000;'),('system.schema','contact','i:8000;'),('system.schema','contextual','i:8000;'),('system.schema','datetime','i:8000;'),('system.schema','dblog','s:4:"8600";'),('system.schema','dynamic_page_cache','i:8000;'),('system.schema','editor','s:4:"8001";'),('system.schema','field','s:4:"8500";'),('system.schema','field_ui','i:8000;'),('system.schema','file','s:4:"8700";'),('system.schema','filter','i:8000;'),('system.schema','help','i:8000;'),('system.schema','history','s:4:"8101";'),('system.schema','image','s:4:"8201";'),('system.schema','link','i:8000;'),('system.schema','menu_link_content','s:4:"8601";'),('system.schema','menu_ui','i:8000;'),('system.schema','node','s:4:"8700";'),('system.schema','options','i:8000;');
INSERT INTO `key_value` VALUES ('system.schema','page_cache','i:8000;'),('system.schema','path','s:4:"8200";'),('system.schema','path_alias','i:8000;'),('system.schema','quickedit','i:8000;'),('system.schema','rdf','i:8000;'),('system.schema','search','i:8000;'),('system.schema','shortcut','i:8000;'),('system.schema','standard','i:8000;'),('system.schema','system','s:4:"8901";'),('system.schema','taxonomy','s:4:"8702";'),('system.schema','text','i:8000;'),('system.schema','toolbar','i:8000;'),('system.schema','tour','i:8000;'),('system.schema','user','s:4:"8100";'),('system.schema','views','s:4:"8500";'),('system.schema','views_ui','i:8000;');
DROP TABLE IF EXISTS `key_value_expire`;
CREATE TABLE `key_value_expire` (   `collection` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'A named collection of key and value pairs.',   `name` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The key of the key/value pair.',   `value` longblob NOT NULL COMMENT 'The value of the key/value pair.',   `expire` int(11) NOT NULL DEFAULT '2147483647' COMMENT 'The time since Unix epoch in seconds when this item expires. Defaults to the maximum possible time.',   PRIMARY KEY (`collection`,`name`),   KEY `all` (`name`,`collection`,`expire`),   KEY `expire` (`expire`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Generic key/value storage table with an expiration.';
DROP TABLE IF EXISTS `menu_link_content`;
CREATE TABLE `menu_link_content` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `revision_id` int(10) unsigned DEFAULT NULL,   `bundle` varchar(32) CHARACTER SET ascii NOT NULL,   `uuid` varchar(128) CHARACTER SET ascii NOT NULL,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   PRIMARY KEY (`id`),   UNIQUE KEY `menu_link_content_field__uuid__value` (`uuid`),   UNIQUE KEY `menu_link_content__revision_id` (`revision_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for menu_link_content entities.' AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `menu_link_content_data`;
CREATE TABLE `menu_link_content_data` (   `id` int(10) unsigned NOT NULL,   `revision_id` int(10) unsigned NOT NULL,   `bundle` varchar(32) CHARACTER SET ascii NOT NULL,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `enabled` tinyint(4) NOT NULL,   `title` varchar(255) DEFAULT NULL,   `description` varchar(255) DEFAULT NULL,   `menu_name` varchar(255) CHARACTER SET ascii DEFAULT NULL,   `link__uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',   `link__title` varchar(255) DEFAULT NULL COMMENT 'The link text.',   `link__options` longblob COMMENT 'Serialized array of options for the link.',   `external` tinyint(4) DEFAULT NULL,   `rediscover` tinyint(4) DEFAULT NULL,   `weight` int(11) DEFAULT NULL,   `expanded` tinyint(4) DEFAULT NULL,   `parent` varchar(255) DEFAULT NULL,   `changed` int(11) DEFAULT NULL,   `default_langcode` tinyint(4) NOT NULL,   `revision_translation_affected` tinyint(4) DEFAULT NULL,   PRIMARY KEY (`id`,`langcode`),   KEY `menu_link_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`),   KEY `menu_link_content__revision_id` (`revision_id`),   KEY `menu_link_content_field__link__uri` (`link__uri`(30)),   KEY `menu_link_content__enabled_bundle` (`enabled`,`bundle`,`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for menu_link_content entities.';
DROP TABLE IF EXISTS `menu_link_content_field_revision`;
CREATE TABLE `menu_link_content_field_revision` (   `id` int(10) unsigned NOT NULL,   `revision_id` int(10) unsigned NOT NULL,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `enabled` tinyint(4) NOT NULL,   `title` varchar(255) DEFAULT NULL,   `description` varchar(255) DEFAULT NULL,   `link__uri` varchar(2048) DEFAULT NULL COMMENT 'The URI of the link.',   `link__title` varchar(255) DEFAULT NULL COMMENT 'The link text.',   `link__options` longblob COMMENT 'Serialized array of options for the link.',   `external` tinyint(4) DEFAULT NULL,   `changed` int(11) DEFAULT NULL,   `default_langcode` tinyint(4) NOT NULL,   `revision_translation_affected` tinyint(4) DEFAULT NULL,   PRIMARY KEY (`revision_id`,`langcode`),   KEY `menu_link_content__id__default_langcode__langcode` (`id`,`default_langcode`,`langcode`),   KEY `menu_link_content_field__link__uri` (`link__uri`(30)) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision data table for menu_link_content entities.';
DROP TABLE IF EXISTS `menu_link_content_revision`;
CREATE TABLE `menu_link_content_revision` (   `id` int(10) unsigned NOT NULL,   `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `revision_user` int(10) unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',   `revision_created` int(11) DEFAULT NULL,   `revision_log_message` longtext,   `revision_default` tinyint(4) DEFAULT NULL,   PRIMARY KEY (`revision_id`),   KEY `menu_link_content__id` (`id`),   KEY `menu_link_content__ef029a1897` (`revision_user`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for menu_link_content entities.' AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `menu_tree`;
CREATE TABLE `menu_tree` (   `menu_name` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The menu name. All links with the same menu name (such as ''tools'') are part of the same menu.',   `mlid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'The menu link ID (mlid) is the integer primary key.',   `id` varchar(255) CHARACTER SET ascii NOT NULL COMMENT 'Unique machine name: the plugin ID.',   `parent` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The plugin ID for the parent of this link.',   `route_name` varchar(255) CHARACTER SET ascii DEFAULT NULL COMMENT 'The machine name of a defined Symfony Route this menu item represents.',   `route_param_key` varchar(255) DEFAULT NULL COMMENT 'An encoded string of route parameters for loading by route.',   `route_parameters` longblob COMMENT 'Serialized array of route parameters of this menu link.',   `url` varchar(255) NOT NULL DEFAULT '' COMMENT 'The external path this link points to (when not using a route).',   `title` longblob COMMENT 'The serialized title for the link. May be a TranslatableMarkup.',   `description` longblob COMMENT 'The serialized description of this link - used for admin pages and title attribute. May be a TranslatableMarkup.',   `class` text COMMENT 'The class for this link plugin.',   `options` longblob COMMENT 'A serialized array of URL options, such as a query string or HTML attributes.',   `provider` varchar(50) CHARACTER SET ascii NOT NULL DEFAULT 'system' COMMENT 'The name of the module that generated this link.',   `enabled` smallint(6) NOT NULL DEFAULT '1' COMMENT 'A flag for whether the link should be rendered in menus. (0 = a disabled menu item that may be shown on admin screens, 1 = a normal, visible link)',   `discovered` smallint(6) NOT NULL DEFAULT '0' COMMENT 'A flag for whether the link was discovered, so can be purged on rebuild',   `expanded` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag for whether this link should be rendered as expanded in menus - expanded links always have their child links displayed, instead of only when the link is in the active trail (1 = expanded, 0 = not expanded)',   `weight` int(11) NOT NULL DEFAULT '0' COMMENT 'Link weight among links in the same menu at the same depth.',   `metadata` longblob COMMENT 'A serialized array of data that may be used by the plugin instance.',   `has_children` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Flag indicating whether any enabled links have this link as a parent (1 = enabled children exist, 0 = no enabled children).',   `depth` smallint(6) NOT NULL DEFAULT '0' COMMENT 'The depth relative to the top level. A link with empty parent will have depth == 1.',   `p1` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The first mlid in the materialized path. If N = depth, then pN must equal the mlid. If depth > 1 then p(N-1) must equal the parent link mlid. All pX where X > depth must equal zero. The columns p1 .. p9 are also called the parents.',   `p2` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The second mlid in the materialized path. See p1.',   `p3` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The third mlid in the materialized path. See p1.',   `p4` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The fourth mlid in the materialized path. See p1.',   `p5` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The fifth mlid in the materialized path. See p1.',   `p6` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The sixth mlid in the materialized path. See p1.',   `p7` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The seventh mlid in the materialized path. See p1.',   `p8` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The eighth mlid in the materialized path. See p1.',   `p9` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The ninth mlid in the materialized path. See p1.',   `form_class` varchar(255) DEFAULT NULL COMMENT 'meh',   PRIMARY KEY (`mlid`),   UNIQUE KEY `id` (`id`),   KEY `menu_parents` (`menu_name`,`p1`,`p2`,`p3`,`p4`,`p5`,`p6`,`p7`,`p8`,`p9`),   KEY `menu_parent_expand_child` (`menu_name`,`expanded`,`has_children`,`parent`(16)),   KEY `route_values` (`route_name`(32),`route_param_key`(16)) ) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COMMENT='Contains the menu tree hierarchy.' AUTO_INCREMENT=67;
INSERT INTO `menu_tree` VALUES ('admin','1','system.admin','','system.admin','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"Administration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','s:0:"";','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','9','a:0:{}','1','1','1','0','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','2','system.admin_content','system.admin','system.admin_content','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"Find and manage content.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-10','a:0:{}','1','2','1','2','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','3','system.admin_structure','system.admin','system.admin_structure','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Structure";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"Administer blocks, content types, menus, etc.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-8','a:0:{}','1','2','1','3','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','4','system.themes_page','system.admin','system.themes_page','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Appearance";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:28:"Select and configure themes.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-6','a:0:{}','0','2','1','4','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','5','system.modules_list','system.admin','system.modules_list','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Extend";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:52:"Add and enable modules to extend site functionality.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-2','a:0:{}','0','2','1','5','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','6','system.admin_config','system.admin','system.admin_config','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Configuration";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:20:"Administer settings.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','0','a:0:{}','1','2','1','6','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','7','system.admin_config_media','system.admin_config','system.admin_config_media','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Media";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','s:0:"";','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-10','a:0:{}','1','3','1','6','7','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','8','system.file_system_settings','system.admin_config_media','system.file_system_settings','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"File system";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:67:"Configure the location of uploaded files and how they are accessed.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','0','a:0:{}','0','4','1','6','7','8','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','9','system.image_toolkit_settings','system.admin_config_media','system.image_toolkit_settings','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Image toolkit";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:74:"Choose which image toolkit to use if you have installed optional toolkits.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','20','a:0:{}','0','4','1','6','7','9','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','10','system.admin_config_services','system.admin_config','system.admin_config_services','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Web services";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','s:0:"";','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','0','a:0:{}','1','3','1','6','10','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','11','system.rss_feeds_settings','system.admin_config_services','system.rss_feeds_settings','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"RSS publishing";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:115:"Configure the site description, the number of items per feed, and whether feeds should be titles/teasers/full-text.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','0','a:0:{}','0','4','1','6','10','11','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','12','system.admin_config_development','system.admin_config','system.admin_config_development','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Development";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:36:"Configure and use development tools.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-10','a:0:{}','1','3','1','6','12','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','13','system.site_maintenance_mode','system.admin_config_development','system.site_maintenance_mode','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Maintenance mode";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:62:"Take the site offline for updates and other maintenance tasks.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-10','a:0:{}','0','4','1','6','12','13','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','14','system.performance_settings','system.admin_config_development','system.performance_settings','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Performance";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"Configure caching and bandwidth optimization.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-20','a:0:{}','0','4','1','6','12','14','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','15','system.logging_settings','system.admin_config_development','system.logging_settings','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"Logging and errors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:61:"Configure the display of error messages and database logging.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-15','a:0:{}','0','4','1','6','12','15','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','16','system.admin_config_regional','system.admin_config','system.admin_config_regional','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:21:"Regional and language";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:59:"Configure regional settings, localization, and translation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-5','a:0:{}','1','3','1','6','16','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','17','system.regional_settings','system.admin_config_regional','system.regional_settings','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Regional settings";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Configure the locale and timezone settings.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-20','a:0:{}','0','4','1','6','16','17','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','18','entity.date_format.collection','system.admin_config_regional','entity.date_format.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:21:"Date and time formats";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:44:"Configure how dates and times are displayed.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-9','a:0:{}','0','4','1','6','16','18','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','19','system.admin_config_search','system.admin_config','system.admin_config_search','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Search and metadata";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:64:"Configure site search, metadata, and search engine optimization.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-10','a:0:{}','1','3','1','6','19','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','20','system.admin_config_system','system.admin_config','system.admin_config_system','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"System";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:49:"Configure basic site settings, actions, and cron.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-20','a:0:{}','1','3','1','6','20','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','21','system.site_information_settings','system.admin_config_system','system.site_information_settings','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Basic site settings";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:77:"Change site name, email address, slogan, default front page, and error pages.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-20','a:0:{}','0','4','1','6','20','21','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','22','system.cron_settings','system.admin_config_system','system.cron_settings','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Cron";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:40:"Manage automatic site maintenance tasks.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','20','a:0:{}','0','4','1','6','20','22','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','23','system.admin_config_ui','system.admin_config','system.admin_config_ui','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:14:"User interface";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:44:"Configure the administrative user interface.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-15','a:0:{}','1','3','1','6','23','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','24','system.admin_config_workflow','system.admin_config','system.admin_config_workflow','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Workflow";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:28:"Manage the content workflow.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','5','a:0:{}','0','3','1','6','24','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','25','system.admin_config_content','system.admin_config','system.admin_config_content','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:17:"Content authoring";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"Configure content formatting and authoring.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','-15','a:0:{}','1','3','1','6','25','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','26','system.admin_reports','system.admin','system.admin_reports','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Reports";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"View reports, updates, and errors.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','5','a:0:{}','1','2','1','26','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','27','system.status','system.admin_reports','system.status','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Status report";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:48:"Get a status report about your site''s operation.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','system','1','1','0','0','a:0:{}','0','3','1','26','27','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','28','user.admin_index','system.admin_config','user.admin_index','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"People";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"Configure user accounts.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','user','1','1','0','-20','a:0:{}','1','3','1','6','28','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','29','entity.user.admin_form','user.admin_index','entity.user.admin_form','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:16:"Account settings";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:105:"Configure default user account settings, including fields, registration requirements, and email messages.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','user','1','1','0','-10','a:0:{}','0','4','1','6','28','29','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','30','entity.user.collection','system.admin','entity.user.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"People";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:45:"Manage user accounts, roles, and permissions.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','user','1','1','0','4','a:0:{}','0','2','1','30','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('account','31','user.page','','user.page','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"My account";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','s:0:"";','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','user','1','1','0','-10','a:0:{}','0','1','31','0','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('account','32','user.logout','','','','a:0:{}','','s:0:"";','s:0:"";','Drupal\\user\\Plugin\\Menu\\LoginLogoutMenuLink','a:0:{}','user','1','1','0','10','a:0:{}','0','1','32','0','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('main','33','standard.front_page','','<front>','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Home";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','s:0:"";','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','standard','1','1','0','0','a:0:{}','0','1','33','0','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','34','help.main','system.admin','help.main','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:4:"Help";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:48:"Reference for usage, configuration, and modules.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','help','1','1','0','9','a:0:{}','0','2','1','34','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('tools','35','search.view','','search.view','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:6:"Search";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','s:0:"";','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','search','0','1','0','0','a:0:{}','0','1','35','0','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','36','entity.search_page.collection','system.admin_config_search','entity.search_page.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Search pages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:51:"Configure search pages and search indexing options.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','search','1','1','0','-10','a:0:{}','0','4','1','6','19','36','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','37','config.sync','system.admin_config_development','config.sync','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Configuration synchronization";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:37:"Import and export your configuration.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','config','1','1','0','0','a:0:{}','0','4','1','6','12','37','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','38','dblog.overview','system.admin_reports','dblog.overview','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:19:"Recent log messages";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:43:"View events that have recently been logged.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','dblog','1','1','0','-1','a:0:{}','0','3','1','26','38','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','39','dblog.page_not_found','system.admin_reports','dblog.page_not_found','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:27:"Top ''page not found'' errors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:36:"View ''page not found'' errors (404s).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','dblog','1','1','0','0','a:0:{}','0','3','1','26','39','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','40','dblog.access_denied','system.admin_reports','dblog.access_denied','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:26:"Top ''access denied'' errors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"View ''access denied'' errors (403s).";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','dblog','1','1','0','0','a:0:{}','0','3','1','26','40','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','41','dblog.search','system.admin_reports','dblog.search','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"Top search phrases";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:33:"View most popular search phrases.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','','1','1','0','0','a:0:{}','0','3','1','26','41','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('footer','42','contact.site_page','','contact.site_page','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Contact";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','s:0:"";','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','contact','1','1','0','0','a:0:{}','0','1','42','0','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','43','entity.contact_form.collection','system.admin_structure','entity.contact_form.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Contact forms";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:32:"Create and manage contact forms.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','contact','1','1','0','0','a:0:{}','0','3','1','3','43','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('tools','44','filter.tips_all','','filter.tips_all','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Compose tips";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','s:0:"";','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','filter','0','1','0','0','a:0:{}','0','1','44','0','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','45','filter.admin_overview','system.admin_config_content','filter.admin_overview','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:24:"Text formats and editors";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:78:"Select and configure text editors, and how content is filtered when displayed.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','filter','1','1','0','0','a:0:{}','0','4','1','6','25','45','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','46','block.admin_display','system.admin_structure','block.admin_display','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Block layout";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:79:"Configure what block content appears in your site''s sidebars and other regions.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','block','1','1','0','0','a:0:{}','0','3','1','3','46','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('tools','47','node.add_page','','node.add_page','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"Add content";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','s:0:"";','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','node','1','1','0','0','a:0:{}','0','1','47','0','0','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','48','entity.node_type.collection','system.admin_structure','entity.node_type.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Content types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:71:"Create and manage fields, forms, and display settings for your content.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','node','1','1','0','0','a:0:{}','0','3','1','3','48','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','49','comment.admin','system.admin_content','comment.admin','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Comments";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:59:"List and edit site comments and the comment approval queue.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','comment','1','1','0','0','a:0:{}','0','3','1','2','49','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','50','entity.comment_type.collection','system.admin_structure','entity.comment_type.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Comment types";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:46:"Manage form and displays settings of comments.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','comment','1','1','0','0','a:0:{}','0','3','1','3','50','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','51','field_ui.display_mode','system.admin_structure','field_ui.display_mode','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Display modes";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:65:"Configure what displays are available for your content and forms.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','field_ui','1','1','0','0','a:0:{}','1','3','1','3','51','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','52','entity.entity_view_mode.collection','field_ui.display_mode','entity.entity_view_mode.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"View modes";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"Manage custom view modes.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','field_ui','1','1','0','0','a:0:{}','0','4','1','3','51','52','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','53','entity.entity_form_mode.collection','field_ui.display_mode','entity.entity_form_mode.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Form modes";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:25:"Manage custom form modes.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','field_ui','1','1','0','0','a:0:{}','0','4','1','3','51','53','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','54','entity.field_storage_config.collection','system.admin_reports','entity.field_storage_config.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:10:"Field list";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:39:"Overview of fields on all entity types.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','field_ui','1','1','0','0','a:0:{}','0','3','1','26','54','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','55','entity.taxonomy_vocabulary.collection','system.admin_structure','entity.taxonomy_vocabulary.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Taxonomy";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:67:"Manage tagging, categorization, and classification of your content.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','taxonomy','1','1','0','0','a:0:{}','0','3','1','3','55','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','56','entity.image_style.collection','system.admin_config_media','entity.image_style.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:12:"Image styles";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:78:"Configure styles that can be used for resizing or adjusting images on display.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','image','1','1','0','0','a:0:{}','0','4','1','6','7','56','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','57','entity.menu.collection','system.admin_structure','entity.menu.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Menus";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:28:"Manage menus and menu links.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','menu_ui','1','1','0','0','a:0:{}','0','3','1','3','57','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','58','entity.path_alias.collection','system.admin_config_search','entity.path_alias.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:11:"URL aliases";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:34:"Add custom URLs to existing paths.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','path','1','1','0','-5','a:0:{}','0','4','1','6','19','58','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','59','entity.shortcut_set.collection','system.admin_config_ui','entity.shortcut_set.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:9:"Shortcuts";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:29:"Add and modify shortcut sets.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','shortcut','1','1','0','0','a:0:{}','0','4','1','6','23','59','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','60','entity.view.collection','system.admin_structure','entity.view.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:5:"Views";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:35:"Manage customized lists of content.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','views_ui','1','1','0','0','a:0:{}','0','3','1','3','60','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','61','views_ui.reports_plugins','system.admin_reports','views_ui.reports_plugins','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Views plugins";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:38:"Overview of plugins used in all views.";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','views_ui','1','1','0','0','a:0:{}','0','3','1','26','61','0','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','62','backup_migrate.quick_backup','system.admin_config_development','backup_migrate.quick_backup','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:18:"Backup and Migrate";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:58:"Create or import backups of your project database or files";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','backup_migrate','1','1','0','0','a:0:{}','1','4','1','6','12','62','0','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','63','backup_migrate.restore','backup_migrate.quick_backup','backup_migrate.restore','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:7:"Restore";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:0:"";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','backup_migrate','1','1','0','1','a:0:{}','0','5','1','6','12','62','63','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','64','backup_migrate.backups','backup_migrate.quick_backup','backup_migrate.backups','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:13:"Saved Backups";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:0:"";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','backup_migrate','1','1','0','2','a:0:{}','0','5','1','6','12','62','64','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm'),('admin','65','backup_migrate.schedule','backup_migrate.quick_backup','entity.backup_migrate_schedule.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Schedule";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:0:"";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','backup_migrate','1','1','0','3','a:0:{}','0','5','1','6','12','62','65','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
INSERT INTO `menu_tree` VALUES ('admin','66','backup_migrate.settings','backup_migrate.quick_backup','entity.backup_migrate_settings.collection','','a:0:{}','','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:8:"Settings";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','O:48:"Drupal\\Core\\StringTranslation\\TranslatableMarkup":3:{s:9:"\0*\0string";s:0:"";s:12:"\0*\0arguments";a:0:{}s:10:"\0*\0options";a:0:{}}','Drupal\\Core\\Menu\\MenuLinkDefault','a:0:{}','backup_migrate','1','1','0','4','a:0:{}','0','5','1','6','12','62','66','0','0','0','0','Drupal\\Core\\Menu\\Form\\MenuLinkDefaultForm');
DROP TABLE IF EXISTS `node`;
CREATE TABLE `node` (   `nid` int(10) unsigned NOT NULL AUTO_INCREMENT,   `vid` int(10) unsigned DEFAULT NULL,   `type` varchar(32) CHARACTER SET ascii NOT NULL COMMENT 'The ID of the target entity.',   `uuid` varchar(128) CHARACTER SET ascii NOT NULL,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   PRIMARY KEY (`nid`),   UNIQUE KEY `node_field__uuid__value` (`uuid`),   UNIQUE KEY `node__vid` (`vid`),   KEY `node_field__type__target_id` (`type`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for node entities.' AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `node__body`;
CREATE TABLE `node__body` (   `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',   `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',   `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',   `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',   `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',   `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',   `body_value` longtext NOT NULL,   `body_summary` longtext,   `body_format` varchar(255) CHARACTER SET ascii DEFAULT NULL,   PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),   KEY `bundle` (`bundle`),   KEY `revision_id` (`revision_id`),   KEY `body_format` (`body_format`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for node field body.';
DROP TABLE IF EXISTS `node__comment`;
CREATE TABLE `node__comment` (   `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',   `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',   `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',   `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',   `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',   `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',   `comment_status` int(11) NOT NULL DEFAULT '0' COMMENT 'Whether comments are allowed on this entity: 0 = no, 1 = closed (read only), 2 = open (read/write).',   PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),   KEY `bundle` (`bundle`),   KEY `revision_id` (`revision_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for node field comment.';
DROP TABLE IF EXISTS `node__field_image`;
CREATE TABLE `node__field_image` (   `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',   `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',   `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',   `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',   `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',   `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',   `field_image_target_id` int(10) unsigned NOT NULL COMMENT 'The ID of the file entity.',   `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image''s ''alt'' attribute.',   `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image''s ''title'' attribute.',   `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',   `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',   PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),   KEY `bundle` (`bundle`),   KEY `revision_id` (`revision_id`),   KEY `field_image_target_id` (`field_image_target_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for node field field_image.';
DROP TABLE IF EXISTS `node__field_tags`;
CREATE TABLE `node__field_tags` (   `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',   `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',   `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',   `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',   `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',   `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',   `field_tags_target_id` int(10) unsigned NOT NULL COMMENT 'The ID of the target entity.',   PRIMARY KEY (`entity_id`,`deleted`,`delta`,`langcode`),   KEY `bundle` (`bundle`),   KEY `revision_id` (`revision_id`),   KEY `field_tags_target_id` (`field_tags_target_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Data storage for node field field_tags.';
DROP TABLE IF EXISTS `node_access`;
CREATE TABLE `node_access` (   `nid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The node.nid this record affects.',   `langcode` varchar(12) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language.langcode of this node.',   `fallback` tinyint(3) unsigned NOT NULL DEFAULT '1' COMMENT 'Boolean indicating whether this record should be used as a fallback if a language condition is not provided.',   `gid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'The grant ID a user must possess in the specified realm to gain this row''s privileges on the node.',   `realm` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The realm in which the user must possess the grant ID. Modules can define one or more realms by implementing hook_node_grants().',   `grant_view` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can view this node.',   `grant_update` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can edit this node.',   `grant_delete` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT 'Boolean indicating whether a user with the realm/grant pair can delete this node.',   PRIMARY KEY (`nid`,`gid`,`realm`,`langcode`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Identifies which realm/grant pairs a user must possess in…';
INSERT INTO `node_access` VALUES ('0','','1','0','all','1','0','0');
DROP TABLE IF EXISTS `node_field_data`;
CREATE TABLE `node_field_data` (   `nid` int(10) unsigned NOT NULL,   `vid` int(10) unsigned NOT NULL,   `type` varchar(32) CHARACTER SET ascii NOT NULL COMMENT 'The ID of the target entity.',   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `status` tinyint(4) NOT NULL,   `uid` int(10) unsigned NOT NULL COMMENT 'The ID of the target entity.',   `title` varchar(255) NOT NULL,   `created` int(11) NOT NULL,   `changed` int(11) NOT NULL,   `promote` tinyint(4) NOT NULL,   `sticky` tinyint(4) NOT NULL,   `default_langcode` tinyint(4) NOT NULL,   `revision_translation_affected` tinyint(4) DEFAULT NULL,   PRIMARY KEY (`nid`,`langcode`),   KEY `node__id__default_langcode__langcode` (`nid`,`default_langcode`,`langcode`),   KEY `node__vid` (`vid`),   KEY `node_field__type__target_id` (`type`),   KEY `node_field__uid__target_id` (`uid`),   KEY `node_field__created` (`created`),   KEY `node_field__changed` (`changed`),   KEY `node__status_type` (`status`,`type`,`nid`),   KEY `node__frontpage` (`promote`,`status`,`sticky`,`created`),   KEY `node__title_type` (`title`(191),`type`(4)) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The data table for node entities.';
DROP TABLE IF EXISTS `node_field_revision`;
CREATE TABLE `node_field_revision` (   `nid` int(10) unsigned NOT NULL,   `vid` int(10) unsigned NOT NULL,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `status` tinyint(4) NOT NULL,   `uid` int(10) unsigned NOT NULL COMMENT 'The ID of the target entity.',   `title` varchar(255) DEFAULT NULL,   `created` int(11) DEFAULT NULL,   `changed` int(11) DEFAULT NULL,   `promote` tinyint(4) DEFAULT NULL,   `sticky` tinyint(4) DEFAULT NULL,   `default_langcode` tinyint(4) NOT NULL,   `revision_translation_affected` tinyint(4) DEFAULT NULL,   PRIMARY KEY (`vid`,`langcode`),   KEY `node__id__default_langcode__langcode` (`nid`,`default_langcode`,`langcode`),   KEY `node_field__uid__target_id` (`uid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision data table for node entities.';
DROP TABLE IF EXISTS `node_revision`;
CREATE TABLE `node_revision` (   `nid` int(10) unsigned NOT NULL,   `vid` int(10) unsigned NOT NULL AUTO_INCREMENT,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `revision_uid` int(10) unsigned DEFAULT NULL COMMENT 'The ID of the target entity.',   `revision_timestamp` int(11) DEFAULT NULL,   `revision_log` longtext,   `revision_default` tinyint(4) DEFAULT NULL,   PRIMARY KEY (`vid`),   KEY `node__nid` (`nid`),   KEY `node_field__langcode` (`langcode`),   KEY `node_field__revision_uid__target_id` (`revision_uid`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for node entities.' AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `node_revision__body`;
CREATE TABLE `node_revision__body` (   `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',   `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',   `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',   `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',   `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',   `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',   `body_value` longtext NOT NULL,   `body_summary` longtext,   `body_format` varchar(255) CHARACTER SET ascii DEFAULT NULL,   PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),   KEY `bundle` (`bundle`),   KEY `revision_id` (`revision_id`),   KEY `body_format` (`body_format`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for node field body.';
DROP TABLE IF EXISTS `node_revision__comment`;
CREATE TABLE `node_revision__comment` (   `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',   `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',   `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',   `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',   `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',   `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',   `comment_status` int(11) NOT NULL DEFAULT '0' COMMENT 'Whether comments are allowed on this entity: 0 = no, 1 = closed (read only), 2 = open (read/write).',   PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),   KEY `bundle` (`bundle`),   KEY `revision_id` (`revision_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for node field comment.';
DROP TABLE IF EXISTS `node_revision__field_image`;
CREATE TABLE `node_revision__field_image` (   `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',   `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',   `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',   `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',   `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',   `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',   `field_image_target_id` int(10) unsigned NOT NULL COMMENT 'The ID of the file entity.',   `field_image_alt` varchar(512) DEFAULT NULL COMMENT 'Alternative image text, for the image''s ''alt'' attribute.',   `field_image_title` varchar(1024) DEFAULT NULL COMMENT 'Image title text, for the image''s ''title'' attribute.',   `field_image_width` int(10) unsigned DEFAULT NULL COMMENT 'The width of the image in pixels.',   `field_image_height` int(10) unsigned DEFAULT NULL COMMENT 'The height of the image in pixels.',   PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),   KEY `bundle` (`bundle`),   KEY `revision_id` (`revision_id`),   KEY `field_image_target_id` (`field_image_target_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for node field field_image.';
DROP TABLE IF EXISTS `node_revision__field_tags`;
CREATE TABLE `node_revision__field_tags` (   `bundle` varchar(128) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The field instance bundle to which this row belongs, used when deleting a field instance',   `deleted` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'A boolean indicating whether this data item has been deleted',   `entity_id` int(10) unsigned NOT NULL COMMENT 'The entity id this data is attached to',   `revision_id` int(10) unsigned NOT NULL COMMENT 'The entity revision id this data is attached to',   `langcode` varchar(32) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The language code for this data item.',   `delta` int(10) unsigned NOT NULL COMMENT 'The sequence number for this data item, used for multi-value fields',   `field_tags_target_id` int(10) unsigned NOT NULL COMMENT 'The ID of the target entity.',   PRIMARY KEY (`entity_id`,`revision_id`,`deleted`,`delta`,`langcode`),   KEY `bundle` (`bundle`),   KEY `revision_id` (`revision_id`),   KEY `field_tags_target_id` (`field_tags_target_id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Revision archive storage for node field field_tags.';
DROP TABLE IF EXISTS `path_alias`;
CREATE TABLE `path_alias` (   `id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `revision_id` int(10) unsigned DEFAULT NULL,   `uuid` varchar(128) CHARACTER SET ascii NOT NULL,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `path` varchar(255) DEFAULT NULL,   `alias` varchar(255) DEFAULT NULL,   `status` tinyint(4) NOT NULL,   PRIMARY KEY (`id`),   UNIQUE KEY `path_alias_field__uuid__value` (`uuid`),   UNIQUE KEY `path_alias__revision_id` (`revision_id`),   KEY `path_alias__status` (`status`,`id`),   KEY `path_alias__alias_langcode_id_status` (`alias`(191),`langcode`,`id`,`status`),   KEY `path_alias__path_langcode_id_status` (`path`(191),`langcode`,`id`,`status`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The base table for path_alias entities.' AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `path_alias_revision`;
CREATE TABLE `path_alias_revision` (   `id` int(10) unsigned NOT NULL,   `revision_id` int(10) unsigned NOT NULL AUTO_INCREMENT,   `langcode` varchar(12) CHARACTER SET ascii NOT NULL,   `path` varchar(255) DEFAULT NULL,   `alias` varchar(255) DEFAULT NULL,   `status` tinyint(4) NOT NULL,   `revision_default` tinyint(4) DEFAULT NULL,   PRIMARY KEY (`revision_id`),   KEY `path_alias__id` (`id`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='The revision table for path_alias entities.' AUTO_INCREMENT=1;
DROP TABLE IF EXISTS `queue`;
CREATE TABLE `queue` (   `item_id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key: Unique item ID.',   `name` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'The queue name.',   `data` longblob COMMENT 'The arbitrary data for the item.',   `expire` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp when the claim lease expires on the item.',   `created` int(11) NOT NULL DEFAULT '0' COMMENT 'Timestamp when the item was created.',   PRIMARY KEY (`item_id`),   KEY `name_created` (`name`,`created`),   KEY `expire` (`expire`) ) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COMMENT='Stores items in queues.' AUTO_INCREMENT=45;
DROP TABLE IF EXISTS `router`;
CREATE TABLE `router` (   `name` varchar(255) CHARACTER SET ascii NOT NULL DEFAULT '' COMMENT 'Primary Key: Machine name of this route',   `path` varchar(255) NOT NULL DEFAULT '' COMMENT 'The path for this URI',   `pattern_outline` varchar(255) NOT NULL DEFAULT '' COMMENT 'The pattern',   `fit` int(11) NOT NULL DEFAULT '0' COMMENT 'A numeric representation of how specific the path is.',   `route` longblob COMMENT 'A serialized Route object',   `number_parts` smallint(6) NOT NULL DEFAULT '0' COMMENT 'Number of parts in this router path.',   PRIMARY KEY (`name`),   KEY `pattern_outline_parts` (`pattern_outline`(191),`number_parts`) ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='Maps paths to various callbacks (access, page and title)';
INSERT INTO `router` VALUES ('<button>','/','/','1','C:31:"Symfony\\Component\\Routing\\Route":743:{a:9:{s:4:"path";s:1:"/";s:4:"host";s:0:"";s:8:"defaults";a:0:{}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:8:"_no_path";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":297:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:8:"#^/$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:1:"/";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:1:"/";s:8:"numParts";i:1;}}}}','1'),('<current>','/<current>','/<current>','1','C:31:"Symfony\\Component\\Routing\\Route":681:{a:9:{s:4:"path";s:10:"/<current>";s:4:"host";s:0:"";s:8:"defaults";a:0:{}s:12:"requirements";a:0:{}s:7:"options";a:2:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":329:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:19:"#^/\\<current\\>$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:10:"/<current>";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:10:"/<current>";s:8:"numParts";i:1;}}}}','1'),('<front>','/','/','1','C:31:"Symfony\\Component\\Routing\\Route":748:{a:9:{s:4:"path";s:1:"/";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:6:"_title";s:4:"Home";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":297:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:8:"#^/$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:1:"/";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:1:"/";s:8:"numParts";i:1;}}}}','1');
INSERT INTO `router` VALUES ('<nolink>','/','/','1','C:31:"Symfony\\Component\\Routing\\Route":743:{a:9:{s:4:"path";s:1:"/";s:4:"host";s:0:"";s:8:"defaults";a:0:{}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:8:"_no_path";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":297:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:8:"#^/$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:1:"/";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:1:"/";s:8:"numParts";i:1;}}}}','1'),('<none>','/','/','1','C:31:"Symfony\\Component\\Routing\\Route":743:{a:9:{s:4:"path";s:1:"/";s:4:"host";s:0:"";s:8:"defaults";a:0:{}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:8:"_no_path";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":297:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:8:"#^/$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:1:"/";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:1:"/";s:8:"numParts";i:1;}}}}','1'),('backup_migrate.advanced_backup','/admin/config/development/backup_migrate/advanced','/admin/config/development/backup_migrate/advanced','31','C:31:"Symfony\\Component\\Routing\\Route":1079:{a:9:{s:4:"path";s:49:"/admin/config/development/backup_migrate/advanced";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:59:"\\Drupal\\backup_migrate\\Form\\BackupMigrateAdvancedBackupForm";s:6:"_title";s:15:"Advanced Backup";}s:12:"requirements";a:1:{s:11:"_permission";s:14:"perform backup";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":445:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:56:"#^/admin/config/development/backup_migrate/advanced$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:49:"/admin/config/development/backup_migrate/advanced";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:31;s:14:"patternOutline";s:49:"/admin/config/development/backup_migrate/advanced";s:8:"numParts";i:5;}}}}','5');
INSERT INTO `router` VALUES ('backup_migrate.backups','/admin/config/development/backup_migrate/backups','/admin/config/development/backup_migrate/backups','31','C:31:"Symfony\\Component\\Routing\\Route":1078:{a:9:{s:4:"path";s:48:"/admin/config/development/backup_migrate/backups";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:59:"\\Drupal\\backup_migrate\\Controller\\BackupController::listAll";s:6:"_title";s:7:"Backups";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"access backup files";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":442:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:55:"#^/admin/config/development/backup_migrate/backups$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:48:"/admin/config/development/backup_migrate/backups";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:31;s:14:"patternOutline";s:48:"/admin/config/development/backup_migrate/backups";s:8:"numParts";i:5;}}}}','5'),('backup_migrate.quick_backup','/admin/config/development/backup_migrate','/admin/config/development/backup_migrate','15','C:31:"Symfony\\Component\\Routing\\Route":1043:{a:9:{s:4:"path";s:40:"/admin/config/development/backup_migrate";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:56:"\\Drupal\\backup_migrate\\Form\\BackupMigrateQuickBackupForm";s:6:"_title";s:18:"Backup and Migrate";}s:12:"requirements";a:1:{s:11:"_permission";s:14:"perform backup";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":418:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:47:"#^/admin/config/development/backup_migrate$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:40:"/admin/config/development/backup_migrate";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:40:"/admin/config/development/backup_migrate";s:8:"numParts";i:4;}}}}','4');
INSERT INTO `router` VALUES ('backup_migrate.restore','/admin/config/development/backup_migrate/restore','/admin/config/development/backup_migrate/restore','31','C:31:"Symfony\\Component\\Routing\\Route":1064:{a:9:{s:4:"path";s:48:"/admin/config/development/backup_migrate/restore";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:52:"\\Drupal\\backup_migrate\\Form\\BackupMigrateRestoreForm";s:6:"_title";s:7:"Restore";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"restore from backup";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":442:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:55:"#^/admin/config/development/backup_migrate/restore$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:48:"/admin/config/development/backup_migrate/restore";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:31;s:14:"patternOutline";s:48:"/admin/config/development/backup_migrate/restore";s:8:"numParts";i:5;}}}}','5'),('big_pipe.nojs','/big_pipe/no-js','/big_pipe/no-js','3','C:31:"Symfony\\Component\\Routing\\Route":930:{a:9:{s:4:"path";s:15:"/big_pipe/no-js";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:59:"\\Drupal\\big_pipe\\Controller\\BigPipeController:setNoJsCookie";s:6:"_title";s:19:"BigPipe no-JS check";}s:12:"requirements";a:1:{s:7:"_access";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:8:"no_cache";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:20:"access_check.default";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":343:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:23:"#^/big_pipe/no\\-js$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:15:"/big_pipe/no-js";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:15:"/big_pipe/no-js";s:8:"numParts";i:2;}}}}','2');
INSERT INTO `router` VALUES ('block.admin_add','/admin/structure/block/add/{plugin_id}/{theme}','/admin/structure/block/add/%','30','C:31:"Symfony\\Component\\Routing\\Route":1325:{a:9:{s:4:"path";s:46:"/admin/structure/block/add/{plugin_id}/{theme}";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:11:"_controller";s:66:"\\Drupal\\block\\Controller\\BlockAddController::blockAddConfigureForm";s:5:"theme";N;s:6:"_title";s:15:"Configure block";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":663:{a:11:{s:4:"vars";a:2:{i:0;s:9:"plugin_id";i:1;s:5:"theme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:78:"#^/admin/structure/block/add/(?P<plugin_id>[^/]++)(?:/(?P<theme>[^/]++))?$#sDu";s:11:"path_tokens";a:3:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"theme";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"plugin_id";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:26:"/admin/structure/block/add";}}s:9:"path_vars";a:2:{i:0;s:9:"plugin_id";i:1;s:5:"theme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:28:"/admin/structure/block/add/%";s:8:"numParts";i:6;}}}}','6'),('block.admin_demo','/admin/structure/block/demo/{theme}','/admin/structure/block/demo/%','30','C:31:"Symfony\\Component\\Routing\\Route":1208:{a:9:{s:4:"path";s:35:"/admin/structure/block/demo/{theme}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:46:"\\Drupal\\block\\Controller\\BlockController::demo";s:15:"_title_callback";s:21:"theme_handler:getName";}s:12:"requirements";a:2:{s:13:"_access_theme";s:4:"TRUE";s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:0;s:4:"utf8";b:1;s:14:"_access_checks";a:2:{i:0;s:18:"access_check.theme";i:1;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":513:{a:11:{s:4:"vars";a:1:{i:0;s:5:"theme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:52:"#^/admin/structure/block/demo/(?P<theme>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"theme";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/block/demo";}}s:9:"path_vars";a:1:{i:0;s:5:"theme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:29:"/admin/structure/block/demo/%";s:8:"numParts";i:5;}}}}','5');
INSERT INTO `router` VALUES ('block.admin_display','/admin/structure/block','/admin/structure/block','7','C:31:"Symfony\\Component\\Routing\\Route":971:{a:9:{s:4:"path";s:22:"/admin/structure/block";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:53:"\\Drupal\\block\\Controller\\BlockListController::listing";s:6:"_title";s:12:"Block layout";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":363:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:29:"#^/admin/structure/block$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:22:"/admin/structure/block";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:22:"/admin/structure/block";s:8:"numParts";i:3;}}}}','3'),('block.admin_display_theme','/admin/structure/block/list/{theme}','/admin/structure/block/list/%','30','C:31:"Symfony\\Component\\Routing\\Route":1196:{a:9:{s:4:"path";s:35:"/admin/structure/block/list/{theme}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:53:"\\Drupal\\block\\Controller\\BlockListController::listing";s:6:"_title";s:12:"Block layout";}s:12:"requirements";a:2:{s:13:"_access_theme";s:4:"TRUE";s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:18:"access_check.theme";i:1;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":513:{a:11:{s:4:"vars";a:1:{i:0;s:5:"theme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:52:"#^/admin/structure/block/list/(?P<theme>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"theme";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:27:"/admin/structure/block/list";}}s:9:"path_vars";a:1:{i:0;s:5:"theme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:29:"/admin/structure/block/list/%";s:8:"numParts";i:5;}}}}','5');
INSERT INTO `router` VALUES ('block.admin_library','/admin/structure/block/library/{theme}','/admin/structure/block/library/%','30','C:31:"Symfony\\Component\\Routing\\Route":1213:{a:9:{s:4:"path";s:38:"/admin/structure/block/library/{theme}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:59:"\\Drupal\\block\\Controller\\BlockLibraryController::listBlocks";s:6:"_title";s:11:"Place block";}s:12:"requirements";a:2:{s:13:"_access_theme";s:4:"TRUE";s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:18:"access_check.theme";i:1;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":522:{a:11:{s:4:"vars";a:1:{i:0;s:5:"theme";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:55:"#^/admin/structure/block/library/(?P<theme>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"theme";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:30:"/admin/structure/block/library";}}s:9:"path_vars";a:1:{i:0;s:5:"theme";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:32:"/admin/structure/block/library/%";s:8:"numParts";i:5;}}}}','5'),('block.category_autocomplete','/block-category/autocomplete','/block-category/autocomplete','3','C:31:"Symfony\\Component\\Routing\\Route":955:{a:9:{s:4:"path";s:28:"/block-category/autocomplete";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:69:"\\Drupal\\block\\Controller\\CategoryAutocompleteController::autocomplete";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":382:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"#^/block\\-category/autocomplete$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:28:"/block-category/autocomplete";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:28:"/block-category/autocomplete";s:8:"numParts";i:2;}}}}','2');
INSERT INTO `router` VALUES ('block_content.add_form','/block/add/{block_content_type}','/block/add/%','6','C:31:"Symfony\\Component\\Routing\\Route":1401:{a:9:{s:4:"path";s:31:"/block/add/{block_content_type}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:64:"\\Drupal\\block_content\\Controller\\BlockContentController::addForm";s:15:"_title_callback";s:72:"\\Drupal\\block_content\\Controller\\BlockContentController::getAddFormTitle";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:10:"parameters";a:1:{s:18:"block_content_type";a:2:{s:4:"type";s:25:"entity:block_content_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":516:{a:11:{s:4:"vars";a:1:{i:0;s:18:"block_content_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:48:"#^/block/add/(?P<block_content_type>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:18:"block_content_type";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:10:"/block/add";}}s:9:"path_vars";a:1:{i:0;s:18:"block_content_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:6;s:14:"patternOutline";s:12:"/block/add/%";s:8:"numParts";i:3;}}}}','3'),('block_content.add_page','/block/add','/block/add','3','C:31:"Symfony\\Component\\Routing\\Route":934:{a:9:{s:4:"path";s:10:"/block/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:60:"\\Drupal\\block_content\\Controller\\BlockContentController::add";s:6:"_title";s:16:"Add custom block";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":327:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:17:"#^/block/add$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:10:"/block/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:10:"/block/add";s:8:"numParts";i:2;}}}}','2');
INSERT INTO `router` VALUES ('block_content.type_add','/admin/structure/block/block-content/types/add','/admin/structure/block/block-content/types/add','63','C:31:"Symfony\\Component\\Routing\\Route":1029:{a:9:{s:4:"path";s:46:"/admin/structure/block/block-content/types/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:22:"block_content_type.add";s:6:"_title";s:3:"Add";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":437:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:54:"#^/admin/structure/block/block\\-content/types/add$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:46:"/admin/structure/block/block-content/types/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:46:"/admin/structure/block/block-content/types/add";s:8:"numParts";i:6;}}}}','6'),('comment.admin','/admin/content/comment','/admin/content/comment','7','C:31:"Symfony\\Component\\Routing\\Route":1292:{a:9:{s:4:"path";s:22:"/admin/content/comment";s:4:"host";s:0:"";s:8:"defaults";a:5:{s:11:"_controller";s:47:"Drupal\\views\\Routing\\ViewPageController::handle";s:6:"_title";s:8:"Comments";s:7:"view_id";s:7:"comment";s:10:"display_id";s:14:"page_published";s:30:"_view_display_show_admin_links";b:1;}s:12:"requirements";a:2:{s:11:"_permission";s:19:"administer comments";s:7:"_format";s:4:"html";}s:7:"options";a:9:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:18:"_view_argument_map";a:0:{}s:23:"_view_display_plugin_id";s:4:"page";s:26:"_view_display_plugin_class";s:38:"Drupal\\views\\Plugin\\views\\display\\Page";s:30:"_view_display_show_admin_links";b:1;s:16:"returns_response";b:0;s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":363:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:29:"#^/admin/content/comment$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:22:"/admin/content/comment";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:22:"/admin/content/comment";s:8:"numParts";i:3;}}}}','3');
INSERT INTO `router` VALUES ('comment.admin_approval','/admin/content/comment/approval','/admin/content/comment/approval','15','C:31:"Symfony\\Component\\Routing\\Route":1330:{a:9:{s:4:"path";s:31:"/admin/content/comment/approval";s:4:"host";s:0:"";s:8:"defaults";a:5:{s:11:"_controller";s:47:"Drupal\\views\\Routing\\ViewPageController::handle";s:6:"_title";s:8:"Comments";s:7:"view_id";s:7:"comment";s:10:"display_id";s:15:"page_unapproved";s:30:"_view_display_show_admin_links";b:1;}s:12:"requirements";a:2:{s:11:"_permission";s:19:"administer comments";s:7:"_format";s:4:"html";}s:7:"options";a:9:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:18:"_view_argument_map";a:0:{}s:23:"_view_display_plugin_id";s:4:"page";s:26:"_view_display_plugin_class";s:38:"Drupal\\views\\Plugin\\views\\display\\Page";s:30:"_view_display_show_admin_links";b:1;s:16:"returns_response";b:0;s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":391:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:38:"#^/admin/content/comment/approval$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/content/comment/approval";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:31:"/admin/content/comment/approval";s:8:"numParts";i:4;}}}}','4'),('comment.approve','/comment/{comment}/approve','/comment/%/approve','5','C:31:"Symfony\\Component\\Routing\\Route":1340:{a:9:{s:4:"path";s:26:"/comment/{comment}/approve";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:6:"_title";s:7:"Approve";s:11:"_controller";s:60:"\\Drupal\\comment\\Controller\\CommentController::commentApprove";s:11:"entity_type";s:7:"comment";}s:12:"requirements";a:3:{s:14:"_entity_access";s:15:"comment.approve";s:11:"_csrf_token";s:4:"TRUE";s:7:"comment";s:3:"\\d+";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:7:"comment";a:2:{s:4:"type";s:14:"entity:comment";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":516:{a:11:{s:4:"vars";a:1:{i:0;s:7:"comment";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:40:"#^/comment/(?P<comment>\\d+)/approve$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:8:"/approve";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:7:"comment";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:8:"/comment";}}s:9:"path_vars";a:1:{i:0;s:7:"comment";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:18:"/comment/%/approve";s:8:"numParts";i:3;}}}}','3');
INSERT INTO `router` VALUES ('comment.multiple_delete_confirm','/admin/content/comment/delete','/admin/content/comment/delete','15','C:31:"Symfony\\Component\\Routing\\Route":1031:{a:9:{s:4:"path";s:29:"/admin/content/comment/delete";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:6:"_title";s:6:"Delete";s:5:"_form";s:42:"\\Drupal\\comment\\Form\\ConfirmDeleteMultiple";s:14:"entity_type_id";s:7:"comment";}s:12:"requirements";a:1:{s:30:"_entity_delete_multiple_access";s:7:"comment";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:35:"access_check.entity_delete_multiple";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":385:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"#^/admin/content/comment/delete$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/content/comment/delete";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:29:"/admin/content/comment/delete";s:8:"numParts";i:4;}}}}','4'),('comment.new_comments_node_links','/comments/render_new_comments_node_links','/comments/render_new_comments_node_links','3','C:31:"Symfony\\Component\\Routing\\Route":1002:{a:9:{s:4:"path";s:40:"/comments/render_new_comments_node_links";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:72:"\\Drupal\\comment\\Controller\\CommentController::renderNewCommentsNodeLinks";}s:12:"requirements";a:1:{s:11:"_permission";s:14:"access content";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":417:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:47:"#^/comments/render_new_comments_node_links$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:40:"/comments/render_new_comments_node_links";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:40:"/comments/render_new_comments_node_links";s:8:"numParts";i:2;}}}}','2');
INSERT INTO `router` VALUES ('comment.node_redirect','/comment/{node}/reply','/comment/%/reply','5','C:31:"Symfony\\Component\\Routing\\Route":1219:{a:9:{s:4:"path";s:21:"/comment/{node}/reply";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:58:"\\Drupal\\comment\\Controller\\CommentController::redirectNode";}s:12:"requirements";a:3:{s:14:"_entity_access";s:9:"node.view";s:20:"_module_dependencies";s:4:"node";s:4:"node";s:3:"\\d+";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:4:"node";a:2:{s:4:"type";s:11:"entity:node";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":498:{a:11:{s:4:"vars";a:1:{i:0;s:4:"node";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:35:"#^/comment/(?P<node>\\d+)/reply$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:6:"/reply";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:4:"node";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:8:"/comment";}}s:9:"path_vars";a:1:{i:0;s:4:"node";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:16:"/comment/%/reply";s:8:"numParts";i:3;}}}}','3'),('comment.reply','/comment/reply/{entity_type}/{entity}/{field_name}/{pid}','/comment/reply/%/%/%','24','C:31:"Symfony\\Component\\Routing\\Route":1776:{a:9:{s:4:"path";s:56:"/comment/reply/{entity_type}/{entity}/{field_name}/{pid}";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:11:"_controller";s:58:"\\Drupal\\comment\\Controller\\CommentController::getReplyForm";s:6:"_title";s:15:"Add new comment";s:3:"pid";N;}s:12:"requirements";a:1:{s:14:"_custom_access";s:61:"\\Drupal\\comment\\Controller\\CommentController::replyFormAccess";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:6:"entity";a:2:{s:4:"type";s:20:"entity:{entity_type}";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.custom";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":926:{a:11:{s:4:"vars";a:4:{i:0;s:11:"entity_type";i:1;s:6:"entity";i:2;s:10:"field_name";i:3;s:3:"pid";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:108:"#^/comment/reply/(?P<entity_type>[^/]++)/(?P<entity>[^/]++)/(?P<field_name>[^/]++)(?:/(?P<pid>[^/]++))?$#sDu";s:11:"path_tokens";a:5:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:3:"pid";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:10:"field_name";i:4;b:1;}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:6:"entity";i:4;b:1;}i:3;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"entity_type";i:4;b:1;}i:4;a:2:{i:0;s:4:"text";i:1;s:14:"/comment/reply";}}s:9:"path_vars";a:4:{i:0;s:11:"entity_type";i:1;s:6:"entity";i:2;s:10:"field_name";i:3;s:3:"pid";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:24;s:14:"patternOutline";s:20:"/comment/reply/%/%/%";s:8:"numParts";i:6;}}}}','6');
INSERT INTO `router` VALUES ('config.diff','/admin/config/development/configuration/sync/diff/{source_name}/{target_name}','/admin/config/development/configuration/sync/diff/%','126','C:31:"Symfony\\Component\\Routing\\Route":1426:{a:9:{s:4:"path";s:77:"/admin/config/development/configuration/sync/diff/{source_name}/{target_name}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:48:"\\Drupal\\config\\Controller\\ConfigController::diff";s:11:"target_name";N;}s:12:"requirements";a:1:{s:11:"_permission";s:25:"synchronize configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":772:{a:11:{s:4:"vars";a:2:{i:0;s:11:"source_name";i:1;s:11:"target_name";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:109:"#^/admin/config/development/configuration/sync/diff/(?P<source_name>[^/]++)(?:/(?P<target_name>[^/]++))?$#sDu";s:11:"path_tokens";a:3:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"target_name";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"source_name";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:49:"/admin/config/development/configuration/sync/diff";}}s:9:"path_vars";a:2:{i:0;s:11:"source_name";i:1;s:11:"target_name";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:126;s:14:"patternOutline";s:51:"/admin/config/development/configuration/sync/diff/%";s:8:"numParts";i:8;}}}}','8'),('config.diff_collection','/admin/config/development/configuration/sync/diff_collection/{collection}/{source_name}/{target_name}','/admin/config/development/configuration/sync/diff_collection/%/%','252','C:31:"Symfony\\Component\\Routing\\Route":1641:{a:9:{s:4:"path";s:101:"/admin/config/development/configuration/sync/diff_collection/{collection}/{source_name}/{target_name}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:48:"\\Drupal\\config\\Controller\\ConfigController::diff";s:11:"target_name";N;}s:12:"requirements";a:1:{s:11:"_permission";s:25:"synchronize configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":962:{a:11:{s:4:"vars";a:3:{i:0;s:10:"collection";i:1;s:11:"source_name";i:2;s:11:"target_name";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:143:"#^/admin/config/development/configuration/sync/diff_collection/(?P<collection>[^/]++)/(?P<source_name>[^/]++)(?:/(?P<target_name>[^/]++))?$#sDu";s:11:"path_tokens";a:4:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"target_name";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"source_name";i:4;b:1;}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:10:"collection";i:4;b:1;}i:3;a:2:{i:0;s:4:"text";i:1;s:60:"/admin/config/development/configuration/sync/diff_collection";}}s:9:"path_vars";a:3:{i:0;s:10:"collection";i:1;s:11:"source_name";i:2;s:11:"target_name";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:252;s:14:"patternOutline";s:64:"/admin/config/development/configuration/sync/diff_collection/%/%";s:8:"numParts";i:9;}}}}','9');
INSERT INTO `router` VALUES ('config.export_download','/admin/config/development/configuration/full/export-download','/admin/config/development/configuration/full/export-download','63','C:31:"Symfony\\Component\\Routing\\Route":1100:{a:9:{s:4:"path";s:60:"/admin/config/development/configuration/full/export-download";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:58:"\\Drupal\\config\\Controller\\ConfigController::downloadExport";}s:12:"requirements";a:1:{s:11:"_permission";s:20:"export configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":479:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:68:"#^/admin/config/development/configuration/full/export\\-download$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:60:"/admin/config/development/configuration/full/export-download";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:60:"/admin/config/development/configuration/full/export-download";s:8:"numParts";i:6;}}}}','6'),('config.export_full','/admin/config/development/configuration/full/export','/admin/config/development/configuration/full/export','63','C:31:"Symfony\\Component\\Routing\\Route":1060:{a:9:{s:4:"path";s:51:"/admin/config/development/configuration/full/export";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:36:"\\Drupal\\config\\Form\\ConfigExportForm";s:6:"_title";s:6:"Export";}s:12:"requirements";a:1:{s:11:"_permission";s:20:"export configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":451:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:58:"#^/admin/config/development/configuration/full/export$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:51:"/admin/config/development/configuration/full/export";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:51:"/admin/config/development/configuration/full/export";s:8:"numParts";i:6;}}}}','6');
INSERT INTO `router` VALUES ('config.export_single','/admin/config/development/configuration/single/export/{config_type}/{config_name}','/admin/config/development/configuration/single/export','63','C:31:"Symfony\\Component\\Routing\\Route":1481:{a:9:{s:4:"path";s:81:"/admin/config/development/configuration/single/export/{config_type}/{config_name}";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:6:"_title";s:13:"Single export";s:5:"_form";s:42:"\\Drupal\\config\\Form\\ConfigSingleExportForm";s:11:"config_type";N;s:11:"config_name";N;}s:12:"requirements";a:1:{s:11:"_permission";s:20:"export configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":786:{a:11:{s:4:"vars";a:2:{i:0;s:11:"config_type";i:1;s:11:"config_name";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:118:"#^/admin/config/development/configuration/single/export(?:/(?P<config_type>[^/]++)(?:/(?P<config_name>[^/]++))?)?$#sDu";s:11:"path_tokens";a:3:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"config_name";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"config_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:53:"/admin/config/development/configuration/single/export";}}s:9:"path_vars";a:2:{i:0;s:11:"config_type";i:1;s:11:"config_name";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:53:"/admin/config/development/configuration/single/export";s:8:"numParts";i:8;}}}}','8'),('config.import_full','/admin/config/development/configuration/full/import','/admin/config/development/configuration/full/import','63','C:31:"Symfony\\Component\\Routing\\Route":1060:{a:9:{s:4:"path";s:51:"/admin/config/development/configuration/full/import";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:36:"\\Drupal\\config\\Form\\ConfigImportForm";s:6:"_title";s:6:"Import";}s:12:"requirements";a:1:{s:11:"_permission";s:20:"import configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":451:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:58:"#^/admin/config/development/configuration/full/import$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:51:"/admin/config/development/configuration/full/import";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:51:"/admin/config/development/configuration/full/import";s:8:"numParts";i:6;}}}}','6');
INSERT INTO `router` VALUES ('config.import_single','/admin/config/development/configuration/single/import','/admin/config/development/configuration/single/import','63','C:31:"Symfony\\Component\\Routing\\Route":1082:{a:9:{s:4:"path";s:53:"/admin/config/development/configuration/single/import";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:13:"Single import";s:5:"_form";s:42:"\\Drupal\\config\\Form\\ConfigSingleImportForm";}s:12:"requirements";a:1:{s:11:"_permission";s:20:"import configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":457:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:60:"#^/admin/config/development/configuration/single/import$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:53:"/admin/config/development/configuration/single/import";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:53:"/admin/config/development/configuration/single/import";s:8:"numParts";i:6;}}}}','6'),('config.sync','/admin/config/development/configuration','/admin/config/development/configuration','15','C:31:"Symfony\\Component\\Routing\\Route":1017:{a:9:{s:4:"path";s:39:"/admin/config/development/configuration";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:30:"\\Drupal\\config\\Form\\ConfigSync";s:6:"_title";s:11:"Synchronize";}s:12:"requirements";a:1:{s:11:"_permission";s:25:"synchronize configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":415:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:46:"#^/admin/config/development/configuration$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:39:"/admin/config/development/configuration";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:39:"/admin/config/development/configuration";s:8:"numParts";i:4;}}}}','4');
INSERT INTO `router` VALUES ('contact.form_add','/admin/structure/contact/add','/admin/structure/contact/add','15','C:31:"Symfony\\Component\\Routing\\Route":971:{a:9:{s:4:"path";s:28:"/admin/structure/contact/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:16:"contact_form.add";s:6:"_title";s:16:"Add contact form";}s:12:"requirements";a:1:{s:11:"_permission";s:24:"administer contact forms";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":382:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:35:"#^/admin/structure/contact/add$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:28:"/admin/structure/contact/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:28:"/admin/structure/contact/add";s:8:"numParts";i:4;}}}}','4'),('contact.site_page','/contact','/contact','1','C:31:"Symfony\\Component\\Routing\\Route":1057:{a:9:{s:4:"path";s:8:"/contact";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:6:"_title";s:7:"Contact";s:11:"_controller";s:61:"\\Drupal\\contact\\Controller\\ContactController::contactSitePage";s:12:"contact_form";N;}s:12:"requirements";a:1:{s:11:"_permission";s:29:"access site-wide contact form";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:12:"contact_form";a:2:{s:4:"type";s:19:"entity:contact_form";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":319:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:15:"#^/contact$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:8:"/contact";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1;s:14:"patternOutline";s:8:"/contact";s:8:"numParts";i:1;}}}}','1');
INSERT INTO `router` VALUES ('contextual.render','/contextual/render','/contextual/render','3','C:31:"Symfony\\Component\\Routing\\Route":898:{a:9:{s:4:"path";s:18:"/contextual/render";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:47:"\\Drupal\\contextual\\ContextualController::render";}s:12:"requirements";a:1:{s:11:"_permission";s:23:"access contextual links";}s:7:"options";a:3:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":351:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:25:"#^/contextual/render$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:18:"/contextual/render";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:3;s:14:"patternOutline";s:18:"/contextual/render";s:8:"numParts";i:2;}}}}','2'),('dblog.access_denied','/admin/reports/access-denied','/admin/reports/access-denied','7','C:31:"Symfony\\Component\\Routing\\Route":1047:{a:9:{s:4:"path";s:28:"/admin/reports/access-denied";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:6:"_title";s:26:"Top ''access denied'' errors";s:11:"_controller";s:56:"\\Drupal\\dblog\\Controller\\DbLogController::topLogMessages";s:4:"type";s:13:"access denied";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":382:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"#^/admin/reports/access\\-denied$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:28:"/admin/reports/access-denied";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:28:"/admin/reports/access-denied";s:8:"numParts";i:3;}}}}','3');
INSERT INTO `router` VALUES ('dblog.confirm','/admin/reports/dblog/confirm','/admin/reports/dblog/confirm','15','C:31:"Symfony\\Component\\Routing\\Route":1003:{a:9:{s:4:"path";s:28:"/admin/reports/dblog/confirm";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:43:"\\Drupal\\dblog\\Form\\DblogClearLogConfirmForm";s:6:"_title";s:34:"Confirm delete recent log messages";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":382:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:35:"#^/admin/reports/dblog/confirm$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:28:"/admin/reports/dblog/confirm";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:28:"/admin/reports/dblog/confirm";s:8:"numParts";i:4;}}}}','4'),('dblog.event','/admin/reports/dblog/event/{event_id}','/admin/reports/dblog/event/%','30','C:31:"Symfony\\Component\\Routing\\Route":1142:{a:9:{s:4:"path";s:37:"/admin/reports/dblog/event/{event_id}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:54:"\\Drupal\\dblog\\Controller\\DbLogController::eventDetails";s:6:"_title";s:7:"Details";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":522:{a:11:{s:4:"vars";a:1:{i:0;s:8:"event_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:54:"#^/admin/reports/dblog/event/(?P<event_id>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:8:"event_id";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:26:"/admin/reports/dblog/event";}}s:9:"path_vars";a:1:{i:0;s:8:"event_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:28:"/admin/reports/dblog/event/%";s:8:"numParts";i:5;}}}}','5');
INSERT INTO `router` VALUES ('dblog.overview','/admin/reports/dblog','/admin/reports/dblog','7','C:31:"Symfony\\Component\\Routing\\Route":1286:{a:9:{s:4:"path";s:20:"/admin/reports/dblog";s:4:"host";s:0:"";s:8:"defaults";a:5:{s:11:"_controller";s:47:"Drupal\\views\\Routing\\ViewPageController::handle";s:6:"_title";s:19:"Recent log messages";s:7:"view_id";s:8:"watchdog";s:10:"display_id";s:4:"page";s:30:"_view_display_show_admin_links";b:1;}s:12:"requirements";a:2:{s:11:"_permission";s:19:"access site reports";s:7:"_format";s:4:"html";}s:7:"options";a:9:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:18:"_view_argument_map";a:0:{}s:23:"_view_display_plugin_id";s:4:"page";s:26:"_view_display_plugin_class";s:38:"Drupal\\views\\Plugin\\views\\display\\Page";s:30:"_view_display_show_admin_links";b:1;s:16:"returns_response";b:0;s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":357:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:27:"#^/admin/reports/dblog$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:20:"/admin/reports/dblog";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:20:"/admin/reports/dblog";s:8:"numParts";i:3;}}}}','3'),('dblog.page_not_found','/admin/reports/page-not-found','/admin/reports/page-not-found','7','C:31:"Symfony\\Component\\Routing\\Route":1054:{a:9:{s:4:"path";s:29:"/admin/reports/page-not-found";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:6:"_title";s:27:"Top ''page not found'' errors";s:11:"_controller";s:56:"\\Drupal\\dblog\\Controller\\DbLogController::topLogMessages";s:4:"type";s:14:"page not found";}s:12:"requirements";a:1:{s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":386:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:38:"#^/admin/reports/page\\-not\\-found$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/reports/page-not-found";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:29:"/admin/reports/page-not-found";s:8:"numParts";i:3;}}}}','3');
INSERT INTO `router` VALUES ('dblog.search','/admin/reports/search','/admin/reports/search','7','C:31:"Symfony\\Component\\Routing\\Route":1043:{a:9:{s:4:"path";s:21:"/admin/reports/search";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:11:"_controller";s:56:"\\Drupal\\dblog\\Controller\\DbLogController::topLogMessages";s:6:"_title";s:18:"Top search phrases";s:4:"type";s:6:"search";}s:12:"requirements";a:2:{s:20:"_module_dependencies";s:6:"search";s:11:"_permission";s:19:"access site reports";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":360:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:28:"#^/admin/reports/search$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:21:"/admin/reports/search";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:21:"/admin/reports/search";s:8:"numParts";i:3;}}}}','3'),('editor.field_untransformed_text','/editor/{entity_type}/{entity}/{field_name}/{langcode}/{view_mode_id}','/editor/%/%/%/%/%','32','C:31:"Symfony\\Component\\Routing\\Route":1956:{a:9:{s:4:"path";s:69:"/editor/{entity_type}/{entity}/{field_name}/{langcode}/{view_mode_id}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:53:"\\Drupal\\editor\\EditorController::getUntransformedText";}s:12:"requirements";a:2:{s:11:"_permission";s:23:"access in-place editing";s:30:"_access_quickedit_entity_field";s:4:"TRUE";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:6:"entity";a:2:{s:4:"type";s:20:"entity:{entity_type}";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:4:"utf8";b:1;s:14:"_access_checks";a:2:{i:0;s:23:"access_check.permission";i:1;s:35:"access_check.quickedit.entity_field";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":1086:{a:11:{s:4:"vars";a:5:{i:0;s:11:"entity_type";i:1;s:6:"entity";i:2;s:10:"field_name";i:3;s:8:"langcode";i:4;s:12:"view_mode_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:126:"#^/editor/(?P<entity_type>[^/]++)/(?P<entity>[^/]++)/(?P<field_name>[^/]++)/(?P<langcode>[^/]++)/(?P<view_mode_id>[^/]++)$#sDu";s:11:"path_tokens";a:6:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"view_mode_id";i:4;b:1;}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:8:"langcode";i:4;b:1;}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:10:"field_name";i:4;b:1;}i:3;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:6:"entity";i:4;b:1;}i:4;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:11:"entity_type";i:4;b:1;}i:5;a:2:{i:0;s:4:"text";i:1;s:7:"/editor";}}s:9:"path_vars";a:5:{i:0;s:11:"entity_type";i:1;s:6:"entity";i:2;s:10:"field_name";i:3;s:8:"langcode";i:4;s:12:"view_mode_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:32;s:14:"patternOutline";s:17:"/editor/%/%/%/%/%";s:8:"numParts";i:6;}}}}','6');
INSERT INTO `router` VALUES ('editor.filter_xss','/editor/filter_xss/{filter_format}','/editor/filter_xss/%','6','C:31:"Symfony\\Component\\Routing\\Route":1206:{a:9:{s:4:"path";s:34:"/editor/filter_xss/{filter_format}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:11:"_controller";s:42:"\\Drupal\\editor\\EditorController::filterXss";}s:12:"requirements";a:1:{s:14:"_entity_access";s:17:"filter_format.use";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:13:"filter_format";a:2:{s:4:"type";s:20:"entity:filter_format";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":520:{a:11:{s:4:"vars";a:1:{i:0;s:13:"filter_format";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:51:"#^/editor/filter_xss/(?P<filter_format>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:13:"filter_format";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:18:"/editor/filter_xss";}}s:9:"path_vars";a:1:{i:0;s:13:"filter_format";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:6;s:14:"patternOutline";s:20:"/editor/filter_xss/%";s:8:"numParts";i:3;}}}}','3'),('editor.image_dialog','/editor/dialog/image/{editor}','/editor/dialog/image/%','14','C:31:"Symfony\\Component\\Routing\\Route":1176:{a:9:{s:4:"path";s:29:"/editor/dialog/image/{editor}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:37:"\\Drupal\\editor\\Form\\EditorImageDialog";s:6:"_title";s:12:"Upload image";}s:12:"requirements";a:1:{s:14:"_entity_access";s:10:"editor.use";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:6:"editor";a:2:{s:4:"type";s:13:"entity:editor";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":496:{a:11:{s:4:"vars";a:1:{i:0;s:6:"editor";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:46:"#^/editor/dialog/image/(?P<editor>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:6:"editor";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:20:"/editor/dialog/image";}}s:9:"path_vars";a:1:{i:0;s:6:"editor";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:14;s:14:"patternOutline";s:22:"/editor/dialog/image/%";s:8:"numParts";i:4;}}}}','4');
INSERT INTO `router` VALUES ('editor.link_dialog','/editor/dialog/link/{editor}','/editor/dialog/link/%','14','C:31:"Symfony\\Component\\Routing\\Route":1166:{a:9:{s:4:"path";s:28:"/editor/dialog/link/{editor}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:5:"_form";s:36:"\\Drupal\\editor\\Form\\EditorLinkDialog";s:6:"_title";s:8:"Add link";}s:12:"requirements";a:1:{s:14:"_entity_access";s:10:"editor.use";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:6:"editor";a:2:{s:4:"type";s:13:"entity:editor";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":493:{a:11:{s:4:"vars";a:1:{i:0;s:6:"editor";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:45:"#^/editor/dialog/link/(?P<editor>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:6:"editor";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:19:"/editor/dialog/link";}}s:9:"path_vars";a:1:{i:0;s:6:"editor";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:14;s:14:"patternOutline";s:21:"/editor/dialog/link/%";s:8:"numParts";i:4;}}}}','4'),('entity.backup_migrate_destination.add_form','/admin/config/development/backup_migrate/settings/destination/add','/admin/config/development/backup_migrate/settings/destination/add','127','C:31:"Symfony\\Component\\Routing\\Route":1142:{a:9:{s:4:"path";s:65:"/admin/config/development/backup_migrate/settings/destination/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:34:"backup_migrate_destination.default";s:6:"_title";s:15:"Add destination";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":494:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:72:"#^/admin/config/development/backup_migrate/settings/destination/add$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:65:"/admin/config/development/backup_migrate/settings/destination/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:127;s:14:"patternOutline";s:65:"/admin/config/development/backup_migrate/settings/destination/add";s:8:"numParts";i:7;}}}}','7');
INSERT INTO `router` VALUES ('entity.backup_migrate_destination.backups','/admin/config/development/backup_migrate/settings/destination/backups/{backup_migrate_destination}','/admin/config/development/backup_migrate/settings/destination/backups/%','254','C:31:"Symfony\\Component\\Routing\\Route":1737:{a:9:{s:4:"path";s:98:"/admin/config/development/backup_migrate/settings/destination/backups/{backup_migrate_destination}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:80:"\\Drupal\\backup_migrate\\Controller\\BackupController::listDestinationEntityBackups";s:15:"_title_callback";s:85:"\\Drupal\\backup_migrate\\Controller\\BackupController::listDestinationEntityBackupsTitle";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:26:"backup_migrate_destination";a:2:{s:4:"type";s:33:"entity:backup_migrate_destination";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":728:{a:11:{s:4:"vars";a:1:{i:0;s:26:"backup_migrate_destination";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:115:"#^/admin/config/development/backup_migrate/settings/destination/backups/(?P<backup_migrate_destination>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:26:"backup_migrate_destination";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:69:"/admin/config/development/backup_migrate/settings/destination/backups";}}s:9:"path_vars";a:1:{i:0;s:26:"backup_migrate_destination";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:254;s:14:"patternOutline";s:71:"/admin/config/development/backup_migrate/settings/destination/backups/%";s:8:"numParts";i:8;}}}}','8');
INSERT INTO `router` VALUES ('entity.backup_migrate_destination.backup_delete','/admin/config/development/backup_migrate/settings/destination/backups/{backup_migrate_destination}/delete/{backup_id}','/admin/config/development/backup_migrate/settings/destination/backups/%/delete/%','1018','C:31:"Symfony\\Component\\Routing\\Route":1807:{a:9:{s:4:"path";s:117:"/admin/config/development/backup_migrate/settings/destination/backups/{backup_migrate_destination}/delete/{backup_id}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:5:"_form";s:44:"\\Drupal\\backup_migrate\\Form\\BackupDeleteForm";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:26:"backup_migrate_destination";a:2:{s:4:"type";s:33:"entity:backup_migrate_destination";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":937:{a:11:{s:4:"vars";a:2:{i:0;s:26:"backup_migrate_destination";i:1;s:9:"backup_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:144:"#^/admin/config/development/backup_migrate/settings/destination/backups/(?P<backup_migrate_destination>[^/]++)/delete/(?P<backup_id>[^/]++)$#sDu";s:11:"path_tokens";a:4:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"backup_id";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:26:"backup_migrate_destination";i:4;b:1;}i:3;a:2:{i:0;s:4:"text";i:1;s:69:"/admin/config/development/backup_migrate/settings/destination/backups";}}s:9:"path_vars";a:2:{i:0;s:26:"backup_migrate_destination";i:1;s:9:"backup_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1018;s:14:"patternOutline";s:80:"/admin/config/development/backup_migrate/settings/destination/backups/%/delete/%";s:8:"numParts";i:10;}}}}','10');
INSERT INTO `router` VALUES ('entity.backup_migrate_destination.backup_download','/admin/config/development/backup_migrate/settings/destination/backups/{backup_migrate_destination}/download/{backup_id}','/admin/config/development/backup_migrate/settings/destination/backups/%/download/%','1018','C:31:"Symfony\\Component\\Routing\\Route":1873:{a:9:{s:4:"path";s:119:"/admin/config/development/backup_migrate/settings/destination/backups/{backup_migrate_destination}/download/{backup_id}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:60:"\\Drupal\\backup_migrate\\Controller\\BackupController::download";s:6:"_title";s:14:"Downlod Backup";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:26:"backup_migrate_destination";a:2:{s:4:"type";s:33:"entity:backup_migrate_destination";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":943:{a:11:{s:4:"vars";a:2:{i:0;s:26:"backup_migrate_destination";i:1;s:9:"backup_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:146:"#^/admin/config/development/backup_migrate/settings/destination/backups/(?P<backup_migrate_destination>[^/]++)/download/(?P<backup_id>[^/]++)$#sDu";s:11:"path_tokens";a:4:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"backup_id";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:9:"/download";}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:26:"backup_migrate_destination";i:4;b:1;}i:3;a:2:{i:0;s:4:"text";i:1;s:69:"/admin/config/development/backup_migrate/settings/destination/backups";}}s:9:"path_vars";a:2:{i:0;s:26:"backup_migrate_destination";i:1;s:9:"backup_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1018;s:14:"patternOutline";s:82:"/admin/config/development/backup_migrate/settings/destination/backups/%/download/%";s:8:"numParts";i:10;}}}}','10');
INSERT INTO `router` VALUES ('entity.backup_migrate_destination.backup_restore','/admin/config/development/backup_migrate/settings/destination/backups/{backup_migrate_destination}/restore/{backup_id}','/admin/config/development/backup_migrate/settings/destination/backups/%/restore/%','1018','C:31:"Symfony\\Component\\Routing\\Route":1812:{a:9:{s:4:"path";s:118:"/admin/config/development/backup_migrate/settings/destination/backups/{backup_migrate_destination}/restore/{backup_id}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:5:"_form";s:45:"\\Drupal\\backup_migrate\\Form\\BackupRestoreForm";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:26:"backup_migrate_destination";a:2:{s:4:"type";s:33:"entity:backup_migrate_destination";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":940:{a:11:{s:4:"vars";a:2:{i:0;s:26:"backup_migrate_destination";i:1;s:9:"backup_id";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:145:"#^/admin/config/development/backup_migrate/settings/destination/backups/(?P<backup_migrate_destination>[^/]++)/restore/(?P<backup_id>[^/]++)$#sDu";s:11:"path_tokens";a:4:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:9:"backup_id";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:8:"/restore";}i:2;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:26:"backup_migrate_destination";i:4;b:1;}i:3;a:2:{i:0;s:4:"text";i:1;s:69:"/admin/config/development/backup_migrate/settings/destination/backups";}}s:9:"path_vars";a:2:{i:0;s:26:"backup_migrate_destination";i:1;s:9:"backup_id";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:1018;s:14:"patternOutline";s:81:"/admin/config/development/backup_migrate/settings/destination/backups/%/restore/%";s:8:"numParts";i:10;}}}}','10');
INSERT INTO `router` VALUES ('entity.backup_migrate_destination.collection','/admin/config/development/backup_migrate/settings/destination','/admin/config/development/backup_migrate/settings/destination','63','C:31:"Symfony\\Component\\Routing\\Route":1120:{a:9:{s:4:"path";s:61:"/admin/config/development/backup_migrate/settings/destination";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:26:"backup_migrate_destination";s:6:"_title";s:18:"Backup Destination";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":481:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:68:"#^/admin/config/development/backup_migrate/settings/destination$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:61:"/admin/config/development/backup_migrate/settings/destination";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:61:"/admin/config/development/backup_migrate/settings/destination";s:8:"numParts";i:6;}}}}','6'),('entity.backup_migrate_destination.delete_form','/admin/config/development/backup_migrate/settings/destination/delete/{backup_migrate_destination}','/admin/config/development/backup_migrate/settings/destination/delete/%','254','C:31:"Symfony\\Component\\Routing\\Route":1610:{a:9:{s:4:"path";s:97:"/admin/config/development/backup_migrate/settings/destination/delete/{backup_migrate_destination}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:33:"backup_migrate_destination.delete";s:6:"_title";s:18:"Delete destination";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:26:"backup_migrate_destination";a:2:{s:4:"type";s:33:"entity:backup_migrate_destination";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":725:{a:11:{s:4:"vars";a:1:{i:0;s:26:"backup_migrate_destination";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:114:"#^/admin/config/development/backup_migrate/settings/destination/delete/(?P<backup_migrate_destination>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:26:"backup_migrate_destination";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:68:"/admin/config/development/backup_migrate/settings/destination/delete";}}s:9:"path_vars";a:1:{i:0;s:26:"backup_migrate_destination";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:254;s:14:"patternOutline";s:70:"/admin/config/development/backup_migrate/settings/destination/delete/%";s:8:"numParts";i:8;}}}}','8');
INSERT INTO `router` VALUES ('entity.backup_migrate_destination.edit_form','/admin/config/development/backup_migrate/settings/destination/edit/{backup_migrate_destination}','/admin/config/development/backup_migrate/settings/destination/edit/%','254','C:31:"Symfony\\Component\\Routing\\Route":1601:{a:9:{s:4:"path";s:95:"/admin/config/development/backup_migrate/settings/destination/edit/{backup_migrate_destination}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:34:"backup_migrate_destination.default";s:6:"_title";s:16:"Edit destination";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:26:"backup_migrate_destination";a:2:{s:4:"type";s:33:"entity:backup_migrate_destination";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":719:{a:11:{s:4:"vars";a:1:{i:0;s:26:"backup_migrate_destination";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:112:"#^/admin/config/development/backup_migrate/settings/destination/edit/(?P<backup_migrate_destination>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:26:"backup_migrate_destination";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:66:"/admin/config/development/backup_migrate/settings/destination/edit";}}s:9:"path_vars";a:1:{i:0;s:26:"backup_migrate_destination";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:254;s:14:"patternOutline";s:68:"/admin/config/development/backup_migrate/settings/destination/edit/%";s:8:"numParts";i:8;}}}}','8'),('entity.backup_migrate_schedule.add','/admin/config/development/backup_migrate/schedule/add','/admin/config/development/backup_migrate/schedule/add','63','C:31:"Symfony\\Component\\Routing\\Route":1087:{a:9:{s:4:"path";s:53:"/admin/config/development/backup_migrate/schedule/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:31:"backup_migrate_schedule.default";s:6:"_title";s:12:"Add schedule";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":457:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:60:"#^/admin/config/development/backup_migrate/schedule/add$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:53:"/admin/config/development/backup_migrate/schedule/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:53:"/admin/config/development/backup_migrate/schedule/add";s:8:"numParts";i:6;}}}}','6');
INSERT INTO `router` VALUES ('entity.backup_migrate_schedule.collection','/admin/config/development/backup_migrate/schedule','/admin/config/development/backup_migrate/schedule','31','C:31:"Symfony\\Component\\Routing\\Route":1058:{a:9:{s:4:"path";s:49:"/admin/config/development/backup_migrate/schedule";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:23:"backup_migrate_schedule";s:6:"_title";s:8:"Schedule";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":445:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:56:"#^/admin/config/development/backup_migrate/schedule$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:49:"/admin/config/development/backup_migrate/schedule";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:31;s:14:"patternOutline";s:49:"/admin/config/development/backup_migrate/schedule";s:8:"numParts";i:5;}}}}','5'),('entity.backup_migrate_schedule.delete_form','/admin/config/development/backup_migrate/schedule/delete/{backup_migrate_schedule}','/admin/config/development/backup_migrate/schedule/delete/%','126','C:31:"Symfony\\Component\\Routing\\Route":1534:{a:9:{s:4:"path";s:82:"/admin/config/development/backup_migrate/schedule/delete/{backup_migrate_schedule}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:30:"backup_migrate_schedule.delete";s:6:"_title";s:15:"Delete schedule";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:23:"backup_migrate_schedule";a:2:{s:4:"type";s:30:"entity:backup_migrate_schedule";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":676:{a:11:{s:4:"vars";a:1:{i:0;s:23:"backup_migrate_schedule";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:99:"#^/admin/config/development/backup_migrate/schedule/delete/(?P<backup_migrate_schedule>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:23:"backup_migrate_schedule";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:56:"/admin/config/development/backup_migrate/schedule/delete";}}s:9:"path_vars";a:1:{i:0;s:23:"backup_migrate_schedule";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:126;s:14:"patternOutline";s:58:"/admin/config/development/backup_migrate/schedule/delete/%";s:8:"numParts";i:7;}}}}','7');
INSERT INTO `router` VALUES ('entity.backup_migrate_schedule.edit_form','/admin/config/development/backup_migrate/schedule/edit/{backup_migrate_schedule}','/admin/config/development/backup_migrate/schedule/edit/%','126','C:31:"Symfony\\Component\\Routing\\Route":1525:{a:9:{s:4:"path";s:80:"/admin/config/development/backup_migrate/schedule/edit/{backup_migrate_schedule}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:31:"backup_migrate_schedule.default";s:6:"_title";s:13:"Edit schedule";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:23:"backup_migrate_schedule";a:2:{s:4:"type";s:30:"entity:backup_migrate_schedule";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":670:{a:11:{s:4:"vars";a:1:{i:0;s:23:"backup_migrate_schedule";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:97:"#^/admin/config/development/backup_migrate/schedule/edit/(?P<backup_migrate_schedule>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:23:"backup_migrate_schedule";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:54:"/admin/config/development/backup_migrate/schedule/edit";}}s:9:"path_vars";a:1:{i:0;s:23:"backup_migrate_schedule";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:126;s:14:"patternOutline";s:56:"/admin/config/development/backup_migrate/schedule/edit/%";s:8:"numParts";i:7;}}}}','7'),('entity.backup_migrate_settings.add','/admin/config/development/backup_migrate/settings/add','/admin/config/development/backup_migrate/settings/add','63','C:31:"Symfony\\Component\\Routing\\Route":1095:{a:9:{s:4:"path";s:53:"/admin/config/development/backup_migrate/settings/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:31:"backup_migrate_settings.default";s:6:"_title";s:20:"Add settings profile";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":457:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:60:"#^/admin/config/development/backup_migrate/settings/add$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:53:"/admin/config/development/backup_migrate/settings/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:53:"/admin/config/development/backup_migrate/settings/add";s:8:"numParts";i:6;}}}}','6');
INSERT INTO `router` VALUES ('entity.backup_migrate_settings.collection','/admin/config/development/backup_migrate/settings','/admin/config/development/backup_migrate/settings','31','C:31:"Symfony\\Component\\Routing\\Route":1058:{a:9:{s:4:"path";s:49:"/admin/config/development/backup_migrate/settings";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:23:"backup_migrate_settings";s:6:"_title";s:8:"Settings";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":445:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:56:"#^/admin/config/development/backup_migrate/settings$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:49:"/admin/config/development/backup_migrate/settings";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:31;s:14:"patternOutline";s:49:"/admin/config/development/backup_migrate/settings";s:8:"numParts";i:5;}}}}','5'),('entity.backup_migrate_settings.delete_form','/admin/config/development/backup_migrate/settings/delete/{backup_migrate_settings}','/admin/config/development/backup_migrate/settings/delete/%','126','C:31:"Symfony\\Component\\Routing\\Route":1542:{a:9:{s:4:"path";s:82:"/admin/config/development/backup_migrate/settings/delete/{backup_migrate_settings}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:30:"backup_migrate_settings.delete";s:6:"_title";s:23:"Delete settings profile";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:23:"backup_migrate_settings";a:2:{s:4:"type";s:30:"entity:backup_migrate_settings";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":676:{a:11:{s:4:"vars";a:1:{i:0;s:23:"backup_migrate_settings";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:99:"#^/admin/config/development/backup_migrate/settings/delete/(?P<backup_migrate_settings>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:23:"backup_migrate_settings";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:56:"/admin/config/development/backup_migrate/settings/delete";}}s:9:"path_vars";a:1:{i:0;s:23:"backup_migrate_settings";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:126;s:14:"patternOutline";s:58:"/admin/config/development/backup_migrate/settings/delete/%";s:8:"numParts";i:7;}}}}','7');
INSERT INTO `router` VALUES ('entity.backup_migrate_settings.edit_form','/admin/config/development/backup_migrate/settings/edit/{backup_migrate_settings}','/admin/config/development/backup_migrate/settings/edit/%','126','C:31:"Symfony\\Component\\Routing\\Route":1533:{a:9:{s:4:"path";s:80:"/admin/config/development/backup_migrate/settings/edit/{backup_migrate_settings}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:31:"backup_migrate_settings.default";s:6:"_title";s:21:"Edit settings profile";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:23:"backup_migrate_settings";a:2:{s:4:"type";s:30:"entity:backup_migrate_settings";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":670:{a:11:{s:4:"vars";a:1:{i:0;s:23:"backup_migrate_settings";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:97:"#^/admin/config/development/backup_migrate/settings/edit/(?P<backup_migrate_settings>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:23:"backup_migrate_settings";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:54:"/admin/config/development/backup_migrate/settings/edit";}}s:9:"path_vars";a:1:{i:0;s:23:"backup_migrate_settings";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:126;s:14:"patternOutline";s:56:"/admin/config/development/backup_migrate/settings/edit/%";s:8:"numParts";i:7;}}}}','7'),('entity.backup_migrate_source.add_form','/admin/config/development/backup_migrate/settings/source/add','/admin/config/development/backup_migrate/settings/source/add','127','C:31:"Symfony\\Component\\Routing\\Route":1119:{a:9:{s:4:"path";s:60:"/admin/config/development/backup_migrate/settings/source/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:29:"backup_migrate_source.default";s:6:"_title";s:17:"Add Backup Source";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":479:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:67:"#^/admin/config/development/backup_migrate/settings/source/add$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:60:"/admin/config/development/backup_migrate/settings/source/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:127;s:14:"patternOutline";s:60:"/admin/config/development/backup_migrate/settings/source/add";s:8:"numParts";i:7;}}}}','7');
INSERT INTO `router` VALUES ('entity.backup_migrate_source.collection','/admin/config/development/backup_migrate/settings/source','/admin/config/development/backup_migrate/settings/source','63','C:31:"Symfony\\Component\\Routing\\Route":1091:{a:9:{s:4:"path";s:56:"/admin/config/development/backup_migrate/settings/source";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:21:"backup_migrate_source";s:6:"_title";s:14:"Backup sources";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":466:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:63:"#^/admin/config/development/backup_migrate/settings/source$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:56:"/admin/config/development/backup_migrate/settings/source";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:63;s:14:"patternOutline";s:56:"/admin/config/development/backup_migrate/settings/source";s:8:"numParts";i:6;}}}}','6'),('entity.backup_migrate_source.delete_form','/admin/config/development/backup_migrate/settings/source/delete/{backup_migrate_source}','/admin/config/development/backup_migrate/settings/source/delete/%','254','C:31:"Symfony\\Component\\Routing\\Route":1545:{a:9:{s:4:"path";s:87:"/admin/config/development/backup_migrate/settings/source/delete/{backup_migrate_source}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:28:"backup_migrate_source.delete";s:6:"_title";s:13:"Delete source";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:21:"backup_migrate_source";a:2:{s:4:"type";s:28:"entity:backup_migrate_source";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":690:{a:11:{s:4:"vars";a:1:{i:0;s:21:"backup_migrate_source";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:104:"#^/admin/config/development/backup_migrate/settings/source/delete/(?P<backup_migrate_source>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:21:"backup_migrate_source";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:63:"/admin/config/development/backup_migrate/settings/source/delete";}}s:9:"path_vars";a:1:{i:0;s:21:"backup_migrate_source";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:254;s:14:"patternOutline";s:65:"/admin/config/development/backup_migrate/settings/source/delete/%";s:8:"numParts";i:8;}}}}','8');
INSERT INTO `router` VALUES ('entity.backup_migrate_source.edit_form','/admin/config/development/backup_migrate/settings/source/edit/{backup_migrate_source}','/admin/config/development/backup_migrate/settings/source/edit/%','254','C:31:"Symfony\\Component\\Routing\\Route":1536:{a:9:{s:4:"path";s:85:"/admin/config/development/backup_migrate/settings/source/edit/{backup_migrate_source}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:29:"backup_migrate_source.default";s:6:"_title";s:11:"Edit source";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer backup and migrate";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:21:"backup_migrate_source";a:2:{s:4:"type";s:28:"entity:backup_migrate_source";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":684:{a:11:{s:4:"vars";a:1:{i:0;s:21:"backup_migrate_source";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:102:"#^/admin/config/development/backup_migrate/settings/source/edit/(?P<backup_migrate_source>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:21:"backup_migrate_source";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:61:"/admin/config/development/backup_migrate/settings/source/edit";}}s:9:"path_vars";a:1:{i:0;s:21:"backup_migrate_source";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:254;s:14:"patternOutline";s:63:"/admin/config/development/backup_migrate/settings/source/edit/%";s:8:"numParts";i:8;}}}}','8'),('entity.block.delete_form','/admin/structure/block/manage/{block}/delete','/admin/structure/block/manage/%/delete','61','C:31:"Symfony\\Component\\Routing\\Route":1326:{a:9:{s:4:"path";s:44:"/admin/structure/block/manage/{block}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:12:"block.delete";s:6:"_title";s:12:"Delete block";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:5:"block";a:2:{s:4:"type";s:12:"entity:block";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":576:{a:11:{s:4:"vars";a:1:{i:0;s:5:"block";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:61:"#^/admin/structure/block/manage/(?P<block>[^/]++)/delete$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"block";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/block/manage";}}s:9:"path_vars";a:1:{i:0;s:5:"block";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:38:"/admin/structure/block/manage/%/delete";s:8:"numParts";i:6;}}}}','6');
INSERT INTO `router` VALUES ('entity.block.disable','/admin/structure/block/manage/{block}/disable','/admin/structure/block/manage/%/disable','61','C:31:"Symfony\\Component\\Routing\\Route":1419:{a:9:{s:4:"path";s:45:"/admin/structure/block/manage/{block}/disable";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:58:"\\Drupal\\block\\Controller\\BlockController::performOperation";s:2:"op";s:7:"disable";}s:12:"requirements";a:2:{s:14:"_entity_access";s:13:"block.disable";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:5:"block";a:2:{s:4:"type";s:12:"entity:block";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":579:{a:11:{s:4:"vars";a:1:{i:0;s:5:"block";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:62:"#^/admin/structure/block/manage/(?P<block>[^/]++)/disable$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:8:"/disable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"block";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/block/manage";}}s:9:"path_vars";a:1:{i:0;s:5:"block";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:39:"/admin/structure/block/manage/%/disable";s:8:"numParts";i:6;}}}}','6'),('entity.block.edit_form','/admin/structure/block/manage/{block}','/admin/structure/block/manage/%','30','C:31:"Symfony\\Component\\Routing\\Route":1260:{a:9:{s:4:"path";s:37:"/admin/structure/block/manage/{block}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:13:"block.default";s:6:"_title";s:15:"Configure block";}s:12:"requirements";a:1:{s:14:"_entity_access";s:12:"block.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:5:"block";a:2:{s:4:"type";s:12:"entity:block";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":519:{a:11:{s:4:"vars";a:1:{i:0;s:5:"block";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:54:"#^/admin/structure/block/manage/(?P<block>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"block";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/block/manage";}}s:9:"path_vars";a:1:{i:0;s:5:"block";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:31:"/admin/structure/block/manage/%";s:8:"numParts";i:5;}}}}','5');
INSERT INTO `router` VALUES ('entity.block.enable','/admin/structure/block/manage/{block}/enable','/admin/structure/block/manage/%/enable','61','C:31:"Symfony\\Component\\Routing\\Route":1413:{a:9:{s:4:"path";s:44:"/admin/structure/block/manage/{block}/enable";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:11:"_controller";s:58:"\\Drupal\\block\\Controller\\BlockController::performOperation";s:2:"op";s:6:"enable";}s:12:"requirements";a:2:{s:14:"_entity_access";s:12:"block.enable";s:11:"_csrf_token";s:4:"TRUE";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:5:"block";a:2:{s:4:"type";s:12:"entity:block";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:2:{i:0;s:19:"access_check.entity";i:1;s:17:"access_check.csrf";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":576:{a:11:{s:4:"vars";a:1:{i:0;s:5:"block";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:61:"#^/admin/structure/block/manage/(?P<block>[^/]++)/enable$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/enable";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:5:"block";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/structure/block/manage";}}s:9:"path_vars";a:1:{i:0;s:5:"block";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:38:"/admin/structure/block/manage/%/enable";s:8:"numParts";i:6;}}}}','6'),('entity.block_content.canonical','/block/{block_content}','/block/%','2','C:31:"Symfony\\Component\\Routing\\Route":1185:{a:9:{s:4:"path";s:22:"/block/{block_content}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:18:"block_content.edit";}s:12:"requirements";a:2:{s:14:"_entity_access";s:20:"block_content.update";s:13:"block_content";s:3:"\\d+";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:10:"parameters";a:1:{s:13:"block_content";a:2:{s:4:"type";s:20:"entity:block_content";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":476:{a:11:{s:4:"vars";a:1:{i:0;s:13:"block_content";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"#^/block/(?P<block_content>\\d+)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:13:"block_content";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:6:"/block";}}s:9:"path_vars";a:1:{i:0;s:13:"block_content";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:2;s:14:"patternOutline";s:8:"/block/%";s:8:"numParts";i:2;}}}}','2');
INSERT INTO `router` VALUES ('entity.block_content.collection','/admin/structure/block/block-content','/admin/structure/block/block-content','15','C:31:"Symfony\\Component\\Routing\\Route":1359:{a:9:{s:4:"path";s:36:"/admin/structure/block/block-content";s:4:"host";s:0:"";s:8:"defaults";a:5:{s:11:"_controller";s:47:"Drupal\\views\\Routing\\ViewPageController::handle";s:6:"_title";s:20:"Custom block library";s:7:"view_id";s:13:"block_content";s:10:"display_id";s:6:"page_1";s:30:"_view_display_show_admin_links";b:1;}s:12:"requirements";a:2:{s:11:"_permission";s:17:"administer blocks";s:7:"_format";s:4:"html";}s:7:"options";a:9:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:18:"_view_argument_map";a:0:{}s:23:"_view_display_plugin_id";s:4:"page";s:26:"_view_display_plugin_class";s:38:"Drupal\\views\\Plugin\\views\\display\\Page";s:30:"_view_display_show_admin_links";b:1;s:16:"returns_response";b:0;s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":407:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:44:"#^/admin/structure/block/block\\-content$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:36:"/admin/structure/block/block-content";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:36:"/admin/structure/block/block-content";s:8:"numParts";i:4;}}}}','4'),('entity.block_content.delete_form','/block/{block_content}/delete','/block/%/delete','5','C:31:"Symfony\\Component\\Routing\\Route":1278:{a:9:{s:4:"path";s:29:"/block/{block_content}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:20:"block_content.delete";s:6:"_title";s:6:"Delete";}s:12:"requirements";a:2:{s:14:"_entity_access";s:20:"block_content.delete";s:13:"block_content";s:3:"\\d+";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:10:"parameters";a:1:{s:13:"block_content";a:2:{s:4:"type";s:20:"entity:block_content";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":534:{a:11:{s:4:"vars";a:1:{i:0;s:13:"block_content";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:43:"#^/block/(?P<block_content>\\d+)/delete$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:13:"block_content";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:6:"/block";}}s:9:"path_vars";a:1:{i:0;s:13:"block_content";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:15:"/block/%/delete";s:8:"numParts";i:3;}}}}','3');
INSERT INTO `router` VALUES ('entity.block_content.edit_form','/block/{block_content}','/block/%','2','C:31:"Symfony\\Component\\Routing\\Route":1185:{a:9:{s:4:"path";s:22:"/block/{block_content}";s:4:"host";s:0:"";s:8:"defaults";a:1:{s:12:"_entity_form";s:18:"block_content.edit";}s:12:"requirements";a:2:{s:14:"_entity_access";s:20:"block_content.update";s:13:"block_content";s:3:"\\d+";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:10:"parameters";a:1:{s:13:"block_content";a:2:{s:4:"type";s:20:"entity:block_content";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":476:{a:11:{s:4:"vars";a:1:{i:0;s:13:"block_content";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"#^/block/(?P<block_content>\\d+)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:13:"block_content";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:6:"/block";}}s:9:"path_vars";a:1:{i:0;s:13:"block_content";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:2;s:14:"patternOutline";s:8:"/block/%";s:8:"numParts";i:2;}}}}','2'),('entity.block_content.field_ui_fields','/admin/structure/block/block-content/manage/{block_content_type}/fields','/admin/structure/block/block-content/manage/%/fields','125','C:31:"Symfony\\Component\\Routing\\Route":1597:{a:9:{s:4:"path";s:71:"/admin/structure/block/block-content/manage/{block_content_type}/fields";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:11:"_controller";s:62:"\\Drupal\\field_ui\\Controller\\FieldConfigListController::listing";s:6:"_title";s:13:"Manage fields";s:14:"entity_type_id";s:13:"block_content";s:6:"bundle";s:0:"";}s:12:"requirements";a:1:{s:11:"_permission";s:31:"administer block_content fields";}s:7:"options";a:6:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:18:"block_content_type";a:2:{s:4:"type";s:25:"entity:block_content_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:9:"_field_ui";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":675:{a:11:{s:4:"vars";a:1:{i:0;s:18:"block_content_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:89:"#^/admin/structure/block/block\\-content/manage/(?P<block_content_type>[^/]++)/fields$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/fields";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:18:"block_content_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:43:"/admin/structure/block/block-content/manage";}}s:9:"path_vars";a:1:{i:0;s:18:"block_content_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:52:"/admin/structure/block/block-content/manage/%/fields";s:8:"numParts";i:7;}}}}','7');
INSERT INTO `router` VALUES ('entity.block_content_type.collection','/admin/structure/block/block-content/types','/admin/structure/block/block-content/types','31','C:31:"Symfony\\Component\\Routing\\Route":1086:{a:9:{s:4:"path";s:42:"/admin/structure/block/block-content/types";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:12:"_entity_list";s:18:"block_content_type";s:6:"_title";s:20:"Custom block library";s:16:"_title_arguments";a:0:{}s:14:"_title_context";s:0:"";}s:12:"requirements";a:1:{s:11:"_permission";s:17:"administer blocks";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":425:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:50:"#^/admin/structure/block/block\\-content/types$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:42:"/admin/structure/block/block-content/types";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:31;s:14:"patternOutline";s:42:"/admin/structure/block/block-content/types";s:8:"numParts";i:5;}}}}','5'),('entity.block_content_type.delete_form','/admin/structure/block/block-content/manage/{block_content_type}/delete','/admin/structure/block/block-content/manage/%/delete','125','C:31:"Symfony\\Component\\Routing\\Route":1557:{a:9:{s:4:"path";s:71:"/admin/structure/block/block-content/manage/{block_content_type}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:25:"block_content_type.delete";s:15:"_title_callback";s:60:"\\Drupal\\Core\\Entity\\Controller\\EntityController::deleteTitle";}s:12:"requirements";a:1:{s:14:"_entity_access";s:25:"block_content_type.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:18:"block_content_type";a:2:{s:4:"type";s:25:"entity:block_content_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":675:{a:11:{s:4:"vars";a:1:{i:0;s:18:"block_content_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:89:"#^/admin/structure/block/block\\-content/manage/(?P<block_content_type>[^/]++)/delete$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:18:"block_content_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:43:"/admin/structure/block/block-content/manage";}}s:9:"path_vars";a:1:{i:0;s:18:"block_content_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:125;s:14:"patternOutline";s:52:"/admin/structure/block/block-content/manage/%/delete";s:8:"numParts";i:7;}}}}','7');
INSERT INTO `router` VALUES ('entity.block_content_type.edit_form','/admin/structure/block/block-content/manage/{block_content_type}','/admin/structure/block/block-content/manage/%','62','C:31:"Symfony\\Component\\Routing\\Route":1488:{a:9:{s:4:"path";s:64:"/admin/structure/block/block-content/manage/{block_content_type}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:23:"block_content_type.edit";s:15:"_title_callback";s:58:"\\Drupal\\Core\\Entity\\Controller\\EntityController::editTitle";}s:12:"requirements";a:1:{s:14:"_entity_access";s:25:"block_content_type.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:10:"parameters";a:1:{s:18:"block_content_type";a:2:{s:4:"type";s:25:"entity:block_content_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}s:4:"utf8";b:1;}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":617:{a:11:{s:4:"vars";a:1:{i:0;s:18:"block_content_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:82:"#^/admin/structure/block/block\\-content/manage/(?P<block_content_type>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:18:"block_content_type";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:43:"/admin/structure/block/block-content/manage";}}s:9:"path_vars";a:1:{i:0;s:18:"block_content_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:62;s:14:"patternOutline";s:45:"/admin/structure/block/block-content/manage/%";s:8:"numParts";i:6;}}}}','6'),('entity.comment.canonical','/comment/{comment}','/comment/%','2','C:31:"Symfony\\Component\\Routing\\Route":1250:{a:9:{s:4:"path";s:18:"/comment/{comment}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:15:"_title_callback";s:67:"\\Drupal\\comment\\Controller\\CommentController::commentPermalinkTitle";s:11:"_controller";s:62:"\\Drupal\\comment\\Controller\\CommentController::commentPermalink";}s:12:"requirements";a:2:{s:14:"_entity_access";s:12:"comment.view";s:7:"comment";s:3:"\\d+";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:7:"comment";a:2:{s:4:"type";s:14:"entity:comment";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":456:{a:11:{s:4:"vars";a:1:{i:0;s:7:"comment";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:32:"#^/comment/(?P<comment>\\d+)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:7:"comment";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:8:"/comment";}}s:9:"path_vars";a:1:{i:0;s:7:"comment";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:2;s:14:"patternOutline";s:10:"/comment/%";s:8:"numParts";i:2;}}}}','2');
INSERT INTO `router` VALUES ('entity.comment.delete_form','/comment/{comment}/delete','/comment/%/delete','5','C:31:"Symfony\\Component\\Routing\\Route":1197:{a:9:{s:4:"path";s:25:"/comment/{comment}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:6:"Delete";s:12:"_entity_form";s:14:"comment.delete";}s:12:"requirements";a:2:{s:14:"_entity_access";s:14:"comment.delete";s:7:"comment";s:3:"\\d+";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:7:"comment";a:2:{s:4:"type";s:14:"entity:comment";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":513:{a:11:{s:4:"vars";a:1:{i:0;s:7:"comment";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:39:"#^/comment/(?P<comment>\\d+)/delete$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:7:"comment";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:8:"/comment";}}s:9:"path_vars";a:1:{i:0;s:7:"comment";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:17:"/comment/%/delete";s:8:"numParts";i:3;}}}}','3'),('entity.comment.delete_multiple_form','/admin/content/comment/delete','/admin/content/comment/delete','15','C:31:"Symfony\\Component\\Routing\\Route":1031:{a:9:{s:4:"path";s:29:"/admin/content/comment/delete";s:4:"host";s:0:"";s:8:"defaults";a:3:{s:6:"_title";s:6:"Delete";s:5:"_form";s:42:"\\Drupal\\comment\\Form\\ConfirmDeleteMultiple";s:14:"entity_type_id";s:7:"comment";}s:12:"requirements";a:1:{s:30:"_entity_delete_multiple_access";s:7:"comment";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:35:"access_check.entity_delete_multiple";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":385:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:36:"#^/admin/content/comment/delete$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:29:"/admin/content/comment/delete";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:29:"/admin/content/comment/delete";s:8:"numParts";i:4;}}}}','4');
INSERT INTO `router` VALUES ('entity.comment.edit_form','/comment/{comment}/edit','/comment/%/edit','5','C:31:"Symfony\\Component\\Routing\\Route":1188:{a:9:{s:4:"path";s:23:"/comment/{comment}/edit";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:4:"Edit";s:12:"_entity_form";s:15:"comment.default";}s:12:"requirements";a:2:{s:14:"_entity_access";s:14:"comment.update";s:7:"comment";s:3:"\\d+";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:7:"comment";a:2:{s:4:"type";s:14:"entity:comment";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":507:{a:11:{s:4:"vars";a:1:{i:0;s:7:"comment";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:37:"#^/comment/(?P<comment>\\d+)/edit$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:5:"/edit";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:3:"\\d+";i:3;s:7:"comment";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:8:"/comment";}}s:9:"path_vars";a:1:{i:0;s:7:"comment";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:5;s:14:"patternOutline";s:15:"/comment/%/edit";s:8:"numParts";i:3;}}}}','3'),('entity.comment.field_ui_fields','/admin/structure/comment/manage/{comment_type}/fields','/admin/structure/comment/manage/%/fields','61','C:31:"Symfony\\Component\\Routing\\Route":1492:{a:9:{s:4:"path";s:53:"/admin/structure/comment/manage/{comment_type}/fields";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:11:"_controller";s:62:"\\Drupal\\field_ui\\Controller\\FieldConfigListController::listing";s:6:"_title";s:13:"Manage fields";s:14:"entity_type_id";s:7:"comment";s:6:"bundle";s:0:"";}s:12:"requirements";a:1:{s:11:"_permission";s:25:"administer comment fields";}s:7:"options";a:6:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:10:"parameters";a:1:{s:12:"comment_type";a:2:{s:4:"type";s:19:"entity:comment_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:9:"_field_ui";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":613:{a:11:{s:4:"vars";a:1:{i:0;s:12:"comment_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:70:"#^/admin/structure/comment/manage/(?P<comment_type>[^/]++)/fields$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/fields";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"comment_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/structure/comment/manage";}}s:9:"path_vars";a:1:{i:0;s:12:"comment_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:40:"/admin/structure/comment/manage/%/fields";s:8:"numParts";i:6;}}}}','6');
INSERT INTO `router` VALUES ('entity.comment_type.add_form','/admin/structure/comment/types/add','/admin/structure/comment/types/add','31','C:31:"Symfony\\Component\\Routing\\Route":995:{a:9:{s:4:"path";s:34:"/admin/structure/comment/types/add";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:16:"comment_type.add";s:6:"_title";s:16:"Add comment type";}s:12:"requirements";a:1:{s:11:"_permission";s:24:"administer comment types";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":400:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:41:"#^/admin/structure/comment/types/add$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:34:"/admin/structure/comment/types/add";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:31;s:14:"patternOutline";s:34:"/admin/structure/comment/types/add";s:8:"numParts";i:5;}}}}','5'),('entity.comment_type.collection','/admin/structure/comment','/admin/structure/comment','7','C:31:"Symfony\\Component\\Routing\\Route":947:{a:9:{s:4:"path";s:24:"/admin/structure/comment";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:12:"comment_type";s:6:"_title";s:13:"Comment types";}s:12:"requirements";a:1:{s:11:"_permission";s:24:"administer comment types";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":369:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:31:"#^/admin/structure/comment$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:24:"/admin/structure/comment";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:24:"/admin/structure/comment";s:8:"numParts";i:3;}}}}','3');
INSERT INTO `router` VALUES ('entity.comment_type.delete_form','/admin/structure/comment/manage/{comment_type}/delete','/admin/structure/comment/manage/%/delete','61','C:31:"Symfony\\Component\\Routing\\Route":1388:{a:9:{s:4:"path";s:53:"/admin/structure/comment/manage/{comment_type}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:19:"comment_type.delete";s:6:"_title";s:6:"Delete";}s:12:"requirements";a:1:{s:14:"_entity_access";s:19:"comment_type.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:10:"parameters";a:1:{s:12:"comment_type";a:2:{s:4:"type";s:19:"entity:comment_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":613:{a:11:{s:4:"vars";a:1:{i:0;s:12:"comment_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:70:"#^/admin/structure/comment/manage/(?P<comment_type>[^/]++)/delete$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"comment_type";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/structure/comment/manage";}}s:9:"path_vars";a:1:{i:0;s:12:"comment_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:40:"/admin/structure/comment/manage/%/delete";s:8:"numParts";i:6;}}}}','6'),('entity.comment_type.edit_form','/admin/structure/comment/manage/{comment_type}','/admin/structure/comment/manage/%','30','C:31:"Symfony\\Component\\Routing\\Route":1320:{a:9:{s:4:"path";s:46:"/admin/structure/comment/manage/{comment_type}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:17:"comment_type.edit";s:6:"_title";s:4:"Edit";}s:12:"requirements";a:1:{s:14:"_entity_access";s:19:"comment_type.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:12:"_admin_route";b:1;s:4:"utf8";b:1;s:10:"parameters";a:1:{s:12:"comment_type";a:2:{s:4:"type";s:19:"entity:comment_type";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":556:{a:11:{s:4:"vars";a:1:{i:0;s:12:"comment_type";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:63:"#^/admin/structure/comment/manage/(?P<comment_type>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"comment_type";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/structure/comment/manage";}}s:9:"path_vars";a:1:{i:0;s:12:"comment_type";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:33:"/admin/structure/comment/manage/%";s:8:"numParts";i:5;}}}}','5');
INSERT INTO `router` VALUES ('entity.contact_form.canonical','/contact/{contact_form}','/contact/%','2','C:31:"Symfony\\Component\\Routing\\Route":1204:{a:9:{s:4:"path";s:23:"/contact/{contact_form}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:6:"_title";s:7:"Contact";s:11:"_controller";s:61:"\\Drupal\\contact\\Controller\\ContactController::contactSitePage";}s:12:"requirements";a:1:{s:14:"_entity_access";s:17:"contact_form.view";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:12:"contact_form";a:2:{s:4:"type";s:19:"entity:contact_form";s:9:"converter";s:21:"paramconverter.entity";}}s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":485:{a:11:{s:4:"vars";a:1:{i:0;s:12:"contact_form";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:40:"#^/contact/(?P<contact_form>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"contact_form";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:8:"/contact";}}s:9:"path_vars";a:1:{i:0;s:12:"contact_form";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:2;s:14:"patternOutline";s:10:"/contact/%";s:8:"numParts";i:2;}}}}','2'),('entity.contact_form.collection','/admin/structure/contact','/admin/structure/contact','7','C:31:"Symfony\\Component\\Routing\\Route":947:{a:9:{s:4:"path";s:24:"/admin/structure/contact";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:12:"contact_form";s:6:"_title";s:13:"Contact forms";}s:12:"requirements";a:1:{s:11:"_permission";s:24:"administer contact forms";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":369:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:31:"#^/admin/structure/contact$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:24:"/admin/structure/contact";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:7;s:14:"patternOutline";s:24:"/admin/structure/contact";s:8:"numParts";i:3;}}}}','3');
INSERT INTO `router` VALUES ('entity.contact_form.delete_form','/admin/structure/contact/manage/{contact_form}/delete','/admin/structure/contact/manage/%/delete','61','C:31:"Symfony\\Component\\Routing\\Route":1388:{a:9:{s:4:"path";s:53:"/admin/structure/contact/manage/{contact_form}/delete";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:19:"contact_form.delete";s:6:"_title";s:6:"Delete";}s:12:"requirements";a:1:{s:14:"_entity_access";s:19:"contact_form.delete";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:12:"contact_form";a:2:{s:4:"type";s:19:"entity:contact_form";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":613:{a:11:{s:4:"vars";a:1:{i:0;s:12:"contact_form";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:70:"#^/admin/structure/contact/manage/(?P<contact_form>[^/]++)/delete$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/delete";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"contact_form";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/structure/contact/manage";}}s:9:"path_vars";a:1:{i:0;s:12:"contact_form";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:40:"/admin/structure/contact/manage/%/delete";s:8:"numParts";i:6;}}}}','6'),('entity.contact_form.edit_form','/admin/structure/contact/manage/{contact_form}','/admin/structure/contact/manage/%','30','C:31:"Symfony\\Component\\Routing\\Route":1334:{a:9:{s:4:"path";s:46:"/admin/structure/contact/manage/{contact_form}";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_form";s:17:"contact_form.edit";s:6:"_title";s:17:"Edit contact form";}s:12:"requirements";a:1:{s:14:"_entity_access";s:19:"contact_form.update";}s:7:"options";a:5:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:12:"contact_form";a:2:{s:4:"type";s:19:"entity:contact_form";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:19:"access_check.entity";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":556:{a:11:{s:4:"vars";a:1:{i:0;s:12:"contact_form";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:63:"#^/admin/structure/contact/manage/(?P<contact_form>[^/]++)$#sDu";s:11:"path_tokens";a:2:{i:0;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"contact_form";i:4;b:1;}i:1;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/structure/contact/manage";}}s:9:"path_vars";a:1:{i:0;s:12:"contact_form";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:30;s:14:"patternOutline";s:33:"/admin/structure/contact/manage/%";s:8:"numParts";i:5;}}}}','5');
INSERT INTO `router` VALUES ('entity.contact_message.field_ui_fields','/admin/structure/contact/manage/{contact_form}/fields','/admin/structure/contact/manage/%/fields','61','C:31:"Symfony\\Component\\Routing\\Route":1509:{a:9:{s:4:"path";s:53:"/admin/structure/contact/manage/{contact_form}/fields";s:4:"host";s:0:"";s:8:"defaults";a:4:{s:11:"_controller";s:62:"\\Drupal\\field_ui\\Controller\\FieldConfigListController::listing";s:6:"_title";s:13:"Manage fields";s:14:"entity_type_id";s:15:"contact_message";s:6:"bundle";s:0:"";}s:12:"requirements";a:1:{s:11:"_permission";s:33:"administer contact_message fields";}s:7:"options";a:6:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:10:"parameters";a:1:{s:12:"contact_form";a:2:{s:4:"type";s:19:"entity:contact_form";s:9:"converter";s:63:"drupal.proxy_original_service.paramconverter.configentity_admin";}}s:9:"_field_ui";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:0:{}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":613:{a:11:{s:4:"vars";a:1:{i:0;s:12:"contact_form";}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:70:"#^/admin/structure/contact/manage/(?P<contact_form>[^/]++)/fields$#sDu";s:11:"path_tokens";a:3:{i:0;a:2:{i:0;s:4:"text";i:1;s:7:"/fields";}i:1;a:5:{i:0;s:8:"variable";i:1;s:1:"/";i:2;s:6:"[^/]++";i:3;s:12:"contact_form";i:4;b:1;}i:2;a:2:{i:0;s:4:"text";i:1;s:31:"/admin/structure/contact/manage";}}s:9:"path_vars";a:1:{i:0;s:12:"contact_form";}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:61;s:14:"patternOutline";s:40:"/admin/structure/contact/manage/%/fields";s:8:"numParts";i:6;}}}}','6'),('entity.date_format.collection','/admin/config/regional/date-time','/admin/config/regional/date-time','15','C:31:"Symfony\\Component\\Routing\\Route":993:{a:9:{s:4:"path";s:32:"/admin/config/regional/date-time";s:4:"host";s:0:"";s:8:"defaults";a:2:{s:12:"_entity_list";s:11:"date_format";s:6:"_title";s:21:"Date and time formats";}s:12:"requirements";a:1:{s:11:"_permission";s:29:"administer site configuration";}s:7:"options";a:4:{s:14:"compiler_class";s:33:"Drupal\\Core\\Routing\\RouteCompiler";s:4:"utf8";b:1;s:12:"_admin_route";b:1;s:14:"_access_checks";a:1:{i:0;s:23:"access_check.permission";}}s:7:"schemes";a:0:{}s:7:"methods";a:2:{i:0;s:3:"GET";i:1;s:4:"POST";}s:9:"condition";s:0:"";s:8:"compiled";C:33:"Drupal\\Core\\Routing\\CompiledRoute":395:{a:11:{s:4:"vars";a:0:{}s:11:"path_prefix";s:0:"";s:10:"path_regex";s:40:"#^/admin/config/regional/date\\-time$#sDu";s:11:"path_tokens";a:1:{i:0;a:2:{i:0;s:4:"text";i:1;s:32:"/admin/config/regional/date-time";}}s:9:"path_vars";a:0:{}s:10:"host_regex";N;s:11:"host_tokens";a:0:{}s:9:"host_vars";a:0:{}s:3:"fit";i:15;s:14:"patternOutline";s:32:"/admin/config/regional/date-time";s:8:"numParts";i:4;}}}}','4');
INSERT INTO `router` VALUES ('entity.date_format.delete_form','/admin/config/regional/date-time/formats/mana